/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.process;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.plugin.file.spreadsheet.process.AbstractImportProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ImportNodesProcess
extends AbstractImportProcess {
    public static final String NODE_ID = "id";
    public static final String NODE_LABEL = "label";

    public ImportNodesProcess(SpreadsheetGeneralConfiguration generalConfig, SheetParser parser, ContainerLoader container, ProgressTicket progressTicket) throws IOException {
        super(generalConfig, container, progressTicket, parser);
    }

    @Override
    public boolean execute() {
        this.setupColumnsIndexesAndFindSpecialColumns(Arrays.asList(NODE_ID, NODE_LABEL), this.generalConfig.getColumnsClasses());
        Integer idColumnIndex = (Integer)this.specialColumnsIndexMap.get(NODE_ID);
        Integer labelColumnIndex = (Integer)this.specialColumnsIndexMap.get(NODE_LABEL);
        Progress.start((ProgressTicket)this.progressTicket);
        for (SheetRow row : this.parser) {
            NodeDraft node;
            if (this.cancel) break;
            if (!this.checkRow(row)) continue;
            String id = null;
            String label = null;
            if (idColumnIndex != null) {
                id = row.get(idColumnIndex);
            }
            if (labelColumnIndex != null) {
                label = row.get(labelColumnIndex);
            }
            NodeDraft nodeDraft = node = id != null ? this.container.factory().newNodeDraft(id) : this.container.factory().newNodeDraft();
            if (label != null) {
                node.setLabel(label);
            }
            for (Map.Entry columnEntry : this.headersIndexMap.entrySet()) {
                Object value;
                String column = (String)columnEntry.getKey();
                Integer index = (Integer)columnEntry.getValue();
                Class type = (Class)this.headersClassMap.get(column);
                if (type == null || (value = row.get(index)) == null || (value = this.parseValue((String)value, type, column)) == null) continue;
                node.setValue(column, value);
            }
            this.container.addNode(node);
        }
        Progress.finish((ProgressTicket)this.progressTicket);
        return !this.cancel;
    }

    @Override
    protected void addColumn(String name, Class type) {
        this.container.addNodeColumn(name, type);
    }
}

