/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.xml.ASMContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ASMContentHandler$Rule {
    final /* synthetic */ ASMContentHandler this$0;
    static /* synthetic */ Class class$org$objectweb$asm$Type;
    static /* synthetic */ Class class$org$objectweb$asm$Handle;

    protected ASMContentHandler$Rule(ASMContentHandler aSMContentHandler) {
        this.this$0 = aSMContentHandler;
    }

    public void begin(String string2, Attributes attributes) throws SAXException {
    }

    public void end(String string2) {
    }

    protected final Object getValue(String string2, String string3) throws SAXException {
        Object object = null;
        if (string3 != null) {
            if ("Ljava/lang/String;".equals(string2)) {
                object = this.decode(string3);
            } else if ("Ljava/lang/Integer;".equals(string2) || "I".equals(string2) || "S".equals(string2) || "B".equals(string2) || "C".equals(string2) || "Z".equals(string2)) {
                object = new Integer(string3);
            } else if ("Ljava/lang/Short;".equals(string2)) {
                object = new Short(string3);
            } else if ("Ljava/lang/Byte;".equals(string2)) {
                object = new Byte(string3);
            } else if ("Ljava/lang/Character;".equals(string2)) {
                object = new Character(this.decode(string3).charAt(0));
            } else if ("Ljava/lang/Boolean;".equals(string2)) {
                object = Boolean.valueOf(string3);
            } else if ("Ljava/lang/Long;".equals(string2) || "J".equals(string2)) {
                object = new Long(string3);
            } else if ("Ljava/lang/Float;".equals(string2) || "F".equals(string2)) {
                object = new Float(string3);
            } else if ("Ljava/lang/Double;".equals(string2) || "D".equals(string2)) {
                object = new Double(string3);
            } else if (Type.getDescriptor(class$org$objectweb$asm$Type == null ? (class$org$objectweb$asm$Type = ASMContentHandler$Rule.class$("org.objectweb.asm.Type")) : class$org$objectweb$asm$Type).equals(string2)) {
                object = Type.getType(string3);
            } else if (Type.getDescriptor(class$org$objectweb$asm$Handle == null ? (class$org$objectweb$asm$Handle = ASMContentHandler$Rule.class$("org.objectweb.asm.Handle")) : class$org$objectweb$asm$Handle).equals(string2)) {
                object = this.decodeHandle(string3);
            } else {
                throw new SAXException("Invalid value:" + string3 + " desc:" + string2 + " ctx:" + this);
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = classNotFoundException.getMessage();
            throw new NoClassDefFoundError(string3);
        }
    }

    Handle decodeHandle(String string2) throws SAXException {
        try {
            int n = string2.indexOf(46);
            int n2 = string2.indexOf(40, n + 1);
            int n3 = string2.lastIndexOf(40);
            int n4 = Integer.parseInt(string2.substring(n3 + 1, string2.length() - 1));
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, n2);
            String string5 = string2.substring(n2, n3 - 1);
            return new Handle(n4, string3, string4, string5);
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException("Malformed handle " + string2, runtimeException);
        }
    }

    private final String decode(String string2) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        try {
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '\\') {
                    if ((c = string2.charAt(++i)) == '\\') {
                        stringBuffer.append('\\');
                        continue;
                    }
                    stringBuffer.append((char)Integer.parseInt(string2.substring(++i, i + 4), 16));
                    i += 3;
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException(runtimeException);
        }
        return stringBuffer.toString();
    }

    protected final Label getLabel(Object object) {
        Label label = (Label)this.this$0.labels.get(object);
        if (label == null) {
            label = new Label();
            this.this$0.labels.put(object, label);
        }
        return label;
    }

    protected final MethodVisitor getCodeVisitor() {
        return (MethodVisitor)this.this$0.peek();
    }

    protected final int getAccess(String string2) {
        int n = 0;
        if (string2.indexOf("public") != -1) {
            n |= 1;
        }
        if (string2.indexOf("private") != -1) {
            n |= 2;
        }
        if (string2.indexOf("protected") != -1) {
            n |= 4;
        }
        if (string2.indexOf("static") != -1) {
            n |= 8;
        }
        if (string2.indexOf("final") != -1) {
            n |= 0x10;
        }
        if (string2.indexOf("super") != -1) {
            n |= 0x20;
        }
        if (string2.indexOf("synchronized") != -1) {
            n |= 0x20;
        }
        if (string2.indexOf("volatile") != -1) {
            n |= 0x40;
        }
        if (string2.indexOf("bridge") != -1) {
            n |= 0x40;
        }
        if (string2.indexOf("varargs") != -1) {
            n |= 0x80;
        }
        if (string2.indexOf("transient") != -1) {
            n |= 0x80;
        }
        if (string2.indexOf("native") != -1) {
            n |= 0x100;
        }
        if (string2.indexOf("interface") != -1) {
            n |= 0x200;
        }
        if (string2.indexOf("abstract") != -1) {
            n |= 0x400;
        }
        if (string2.indexOf("strict") != -1) {
            n |= 0x800;
        }
        if (string2.indexOf("synthetic") != -1) {
            n |= 0x1000;
        }
        if (string2.indexOf("annotation") != -1) {
            n |= 0x2000;
        }
        if (string2.indexOf("enum") != -1) {
            n |= 0x4000;
        }
        if (string2.indexOf("deprecated") != -1) {
            n |= 0x20000;
        }
        return n;
    }
}

