export = Bridge;
/**
 * @constructor
 * @param {Object} opts Options to pass to the bridge
 * @param {AppServiceRegistration|string} opts.registration Application service
 * registration object or path to the registration file.
 * @param {string} opts.homeserverUrl The base HS url
 * @param {string} opts.domain The domain part for user_ids and room aliases
 * e.g. "bar" in "@foo:bar".
 * @param {string} opts.networkName A human readable string that will be used when
 * the bridge signals errors to the client. Will not include in error events if ommited.
 * @param {Object} opts.controller The controller logic for the bridge.
 * @param {Bridge~onEvent} opts.controller.onEvent Function. Called when
 * an event has been received from the HS.
 * @param {Bridge~onUserQuery=} opts.controller.onUserQuery Function. If supplied,
 * the bridge will invoke this function when queried via onUserQuery. If
 * not supplied, no users will be provisioned on user queries. Provisioned users
 * will automatically be stored in the associated <code>userStore</code>.
 * @param {Bridge~onAliasQuery=} opts.controller.onAliasQuery Function. If supplied,
 * the bridge will invoke this function when queried via onAliasQuery. If
 * not supplied, no rooms will be provisioned on alias queries. Provisioned rooms
 * will automatically be stored in the associated <code>roomStore</code>.
 * @param {Bridge~onAliasQueried=} opts.controller.onAliasQueried Function.
 * If supplied, the bridge will invoke this function when a room has been created
 * via onAliasQuery.
 * @param {Bridge~onLog=} opts.controller.onLog Function. Invoked when
 * logging. Defaults to a function which logs to the console.
 * @param {Bridge~thirdPartyLookup=} opts.controller.thirdPartyLookup Object. If
 * supplied, the bridge will respond to third-party entity lookups using the
 * contained helper functions.
 * @param {Bridge~onRoomUpgrade=} opts.controller.onRoomUpgrade Function. If
 * supplied, the bridge will invoke this function when it sees an upgrade event
 * for a room.
 * @param {(RoomBridgeStore|string)=} opts.roomStore The room store instance to
 * use, or the path to the room .db file to load. A database will be created if
 * this is not specified.
 * @param {(UserBridgeStore|string)=} opts.userStore The user store instance to
 * use, or the path to the user .db file to load. A database will be created if
 * this is not specified.
 * @param {(EventBridgeStore|string)=} opts.eventStore The event store instance to
 * use, or the path to the event .db file to load. This will NOT be created if it
 * isn't specified.
 * @param {MembershipCache=} opts.membershipCache The membership cache instance
 * to use, which can be manually created by a bridge for greater control over
 * caching. By default a membership cache will be created internally.
 * @param {boolean=} opts.suppressEcho True to stop receiving onEvent callbacks
 * for events which were sent by a bridge user. Default: true.
 * @param {ClientFactory=} opts.clientFactory The client factory instance to
 * use. If not supplied, one will be created.
 * @param {boolean} opts.logRequestOutcome True to enable SUCCESS/FAILED log lines
 * to be sent to onLog. Default: true.
 * @param {Object=} opts.intentOptions Options to supply to created Intent instances.
 * @param {Object=} opts.intentOptions.bot Options to supply to the bot intent.
 * @param {Object=} opts.intentOptions.clients Options to supply to the client intents.
 * @param {Object=} opts.escapeUserIds Escape userIds for non-bot intents with
 * {@link MatrixUser~escapeUserId}
 * Default: true
 * @param {Object=} opts.queue Options for the onEvent queue. When the bridge
 * receives an incoming transaction, it needs to asyncly query the data store for
 * contextual info before calling onEvent. A queue is used to keep the onEvent
 * calls consistent with the arrival order from the incoming transactions.
 * @param {string=} opts.queue.type The type of queue to use when feeding through
 * to {@link Bridge~onEvent}. One of: "none", single", "per_room". If "none",
 * events are fed through as soon as contextual info is obtained, which may result
 * in out of order events but stops HOL blocking. If "single", onEvent calls will
 * be in order but may be slower due to HOL blocking. If "per_room", a queue per
 * room ID is made which reduces the impact of HOL blocking to be scoped to a room.
 * Default: "single".
 * @param {boolean=} opts.queue.perRequest True to only feed through the next
 * event after the request object in the previous call succeeds or fails. It is
 * <b>vital</b> that you consistently resolve/reject the request if this is 'true',
 * else you will not get any further events from this queue. To aid debugging this,
 * consider setting a delayed listener on the request factory. If false, the mere
 * invockation of onEvent is enough to trigger the next event in the queue.
 * You probably want to set this to 'true' if your {@link Bridge~onEvent} is
 * performing async operations where ordering matters (e.g. messages). Default: false.
 * @param {boolean=} opts.disableContext True to disable {@link Bridge~BridgeContext}
 * parameters in {@link Bridge~onEvent}. Disabling the context makes the
 * bridge do fewer database lookups, but prevents there from being a
 * <code>context</code> parameter. Default: false.
 * @param {boolean=} opts.disableStores True to disable enabling of stores.
 * This should be used by bridges that use their own database instances and
 * do not need any of the included store objects. This implies setting
 * disableContext to True. Default: false.
 * @param {Object=} opts.roomLinkValidation Options to supply to the room link
 * validator. If not defined then all room links are accepted.
 * @param {string} opts.roomLinkValidation.ruleFile A file containing rules
 * on which matrix rooms can be bridged.
 * @param {Object=} opts.roomLinkValidation.rules A object containing rules
 * on which matrix rooms can be bridged. This is used if ruleFile is undefined.
 * @param {boolean=} opts.roomLinkValidation.triggerEndpoint Enable the endpoint
 * to trigger a reload of the rules file.
 * Default: false
 * @param {string} opts.authenticateThirdpartyEndpoints Should the bridge authenticate
 * requests to third party endpoints. This is false by default to be backwards-compatible
 * with Synapse.
 * @param {RoomUpgradeHandler~Options} opts.roomUpgradeOpts Options to supply to
 * the room upgrade handler. If not defined then upgrades are NOT handled by the bridge.
 */
declare function Bridge(opts: {
    registration: import("matrix-appservice").AppServiceRegistration | string;
    homeserverUrl: string;
    domain: string;
}): void;
declare class Bridge {
    /**
     * @constructor
     * @param {Object} opts Options to pass to the bridge
     * @param {AppServiceRegistration|string} opts.registration Application service
     * registration object or path to the registration file.
     * @param {string} opts.homeserverUrl The base HS url
     * @param {string} opts.domain The domain part for user_ids and room aliases
     * e.g. "bar" in "@foo:bar".
     * @param {string} opts.networkName A human readable string that will be used when
     * the bridge signals errors to the client. Will not include in error events if ommited.
     * @param {Object} opts.controller The controller logic for the bridge.
     * @param {Bridge~onEvent} opts.controller.onEvent Function. Called when
     * an event has been received from the HS.
     * @param {Bridge~onUserQuery=} opts.controller.onUserQuery Function. If supplied,
     * the bridge will invoke this function when queried via onUserQuery. If
     * not supplied, no users will be provisioned on user queries. Provisioned users
     * will automatically be stored in the associated <code>userStore</code>.
     * @param {Bridge~onAliasQuery=} opts.controller.onAliasQuery Function. If supplied,
     * the bridge will invoke this function when queried via onAliasQuery. If
     * not supplied, no rooms will be provisioned on alias queries. Provisioned rooms
     * will automatically be stored in the associated <code>roomStore</code>.
     * @param {Bridge~onAliasQueried=} opts.controller.onAliasQueried Function.
     * If supplied, the bridge will invoke this function when a room has been created
     * via onAliasQuery.
     * @param {Bridge~onLog=} opts.controller.onLog Function. Invoked when
     * logging. Defaults to a function which logs to the console.
     * @param {Bridge~thirdPartyLookup=} opts.controller.thirdPartyLookup Object. If
     * supplied, the bridge will respond to third-party entity lookups using the
     * contained helper functions.
     * @param {Bridge~onRoomUpgrade=} opts.controller.onRoomUpgrade Function. If
     * supplied, the bridge will invoke this function when it sees an upgrade event
     * for a room.
     * @param {(RoomBridgeStore|string)=} opts.roomStore The room store instance to
     * use, or the path to the room .db file to load. A database will be created if
     * this is not specified.
     * @param {(UserBridgeStore|string)=} opts.userStore The user store instance to
     * use, or the path to the user .db file to load. A database will be created if
     * this is not specified.
     * @param {(EventBridgeStore|string)=} opts.eventStore The event store instance to
     * use, or the path to the event .db file to load. This will NOT be created if it
     * isn't specified.
     * @param {MembershipCache=} opts.membershipCache The membership cache instance
     * to use, which can be manually created by a bridge for greater control over
     * caching. By default a membership cache will be created internally.
     * @param {boolean=} opts.suppressEcho True to stop receiving onEvent callbacks
     * for events which were sent by a bridge user. Default: true.
     * @param {ClientFactory=} opts.clientFactory The client factory instance to
     * use. If not supplied, one will be created.
     * @param {boolean} opts.logRequestOutcome True to enable SUCCESS/FAILED log lines
     * to be sent to onLog. Default: true.
     * @param {Object=} opts.intentOptions Options to supply to created Intent instances.
     * @param {Object=} opts.intentOptions.bot Options to supply to the bot intent.
     * @param {Object=} opts.intentOptions.clients Options to supply to the client intents.
     * @param {Object=} opts.escapeUserIds Escape userIds for non-bot intents with
     * {@link MatrixUser~escapeUserId}
     * Default: true
     * @param {Object=} opts.queue Options for the onEvent queue. When the bridge
     * receives an incoming transaction, it needs to asyncly query the data store for
     * contextual info before calling onEvent. A queue is used to keep the onEvent
     * calls consistent with the arrival order from the incoming transactions.
     * @param {string=} opts.queue.type The type of queue to use when feeding through
     * to {@link Bridge~onEvent}. One of: "none", single", "per_room". If "none",
     * events are fed through as soon as contextual info is obtained, which may result
     * in out of order events but stops HOL blocking. If "single", onEvent calls will
     * be in order but may be slower due to HOL blocking. If "per_room", a queue per
     * room ID is made which reduces the impact of HOL blocking to be scoped to a room.
     * Default: "single".
     * @param {boolean=} opts.queue.perRequest True to only feed through the next
     * event after the request object in the previous call succeeds or fails. It is
     * <b>vital</b> that you consistently resolve/reject the request if this is 'true',
     * else you will not get any further events from this queue. To aid debugging this,
     * consider setting a delayed listener on the request factory. If false, the mere
     * invockation of onEvent is enough to trigger the next event in the queue.
     * You probably want to set this to 'true' if your {@link Bridge~onEvent} is
     * performing async operations where ordering matters (e.g. messages). Default: false.
     * @param {boolean=} opts.disableContext True to disable {@link Bridge~BridgeContext}
     * parameters in {@link Bridge~onEvent}. Disabling the context makes the
     * bridge do fewer database lookups, but prevents there from being a
     * <code>context</code> parameter. Default: false.
     * @param {boolean=} opts.disableStores True to disable enabling of stores.
     * This should be used by bridges that use their own database instances and
     * do not need any of the included store objects. This implies setting
     * disableContext to True. Default: false.
     * @param {Object=} opts.roomLinkValidation Options to supply to the room link
     * validator. If not defined then all room links are accepted.
     * @param {string} opts.roomLinkValidation.ruleFile A file containing rules
     * on which matrix rooms can be bridged.
     * @param {Object=} opts.roomLinkValidation.rules A object containing rules
     * on which matrix rooms can be bridged. This is used if ruleFile is undefined.
     * @param {boolean=} opts.roomLinkValidation.triggerEndpoint Enable the endpoint
     * to trigger a reload of the rules file.
     * Default: false
     * @param {string} opts.authenticateThirdpartyEndpoints Should the bridge authenticate
     * requests to third party endpoints. This is false by default to be backwards-compatible
     * with Synapse.
     * @param {RoomUpgradeHandler~Options} opts.roomUpgradeOpts Options to supply to
     * the room upgrade handler. If not defined then upgrades are NOT handled by the bridge.
     */
    constructor(opts: {
        registration: import("matrix-appservice").AppServiceRegistration | string;
        homeserverUrl: string;
        domain: string;
    });
    appService: import("matrix-appservice").AppService | null;
    opts: {
        registration: import("matrix-appservice").AppServiceRegistration | string;
        homeserverUrl: string;
        domain: string;
    };
    _clientFactory: any;
    _botClient: any;
    _appServiceBot: import("./components/app-service-bot") | null;
    _requestFactory: import("./components/request-factory").RequestFactory | null;
    _botIntent: import("./components/intent").Intent | null;
    _intents: {};
    _intentLastAccessed: any;
    _intentLastAccessedTimeout: NodeJS.Timeout | null;
    _powerLevelMap: {};
    _membershipCache: any;
    _intentBackingStore: {
        setMembership: any;
        setPowerLevelContent: (roomId: any, content: any) => void;
        getMembership: any;
        getPowerLevelContent: (roomId: any) => any;
    };
    _queue: import("./components/event-queue").EventQueueSingle | import("./components/event-queue").EventQueuePerRoom | import("./components/event-queue").EventQueueNone;
    _prevRequestPromise: import("bluebird")<void>;
    _metrics: import("./components/prometheusmetrics").PrometheusMetrics | null;
    _roomLinkValidator: any;
    _roomUpgradeHandler: import("./components/room-upgrade-handler") | null;
    loadDatabases(): import("bluebird")<any>;
    _userStore: any;
    _roomStore: any;
    _eventStore: any;
    run(port: number, config: Object, appServiceInstance?: import("matrix-appservice").AppService | undefined, hostname: string): import("bluebird")<any>;
    _customiseAppservice(): void;
    _setupIntentCulling(): void;
    _customiseAppserviceThirdPartyLookup(lookupController: any): void;
    addAppServicePath(opts: {
        method: string;
        path: string;
        checkToken: string;
    }): void;
    getRoomStore(): import("./components/room-bridge-store") | null;
    getUserStore(): import("./components/user-bridge-store") | null;
    getEventStore(): import("./components/event-bridge-store") | null;
    getRequestFactory(): import("./components/request-factory").RequestFactory;
    getClientFactory(): import("./components/client-factory").ClientFactory;
    getBot(): import("./components/app-service-bot");
    canProvisionRoom(roomId: string, cache?: boolean): Promise<any>;
    getRoomLinkValidator(): any;
    getIntent(userId: string | null, request?: Request | undefined): import("./components/intent").Intent;
    getIntentFromLocalpart(localpart: string | null, request?: Request | undefined): import("./components/intent").Intent;
    provisionUser(matrixUser: import("./models/users/matrix"), provisionedUser: any): Promise<any>;
    _provisionUser(matrixUser: any, provisionedUser: any): Promise<void>;
    _onUserQuery(userId: any): Promise<void>;
    _onAliasQuery(alias: any): import("bluebird")<void>;
    __onAliasQuery(alias: any): Promise<void>;
    _onEvent(event: any): import("bluebird")<unknown>;
    __onEvent(event: any): Promise<unknown>;
    _limited(promise: any, request: any): Promise<any>;
    _onConsume(err: any, data: any): void;
    _getBridgeContext(event: any): Promise<import("./components/bridge-context") | null>;
    _handleEventError(event: any, error: any): void;
    _getUserRegex(): string;
    _updateIntents(event: any): void;
    _setPowerLevelEntry(roomId: any, content: any): void;
    _getPowerLevelEntry(roomId: any): any;
    getPrometheusMetrics(registerEndpoint?: boolean, registry?: any | null): import("./components/prometheusmetrics").PrometheusMetrics;
    registerBridgeGauges(counterFunc: any): void;
    requestCheckToken(req: any): boolean;
}
declare namespace Bridge {
    export { Bridge };
}
/**
 * ~ProvisionedUser
 */
type Bridge = {
    /**
     * The display name to set for the provisioned user.
     */
    name?: string | undefined;
    /**
     * The avatar URL to set for the provisioned user.
     */
    url?: string | undefined;
    /**
     * The remote user to link to the provisioned user.
     */
    remote?: any | undefined;
};
