export = BridgeContext;
/**
 * Bridge context.
 *
 * @property {Object} senders Data models on senders of this event
 * @property {MatrixUser} senders.matrix The sender of this event
 * @property {?RemoteUser} senders.remote The first linked remote sender: remotes[0]
 * @property {RemoteUser[]} senders.remotes The linked remote senders
 * @property {Object} targets Data models on targets (e.g. state_key in
 * m.room.member) of this event.
 * @property {?MatrixUser} targets.matrix The target of this event if applicable.
 * @property {?RemoteUser} targets.remote The first linked remote target: remotes[0]
 * @property {RemoteUser[]} targets.remotes The linked remote targets
 * @property {Object} rooms Data models on rooms concerning this event.
 * @property {MatrixRoom} rooms.matrix The room for this event.
 * @property {?RemoteRoom} rooms.remote The first linked remote room: remotes[0]
 * @property {RemoteRoom[]} rooms.remotes The linked remote rooms for this event
 */
declare class BridgeContext {
    /**
     * @param {Object} ctx Event related data
     * @param {string} ctx.sender Matrix user ID of the sender.
     * @param {string=} ctx.target Matrix user ID of the target.
     * @param {string} ctx.room Matrix room ID.
     */
    constructor(ctx: {
        sender: string;
        target?: string | undefined;
        room: string;
    });
    _ctx: {
        sender: string;
        target?: string | undefined;
        room: string;
    };
    senders: {
        matrix: import("../models/users/matrix");
        remote: null;
        remotes: never[];
    };
    targets: {
        matrix: import("../models/users/matrix") | null;
        remote: null;
        remotes: never[];
    };
    rooms: {
        matrix: import("../models/rooms/matrix");
        remote: null;
        remotes: never[];
    };
    /**
     * Returns this instance after its initialization.
     *
     * @param {RoomBridgeStore} roomStore
     * @param {UserBridgeStore} userStore
     * @returns {Promise<BridgeContext>}
     */
    get(roomStore: any, userStore: any): Promise<BridgeContext>;
}
declare const Promise: typeof import("bluebird");
