/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.MapWriter;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.pkg.PackageAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageLoader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private final Map<String, Package> packageClassLoaders = new ConcurrentHashMap<String, Package>();
    private PackageAPI.Packages myCopy = new PackageAPI.Packages();
    private PackageAPI packageAPI;

    public PackageLoader(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.packageAPI = new PackageAPI(coreContainer, this);
        this.refreshPackageConf();
    }

    public PackageAPI getPackageAPI() {
        return this.packageAPI;
    }

    public Package getPackage(String key) {
        return this.packageClassLoaders.get(key);
    }

    public Map<String, Package> getPackages() {
        return Collections.EMPTY_MAP;
    }

    public void refreshPackageConf() {
        log.info("{} updated to version {}", (Object)"/packages.json", (Object)this.packageAPI.pkgs.znodeVersion);
        ArrayList<Package> updated = new ArrayList<Package>();
        Map<String, List<PackageAPI.PkgVersion>> modified = this.getModified(this.myCopy, this.packageAPI.pkgs);
        for (Map.Entry<String, List<PackageAPI.PkgVersion>> e : modified.entrySet()) {
            Package p;
            if (e.getValue() != null) {
                p = this.packageClassLoaders.get(e.getKey());
                if (e.getValue() != null && p == null) {
                    p = new Package(e.getKey());
                    this.packageClassLoaders.put(e.getKey(), p);
                }
                p.updateVersions(e.getValue());
                updated.add(p);
                continue;
            }
            p = this.packageClassLoaders.remove(e.getKey());
            if (p == null) continue;
            p.markDeleted();
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{p});
        }
        for (SolrCore core : this.coreContainer.getCores()) {
            core.getPackageListeners().packagesUpdated(updated);
        }
        this.myCopy = this.packageAPI.pkgs;
    }

    public Map<String, List<PackageAPI.PkgVersion>> getModified(PackageAPI.Packages old, PackageAPI.Packages newPkgs) {
        HashMap<String, List<PackageAPI.PkgVersion>> changed = new HashMap<String, List<PackageAPI.PkgVersion>>();
        for (Map.Entry<String, List<PackageAPI.PkgVersion>> e : newPkgs.packages.entrySet()) {
            List<PackageAPI.PkgVersion> versions = old.packages.get(e.getKey());
            if (versions != null) {
                if (Objects.equals(e.getValue(), versions)) continue;
                if (log.isInfoEnabled()) {
                    log.info("Package {} is modified ", (Object)e.getKey());
                }
                changed.put(e.getKey(), e.getValue());
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info("A new package: {} introduced", (Object)e.getKey());
            }
            changed.put(e.getKey(), e.getValue());
        }
        for (String s : old.packages.keySet()) {
            if (newPkgs.packages.keySet().contains(s)) continue;
            log.info("Package: {} is removed althogether", (Object)s);
            changed.put(s, null);
        }
        return changed;
    }

    public void notifyListeners(String pkg) {
        Package p = this.packageClassLoaders.get(pkg);
        if (p != null) {
            List<Package> l = Collections.singletonList(p);
            for (SolrCore core : this.coreContainer.getCores()) {
                core.getPackageListeners().packagesUpdated(l);
            }
        }
    }

    private static String findBiggest(String lessThan, List<String> sortedList) {
        String latest = null;
        for (String v : sortedList) {
            if (v.compareTo(lessThan) >= 1) break;
            latest = v;
        }
        return latest;
    }

    @Override
    public void close() {
        for (Package p : this.packageClassLoaders.values()) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{p});
        }
    }

    public class Package
    implements Closeable {
        final String name;
        final Map<String, Version> myVersions = new ConcurrentHashMap<String, Version>();
        private List<String> sortedVersions = new CopyOnWriteArrayList<String>();
        String latest;
        private boolean deleted;

        Package(String name) {
            this.name = name;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public Set<String> allVersions() {
            return this.myVersions.keySet();
        }

        private synchronized void updateVersions(List<PackageAPI.PkgVersion> modified) {
            for (PackageAPI.PkgVersion pkgVersion : modified) {
                Version version = this.myVersions.get(pkgVersion.version);
                if (version != null) continue;
                log.info("A new version: {} added for package: {} with artifacts {}", new Object[]{pkgVersion.version, this.name, pkgVersion.files});
                Version ver = null;
                try {
                    ver = new Version(this, pkgVersion);
                }
                catch (Exception e) {
                    log.error("package could not be loaded {}", (Object)ver, (Object)e);
                    continue;
                }
                this.myVersions.put(pkgVersion.version, ver);
                this.sortedVersions.add(pkgVersion.version);
            }
            HashSet<String> newVersions = new HashSet<String>();
            for (PackageAPI.PkgVersion v : modified) {
                newVersions.add(v.version);
            }
            for (String s : new HashSet<String>(this.myVersions.keySet())) {
                if (newVersions.contains(s)) continue;
                log.info("version: {} is removed from package: {}", (Object)s, (Object)this.name);
                this.sortedVersions.remove(s);
                Version removed = this.myVersions.remove(s);
                if (removed == null) continue;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{removed});
            }
            this.sortedVersions.sort(String::compareTo);
            if (this.sortedVersions.size() > 0) {
                String string = this.sortedVersions.get(this.sortedVersions.size() - 1);
                if (!string.equals(this.latest)) {
                    log.info("version: {} is the new latest in package: {}", (Object)string, (Object)this.name);
                }
                this.latest = string;
            } else {
                log.error("latest version:  null");
                this.latest = null;
            }
        }

        public Version getLatest() {
            return this.latest == null ? null : this.myVersions.get(this.latest);
        }

        public Version getVersion(String version) {
            return this.myVersions.get(version);
        }

        public Version getLatest(String lessThan) {
            if (lessThan == null) {
                return this.getLatest();
            }
            String latest = PackageLoader.findBiggest(lessThan, new ArrayList<String>(this.sortedVersions));
            return latest == null ? null : this.myVersions.get(latest);
        }

        public String name() {
            return this.name;
        }

        private void markDeleted() {
            this.deleted = true;
            this.myVersions.clear();
            this.sortedVersions.clear();
            this.latest = null;
        }

        @Override
        public void close() throws IOException {
            for (Version v : this.myVersions.values()) {
                v.close();
            }
        }

        public class Version
        implements MapWriter,
        Closeable {
            private final Package parent;
            private SolrResourceLoader loader;
            private final PackageAPI.PkgVersion version;

            public void writeMap(MapWriter.EntryWriter ew) throws IOException {
                ew.put((CharSequence)"package", (CharSequence)this.parent.name());
                this.version.writeMap(ew);
            }

            Version(Package parent, PackageAPI.PkgVersion v) {
                this.parent = parent;
                this.version = v;
                ArrayList<Path> paths = new ArrayList<Path>();
                ArrayList errs = new ArrayList();
                PackageLoader.this.coreContainer.getPackageStoreAPI().validateFiles(this.version.files, true, s -> errs.add(s));
                if (!errs.isEmpty()) {
                    throw new RuntimeException("Cannot load package: " + errs);
                }
                for (String file : this.version.files) {
                    paths.add(PackageLoader.this.coreContainer.getPackageStoreAPI().getPackageStore().getRealpath(file));
                }
                this.loader = new PackageResourceLoader("PACKAGE_LOADER: " + parent.name() + ":" + this.version, paths, Paths.get(PackageLoader.this.coreContainer.getSolrHome(), new String[0]), PackageLoader.this.coreContainer.getResourceLoader().getClassLoader());
            }

            public String getVersion() {
                return this.version.version;
            }

            public Collection getFiles() {
                return Collections.unmodifiableList(this.version.files);
            }

            public SolrResourceLoader getLoader() {
                return this.loader;
            }

            @Override
            public void close() throws IOException {
                if (this.loader != null) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
                }
            }

            public String toString() {
                return this.jsonStr();
            }
        }
    }

    static class PackageResourceLoader
    extends SolrResourceLoader {
        List<Path> paths;

        PackageResourceLoader(String name, List<Path> classpath, Path instanceDir, ClassLoader parent) {
            super(name, classpath, instanceDir, parent);
            this.paths = classpath;
        }

        @Override
        public <T> boolean addToCoreAware(T obj) {
            return false;
        }

        @Override
        public <T> boolean addToResourceLoaderAware(T obj) {
            return false;
        }

        @Override
        public <T> void addToInfoBeans(T obj) {
        }

        @Override
        public InputStream openResource(String resource) {
            return this.getClassLoader().getResourceAsStream(resource);
        }
    }
}

