/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import org.apache.solr.handler.export.PriorityQueue;
import org.apache.solr.handler.export.SortDoc;

class SortQueue
extends PriorityQueue<SortDoc> {
    private SortDoc proto;
    private Object[] cache;

    public SortQueue(int len, SortDoc proto) {
        super(len);
        this.proto = proto;
    }

    @Override
    protected boolean lessThan(SortDoc t1, SortDoc t2) {
        return t1.lessThan(t2);
    }

    protected void populate() {
        Object[] heap = this.getHeapArray();
        this.cache = new SortDoc[heap.length];
        for (int i = 1; i < heap.length; ++i) {
            this.cache[i] = heap[i] = this.proto.copy();
        }
        this.size = this.maxSize;
    }

    protected void reset() {
        Object[] heap = this.getHeapArray();
        if (this.cache != null) {
            System.arraycopy(this.cache, 1, heap, 1, heap.length - 1);
            this.size = this.maxSize;
        } else {
            this.populate();
        }
    }
}

