/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters.solr;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.http.client.HttpClient;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrCoreContainerReporter;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.reporters.solr.SolrReporter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClusterReporter
extends SolrCoreContainerReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CLUSTER_GROUP = SolrMetricManager.enforcePrefix(SolrInfoBean.Group.cluster.toString());
    public static final List<SolrReporter.Report> DEFAULT_REPORTS = new ArrayList<SolrReporter.Report>(){
        {
            this.add(new SolrReporter.Report(CLUSTER_GROUP, "jetty", SolrMetricManager.enforcePrefix(SolrInfoBean.Group.jetty.toString()), Collections.emptySet()));
            this.add(new SolrReporter.Report(CLUSTER_GROUP, "jvm", SolrMetricManager.enforcePrefix(SolrInfoBean.Group.jvm.toString()), (Collection<String>)new HashSet<String>(){
                {
                    this.add("memory\\.total\\..*");
                    this.add("memory\\.heap\\..*");
                    this.add("os\\.SystemLoadAverage");
                    this.add("os\\.FreePhysicalMemorySize");
                    this.add("os\\.FreeSwapSpaceSize");
                    this.add("os\\.OpenFileDescriptorCount");
                    this.add("threads\\.count");
                }
            }));
            this.add(new SolrReporter.Report(CLUSTER_GROUP, "node", SolrMetricManager.enforcePrefix(SolrInfoBean.Group.node.toString()), (Collection<String>)new HashSet<String>(){
                {
                    this.add("CONTAINER\\.cores\\..*");
                    this.add("CONTAINER\\.fs\\..*");
                }
            }));
            this.add(new SolrReporter.Report(CLUSTER_GROUP, "leader.$1", "solr\\.core\\.(.*)\\.leader", (Collection<String>)new HashSet<String>(){
                {
                    this.add("UPDATE\\./update/.*");
                    this.add("QUERY\\./select.*");
                    this.add("INDEX\\..*");
                    this.add("TLOG\\..*");
                }
            }));
        }
    };
    private String handler = "/admin/metrics/collector";
    private List<SolrReporter.Report> reports = new ArrayList<SolrReporter.Report>();
    private SolrReporter reporter;

    public SolrClusterReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public void setReport(List<Map> reportConfig) {
        if (reportConfig == null || reportConfig.isEmpty()) {
            return;
        }
        reportConfig.forEach(map -> {
            SolrReporter.Report r = SolrReporter.Report.fromMap(map);
            if (r != null) {
                this.reports.add(r);
            }
        });
    }

    public void setReport(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        SolrReporter.Report r = SolrReporter.Report.fromMap(map);
        if (r != null) {
            this.reports.add(r);
        }
    }

    List<SolrReporter.Report> getReports() {
        return this.reports;
    }

    @Override
    protected void doInit() {
        if (this.reports.isEmpty()) {
            this.reports = DEFAULT_REPORTS;
        }
    }

    @Override
    protected void validate() throws IllegalStateException {
    }

    @Override
    public void close() throws IOException {
        if (this.reporter != null) {
            this.reporter.close();
        }
    }

    @Override
    public void init(PluginInfo pluginInfo, CoreContainer cc) {
        super.init(pluginInfo, cc);
        if (this.reporter != null) {
            this.reporter.close();
        }
        if (!this.enabled) {
            log.info("Reporter disabled for registry {}", (Object)this.registryName);
            return;
        }
        if (!cc.isZooKeeperAware()) {
            log.warn("Not ZK-aware, not starting...");
            return;
        }
        if (this.period < 1) {
            log.info("Turning off node reporter, period={}", (Object)this.period);
            return;
        }
        HttpClient httpClient = cc.getUpdateShardHandler().getDefaultHttpClient();
        ZkController zk = cc.getZkController();
        String reporterId = zk.getNodeName();
        this.reporter = SolrReporter.Builder.forReports(this.metricManager, this.reports).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).withHandler(this.handler).withReporterId(reporterId).setCompact(true).cloudClient(false).skipAggregateValues(true).skipHistograms(true).build(httpClient, (Supplier<String>)new OverseerUrlSupplier(zk));
        this.reporter.start(this.period, TimeUnit.SECONDS);
    }

    static class OverseerUrlSupplier
    implements Supplier<String> {
        private static final long DEFAULT_INTERVAL = 30000000L;
        private ZkController zk;
        private String lastKnownUrl = null;
        private long lastCheckTime = 0L;
        private long interval = 30000000L;

        OverseerUrlSupplier(ZkController zk) {
            this.zk = zk;
        }

        @Override
        public String get() {
            ZkNodeProps props;
            if (this.zk == null) {
                return null;
            }
            long now = System.nanoTime();
            if (this.lastKnownUrl != null && now - this.lastCheckTime < this.interval) {
                return this.lastKnownUrl;
            }
            if (!this.zk.isConnected()) {
                return this.lastKnownUrl;
            }
            this.lastCheckTime = now;
            SolrZkClient zkClient = this.zk.getZkClient();
            try {
                props = ZkNodeProps.load((byte[])zkClient.getData("/overseer_elect/leader", null, null, true));
            }
            catch (KeeperException e) {
                log.warn("Could not obtain overseer's address, skipping.", (Throwable)e);
                return this.lastKnownUrl;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this.lastKnownUrl;
            }
            if (props == null) {
                return this.lastKnownUrl;
            }
            String oid = props.getStr("id");
            if (oid == null) {
                return this.lastKnownUrl;
            }
            String nodeName = null;
            try {
                nodeName = LeaderElector.getNodeName(oid);
            }
            catch (Exception e) {
                log.warn("Unknown format of leader id, skipping: {}", (Object)oid, (Object)e);
                return this.lastKnownUrl;
            }
            String url = this.zk.getZkStateReader().getBaseUrlForNodeName(nodeName);
            try {
                new URL(url);
            }
            catch (MalformedURLException mue) {
                log.warn("Malformed Overseer's leader URL: url", (Throwable)mue);
                return this.lastKnownUrl;
            }
            this.lastKnownUrl = url;
            return url;
        }
    }
}

