/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FilterNumericDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

final class NumericFacets {
    NumericFacets() {
    }

    public static NamedList<Integer> getCounts(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort) throws IOException {
        SchemaField sf = searcher.getSchema().getField(fieldName);
        if (sf.multiValued()) {
            return NumericFacets.getCountsMultiValued(searcher, docs, fieldName, offset, limit, mincount, missing, sort);
        }
        return NumericFacets.getCountsSingleValue(searcher, docs, fieldName, offset, limit, mincount, missing, sort);
    }

    private static NamedList<Integer> getCountsSingleValue(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort) throws IOException {
        NamedList result;
        int missingCount;
        block40: {
            ValueSource vs;
            PriorityQueue<Entry> pq;
            List leaves;
            FieldType ft;
            SchemaField sf;
            block39: {
                FunctionValues values;
                int readerIdx;
                boolean zeros = mincount <= 0;
                mincount = Math.max(mincount, 1);
                sf = searcher.getSchema().getField(fieldName);
                ft = sf.getType();
                NumberType numericType = ft.getNumberType();
                if (numericType == null) {
                    throw new IllegalStateException();
                }
                zeros = zeros && !ft.isPointField() && sf.indexed();
                leaves = searcher.getIndexReader().leaves();
                HashTable hashTable = new HashTable(true);
                Iterator ctxIt = leaves.iterator();
                LeafReaderContext ctx = null;
                Object longs = null;
                missingCount = 0;
                DocIterator docsIt = docs.iterator();
                while (docsIt.hasNext()) {
                    int valuesDocID;
                    int doc = docsIt.nextDoc();
                    if (ctx == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                        while ((ctx = (LeafReaderContext)ctxIt.next()) == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                        }
                        assert (doc >= ctx.docBase);
                        switch (numericType) {
                            case LONG: 
                            case DATE: 
                            case INTEGER: {
                                longs = DocValues.getNumeric((LeafReader)ctx.reader(), (String)fieldName);
                                break;
                            }
                            case FLOAT: {
                                longs = new FilterNumericDocValues(DocValues.getNumeric((LeafReader)ctx.reader(), (String)fieldName)){

                                    public long longValue() throws IOException {
                                        long bits = super.longValue();
                                        if (bits < 0L) {
                                            bits ^= Long.MAX_VALUE;
                                        }
                                        return bits;
                                    }
                                };
                                break;
                            }
                            case DOUBLE: {
                                longs = new FilterNumericDocValues(DocValues.getNumeric((LeafReader)ctx.reader(), (String)fieldName)){

                                    public long longValue() throws IOException {
                                        long bits = super.longValue();
                                        if (bits < 0L) {
                                            bits ^= Long.MAX_VALUE;
                                        }
                                        return bits;
                                    }
                                };
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unexpected type: " + (Object)((Object)numericType)));
                            }
                        }
                    }
                    if ((valuesDocID = longs.docID()) < doc - ctx.docBase) {
                        valuesDocID = longs.advance(doc - ctx.docBase);
                    }
                    if (valuesDocID == doc - ctx.docBase) {
                        hashTable.add(doc, longs.longValue(), 1);
                        continue;
                    }
                    ++missingCount;
                }
                result = new NamedList();
                if (limit == 0) {
                    return NumericFacets.finalize((NamedList<Integer>)result, missingCount, missing);
                }
                int pqSize = limit < 0 ? hashTable.size : Math.min(offset + limit, hashTable.size);
                pq = "count".equals(sort) || "true".equals(sort) ? new PriorityQueue<Entry>(pqSize){

                    protected boolean lessThan(Entry a, Entry b) {
                        return a.count < b.count || a.count == b.count && a.bits > b.bits;
                    }
                } : new PriorityQueue<Entry>(pqSize){

                    protected boolean lessThan(Entry a, Entry b) {
                        return a.bits > b.bits;
                    }
                };
                Entry e = null;
                for (int i = 0; i < hashTable.bits.length; ++i) {
                    if (hashTable.counts[i] < mincount) continue;
                    if (e == null) {
                        e = new Entry();
                    }
                    e.bits = hashTable.bits[i];
                    e.count = hashTable.counts[i];
                    e.docID = hashTable.docIDs[i];
                    e = (Entry)pq.insertWithOverflow((Object)e);
                }
                vs = ft.getValueSource(sf, null);
                if (zeros && !"count".equals(sort) && !"true".equals(sort)) break block39;
                ArrayDeque<Entry> counts = new ArrayDeque<Entry>();
                while (pq.size() > offset) {
                    counts.addFirst((Entry)pq.pop());
                }
                for (Entry entry : counts) {
                    readerIdx = ReaderUtil.subIndex((int)entry.docID, (List)leaves);
                    values = vs.getValues(Collections.emptyMap(), (LeafReaderContext)leaves.get(readerIdx));
                    result.add(values.strVal(entry.docID - ((LeafReaderContext)leaves.get((int)readerIdx)).docBase), (Object)entry.count);
                }
                if (!zeros || limit >= 0 && result.size() >= limit) break block40;
                if (!sf.indexed() && !sf.hasDocValues()) {
                    throw new IllegalStateException("Cannot use facet.mincount=0 on field " + sf.getName() + " which is neither indexed nor docValues");
                }
                HashSet<String> alreadySeen = new HashSet<String>();
                while (pq.size() > 0) {
                    Entry entry;
                    entry = (Entry)pq.pop();
                    readerIdx = ReaderUtil.subIndex((int)entry.docID, (List)leaves);
                    values = vs.getValues(Collections.emptyMap(), (LeafReaderContext)leaves.get(readerIdx));
                    alreadySeen.add(values.strVal(entry.docID - ((LeafReaderContext)leaves.get((int)readerIdx)).docBase));
                }
                for (int i = 0; i < result.size(); ++i) {
                    alreadySeen.add(result.getName(i));
                }
                Terms terms = searcher.getSlowAtomicReader().terms(fieldName);
                if (terms != null) {
                    BytesRef term;
                    String prefixStr = TrieField.getMainValuePrefix(ft);
                    BytesRef prefix = prefixStr != null ? new BytesRef((CharSequence)prefixStr) : new BytesRef();
                    TermsEnum termsEnum = terms.iterator();
                    switch (termsEnum.seekCeil(prefix)) {
                        case FOUND: 
                        case NOT_FOUND: {
                            term = termsEnum.term();
                            break;
                        }
                        case END: {
                            term = null;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    CharsRefBuilder spare = new CharsRefBuilder();
                    int skipped = hashTable.size;
                    while (skipped < offset && term != null && StringHelper.startsWith((BytesRef)term, (BytesRef)prefix)) {
                        ft.indexedToReadable(term, spare);
                        String termStr = spare.toString();
                        if (!alreadySeen.contains(termStr)) {
                            ++skipped;
                        }
                        term = termsEnum.next();
                    }
                    while (term != null && StringHelper.startsWith((BytesRef)term, (BytesRef)prefix) && (limit < 0 || result.size() < limit)) {
                        ft.indexedToReadable(term, spare);
                        String termStr = spare.toString();
                        if (!alreadySeen.contains(termStr)) {
                            result.add(termStr, (Object)0);
                        }
                        term = termsEnum.next();
                    }
                }
                break block40;
            }
            if (!sf.indexed()) {
                throw new IllegalStateException("Cannot use facet.sort=index on a field which is not indexed");
            }
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            while (pq.size() > 0) {
                Entry entry = (Entry)pq.pop();
                int readerIdx = ReaderUtil.subIndex((int)entry.docID, (List)leaves);
                FunctionValues values = vs.getValues(Collections.emptyMap(), (LeafReaderContext)leaves.get(readerIdx));
                counts.put(values.strVal(entry.docID - ((LeafReaderContext)leaves.get((int)readerIdx)).docBase), entry.count);
            }
            Terms terms = searcher.getSlowAtomicReader().terms(fieldName);
            if (terms != null) {
                BytesRef term;
                String prefixStr = TrieField.getMainValuePrefix(ft);
                BytesRef prefix = prefixStr != null ? new BytesRef((CharSequence)prefixStr) : new BytesRef();
                TermsEnum termsEnum = terms.iterator();
                switch (termsEnum.seekCeil(prefix)) {
                    case FOUND: 
                    case NOT_FOUND: {
                        term = termsEnum.term();
                        break;
                    }
                    case END: {
                        term = null;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                CharsRefBuilder spare = new CharsRefBuilder();
                for (int i = 0; i < offset && term != null && StringHelper.startsWith((BytesRef)term, (BytesRef)prefix); ++i) {
                    term = termsEnum.next();
                }
                while (term != null && StringHelper.startsWith((BytesRef)term, (BytesRef)prefix) && (limit < 0 || result.size() < limit)) {
                    ft.indexedToReadable(term, spare);
                    String termStr = spare.toString();
                    Integer count = (Integer)counts.get(termStr);
                    if (count == null) {
                        count = 0;
                    }
                    result.add(termStr, (Object)count);
                    term = termsEnum.next();
                }
            }
        }
        return NumericFacets.finalize((NamedList<Integer>)result, missingCount, missing);
    }

    private static NamedList<Integer> getCountsMultiValued(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort) throws IOException {
        mincount = Math.max(mincount, 1);
        SchemaField sf = searcher.getSchema().getField(fieldName);
        FieldType ft = sf.getType();
        assert (sf.multiValued());
        List leaves = searcher.getIndexReader().leaves();
        HashTable hashTable = new HashTable(false);
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        SortedNumericDocValues longs = null;
        int missingCount = 0;
        DocIterator docsIt = docs.iterator();
        while (docsIt.hasNext()) {
            int valuesDocID;
            int doc = docsIt.nextDoc();
            if (ctx == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                while ((ctx = (LeafReaderContext)ctxIt.next()) == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                }
                assert (doc >= ctx.docBase);
                longs = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)fieldName);
            }
            if ((valuesDocID = longs.docID()) < doc - ctx.docBase) {
                valuesDocID = longs.advance(doc - ctx.docBase);
            }
            if (valuesDocID == doc - ctx.docBase) {
                long l = longs.nextValue();
                hashTable.add(l, 1);
                int count = longs.docValueCount();
                for (int i = 1; i < count; ++i) {
                    long lnew = longs.nextValue();
                    if (lnew > l) {
                        hashTable.add(lnew, 1);
                    }
                    l = lnew;
                }
                continue;
            }
            ++missingCount;
        }
        if (limit == 0) {
            NamedList result = new NamedList();
            return NumericFacets.finalize((NamedList<Integer>)result, missingCount, missing);
        }
        int pqSize = limit < 0 ? hashTable.size : Math.min(offset + limit, hashTable.size);
        PriorityQueue<Entry> pq = "count".equals(sort) || "true".equals(sort) ? new PriorityQueue<Entry>(pqSize){

            protected boolean lessThan(Entry a, Entry b) {
                return a.count < b.count || a.count == b.count && a.bits > b.bits;
            }
        } : new PriorityQueue<Entry>(pqSize){

            protected boolean lessThan(Entry a, Entry b) {
                return a.bits > b.bits;
            }
        };
        Entry e = null;
        for (int i = 0; i < hashTable.bits.length; ++i) {
            if (hashTable.counts[i] < mincount) continue;
            if (e == null) {
                e = new Entry();
            }
            e.bits = hashTable.bits[i];
            e.count = hashTable.counts[i];
            e = (Entry)pq.insertWithOverflow((Object)e);
        }
        NamedList result = new NamedList(Math.max(pq.size() - offset + 1, 1));
        ArrayDeque<Entry> counts = new ArrayDeque<Entry>(pq.size() - offset);
        while (pq.size() > offset) {
            counts.addFirst((Entry)pq.pop());
        }
        for (Entry entry : counts) {
            result.add(NumericFacets.bitsToStringValue(ft, entry.bits), (Object)entry.count);
        }
        return NumericFacets.finalize((NamedList<Integer>)result, missingCount, missing);
    }

    private static NamedList<Integer> finalize(NamedList<Integer> result, int missingCount, boolean missing) {
        if (missing) {
            result.add(null, (Object)missingCount);
        }
        return result;
    }

    private static String bitsToStringValue(FieldType fieldType, long bits) {
        switch (fieldType.getNumberType()) {
            case LONG: 
            case INTEGER: {
                return String.valueOf(bits);
            }
            case FLOAT: {
                return String.valueOf(NumericUtils.sortableIntToFloat((int)((int)bits)));
            }
            case DOUBLE: {
                return String.valueOf(NumericUtils.sortableLongToDouble((long)bits));
            }
            case DATE: {
                return new Date(bits).toInstant().toString();
            }
        }
        throw new AssertionError((Object)("Unsupported NumberType: " + (Object)((Object)fieldType.getNumberType())));
    }

    static class HashTable {
        static final float LOAD_FACTOR = 0.7f;
        long[] bits;
        int[] counts;
        int[] docIDs;
        int mask;
        int size;
        int threshold;

        HashTable(boolean needsDocId) {
            int capacity = 64;
            this.bits = new long[64];
            this.counts = new int[64];
            if (needsDocId) {
                this.docIDs = new int[64];
            }
            this.mask = 63;
            this.size = 0;
            this.threshold = 44;
        }

        private int hash(long v) {
            int h = (int)(v ^ v >>> 32);
            h = 31 * h & this.mask;
            return h;
        }

        void add(int docID, long value, int count) {
            int h;
            if (this.size >= this.threshold) {
                this.rehash();
            }
            int slot = h = this.hash(value);
            while (true) {
                if (this.counts[slot] == 0) {
                    this.bits[slot] = value;
                    this.docIDs[slot] = docID;
                    ++this.size;
                    break;
                }
                if (this.bits[slot] == value) {
                    break;
                }
                slot = slot + 1 & this.mask;
            }
            int n = slot;
            this.counts[n] = this.counts[n] + count;
        }

        void add(long value, int count) {
            int h;
            if (this.size >= this.threshold) {
                this.rehash();
            }
            int slot = h = this.hash(value);
            while (true) {
                if (this.counts[slot] == 0) {
                    this.bits[slot] = value;
                    ++this.size;
                    break;
                }
                if (this.bits[slot] == value) {
                    break;
                }
                slot = slot + 1 & this.mask;
            }
            int n = slot;
            this.counts[n] = this.counts[n] + count;
        }

        private void rehash() {
            long[] oldBits = this.bits;
            int[] oldCounts = this.counts;
            int[] oldDocIDs = this.docIDs;
            int newCapacity = this.bits.length * 2;
            this.bits = new long[newCapacity];
            this.counts = new int[newCapacity];
            if (oldDocIDs != null) {
                this.docIDs = new int[newCapacity];
            }
            this.mask = newCapacity - 1;
            this.threshold = (int)(0.7f * (float)newCapacity);
            this.size = 0;
            if (oldDocIDs != null) {
                for (int i = 0; i < oldBits.length; ++i) {
                    if (oldCounts[i] <= 0) continue;
                    this.add(oldDocIDs[i], oldBits[i], oldCounts[i]);
                }
            } else {
                for (int i = 0; i < oldBits.length; ++i) {
                    if (oldCounts[i] <= 0) continue;
                    this.add(oldBits[i], oldCounts[i]);
                }
            }
        }
    }

    private static class Entry {
        int docID;
        int count;
        long bits;

        private Entry() {
        }
    }
}

