/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.common.SolrException;

class StringFilterFunction
extends StringValue.AbstractStringValue {
    private final StringValue baseExpr;
    private final BooleanValue filterExpr;
    public static final String name = "filter";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;

    public StringFilterFunction(StringValue baseExpr, BooleanValue filterExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.filterExpr = filterExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, filterExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, filterExpr);
    }

    @Override
    public String getString() {
        String value = this.baseExpr.getString();
        this.exists = this.baseExpr.exists() && this.filterExpr.getBoolean() && this.filterExpr.exists();
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

