/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public class PackedQuadPrefixTree
extends QuadPrefixTree {
    public static final int MAX_LEVELS_POSSIBLE = 29;
    protected static final byte[] QUAD = new byte[]{0, 1, 2, 3};
    protected boolean leafyPrune = true;

    public PackedQuadPrefixTree(SpatialContext ctx, int maxLevels) {
        super(ctx, maxLevels);
        if (maxLevels > 29) {
            throw new IllegalArgumentException("maxLevels of " + maxLevels + " exceeds limit of " + 29);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(maxLevels:" + this.maxLevels + ",ctx:" + this.ctx + ",prune:" + this.leafyPrune + ")";
    }

    @Override
    public Cell getWorldCell() {
        return new PackedQuadCell(0L);
    }

    @Override
    public Cell getCell(Point p, int level) {
        if (!this.robust) {
            ArrayList<Cell> cells = new ArrayList<Cell>(1);
            this.buildNotRobustly(this.xmid, this.ymid, 0, cells, 0L, (Shape)this.ctx.makePoint(p.getX(), p.getY()), level);
            if (!cells.isEmpty()) {
                return (Cell)cells.get(0);
            }
        }
        double currentXmid = this.xmid;
        double currentYmid = this.ymid;
        double xp = p.getX();
        double yp = p.getY();
        long term = 0L;
        int levelLimit = level > this.maxLevels ? this.maxLevels : level;
        SpatialRelation rel = SpatialRelation.CONTAINS;
        for (int lvl = 0; lvl < levelLimit; ++lvl) {
            int quad = this.battenberg(currentXmid, currentYmid, xp, yp);
            double halfWidth = this.levelW[lvl + 1];
            double halfHeight = this.levelH[lvl + 1];
            switch (quad) {
                case 0: {
                    currentXmid -= halfWidth;
                    currentYmid += halfHeight;
                    break;
                }
                case 1: {
                    currentXmid += halfWidth;
                    currentYmid += halfHeight;
                    break;
                }
                case 2: {
                    currentXmid -= halfWidth;
                    currentYmid -= halfHeight;
                    break;
                }
                case 3: {
                    currentXmid += halfWidth;
                    currentYmid -= halfHeight;
                    break;
                }
            }
            term |= (long)quad << 64 - (lvl + 1 << 1);
            term = (term >>> 1) + 1L << 1;
        }
        return new PackedQuadCell(term, rel);
    }

    protected void buildNotRobustly(double x, double y, int level, List<Cell> matches, long term, Shape shape, int maxLevel) {
        double w = this.levelW[level] / 2.0;
        double h = this.levelH[level] / 2.0;
        this.checkBattenbergNotRobustly(QUAD[0], x - w, y + h, level, matches, term, shape, maxLevel);
        this.checkBattenbergNotRobustly(QUAD[1], x + w, y + h, level, matches, term, shape, maxLevel);
        this.checkBattenbergNotRobustly(QUAD[2], x - w, y - h, level, matches, term, shape, maxLevel);
        this.checkBattenbergNotRobustly(QUAD[3], x + w, y - h, level, matches, term, shape, maxLevel);
    }

    protected void checkBattenbergNotRobustly(byte quad, double cx, double cy, int level, List<Cell> matches, long term, Shape shape, int maxLevel) {
        if (shape instanceof Point && !matches.isEmpty()) {
            return;
        }
        double w = this.levelW[level] / 2.0;
        double h = this.levelH[level] / 2.0;
        SpatialRelation v = shape.relate((Shape)this.ctx.makeRectangle(cx - w, cx + w, cy - h, cy + h));
        if (SpatialRelation.DISJOINT == v) {
            return;
        }
        term |= (long)quad << 64 - (++level << 1);
        term = (term >>> 1) + 1L << 1;
        if (SpatialRelation.CONTAINS == v || level >= maxLevel) {
            matches.add(new PackedQuadCell(term, v.transpose()));
        } else {
            this.buildNotRobustly(cx, cy, level, matches, term, shape, maxLevel);
        }
    }

    @Override
    public Cell readCell(BytesRef term, Cell scratch) {
        PackedQuadCell cell = (PackedQuadCell)scratch;
        if (cell == null) {
            cell = (PackedQuadCell)this.getWorldCell();
        }
        cell.readCell(term);
        return cell;
    }

    @Override
    public CellIterator getTreeCellIterator(Shape shape, int detailLevel) {
        if (detailLevel > this.maxLevels) {
            throw new IllegalArgumentException("detailLevel:" + detailLevel + " exceed max: " + this.maxLevels);
        }
        return new PrefixTreeIterator(shape, (short)detailLevel);
    }

    public boolean isPruneLeafyBranches() {
        return this.leafyPrune;
    }

    public void setPruneLeafyBranches(boolean pruneLeafyBranches) {
        this.leafyPrune = pruneLeafyBranches;
    }

    protected class PackedQuadCell
    extends QuadPrefixTree.QuadCell {
        private long term;

        PackedQuadCell(long term) {
            super(PackedQuadPrefixTree.this, null, 0, 0);
            this.term = term;
            this.b_off = 0;
            this.bytes = this.longToByteArray(this.term, new byte[8]);
            this.b_len = 8;
            this.readLeafAdjust();
        }

        PackedQuadCell(long term, SpatialRelation shapeRel) {
            this(term);
            this.shapeRel = shapeRel;
        }

        @Override
        protected void readCell(BytesRef bytes) {
            this.shapeRel = null;
            this.shape = null;
            this.bytes = bytes.bytes;
            this.b_off = bytes.offset;
            this.b_len = (short)bytes.length;
            this.term = this.longFromByteArray(this.bytes, bytes.offset);
            this.readLeafAdjust();
        }

        private final int getShiftForLevel(int level) {
            return 64 - (level << 1);
        }

        public boolean isEnd(int level, int shift) {
            return this.term != 0L && (1L << (level << 1)) - 1L - (this.term >>> shift) == 0L;
        }

        public PackedQuadCell nextCell(boolean descend) {
            long newTerm;
            boolean isLeaf;
            int level = this.getLevel();
            int shift = this.getShiftForLevel(level);
            if (!descend && this.isEnd(level, shift) || this.isEnd(PackedQuadPrefixTree.this.maxLevels, this.getShiftForLevel(PackedQuadPrefixTree.this.maxLevels))) {
                return null;
            }
            boolean bl = isLeaf = (this.term & 1L) == 1L;
            if (descend && !isLeaf && level != PackedQuadPrefixTree.this.maxLevels || level == 0) {
                newTerm = (this.term >>> 1) + 1L << 1;
            } else {
                newTerm = this.term + (1L << shift);
                if ((this.term >>> shift & 3L) == 3L) {
                    newTerm = (newTerm >>> 1) - (long)(Long.numberOfTrailingZeros(newTerm >>> shift) >>> 1) << 1;
                }
            }
            return new PackedQuadCell(newTerm);
        }

        @Override
        protected void readLeafAdjust() {
            boolean bl = this.isLeaf = (1L & this.term) == 1L;
            if (this.getLevel() == this.getMaxLevels()) {
                this.isLeaf = true;
            }
        }

        @Override
        public BytesRef getTokenBytesWithLeaf(BytesRef result) {
            result = this.getTokenBytesNoLeaf(result);
            if (this.isLeaf()) {
                result.bytes[7] = (byte)((long)result.bytes[7] | 1L);
            }
            return result;
        }

        @Override
        public BytesRef getTokenBytesNoLeaf(BytesRef result) {
            if (result == null) {
                result = new BytesRef(8);
            } else if (result.bytes.length < 8) {
                result.bytes = new byte[8];
            }
            result.bytes = this.longToByteArray(this.term, result.bytes);
            result.offset = 0;
            result.length = 8;
            result.bytes[7] = (byte)(result.bytes[7] & 0xFFFFFFFE);
            return result;
        }

        @Override
        public int compareToNoLeaf(Cell fromCell) {
            PackedQuadCell b = (PackedQuadCell)fromCell;
            long thisTerm = (1L & this.term) == 1L ? this.term - 1L : this.term;
            long fromTerm = (1L & b.term) == 1L ? b.term - 1L : b.term;
            int result = Long.compareUnsigned(thisTerm, fromTerm);
            assert (Math.signum(result) == Math.signum(PackedQuadCell.compare(this.longToByteArray(thisTerm, new byte[8]), 0, 8, this.longToByteArray(fromTerm, new byte[8]), 0, 8)));
            return result;
        }

        @Override
        public int getLevel() {
            int l = (int)(this.term >>> 1 & 0x1FL);
            return l;
        }

        @Override
        protected Collection<Cell> getSubCells() {
            ArrayList<Cell> cells = new ArrayList<Cell>(4);
            PackedQuadCell pqc = new PackedQuadCell((this.term & 1L) == 1L ? this.term - 1L : this.term).nextCell(true);
            cells.add(pqc);
            pqc = pqc.nextCell(false);
            cells.add(pqc);
            pqc = pqc.nextCell(false);
            cells.add(pqc);
            cells.add(pqc.nextCell(false));
            return cells;
        }

        @Override
        protected QuadPrefixTree.QuadCell getSubCell(Point p) {
            return (PackedQuadCell)PackedQuadPrefixTree.this.getCell(p, this.getLevel() + 1);
        }

        @Override
        public boolean isPrefixOf(Cell c) {
            PackedQuadCell cell = (PackedQuadCell)c;
            return this.term == 0L || this.isInternalPrefix(cell);
        }

        protected boolean isInternalPrefix(PackedQuadCell c) {
            int shift = 64 - (this.getLevel() << 1);
            return (this.term >>> shift) - (c.term >>> shift) == 0L;
        }

        protected long concat(byte postfix) {
            return this.term | (long)postfix << (this.getMaxLevels() - this.getLevel() << 1) + 6;
        }

        @Override
        protected Rectangle makeShape() {
            double height;
            double width;
            double xmin = PackedQuadPrefixTree.this.xmin;
            double ymin = PackedQuadPrefixTree.this.ymin;
            int level = this.getLevel();
            int l = 0;
            int i = 1;
            while (l < level) {
                byte b = (byte)(this.term >>> 64 - (i << 1) & 3L);
                switch (b) {
                    case 0: {
                        ymin += PackedQuadPrefixTree.this.levelH[l];
                        break;
                    }
                    case 1: {
                        xmin += PackedQuadPrefixTree.this.levelW[l];
                        ymin += PackedQuadPrefixTree.this.levelH[l];
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        xmin += PackedQuadPrefixTree.this.levelW[l];
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected quadrant");
                    }
                }
                l = (short)(l + 1);
                i = (short)(i + 1);
            }
            if (level > 0) {
                width = PackedQuadPrefixTree.this.levelW[level - 1];
                height = PackedQuadPrefixTree.this.levelH[level - 1];
            } else {
                width = PackedQuadPrefixTree.this.gridW;
                height = PackedQuadPrefixTree.this.gridH;
            }
            return new RectangleImpl(xmin, xmin + width, ymin, ymin + height, PackedQuadPrefixTree.this.ctx);
        }

        private long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
            return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
        }

        private byte[] longToByteArray(long value, byte[] result) {
            for (int i = 7; i >= 0; --i) {
                result[i] = (byte)(value & 0xFFL);
                value >>= 8;
            }
            return result;
        }

        private long longFromByteArray(byte[] bytes, int ofs) {
            assert (bytes.length >= 8);
            return this.fromBytes(bytes[0 + ofs], bytes[1 + ofs], bytes[2 + ofs], bytes[3 + ofs], bytes[4 + ofs], bytes[5 + ofs], bytes[6 + ofs], bytes[7 + ofs]);
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder(64);
            int numberOfLeadingZeros = Long.numberOfLeadingZeros(this.term);
            for (int i = 0; i < numberOfLeadingZeros; ++i) {
                s.append('0');
            }
            if (this.term != 0L) {
                s.append(Long.toBinaryString(this.term));
            }
            return s.toString();
        }
    }

    protected class PrefixTreeIterator
    extends CellIterator {
        private Shape shape;
        private PackedQuadCell thisCell;
        private PackedQuadCell nextCell;
        private short level;
        private final short detailLevel;
        private CellIterator pruneIter;

        PrefixTreeIterator(Shape shape, short detailLevel) {
            this.shape = shape;
            this.thisCell = ((PackedQuadCell)PackedQuadPrefixTree.this.getWorldCell()).nextCell(true);
            this.detailLevel = detailLevel;
            this.nextCell = null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextCell != null) {
                return true;
            }
            while (this.thisCell != null) {
                SpatialRelation rel = this.thisCell.getShape().relate(this.shape);
                if (rel == SpatialRelation.DISJOINT) {
                    this.thisCell = this.thisCell.nextCell(false);
                    continue;
                }
                this.thisCell.setShapeRel(rel);
                this.nextCell = this.thisCell;
                if (rel == SpatialRelation.WITHIN) {
                    this.thisCell.setLeaf();
                    this.thisCell = this.thisCell.nextCell(false);
                    break;
                }
                this.level = (short)this.thisCell.getLevel();
                if (this.level == this.detailLevel || this.pruned(rel)) {
                    this.thisCell.setLeaf();
                    if (this.shape instanceof Point) {
                        this.thisCell.setShapeRel(SpatialRelation.WITHIN);
                        this.thisCell = null;
                        break;
                    }
                    this.thisCell = this.thisCell.nextCell(false);
                    break;
                }
                this.thisCell = this.thisCell.nextCell(true);
                break;
            }
            return this.nextCell != null;
        }

        private boolean pruned(SpatialRelation rel) {
            if (rel == SpatialRelation.INTERSECTS && PackedQuadPrefixTree.this.leafyPrune && this.level == this.detailLevel - 1) {
                int leaves = 0;
                this.pruneIter = this.thisCell.getNextLevelCells(this.shape);
                while (this.pruneIter.hasNext()) {
                    this.pruneIter.next();
                    ++leaves;
                }
                return leaves == 4;
            }
            return false;
        }

        @Override
        public Cell next() {
            if (this.nextCell == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            PackedQuadCell temp = this.nextCell;
            this.nextCell = null;
            return temp;
        }

        @Override
        public void remove() {
        }
    }

    public static class Factory
    extends QuadPrefixTree.Factory {
        @Override
        protected SpatialPrefixTree newSPT() {
            PackedQuadPrefixTree tree = new PackedQuadPrefixTree(this.ctx, this.maxLevels != null ? this.maxLevels : 29);
            tree.robust = this.getVersion().onOrAfter(Version.LUCENE_8_3_0);
            return tree;
        }
    }
}

