/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.tool;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaFxUtils {
    private static final Logger logger = LogManager.getLogger(JavaFxUtils.class);

    public static void invokeInFxThreadAndWait(Runnable run) {
        if (Platform.isFxApplicationThread()) {
            run.run();
            return;
        }
        try {
            FutureTask<Object> future = new FutureTask<Object>(run, null);
            Platform.runLater(future);
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("invokeInFxThreadAndWait() failed", (Throwable)e);
        }
    }

    public static <V> V invokeInFxThreadAndWait(Callable<V> call) {
        V result = null;
        if (Platform.isFxApplicationThread()) {
            try {
                result = call.call();
            }
            catch (Exception e) {
                logger.error("invokeInFxThreadAndWait() failed", (Throwable)e);
            }
        } else {
            try {
                FutureTask<V> future = new FutureTask<V>(call);
                Platform.runLater(future);
                result = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("invokeInFxThreadAndWait() failed", (Throwable)e);
            }
        }
        return result;
    }
}

