# -*- coding: utf-8 -*-
info = {
    "name": "nl",
    "date_order": "DMY",
    "january": [
        "januari",
        "jan"
    ],
    "february": [
        "februari",
        "feb"
    ],
    "march": [
        "maart",
        "mrt"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "juni",
        "jun"
    ],
    "july": [
        "juli",
        "jul"
    ],
    "august": [
        "augustus",
        "aug"
    ],
    "september": [
        "september",
        "sep"
    ],
    "october": [
        "oktober",
        "okt"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "december",
        "dec"
    ],
    "monday": [
        "maandag",
        "ma"
    ],
    "tuesday": [
        "dinsdag",
        "di"
    ],
    "wednesday": [
        "woensdag",
        "wo"
    ],
    "thursday": [
        "donderdag",
        "do"
    ],
    "friday": [
        "vrijdag",
        "vr"
    ],
    "saturday": [
        "zaterdag",
        "za"
    ],
    "sunday": [
        "zondag",
        "zo"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "jaar",
        "jr"
    ],
    "month": [
        "maand",
        "mnd",
        "maanden"
    ],
    "week": [
        "week",
        "wk",
        "weken"
    ],
    "day": [
        "dag",
        "dagen"
    ],
    "hour": [
        "uur"
    ],
    "minute": [
        "minuut",
        "min",
        "minuten"
    ],
    "second": [
        "seconde",
        "sec",
        "s",
        "seconden"
    ],
    "relative-type": {
        "1 year ago": [
            "vorig jaar",
            "vorige jaar"
        ],
        "0 year ago": [
            "dit jaar"
        ],
        "in 1 year": [
            "volgend jaar"
        ],
        "1 month ago": [
            "vorige maand"
        ],
        "0 month ago": [
            "deze maand"
        ],
        "in 1 month": [
            "volgende maand"
        ],
        "1 week ago": [
            "vorige week"
        ],
        "0 week ago": [
            "deze week"
        ],
        "in 1 week": [
            "volgende week"
        ],
        "1 day ago": [
            "gisteren"
        ],
        "0 day ago": [
            "vandaag"
        ],
        "in 1 day": [
            "morgen"
        ],
        "0 hour ago": [
            "binnen een uur"
        ],
        "0 minute ago": [
            "binnen een minuut"
        ],
        "0 second ago": [
            "nu"
        ],
        "2 day ago": [
            "eergisteren"
        ],
        "in 2 day": [
            "overmorgen"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "over (\\d+) jaar"
        ],
        "\\1 year ago": [
            "(\\d+) jaar geleden"
        ],
        "in \\1 month": [
            "over (\\d+) maand",
            "over (\\d+) maanden"
        ],
        "\\1 month ago": [
            "(\\d+) maand geleden",
            "(\\d+) maanden geleden"
        ],
        "in \\1 week": [
            "over (\\d+) week",
            "over (\\d+) weken"
        ],
        "\\1 week ago": [
            "(\\d+) week geleden",
            "(\\d+) weken geleden"
        ],
        "in \\1 day": [
            "over (\\d+) dag",
            "over (\\d+) dagen",
            "over (\\d+) dgn"
        ],
        "\\1 day ago": [
            "(\\d+) dag geleden",
            "(\\d+) dagen geleden",
            "(\\d+) dgn geleden"
        ],
        "in \\1 hour": [
            "over (\\d+) uur"
        ],
        "\\1 hour ago": [
            "(\\d+) uur geleden"
        ],
        "in \\1 minute": [
            "over (\\d+) minuut",
            "over (\\d+) minuten",
            "over (\\d+) min"
        ],
        "\\1 minute ago": [
            "(\\d+) minuut geleden",
            "(\\d+) minuten geleden",
            "(\\d+) min geleden"
        ],
        "in \\1 second": [
            "over (\\d+) seconde",
            "over (\\d+) seconden",
            "over (\\d+) sec"
        ],
        "\\1 second ago": [
            "(\\d+) seconde geleden",
            "(\\d+) seconden geleden",
            "(\\d+) sec geleden"
        ]
    },
    "locale_specific": {
        "nl-BQ": {
            "name": "nl-BQ"
        },
        "nl-SX": {
            "name": "nl-SX"
        },
        "nl-CW": {
            "name": "nl-CW"
        },
        "nl-AW": {
            "name": "nl-AW"
        },
        "nl-BE": {
            "name": "nl-BE"
        },
        "nl-SR": {
            "name": "nl-SR"
        }
    },
    "skip": [
        "om",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "geleden"
    ],
    "in": [
        "in"
    ]
}
