# Glewlwyd documentation

Tis folder contains full documentation for Glewlwyd and additional resources.

## Documentation

### General

- [Install Glewlwyd](INSTALL.md)
- [Getting started](GETTING_STARTED.md)
- [Scopes](SCOPE.md)
- [User documentation](USER.md)

### Modules

- [Install User Backend Dabatase](USER_DATABASE.md)
- [Install User Backend LDAP](USER_LDAP.md)
- [Install User Backend HTTP](USER_HTTP.md)
- [Install Client Backend Database](CLIENT_DATABASE.md)
- [Install Client Backend LDAP](CLIENT_LDAP.md)
- [Install Authentication Scheme HOTP/TOTP](OTP.md)
- [Install Authentication Scheme Webauthn](WEBAUTHN.md)
- [Install Authentication Scheme E-mail code](EMAIL.md)
- [Install Authentication Scheme TLS certificate](CERTIFICATE.md)
- [Install Authentication Scheme HTTP Basic Authentification](HTTP.md)
- [Install Authentication Scheme OAuth2/OIDC client](OAUTH2_SCHEME.md)

### Plugins

- [Install Plugin OAuth2](OAUTH2.md)
- [Install Plugin OpenID Connect](OIDC.md)
- [Install Plugin Register new user](REGISTER.md)

### Screenshots

- [Screenshots available](screenshots/)

### Database init

- [Database folder](database/)

### Development

- [How to write user backend modules](../src/user/)
- [How to write client backend modules](../src/client/)
- [How to write authentication schemes modules](../src/scheme/)
- [How to write plugins](../src/plugin/)

### Additional Resources

- [Token validation for resource services](resources/)
