/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.util.IllegalFormatConversionException;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.ObjPtr;
import org.jcodings.Ptr;
import org.joni.ArrayCompiler;
import org.joni.BitStatus;
import org.joni.Matcher;
import org.joni.MinMaxLen;
import org.joni.NameEntry;
import org.joni.NodeOptInfo;
import org.joni.OptEnvironment;
import org.joni.Option;
import org.joni.Parser;
import org.joni.Regex;
import org.joni.Syntax;
import org.joni.UnsetAddrList;
import org.joni.WarnCallback;
import org.joni.ast.AnchorNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.ListNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StringNode;

final class Analyser
extends Parser {
    private static final int GET_CHAR_LEN_VARLEN = -1;
    private static final int GET_CHAR_LEN_TOP_ALT_VARLEN = -2;
    private static final int RECURSION_EXIST = 1;
    private static final int RECURSION_INFINITE = 2;
    private static final int FOUND_CALLED_NODE = 1;
    private static final int THRESHOLD_CASE_FOLD_ALT_FOR_EXPANSION = 8;
    private static final int CEC_THRES_NUM_BIG_REPEAT = 512;
    private static final int CEC_INFINITE_NUM = Integer.MAX_VALUE;
    private static final int CEC_IN_INFINITE_REPEAT = 1;
    private static final int CEC_IN_FINITE_REPEAT = 2;
    private static final int CEC_CONT_BIG_REPEAT = 4;
    private static final int IN_ALT = 1;
    private static final int IN_NOT = 2;
    private static final int IN_REPEAT = 4;
    private static final int IN_VAR_REPEAT = 8;
    private static final int IN_CALL = 16;
    private static final int IN_RECCALL = 32;
    private static final int EXPAND_STRING_MAX_LENGTH = 100;
    private static final int MAX_NODE_OPT_INFO_REF_COUNT = 5;

    protected Analyser(Regex regex, Syntax syntax, byte[] bytes2, int p2, int end2, WarnCallback warnings) {
        super(regex, syntax, bytes2, p2, end2, warnings);
    }

    protected final void compile() {
        this.reset();
        this.regex.numMem = 0;
        this.regex.numRepeat = 0;
        this.regex.numNullCheck = 0;
        this.regex.repeatRangeLo = null;
        this.regex.repeatRangeHi = null;
        this.regex.numCombExpCheck = 0;
        Node root = this.parseRegexp();
        this.regex.numMem = this.env.numMem;
        if (this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.regex.options)) {
            if (this.env.numNamed != this.env.numMem) {
                root = this.disableNoNameGroupCapture(root);
            } else {
                this.numberedRefCheck(root);
            }
        }
        if (this.env.numCall > 0) {
            this.env.unsetAddrList = new UnsetAddrList(this.env.numCall);
            this.setupSubExpCall(root);
            this.subexpRecursiveCheckTrav(root);
            this.subexpInfRecursiveCheckTrav(root);
            this.regex.numCall = this.env.numCall;
        } else {
            this.regex.numCall = 0;
        }
        Node.TopNode top = Node.newTop(root);
        this.setupTree(root, 0);
        root = top.getRoot();
        this.regex.captureHistory = this.env.captureHistory;
        this.regex.btMemStart = this.env.btMemStart;
        this.regex.btMemEnd = this.env.btMemEnd;
        if (Option.isFindCondition(this.regex.options)) {
            this.regex.btMemEnd = BitStatus.bsAll();
        } else {
            this.regex.btMemEnd = this.env.btMemEnd;
            this.regex.btMemEnd |= this.regex.captureHistory;
        }
        this.regex.clearOptimizeInfo();
        this.setOptimizedInfoFromTree(root);
        this.env.memNodes = null;
        new ArrayCompiler(this).compile(root);
        this.regex.stackPopLevel = this.regex.numRepeat != 0 || this.regex.btMemEnd != 0 ? 2 : (this.regex.btMemStart != 0 ? 1 : 0);
        this.regex.options &= ~this.syntax.options;
    }

    private String encStringToString(byte[] bytes2, int p2, int end2) {
        StringBuilder sb = new StringBuilder("\nPATTERN: /");
        if (this.enc.minLength() > 1) {
            for (int p_ = p2; p_ < end2; p_ += this.enc.length(bytes2, p_, end2)) {
                int code = this.enc.mbcToCode(bytes2, p_, end2);
                if (code >= 128) {
                    try {
                        sb.append(String.format(" 0x%04x ", code));
                    }
                    catch (IllegalFormatConversionException ifce) {
                        sb.append(code);
                    }
                    continue;
                }
                sb.append((char)code);
            }
        } else {
            while (p2 < end2) {
                sb.append(new String(bytes2, p2, 1));
                ++p2;
            }
        }
        return sb.append("/").toString();
    }

    private void noNameDisableMapFor_listAlt(Node node, int[] map2, Ptr counter) {
        ListNode can = (ListNode)node;
        do {
            can.setValue(this.noNameDisableMap(can.value, map2, counter));
        } while ((can = can.tail) != null);
    }

    private void noNameDisableMapFor_quantifier(Node node, int[] map2, Ptr counter) {
        Node target;
        QuantifierNode qn = (QuantifierNode)node;
        Node old = target = qn.target;
        if ((target = this.noNameDisableMap(target, map2, counter)) != old) {
            qn.setTarget(target);
            if (target.getType() == 5) {
                qn.reduceNestedQuantifier((QuantifierNode)target);
            }
        }
    }

    private Node noNameDisableMapFor_enclose(Node node, int[] map2, Ptr counter) {
        EncloseNode en = (EncloseNode)node;
        if (en.type == 1) {
            if (en.isNamedGroup()) {
                map2[en.regNum] = ++counter.p;
                en.regNum = counter.p;
                en.setTarget(this.noNameDisableMap(en.target, map2, counter));
            } else {
                node = en.target;
                en.target = null;
                node = this.noNameDisableMap(node, map2, counter);
            }
        } else {
            en.setTarget(this.noNameDisableMap(en.target, map2, counter));
        }
        return node;
    }

    private void noNameDisableMapFor_anchor(Node node, int[] map2, Ptr counter) {
        AnchorNode an = (AnchorNode)node;
        if (an.target != null) {
            an.setTarget(this.noNameDisableMap(an.target, map2, counter));
        }
    }

    private Node noNameDisableMap(Node node, int[] map2, Ptr counter) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                this.noNameDisableMapFor_listAlt(node, map2, counter);
                break;
            }
            case 5: {
                this.noNameDisableMapFor_quantifier(node, map2, counter);
                break;
            }
            case 6: {
                node = this.noNameDisableMapFor_enclose(node, map2, counter);
                break;
            }
            case 7: {
                this.noNameDisableMapFor_anchor(node, map2, counter);
            }
        }
        return node;
    }

    private void renumberByMap(Node node, int[] map2) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ListNode can = (ListNode)node;
                do {
                    this.renumberByMap(can.value, map2);
                } while ((can = can.tail) != null);
                break;
            }
            case 5: {
                this.renumberByMap(((QuantifierNode)node).target, map2);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.type == 8) {
                    en.regNum = map2[en.regNum];
                }
                this.renumberByMap(en.target, map2);
                break;
            }
            case 4: {
                ((BackRefNode)node).renumber(map2);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                if (an.target == null) break;
                this.renumberByMap(an.target, map2);
            }
        }
    }

    protected final void numberedRefCheck(Node node) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ListNode can = (ListNode)node;
                do {
                    this.numberedRefCheck(can.value);
                } while ((can = can.tail) != null);
                break;
            }
            case 5: {
                this.numberedRefCheck(((QuantifierNode)node).target);
                break;
            }
            case 6: {
                this.numberedRefCheck(((EncloseNode)node).target);
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isNameRef()) break;
                this.newValueException("numbered backref/call is not allowed. (use name)");
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                if (an.target == null) break;
                this.numberedRefCheck(an.target);
            }
        }
    }

    protected final Node disableNoNameGroupCapture(Node root) {
        int[] map2 = new int[this.env.numMem + 1];
        root = this.noNameDisableMap(root, map2, new Ptr(0));
        this.renumberByMap(root, map2);
        int pos2 = 1;
        for (int i2 = 1; i2 <= this.env.numMem; ++i2) {
            if (map2[i2] <= 0) continue;
            this.env.memNodes[pos2] = this.env.memNodes[i2];
            ++pos2;
        }
        int loc = this.env.captureHistory;
        this.env.captureHistory = BitStatus.bsClear();
        for (int i3 = 1; i3 <= 31; ++i3) {
            if (!BitStatus.bsAt(loc, i3)) continue;
            this.env.captureHistory = BitStatus.bsOnAtSimple(this.env.captureHistory, map2[i3]);
        }
        this.env.numMem = this.env.numNamed;
        this.regex.numMem = this.env.numNamed;
        this.regex.renumberNameTable(map2);
        return root;
    }

    private int quantifiersMemoryInfo(Node node) {
        int info = 0;
        block0 : switch (node.getType()) {
            case 8: 
            case 9: {
                ListNode can = (ListNode)node;
                do {
                    int v;
                    if ((v = this.quantifiersMemoryInfo(can.value)) <= info) continue;
                    info = v;
                } while ((can = can.tail) != null);
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.isRecursion()) {
                    return 3;
                }
                info = this.quantifiersMemoryInfo(cn.target);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.upper == 0) break;
                info = this.quantifiersMemoryInfo(qn.target);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        return 2;
                    }
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        info = this.quantifiersMemoryInfo(en.target);
                        break block0;
                    }
                }
                break;
            }
        }
        return info;
    }

    private int getMinMatchLength(Node node) {
        int min2 = 0;
        block0 : switch (node.getType()) {
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isRecursion()) break;
                if (br.back[0] > this.env.numMem) {
                    if (!this.syntax.op3OptionECMAScript()) {
                        this.newValueException("invalid backref number/name");
                    }
                } else {
                    min2 = this.getMinMatchLength(this.env.memNodes[br.back[0]]);
                }
                for (int i2 = 1; i2 < br.backNum; ++i2) {
                    if (br.back[i2] > this.env.numMem) {
                        if (this.syntax.op3OptionECMAScript()) continue;
                        this.newValueException("invalid backref number/name");
                        continue;
                    }
                    int tmin = this.getMinMatchLength(this.env.memNodes[br.back[i2]]);
                    if (min2 <= tmin) continue;
                    min2 = tmin;
                }
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.isRecursion()) {
                    EncloseNode en = cn.target;
                    if (!en.isMinFixed()) break;
                    min2 = en.minLength;
                    break;
                }
                min2 = this.getMinMatchLength(cn.target);
                break;
            }
            case 8: {
                ListNode can = (ListNode)node;
                do {
                    min2 += this.getMinMatchLength(can.value);
                } while ((can = can.tail) != null);
                break;
            }
            case 9: {
                ListNode y = (ListNode)node;
                do {
                    Node x = y.value;
                    int tmin = this.getMinMatchLength(x);
                    if (y == node) {
                        min2 = tmin;
                        continue;
                    }
                    if (min2 <= tmin) continue;
                    min2 = tmin;
                } while ((y = y.tail) != null);
                break;
            }
            case 0: {
                min2 = ((StringNode)node).length();
                break;
            }
            case 2: {
                min2 = 1;
                break;
            }
            case 1: 
            case 3: {
                min2 = 1;
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.lower <= 0) break;
                min2 = this.getMinMatchLength(qn.target);
                min2 = MinMaxLen.distanceMultiply(min2, qn.lower);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (en.isMinFixed()) {
                            min2 = en.minLength;
                            break block0;
                        }
                        if (en.isMark1()) {
                            min2 = 0;
                            break block0;
                        }
                        en.setMark1();
                        min2 = this.getMinMatchLength(en.target);
                        en.clearMark1();
                        en.minLength = min2;
                        en.setMinFixed();
                        break block0;
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        min2 = this.getMinMatchLength(en.target);
                        break block0;
                    }
                }
                break;
            }
        }
        return min2;
    }

    private int getMaxMatchLength(Node node) {
        int max2 = 0;
        block0 : switch (node.getType()) {
            case 8: {
                ListNode ln = (ListNode)node;
                do {
                    int tmax = this.getMaxMatchLength(ln.value);
                    max2 = MinMaxLen.distanceAdd(max2, tmax);
                } while ((ln = ln.tail) != null);
                break;
            }
            case 9: {
                ListNode an = (ListNode)node;
                do {
                    int tmax;
                    if (max2 >= (tmax = this.getMaxMatchLength(an.value))) continue;
                    max2 = tmax;
                } while ((an = an.tail) != null);
                break;
            }
            case 0: {
                max2 = ((StringNode)node).length();
                break;
            }
            case 2: {
                max2 = this.enc.maxLength();
                break;
            }
            case 1: 
            case 3: {
                max2 = this.enc.maxLength();
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isRecursion()) {
                    max2 = Integer.MAX_VALUE;
                    break;
                }
                for (int i2 = 0; i2 < br.backNum; ++i2) {
                    if (br.back[i2] > this.env.numMem) {
                        if (this.syntax.op3OptionECMAScript()) continue;
                        this.newValueException("invalid backref number/name");
                        continue;
                    }
                    int tmax = this.getMaxMatchLength(this.env.memNodes[br.back[i2]]);
                    if (max2 >= tmax) continue;
                    max2 = tmax;
                }
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (!cn.isRecursion()) {
                    max2 = this.getMaxMatchLength(cn.target);
                    break;
                }
                max2 = Integer.MAX_VALUE;
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.upper == 0 || (max2 = this.getMaxMatchLength(qn.target)) == 0) break;
                if (!QuantifierNode.isRepeatInfinite(qn.upper)) {
                    max2 = MinMaxLen.distanceMultiply(max2, qn.upper);
                    break;
                }
                max2 = Integer.MAX_VALUE;
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (en.isMaxFixed()) {
                            max2 = en.maxLength;
                            break block0;
                        }
                        if (en.isMark1()) {
                            max2 = Integer.MAX_VALUE;
                            break block0;
                        }
                        en.setMark1();
                        max2 = this.getMaxMatchLength(en.target);
                        en.clearMark1();
                        en.maxLength = max2;
                        en.setMaxFixed();
                        break block0;
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        max2 = this.getMaxMatchLength(en.target);
                        break block0;
                    }
                }
                break;
            }
        }
        return max2;
    }

    protected final int getCharLengthTree(Node node) {
        return this.getCharLengthTree(node, 0);
    }

    private int getCharLengthTree(Node node, int level2) {
        ++level2;
        int len = 0;
        this.returnCode = 0;
        switch (node.getType()) {
            case 8: {
                ListNode ln = (ListNode)node;
                do {
                    int tlen = this.getCharLengthTree(ln.value, level2);
                    if (this.returnCode != 0) continue;
                    len = MinMaxLen.distanceAdd(len, tlen);
                } while (this.returnCode == 0 && (ln = ln.tail) != null);
                break;
            }
            case 9: {
                ListNode an = (ListNode)node;
                boolean varLen = false;
                int tlen = this.getCharLengthTree(an.value, level2);
                while (this.returnCode == 0 && (an = an.tail) != null) {
                    int tlen2 = this.getCharLengthTree(an.value, level2);
                    if (this.returnCode != 0 || tlen == tlen2) continue;
                    varLen = true;
                }
                if (this.returnCode != 0) break;
                if (varLen) {
                    if (level2 == 1) {
                        this.returnCode = -2;
                        break;
                    }
                    this.returnCode = -1;
                    break;
                }
                len = tlen;
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                len = sn.length(this.enc);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.lower == qn.upper) {
                    int tlen = this.getCharLengthTree(qn.target, level2);
                    if (this.returnCode != 0) break;
                    len = MinMaxLen.distanceMultiply(tlen, qn.lower);
                    break;
                }
                this.returnCode = -1;
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (!cn.isRecursion()) {
                    len = this.getCharLengthTree(cn.target, level2);
                    break;
                }
                this.returnCode = -1;
                break;
            }
            case 2: {
                len = 1;
            }
            case 1: 
            case 3: {
                len = 1;
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (en.isCLenFixed()) {
                            len = en.charLength;
                            break;
                        }
                        len = this.getCharLengthTree(en.target, level2);
                        if (this.returnCode != 0) break;
                        en.charLength = len;
                        en.setCLenFixed();
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        len = this.getCharLengthTree(en.target, level2);
                        break;
                    }
                }
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.returnCode = -1;
            }
        }
        return len;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNotIncluded(Node x, Node y) {
        block26: while (true) {
            int yType = y.getType();
            switch (x.getType()) {
                case 2: {
                    Node tmp;
                    switch (yType) {
                        case 2: {
                            CTypeNode cny = (CTypeNode)y;
                            CTypeNode cnx = (CTypeNode)x;
                            if (cny.ctype != cnx.ctype) return false;
                            if (cny.not == cnx.not) return false;
                            if (cny.asciiRange != cnx.asciiRange) return false;
                            return true;
                        }
                        case 1: {
                            tmp = x;
                            x = y;
                            y = tmp;
                            continue block26;
                        }
                        case 0: {
                            tmp = x;
                            x = y;
                            y = tmp;
                            continue block26;
                        }
                    }
                    return false;
                }
                case 1: {
                    Node tmp;
                    CClassNode xc = (CClassNode)x;
                    switch (yType) {
                        case 2: {
                            CTypeNode yc = (CTypeNode)y;
                            switch (yc.ctype) {
                                case 12: {
                                    if (!yc.not) {
                                        if (xc.mbuf != null) return false;
                                        if (xc.isNot()) return false;
                                        int i2 = 0;
                                        while (i2 < 256) {
                                            if (xc.bs.at(i2) && (yc.asciiRange ? this.enc.isSbWord(i2) : this.enc.isWord(i2))) {
                                                return false;
                                            }
                                            ++i2;
                                        }
                                        return true;
                                    }
                                    if (xc.mbuf != null) {
                                        return false;
                                    }
                                    int i3 = 0;
                                    while (i3 < 256) {
                                        boolean isWord = yc.asciiRange ? this.enc.isSbWord(i3) : this.enc.isWord(i3);
                                        if (!isWord && (!xc.isNot() ? xc.bs.at(i3) : !xc.bs.at(i3))) {
                                            return false;
                                        }
                                        ++i3;
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                        case 1: {
                            CClassNode yc = (CClassNode)y;
                            for (int i4 = 0; i4 < 256; ++i4) {
                                boolean v = xc.bs.at(i4);
                                if ((!v || xc.isNot()) && (v || !xc.isNot())) continue;
                                v = yc.bs.at(i4);
                                if (v) {
                                    if (!yc.isNot()) return false;
                                }
                                if (v || !yc.isNot()) continue;
                                return false;
                            }
                            if (xc.mbuf == null) {
                                if (!xc.isNot()) return true;
                            }
                            if (yc.mbuf != null) return false;
                            if (yc.isNot()) return false;
                            return true;
                        }
                        case 0: {
                            tmp = x;
                            x = y;
                            y = tmp;
                            continue block26;
                        }
                    }
                    return false;
                }
                case 0: {
                    StringNode xs = (StringNode)x;
                    if (xs.length() == 0) return false;
                    switch (yType) {
                        case 2: {
                            CTypeNode cy = (CTypeNode)y;
                            switch (cy.ctype) {
                                case 12: {
                                    if (cy.asciiRange) {
                                        if (Matcher.isMbcAsciiWord(this.enc, xs.bytes, xs.p, xs.end)) {
                                            return cy.not;
                                        }
                                        if (cy.not) return false;
                                        return true;
                                    }
                                    if (this.enc.isMbcWord(xs.bytes, xs.p, xs.end)) {
                                        return cy.not;
                                    }
                                    if (cy.not) return false;
                                    return true;
                                }
                            }
                            return false;
                        }
                        case 1: {
                            CClassNode cc = (CClassNode)y;
                            int code = this.enc.mbcToCode(xs.bytes, xs.p, xs.p + this.enc.maxLength());
                            if (cc.isCodeInCC(this.enc, code)) return false;
                            return true;
                        }
                        case 0: {
                            StringNode ys = (StringNode)y;
                            int len = xs.length();
                            if (len > ys.length()) {
                                len = ys.length();
                            }
                            if (xs.isAmbig()) return false;
                            if (ys.isAmbig()) {
                                return false;
                            }
                            int i5 = 0;
                            int p2 = ys.p;
                            int q = xs.p;
                            while (i5 < len) {
                                if (ys.bytes[p2] != xs.bytes[q]) {
                                    return true;
                                }
                                ++i5;
                                ++p2;
                                ++q;
                            }
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            break;
        }
        return false;
    }

    private Node getHeadValueNode(Node node, boolean exact) {
        Node n = null;
        block0 : switch (node.getType()) {
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 1: 
            case 2: {
                if (exact) break;
                n = node;
                break;
            }
            case 8: {
                n = this.getHeadValueNode(((ListNode)node).value, exact);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.end <= sn.p || exact && !sn.isRaw() && Option.isIgnoreCase(this.regex.options)) break;
                n = node;
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                if (qn.lower <= 0) break;
                if (qn.headExact != null) {
                    n = qn.headExact;
                    break;
                }
                n = this.getHeadValueNode(qn.target, exact);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 2: {
                        int options2 = this.regex.options;
                        this.regex.options = en.option;
                        n = this.getHeadValueNode(en.target, exact);
                        this.regex.options = options2;
                        break block0;
                    }
                    case 1: 
                    case 4: 
                    case 8: {
                        n = this.getHeadValueNode(en.target, exact);
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                if (an.type != 1024) break;
                n = this.getHeadValueNode(an.target, exact);
                break;
            }
        }
        return n;
    }

    private boolean checkTypeTree(Node node, int typeMask, int encloseMask, int anchorMask) {
        if ((node.getType2Bit() & typeMask) == 0) {
            return true;
        }
        boolean invalid = false;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ListNode can = (ListNode)node;
                while (!(invalid = this.checkTypeTree(can.value, typeMask, encloseMask, anchorMask)) && (can = can.tail) != null) {
                }
                break;
            }
            case 5: {
                invalid = this.checkTypeTree(((QuantifierNode)node).target, typeMask, encloseMask, anchorMask);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if ((en.type & encloseMask) == 0) {
                    return true;
                }
                invalid = this.checkTypeTree(en.target, typeMask, encloseMask, anchorMask);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                if ((an.type & anchorMask) == 0) {
                    return true;
                }
                if (an.target == null) break;
                invalid = this.checkTypeTree(an.target, typeMask, encloseMask, anchorMask);
                break;
            }
        }
        return invalid;
    }

    private int subexpInfRecursiveCheck(Node node, boolean head) {
        int r = 0;
        switch (node.getType()) {
            case 8: {
                ListNode x = (ListNode)node;
                do {
                    int min2;
                    int ret;
                    if ((ret = this.subexpInfRecursiveCheck(x.value, head)) == 2) {
                        return ret;
                    }
                    r |= ret;
                    if (!head || (min2 = this.getMinMatchLength(x.value)) == 0) continue;
                    head = false;
                } while ((x = x.tail) != null);
                break;
            }
            case 9: {
                ListNode can = (ListNode)node;
                r = 1;
                do {
                    int ret;
                    if ((ret = this.subexpInfRecursiveCheck(can.value, head)) == 2) {
                        return ret;
                    }
                    r &= ret;
                } while ((can = can.tail) != null);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                r = this.subexpInfRecursiveCheck(qn.target, head);
                if (r != 1 || qn.lower != 0) break;
                r = 0;
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpInfRecursiveCheck(an.target, head);
                    }
                }
                break;
            }
            case 10: {
                r = this.subexpInfRecursiveCheck(((CallNode)node).target, head);
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.isMark2()) {
                    return 0;
                }
                if (en.isMark1()) {
                    return !head ? 1 : 2;
                }
                en.setMark2();
                r = this.subexpInfRecursiveCheck(en.target, head);
                en.clearMark2();
                break;
            }
        }
        return r;
    }

    protected final int subexpInfRecursiveCheckTrav(Node node) {
        int r = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ListNode can = (ListNode)node;
                while ((r = this.subexpInfRecursiveCheckTrav(can.value)) == 0 && (can = can.tail) != null) {
                }
                break;
            }
            case 5: {
                r = this.subexpInfRecursiveCheckTrav(((QuantifierNode)node).target);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpInfRecursiveCheckTrav(an.target);
                    }
                }
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.isRecursion()) {
                    en.setMark1();
                    r = this.subexpInfRecursiveCheck(en.target, true);
                    if (r > 0) {
                        this.newValueException("never ending recursion");
                    }
                    en.clearMark1();
                }
                r = this.subexpInfRecursiveCheckTrav(en.target);
                break;
            }
        }
        return r;
    }

    private int subexpRecursiveCheck(Node node) {
        int r = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ListNode can = (ListNode)node;
                do {
                    r |= this.subexpRecursiveCheck(can.value);
                } while ((can = can.tail) != null);
                break;
            }
            case 5: {
                r = this.subexpRecursiveCheck(((QuantifierNode)node).target);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpRecursiveCheck(an.target);
                    }
                }
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                r = this.subexpRecursiveCheck(cn.target);
                if (r == 0) break;
                cn.setRecursion();
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (en.isMark2()) {
                    return 0;
                }
                if (en.isMark1()) {
                    return 1;
                }
                en.setMark2();
                r = this.subexpRecursiveCheck(en.target);
                en.clearMark2();
                break;
            }
        }
        return r;
    }

    protected final int subexpRecursiveCheckTrav(Node node) {
        int r = 0;
        switch (node.getType()) {
            case 8: 
            case 9: {
                ListNode can = (ListNode)node;
                do {
                    int ret;
                    if ((ret = this.subexpRecursiveCheckTrav(can.value)) != 1) continue;
                    r = 1;
                } while ((can = can.tail) != null);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                r = this.subexpRecursiveCheckTrav(qn.target);
                if (qn.upper != 0 || r != 1) break;
                qn.isRefered = true;
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        r = this.subexpRecursiveCheckTrav(an.target);
                    }
                }
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                if (!en.isRecursion() && en.isCalled()) {
                    en.setMark1();
                    r = this.subexpRecursiveCheck(en.target);
                    if (r != 0) {
                        en.setRecursion();
                    }
                    en.clearMark1();
                }
                r = this.subexpRecursiveCheckTrav(en.target);
                if (!en.isCalled()) break;
                r |= 1;
                break;
            }
        }
        return r;
    }

    private void setCallAttr(CallNode cn) {
        EncloseNode en = this.env.memNodes[cn.groupNum];
        if (en == null) {
            this.newValueException("undefined name <%n> reference", cn.nameP, cn.nameEnd);
        }
        en.setCalled();
        cn.setTarget(en);
        this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, cn.groupNum);
        cn.unsetAddrList = this.env.unsetAddrList;
    }

    protected final void setupSubExpCall(Node node) {
        switch (node.getType()) {
            case 8: {
                ListNode ln = (ListNode)node;
                do {
                    this.setupSubExpCall(ln.value);
                } while ((ln = ln.tail) != null);
                break;
            }
            case 9: {
                ListNode can = (ListNode)node;
                do {
                    this.setupSubExpCall(can.value);
                } while ((can = can.tail) != null);
                break;
            }
            case 5: {
                this.setupSubExpCall(((QuantifierNode)node).target);
                break;
            }
            case 6: {
                this.setupSubExpCall(((EncloseNode)node).target);
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.groupNum != 0) {
                    int gNum = cn.groupNum;
                    if (this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.env.option)) {
                        this.newValueException("numbered backref/call is not allowed. (use name)");
                    }
                    if (gNum > this.env.numMem) {
                        this.newValueException("undefined group <%n> reference", cn.nameP, cn.nameEnd);
                    }
                    this.setCallAttr(cn);
                    break;
                }
                if (cn.nameP == cn.nameEnd) {
                    this.setCallAttr(cn);
                    break;
                }
                NameEntry ne = this.regex.nameToGroupNumbers(cn.name, cn.nameP, cn.nameEnd);
                if (ne == null) {
                    this.newValueException("undefined name <%n> reference", cn.nameP, cn.nameEnd);
                    break;
                }
                if (ne.backNum > 1) {
                    this.newValueException("multiplex definition name <%n> call", cn.nameP, cn.nameEnd);
                    break;
                }
                cn.groupNum = ne.backRef1;
                this.setCallAttr(cn);
                break;
            }
            case 7: {
                AnchorNode an = (AnchorNode)node;
                switch (an.type) {
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: {
                        this.setupSubExpCall(an.target);
                    }
                }
            }
        }
    }

    private Node divideLookBehindAlternatives(Node node) {
        AnchorNode an = (AnchorNode)node;
        int anchorType = an.type;
        Node head = an.target;
        Node np = ((ListNode)head).value;
        node.replaceWith(head);
        Node tmp = node;
        node = head;
        head = tmp;
        ((ListNode)node).setValue(head);
        ((AnchorNode)head).setTarget(np);
        np = node;
        while ((np = ((ListNode)np).tail) != null) {
            AnchorNode insert2 = new AnchorNode(anchorType);
            insert2.setTarget(((ListNode)np).value);
            ((ListNode)np).setValue(insert2);
        }
        if (anchorType == 8192) {
            np = node;
            do {
                ((ListNode)np).toListNode();
            } while ((np = ((ListNode)np).tail) != null);
        }
        return node;
    }

    private Node setupLookBehind(AnchorNode node) {
        int len = this.getCharLengthTree(node.target);
        switch (this.returnCode) {
            case 0: {
                node.charLength = len;
                break;
            }
            case -1: {
                this.newSyntaxException("invalid pattern in look-behind");
                break;
            }
            case -2: {
                if (this.syntax.differentLengthAltLookBehind()) {
                    return this.divideLookBehindAlternatives(node);
                }
                this.newSyntaxException("invalid pattern in look-behind");
            }
        }
        return node;
    }

    private void nextSetup(Node node, Node nextNode) {
        while (true) {
            EncloseNode en;
            int type2;
            if ((type2 = node.getType()) == 5) {
                Node y;
                Node x;
                QuantifierNode qn = (QuantifierNode)node;
                if (!qn.greedy || !QuantifierNode.isRepeatInfinite(qn.upper)) break;
                StringNode n = (StringNode)this.getHeadValueNode(nextNode, true);
                if (n != null && n.bytes[n.p] != 0) {
                    qn.nextHeadExact = n;
                }
                if (qn.lower > 1 || !qn.target.isSimple() || (x = this.getHeadValueNode(qn.target, false)) == null || (y = this.getHeadValueNode(nextNode, false)) == null || !this.isNotIncluded(x, y)) break;
                EncloseNode en2 = new EncloseNode(4);
                en2.setStopBtSimpleRepeat();
                node.replaceWith(en2);
                en2.setTarget(node);
                break;
            }
            if (type2 != 6 || !(en = (EncloseNode)node).isMemory()) break;
            node = en.target;
        }
    }

    private void updateStringNodeCaseFoldSingleByte(StringNode sn, byte[] toLower) {
        int end2 = sn.end;
        byte[] bytes2 = sn.bytes;
        int sp = 0;
        for (int p2 = sn.p; p2 < end2; ++p2) {
            byte lower = toLower[bytes2[p2] & 0xFF];
            if (lower != bytes2[p2]) {
                byte[] sbuf = new byte[end2 - sn.p];
                System.arraycopy(bytes2, sn.p, sbuf, 0, sp);
                while (p2 < end2) {
                    sbuf[sp++] = toLower[bytes2[p2++] & 0xFF];
                }
                sn.set(sbuf, 0, sp);
                break;
            }
            ++sp;
        }
    }

    private void updateStringNodeCaseFoldMultiByte(StringNode sn) {
        byte[] bytes2 = sn.bytes;
        int end2 = sn.end;
        this.value = sn.p;
        int sp = 0;
        byte[] buf = new byte[18];
        while (this.value < end2) {
            int ovalue = this.value;
            int len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, bytes2, this, end2, buf);
            for (int i2 = 0; i2 < len; ++i2) {
                if (bytes2[ovalue + i2] == buf[i2]) continue;
                byte[] sbuf = new byte[sn.length() << 1];
                System.arraycopy(bytes2, sn.p, sbuf, 0, ovalue - sn.p);
                this.value = ovalue;
                while (this.value < end2) {
                    len = this.enc.mbcCaseFold(this.regex.caseFoldFlag, bytes2, this, end2, buf);
                    for (i2 = 0; i2 < len; ++i2) {
                        if (sp >= sbuf.length) {
                            byte[] tmp = new byte[sbuf.length << 1];
                            System.arraycopy(sbuf, 0, tmp, 0, sbuf.length);
                            sbuf = tmp;
                        }
                        sbuf[sp++] = buf[i2];
                    }
                }
                sn.set(sbuf, 0, sp);
                return;
            }
            sp += len;
        }
    }

    private void updateStringNodeCaseFold(Node node) {
        StringNode sn = (StringNode)node;
        byte[] toLower = this.enc.toLowerCaseTable();
        if (toLower != null) {
            this.updateStringNodeCaseFoldSingleByte(sn, toLower);
        } else {
            this.updateStringNodeCaseFoldMultiByte(sn);
        }
    }

    private Node expandCaseFoldMakeRemString(byte[] bytes2, int p2, int end2) {
        StringNode node = new StringNode(bytes2, p2, end2);
        this.updateStringNodeCaseFold(node);
        node.setAmbig();
        node.setDontGetOptInfo();
        return node;
    }

    private boolean isCaseFoldVariableLength(int itemNum, CaseFoldCodeItem[] items, int slen) {
        for (int i2 = 0; i2 < itemNum; ++i2) {
            if (items[i2].byteLen == slen && items[i2].code.length == 1) continue;
            return true;
        }
        return false;
    }

    private boolean expandCaseFoldStringAlt(int itemNum, CaseFoldCodeItem[] items, byte[] bytes2, int p2, int slen, int end2, ObjPtr<Node> node) {
        ListNode altNode;
        ListNode listNode;
        boolean varlen = false;
        for (int i2 = 0; i2 < itemNum; ++i2) {
            if (items[i2].byteLen == slen) continue;
            varlen = true;
            break;
        }
        ListNode varANode = null;
        if (varlen) {
            varANode = ListNode.newAlt(null, null);
            node.p = varANode;
            listNode = ListNode.newList(null, null);
            varANode.setValue(listNode);
            altNode = ListNode.newAlt(null, null);
            listNode.setValue(altNode);
        } else {
            altNode = ListNode.newAlt(null, null);
            node.p = altNode;
        }
        StringNode snode = new StringNode(bytes2, p2, p2 + slen);
        altNode.setValue(snode);
        for (int i3 = 0; i3 < itemNum; ++i3) {
            snode = new StringNode();
            for (int j = 0; j < items[i3].code.length; ++j) {
                snode.catCode(items[i3].code[j], this.enc);
            }
            ListNode an = ListNode.newAlt(null, null);
            if (items[i3].byteLen != slen) {
                int q = p2 + items[i3].byteLen;
                if (q < end2) {
                    Node rem = this.expandCaseFoldMakeRemString(bytes2, q, end2);
                    listNode = ListNode.listAdd(null, snode);
                    ListNode.listAdd(listNode, rem);
                    an.setValue(listNode);
                } else {
                    an.setValue(snode);
                }
                varANode.setTail(an);
                varANode = an;
                continue;
            }
            an.setValue(snode);
            altNode.setTail(an);
            altNode = an;
        }
        return varlen;
    }

    private Node expandCaseFoldString(Node node) {
        int p2;
        int len;
        StringNode sn = (StringNode)node;
        if (sn.isAmbig() || sn.length() <= 0) {
            return node;
        }
        byte[] bytes2 = sn.bytes;
        int end2 = sn.end;
        int altNum = 1;
        Node topRoot = null;
        ListNode root = null;
        ObjPtr<Node> prevNode = new ObjPtr<Node>();
        StringNode stringNode = null;
        for (p2 = sn.p; p2 < end2; p2 += len) {
            CaseFoldCodeItem[] items = this.enc.caseFoldCodesByString(this.regex.caseFoldFlag, bytes2, p2, end2);
            len = this.enc.length(bytes2, p2, end2);
            if (items.length == 0 || !this.isCaseFoldVariableLength(items.length, items, len)) {
                if (stringNode == null) {
                    if (root == null && prevNode.p != null) {
                        root = ListNode.listAdd(null, (Node)prevNode.p);
                        topRoot = root;
                    }
                    stringNode = new StringNode();
                    prevNode.p = stringNode;
                    if (root != null) {
                        ListNode.listAdd(root, stringNode);
                    }
                }
                stringNode.catBytes(bytes2, p2, p2 + len);
                continue;
            }
            if ((altNum *= items.length + 1) > 8) break;
            if (stringNode != null) {
                this.updateStringNodeCaseFold(stringNode);
                stringNode.setAmbig();
            }
            if (root == null && prevNode.p != null) {
                root = ListNode.listAdd(null, (Node)prevNode.p);
                topRoot = root;
            }
            if (this.expandCaseFoldStringAlt(items.length, items, bytes2, p2, len, end2, prevNode)) {
                if (root == null) {
                    topRoot = (ListNode)prevNode.p;
                } else {
                    ListNode.listAdd(root, (Node)prevNode.p);
                }
                root = (ListNode)((ListNode)prevNode.p).value;
            } else if (root != null) {
                ListNode.listAdd(root, (Node)prevNode.p);
            }
            stringNode = null;
        }
        if (stringNode != null) {
            this.updateStringNodeCaseFold(stringNode);
            stringNode.setAmbig();
        }
        if (p2 < end2) {
            Node srem = this.expandCaseFoldMakeRemString(bytes2, p2, end2);
            if (prevNode.p != null && root == null) {
                root = ListNode.listAdd(null, (Node)prevNode.p);
                topRoot = root;
            }
            if (root == null) {
                prevNode.p = srem;
            } else {
                ListNode.listAdd(root, srem);
            }
        }
        Node xnode = topRoot != null ? topRoot : (Node)prevNode.p;
        node.replaceWith(xnode);
        return xnode;
    }

    protected final int setupCombExpCheck(Node node, int state2) {
        int r = state2;
        block0 : switch (node.getType()) {
            case 8: {
                ListNode ln = (ListNode)node;
                while ((r = this.setupCombExpCheck(ln.value, r)) >= 0 && (ln = ln.tail) != null) {
                }
                break;
            }
            case 9: {
                int ret;
                ListNode an = (ListNode)node;
                do {
                    ret = this.setupCombExpCheck(an.value, state2);
                    r |= ret;
                } while (ret >= 0 && (an = an.tail) != null);
                break;
            }
            case 5: {
                QuantifierNode qn = (QuantifierNode)node;
                int childState = state2;
                int addState = 0;
                if (!QuantifierNode.isRepeatInfinite(qn.upper) && qn.upper > 1) {
                    childState |= 2;
                    if (this.env.backrefedMem == 0 && qn.target.getType() == 6) {
                        EncloseNode en = (EncloseNode)qn.target;
                        if (en.type == 1 && en.target.getType() == 5) {
                            QuantifierNode q = (QuantifierNode)en.target;
                            if (QuantifierNode.isRepeatInfinite(q.upper) && q.greedy == qn.greedy) {
                                int n = qn.upper = qn.lower == 0 ? 1 : qn.lower;
                                if (qn.upper == 1) {
                                    childState = state2;
                                }
                            }
                        }
                    }
                }
                if ((state2 & 2) != 0) {
                    qn.combExpCheckNum = -1;
                } else {
                    int varNum;
                    if (QuantifierNode.isRepeatInfinite(qn.upper)) {
                        varNum = Integer.MAX_VALUE;
                        childState |= 1;
                    } else {
                        varNum = qn.upper - qn.lower;
                    }
                    if (varNum >= 512) {
                        addState |= 4;
                    }
                    if (((state2 & 1) != 0 && varNum != 0 || (state2 & 4) != 0 && varNum >= 512) && qn.combExpCheckNum == 0) {
                        ++this.env.numCombExpCheck;
                        qn.combExpCheckNum = this.env.numCombExpCheck;
                        if (this.env.currMaxRegNum > this.env.combExpMaxRegNum) {
                            this.env.combExpMaxRegNum = this.env.currMaxRegNum;
                        }
                    }
                }
                r = this.setupCombExpCheck(qn.target, childState);
                r |= addState;
                break;
            }
            case 6: {
                EncloseNode en = (EncloseNode)node;
                switch (en.type) {
                    case 1: {
                        if (this.env.currMaxRegNum < en.regNum) {
                            this.env.currMaxRegNum = en.regNum;
                        }
                        r = this.setupCombExpCheck(en.target, state2);
                        break block0;
                    }
                }
                r = this.setupCombExpCheck(en.target, state2);
                break;
            }
            case 10: {
                CallNode cn = (CallNode)node;
                if (cn.isRecursion()) {
                    this.env.hasRecursion = true;
                    break;
                }
                r = this.setupCombExpCheck(cn.target, state2);
                break;
            }
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    protected final Node setupTree(Node node, int state) {
        block51: {
            block25: while (true) lbl-1000:
            // 3 sources

            {
                switch (node.getType()) {
                    case 8: {
                        lin = (ListNode)node;
                        prev = null;
                        do {
                            this.setupTree(lin.value, state);
                            if (prev != null) {
                                this.nextSetup(prev, lin.value);
                            }
                            prev = lin.value;
                        } while ((lin = lin.tail) != null);
                        break block25;
                    }
                    case 9: {
                        aln = (ListNode)node;
                        do {
                            this.setupTree(aln.value, state | 1);
                        } while ((aln = aln.tail) != null);
                        break block25;
                    }
                    case 1: {
                        break block25;
                    }
                    case 0: {
                        if (!Option.isIgnoreCase(this.regex.options) || ((StringNode)node).isRaw()) break block25;
                        node = this.expandCaseFoldString(node);
                        break block25;
                    }
                    case 2: 
                    case 3: {
                        break block25;
                    }
                    case 10: {
                        break block25;
                    }
                    case 4: {
                        br = (BackRefNode)node;
                        for (i = 0; i < br.backNum; ++i) {
                            if (br.back[i] > this.env.numMem) {
                                if (this.syntax.op3OptionECMAScript()) continue;
                                this.newValueException("invalid backref number/name");
                                continue;
                            }
                            this.env.backrefedMem = BitStatus.bsOnAt(this.env.backrefedMem, br.back[i]);
                            this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, br.back[i]);
                            if (br.isNestLevel()) {
                                this.env.btMemEnd = BitStatus.bsOnAt(this.env.btMemEnd, br.back[i]);
                            }
                            this.env.memNodes[br.back[i]].setMemBackrefed();
                        }
                        break block25;
                    }
                    case 5: {
                        qn = (QuantifierNode)node;
                        target = qn.target;
                        if ((state & 4) != 0) {
                            qn.setInRepeat();
                        }
                        if ((QuantifierNode.isRepeatInfinite(qn.upper) || qn.lower >= 1) && (d = this.getMinMatchLength(target)) == 0) {
                            qn.targetEmptyInfo = 1;
                            info = this.quantifiersMemoryInfo(target);
                            if (info > 0) {
                                qn.targetEmptyInfo = info;
                            }
                        }
                        state |= 4;
                        if (qn.lower != qn.upper) {
                            state |= 8;
                        }
                        if ((target = this.setupTree(target, state)).getType() == 0) {
                            sn = (StringNode)target;
                            if (qn.lower > 1) {
                                str = new StringNode(sn.bytes, sn.p, sn.end);
                                str.flag = sn.flag;
                                n = qn.lower;
                                len = sn.length();
                                for (i = 1; i < n && (i + 1) * len <= 100; ++i) {
                                    str.catBytes(sn.bytes, sn.p, sn.end);
                                }
                                if (i < qn.upper || QuantifierNode.isRepeatInfinite(qn.upper)) {
                                    qn.lower -= i;
                                    if (!QuantifierNode.isRepeatInfinite(qn.upper)) {
                                        qn.upper -= i;
                                    }
                                    list = ListNode.newList(str, null);
                                    qn.replaceWith(list);
                                    ListNode.listAdd(list, qn);
                                    break block25;
                                }
                                qn.replaceWith(str);
                                break block25;
                            }
                        }
                        if (!qn.greedy || qn.targetEmptyInfo == 0) break block25;
                        if (target.getType() == 5) {
                            tqn = (QuantifierNode)target;
                            if (tqn.headExact == null) break block25;
                            qn.headExact = tqn.headExact;
                            tqn.headExact = null;
                            break block25;
                        }
                        qn.headExact = this.getHeadValueNode(qn.target, true);
                        break block25;
                    }
                    case 6: {
                        en = (EncloseNode)node;
                        switch (en.type) {
                            case 2: {
                                options = this.regex.options;
                                this.regex.options = en.option;
                                this.setupTree(en.target, state);
                                this.regex.options = options;
                                break;
                            }
                            case 1: {
                                if ((state & 27) != 0) {
                                    this.env.btMemStart = BitStatus.bsOnAt(this.env.btMemStart, en.regNum);
                                }
                                if (en.isCalled()) {
                                    state |= 16;
                                }
                                if (en.isRecursion()) {
                                    state |= 32;
                                } else if ((state & 32) != 0) {
                                    en.setRecursion();
                                }
                                this.setupTree(en.target, state);
                                break;
                            }
                            case 4: {
                                this.setupTree(en.target, state);
                                if (en.target.getType() == 5) {
                                    tqn = (QuantifierNode)en.target;
                                    if (!QuantifierNode.isRepeatInfinite(tqn.upper) || tqn.lower > 1 || !tqn.greedy || !tqn.target.isSimple()) break block25;
                                    en.setStopBtSimpleRepeat();
                                    break;
                                }
                                break block51;
                            }
                            case 8: {
                                if (!en.isNameRef() && this.env.numNamed > 0 && this.syntax.captureOnlyNamedGroup() && !Option.isCaptureGroup(this.env.option)) {
                                    this.newValueException("numbered backref/call is not allowed. (use name)");
                                }
                                if (en.regNum > this.env.numMem) {
                                    this.newValueException("invalid backref number/name");
                                }
                                this.setupTree(en.target, state);
                                break;
                            }
                            case 16: {
                                this.setupTree(en.target, state);
                            }
                        }
                        break block25;
                    }
                    case 7: {
                        an = (AnchorNode)node;
                        switch (an.type) {
                            case 1024: {
                                this.setupTree(an.target, state);
                                break block25;
                            }
                            case 2048: {
                                this.setupTree(an.target, state | 2);
                                break block25;
                            }
                            case 4096: {
                                if (this.checkTypeTree(an.target, 2031, 3, 78823)) {
                                    this.newSyntaxException("invalid pattern in look-behind");
                                }
                                if ((node = this.setupLookBehind(an)).getType() != 7) ** GOTO lbl-1000
                                this.setupTree(((AnchorNode)node).target, state);
                                node = this.setupLookBehind(an);
                                break block25;
                            }
                            case 8192: {
                                if (!this.checkTypeTree(an.target, 2031, 2, 78823)) continue block25;
                                this.newSyntaxException("invalid pattern in look-behind");
                                if ((node = this.setupLookBehind(an)).getType() != 7) continue block25;
                                this.setupTree(((AnchorNode)node).target, state | 2);
                                node = this.setupLookBehind(an);
                            }
                        }
                    }
                }
                break;
            }
        }
        return node;
    }

    /*
     * Unable to fully structure code
     */
    private void optimizeNodeLeft(Node node, NodeOptInfo opt, OptEnvironment oenv) {
        opt.clear();
        opt.setBoundNode(oenv.mmd);
        switch (node.getType()) {
            case 8: {
                nenv = new OptEnvironment();
                nopt = new NodeOptInfo();
                nenv.copy(oenv);
                lin = (ListNode)node;
                do {
                    this.optimizeNodeLeft(lin.value, nopt, nenv);
                    nenv.mmd.add(nopt.length);
                    opt.concatLeftNode(nopt, this.enc);
                } while ((lin = lin.tail) != null);
                break;
            }
            case 9: {
                nopt = new NodeOptInfo();
                aln = (ListNode)node;
                do {
                    this.optimizeNodeLeft(aln.value, nopt, oenv);
                    if (aln == node) {
                        opt.copy(nopt);
                        continue;
                    }
                    opt.altMerge(nopt, oenv);
                } while ((aln = aln.tail) != null);
                break;
            }
            case 0: {
                sn = (StringNode)node;
                slen = sn.length();
                if (!sn.isAmbig()) {
                    opt.exb.concatStr(sn.bytes, sn.p, sn.end, sn.isRaw(), this.enc);
                    opt.exb.ignoreCase = 0;
                    if (slen > 0) {
                        opt.map.addChar(sn.bytes[sn.p], this.enc);
                    }
                    opt.length.set(slen, slen);
                } else {
                    if (sn.isDontGetOptInfo()) {
                        n = sn.length(this.enc);
                        max = this.enc.maxLength() * n;
                    } else {
                        opt.exb.concatStr(sn.bytes, sn.p, sn.end, sn.isRaw(), this.enc);
                        opt.exb.ignoreCase = 1;
                        if (slen > 0) {
                            opt.map.addCharAmb(sn.bytes, sn.p, sn.end, this.enc, oenv.caseFoldFlag);
                        }
                        max = slen;
                    }
                    opt.length.set(slen, max);
                }
                if (opt.exb.length != slen) break;
                opt.exb.reachEnd = true;
                break;
            }
            case 1: {
                cc = (CClassNode)node;
                if (cc.mbuf != null || cc.isNot()) {
                    min = this.enc.minLength();
                    max = this.enc.maxLength();
                    opt.length.set(min, max);
                    break;
                }
                for (i = 0; i < 256; ++i) {
                    z = cc.bs.at(i);
                    if ((!z || cc.isNot()) && (z || !cc.isNot())) continue;
                    opt.map.addChar((byte)i, this.enc);
                }
                opt.length.set(1, 1);
                break;
            }
            case 2: {
                max = this.enc.maxLength();
                if (max != 1) ** GOTO lbl83
                min = 1;
                cn = (CTypeNode)node;
                maxCode = cn.asciiRange != false ? 128 : 256;
                switch (cn.ctype) {
                    case 12: {
                        if (cn.not) {
                            for (i = 0; i < 256; ++i) {
                                if (this.enc.isWord(i) && i < maxCode) continue;
                                opt.map.addChar((byte)i, this.enc);
                            }
                        } else {
                            for (i = 0; i < maxCode; ++i) {
                                if (!this.enc.isWord(i)) continue;
                                opt.map.addChar((byte)i, this.enc);
                            }
                        }
                    }
                }
                ** GOTO lbl84
lbl83:
                // 1 sources

                min = this.enc.minLength();
lbl84:
                // 3 sources

                opt.length.set(min, max);
                break;
            }
            case 3: {
                opt.length.set(this.enc.minLength(), this.enc.maxLength());
                break;
            }
            case 7: {
                an = (AnchorNode)node;
                switch (an.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 2048: 
                    case 4096: {
                        opt.anchor.add(an.type);
                        break;
                    }
                    case 1024: {
                        nopt = new NodeOptInfo();
                        this.optimizeNodeLeft(an.target, nopt, oenv);
                        if (nopt.exb.length > 0) {
                            opt.expr.copy(nopt.exb);
                        } else if (nopt.exm.length > 0) {
                            opt.expr.copy(nopt.exm);
                        }
                        opt.expr.reachEnd = false;
                        if (nopt.map.value <= 0) break;
                        opt.map.copy(nopt.map);
                        break;
                    }
                }
                break;
            }
            case 4: {
                br = (BackRefNode)node;
                if (br.isRecursion()) {
                    opt.length.set(0, 0x7FFFFFFF);
                    break;
                }
                nodes = oenv.scanEnv.memNodes;
                min = 0;
                max = 0;
                if (nodes != null && nodes[br.back[0]] != null) {
                    min = this.getMinMatchLength(nodes[br.back[0]]);
                    max = this.getMaxMatchLength(nodes[br.back[0]]);
                }
                for (i = 1; i < br.backNum; ++i) {
                    if (nodes[br.back[i]] == null) continue;
                    tmin = this.getMinMatchLength(nodes[br.back[i]]);
                    tmax = this.getMaxMatchLength(nodes[br.back[i]]);
                    if (min > tmin) {
                        min = tmin;
                    }
                    if (max >= tmax) continue;
                    max = tmax;
                }
                opt.length.set(min, max);
                break;
            }
            case 10: {
                cn = (CallNode)node;
                if (cn.isRecursion()) {
                    opt.length.set(0, 0x7FFFFFFF);
                    break;
                }
                safe = oenv.options;
                oenv.options = cn.target.option;
                this.optimizeNodeLeft(cn.target, opt, oenv);
                oenv.options = safe;
                break;
            }
            case 5: {
                nopt = new NodeOptInfo();
                qn = (QuantifierNode)node;
                this.optimizeNodeLeft(qn.target, nopt, oenv);
                if (QuantifierNode.isRepeatInfinite(qn.upper) && oenv.mmd.max == 0 && qn.target.getType() == 3 && qn.greedy) {
                    if (Option.isMultiline(oenv.options)) {
                        opt.anchor.add(32768);
                    } else {
                        opt.anchor.add(16384);
                    }
                }
                if (qn.lower > 0) {
                    opt.copy(nopt);
                    if (nopt.exb.length > 0 && nopt.exb.reachEnd) {
                        for (i = 2; i <= qn.lower && !opt.exb.isFull(); ++i) {
                            opt.exb.concat(nopt.exb, this.enc);
                        }
                        if (i < qn.lower) {
                            opt.exb.reachEnd = false;
                        }
                    }
                    if (qn.lower != qn.upper) {
                        opt.exb.reachEnd = false;
                        opt.exm.reachEnd = false;
                    }
                    if (qn.lower > 1) {
                        opt.exm.reachEnd = false;
                    }
                }
                min = MinMaxLen.distanceMultiply(nopt.length.min, qn.lower);
                max = QuantifierNode.isRepeatInfinite(qn.upper) != false ? (nopt.length.max > 0 ? 0x7FFFFFFF : 0) : MinMaxLen.distanceMultiply(nopt.length.max, qn.upper);
                opt.length.set(min, max);
                break;
            }
            case 6: {
                en = (EncloseNode)node;
                switch (en.type) {
                    case 2: {
                        save = oenv.options;
                        oenv.options = en.option;
                        this.optimizeNodeLeft(en.target, opt, oenv);
                        oenv.options = save;
                        break;
                    }
                    case 1: {
                        if (++en.optCount > 5) {
                            min = 0;
                            max = 0x7FFFFFFF;
                            if (en.isMinFixed()) {
                                min = en.minLength;
                            }
                            if (en.isMaxFixed()) {
                                max = en.maxLength;
                            }
                            opt.length.set(min, max);
                            break;
                        }
                        this.optimizeNodeLeft(en.target, opt, oenv);
                        if (!opt.anchor.isSet(49152) || !BitStatus.bsAt(oenv.scanEnv.backrefedMem, en.regNum)) break;
                        opt.anchor.remove(49152);
                        break;
                    }
                    case 4: 
                    case 8: {
                        this.optimizeNodeLeft(en.target, opt, oenv);
                        break;
                    }
                    case 16: {
                        opt.length.set(0, 0x7FFFFFFF);
                    }
                }
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    protected final void setOptimizedInfoFromTree(Node node) {
        NodeOptInfo opt = new NodeOptInfo();
        OptEnvironment oenv = new OptEnvironment();
        oenv.enc = this.regex.enc;
        oenv.options = this.regex.options;
        oenv.caseFoldFlag = this.regex.caseFoldFlag;
        oenv.scanEnv = this.env;
        oenv.mmd.clear();
        this.optimizeNodeLeft(node, opt, oenv);
        this.regex.anchor = opt.anchor.leftAnchor & 0xD005;
        if ((opt.anchor.leftAnchor & 0x1800) != 0) {
            this.regex.anchor &= 0xFFFF7FFF;
        }
        this.regex.anchor |= opt.anchor.rightAnchor & 0x818;
        if ((this.regex.anchor & 0x18) != 0) {
            this.regex.anchorDmin = opt.length.min;
            this.regex.anchorDmax = opt.length.max;
        }
        if (opt.exb.length > 0 || opt.exm.length > 0) {
            opt.exb.select(opt.exm, this.enc);
            if (opt.map.value > 0 && opt.exb.compare(opt.map) > 0) {
                this.regex.setOptimizeMapInfo(opt.map);
                this.regex.setSubAnchor(opt.map.anchor);
            } else {
                this.regex.setOptimizeExactInfo(opt.exb);
                this.regex.setSubAnchor(opt.exb.anchor);
            }
        } else if (opt.map.value > 0) {
            this.regex.setOptimizeMapInfo(opt.map);
            this.regex.setSubAnchor(opt.map.anchor);
        } else {
            this.regex.subAnchor |= opt.anchor.leftAnchor & 2;
            if (opt.length.max == 0) {
                this.regex.subAnchor |= opt.anchor.rightAnchor & 0x20;
            }
        }
    }
}

