/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.ListePset;
import mediathek.daten.ListePsetVorlagen;
import mediathek.gui.dialogEinstellungen.PanelEinstellungenGeo;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.gui.dialogEinstellungen.PanelPsetKurz;
import mediathek.gui.dialogEinstellungen.PanelPsetLang;
import mediathek.tool.Functions;
import mediathek.tool.GuiFunktionenProgramme;

public class DialogStarteinstellungen
extends JDialog {
    private final Daten daten;
    private State status = State.START;
    private final JFrame parentComponent;
    private boolean anpassen = false;
    private JButton jButtonAnpassen;
    private JButton jButtonStandard;
    private JCheckBox jCheckBoxAlleEinstellungen;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;

    public DialogStarteinstellungen(JFrame parent, Daten dd) {
        super((Frame)parent, true);
        this.parentComponent = parent;
        this.initComponents();
        this.daten = dd;
        this.setTitle("Erster Start");
        this.jButtonStandard.addActionListener(e -> this.weiter());
        this.jButtonAnpassen.addActionListener(e -> {
            this.anpassen = true;
            this.weiter();
        });
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.addActionListener(e -> {
            this.status = State.PSET;
            this.weiter();
        });
        MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_VLC, GuiFunktionenProgramme.getMusterPfadVlc());
        MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_FFMPEG, GuiFunktionenProgramme.getMusterPfadFFmpeg());
        this.createLayout();
        if (MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_VLC).isEmpty() || MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_FFMPEG).isEmpty()) {
            this.jButtonStandard.setEnabled(false);
            this.anpassen = true;
        }
    }

    private void createLayout() {
        PanelEinstellungenGeo panelEinstellungenGeo = new PanelEinstellungenGeo(this.parentComponent);
        this.jPanelExtra.setLayout(new BorderLayout());
        this.jPanelExtra.add((Component)panelEinstellungenGeo, "Center");
    }

    private void weiter() {
        this.jButtonStandard.setEnabled(true);
        switch (this.status) {
            case START: {
                this.statusStart();
                break;
            }
            case PFAD: {
                this.statusPfade();
                break;
            }
            case PSET: {
                this.statusPset();
                break;
            }
            default: {
                this.beenden();
            }
        }
    }

    private void statusStart() {
        this.jButtonStandard.setText("Weiter");
        this.status = MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_VLC).isEmpty() || MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_FFMPEG).isEmpty() ? State.PFAD : (this.anpassen ? State.PFAD : (this.addStandarSet(this.parentComponent, this.daten) ? State.FERTIG : State.PSET));
        this.weiter();
    }

    private void statusPfade() {
        this.jButtonAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        switch (Functions.getOs()) {
            case MAC: 
            case WIN32: 
            case WIN64: {
                this.jScrollPane1.setViewportView(new PanelProgrammPfade(this.parentComponent, true, false));
                break;
            }
            default: {
                this.jScrollPane1.setViewportView(new PanelProgrammPfade(this.parentComponent, true, true));
            }
        }
        this.status = State.PSET;
        this.jButtonStandard.setText("Weiter");
    }

    private void statusPset() {
        this.jButtonAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(true);
        if (Daten.listePset.isEmpty()) {
            this.addStandarSet(this.parentComponent, this.daten);
        }
        if (this.jCheckBoxAlleEinstellungen.isSelected()) {
            this.jScrollPane1.setViewportView(new PanelPsetLang(this.daten, this.parentComponent, Daten.listePset));
        } else {
            this.jScrollPane1.setViewportView(new PanelPsetKurz(this.daten, this.parentComponent, Daten.listePset));
        }
        this.status = State.FERTIG;
        this.jButtonStandard.setText("Weiter");
    }

    private boolean addStandarSet(JFrame parent, Daten daten) {
        boolean ret = false;
        ListePset pSet = ListePsetVorlagen.getStandarset(parent, true);
        if (pSet != null) {
            Daten.listePset.addPset(pSet);
            MVConfig.add(MVConfig.Configs.SYSTEM_VERSION_PROGRAMMSET, pSet.version);
            ret = true;
        }
        return ret;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        this.jButtonStandard = new JButton();
        this.jCheckBoxAlleEinstellungen = new JCheckBox();
        this.jButtonAnpassen = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.setDefaultCloseOperation(2);
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 255), 3));
        this.jButtonStandard.setText("Mit Standardeinstellungen starten");
        this.jCheckBoxAlleEinstellungen.setText("alle Einstellungen anzeigen");
        this.jButtonAnpassen.setText("Einstellungen anpassen");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAlleEinstellungen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonAnpassen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStandard).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonStandard).addComponent(this.jCheckBoxAlleEinstellungen).addComponent(this.jButtonAnpassen)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 788, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 510, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 791, Short.MAX_VALUE).addComponent(jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addGap(18, 18, 18).addComponent(jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private static enum State {
        START,
        PFAD,
        PSET,
        FERTIG;

    }
}

