/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.ArrowLinkColorXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.Color;
import java.awt.event.ActionEvent;

public class ColorArrowLinkAction
extends FreemindAction
implements ActorXml {
    MindMapArrowLinkModel arrowLink;
    private final MindMapController controller;

    public ColorArrowLinkAction(MindMapController controller, MindMapArrowLinkModel arrowLink) {
        super("arrow_link_color", "images/Colors24.gif", controller);
        this.controller = controller;
        this.arrowLink = arrowLink;
        this.addActor(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color selectedColor = this.arrowLink.getColor();
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), (String)this.getValue("Name"), selectedColor);
        if (color == null) {
            return;
        }
        this.setArrowLinkColor(this.arrowLink, color);
    }

    public void setArrowLinkColor(MindMapLink arrowLink, Color color) {
        this.controller.doTransaction((String)this.getValue("Name"), this.getActionPair(arrowLink, color));
    }

    private ActionPair getActionPair(MindMapLink arrowLink, Color color) {
        return new ActionPair((XmlAction)this.createArrowLinkColorXmlAction(arrowLink, color), (XmlAction)this.createArrowLinkColorXmlAction(arrowLink, arrowLink.getColor()));
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof ArrowLinkColorXmlAction) {
            ArrowLinkColorXmlAction colorAction = (ArrowLinkColorXmlAction)action;
            MindMapLink link = this.getLinkRegistry().getLinkForId(colorAction.getId());
            ((LineAdapter)((Object)link)).setColor(Tools.xmlToColor(colorAction.getColor()));
            this.controller.nodeChanged(link.getSource());
        }
    }

    @Override
    public Class getDoActionClass() {
        return ArrowLinkColorXmlAction.class;
    }

    private ArrowLinkColorXmlAction createArrowLinkColorXmlAction(MindMapLink arrowLink, Color color) {
        ArrowLinkColorXmlAction action = new ArrowLinkColorXmlAction();
        action.setColor(Tools.colorToXml(color));
        action.setId(arrowLink.getUniqueId());
        return action;
    }

    private MindMapLinkRegistry getLinkRegistry() {
        return this.controller.getMap().getLinkRegistry();
    }
}

