/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyContext;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.IvyNode;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.IvyNodeCallers;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.IvyNodeEviction;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.ResolveData;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.RestartResolveProcess;
import org.jetbrains.kotlin.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.jetbrains.kotlin.org.apache.ivy.plugins.conflict.StrictConflictException;
import org.jetbrains.kotlin.org.apache.ivy.plugins.latest.LatestStrategy;
import org.jetbrains.kotlin.org.apache.ivy.plugins.version.VersionMatcher;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;

public class LatestCompatibleConflictManager
extends LatestConflictManager {
    public LatestCompatibleConflictManager() {
    }

    public LatestCompatibleConflictManager(String name, LatestStrategy strategy) {
        super(name, strategy);
    }

    @Override
    public Collection<IvyNode> resolveConflicts(IvyNode parent, Collection<IvyNode> conflicts) {
        Iterator<IvyNode> iter;
        IvyNode node;
        ModuleRevisionId mrid;
        if (conflicts.size() < 2) {
            return conflicts;
        }
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        if (versionMatcher.isDynamic(mrid = (node = (iter = conflicts.iterator()).next()).getResolvedId())) {
            while (iter.hasNext()) {
                IvyNode other = iter.next();
                if (!versionMatcher.isDynamic(other.getResolvedId()) && (versionMatcher.accept(mrid, other.getResolvedId()) || this.handleIncompatibleConflict(parent, conflicts, node, other))) continue;
                return null;
            }
            if (conflicts.size() == 2) {
                Iterator<IvyNode> it = conflicts.iterator();
                it.next();
                return Collections.singleton(it.next());
            }
            LinkedHashSet<IvyNode> newConflicts = new LinkedHashSet<IvyNode>(conflicts);
            newConflicts.remove(node);
            return super.resolveConflicts(parent, newConflicts);
        }
        while (iter.hasNext()) {
            IvyNode other = iter.next();
            if (versionMatcher.accept(other.getResolvedId(), mrid) || this.handleIncompatibleConflict(parent, conflicts, node, other)) continue;
            return null;
        }
        return Collections.singleton(node);
    }

    private boolean handleIncompatibleConflict(IvyNode parent, Collection<IvyNode> conflicts, IvyNode node, IvyNode other) {
        try {
            LatestConflictManager.IvyNodeArtifactInfo latest = (LatestConflictManager.IvyNodeArtifactInfo)this.getStrategy().findLatest(this.toArtifactInfo(Arrays.asList(node, other)), null);
            if (latest != null) {
                IvyNode latestNode = latest.getNode();
                IvyNode oldestNode = latestNode == node ? other : node;
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), parent, oldestNode, latestNode);
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), parent, latestNode, oldestNode);
                this.handleUnsolvableConflict(parent, conflicts, node, other);
                return true;
            }
            return false;
        }
        catch (LatestConflictManager.NoConflictResolvedYetException ex) {
            return false;
        }
    }

    private void blackListIncompatibleCallerAndRestartResolveIfPossible(IvySettings settings, IvyNode parent, IvyNode selected, IvyNode evicted) {
        Stack<IvyNode> callerStack = new Stack<IvyNode>();
        callerStack.push(evicted);
        Collection<IvyNodeBlacklist> toBlacklist = this.blackListIncompatibleCaller(settings.getVersionMatcher(), parent, selected, evicted, callerStack);
        if (toBlacklist != null) {
            StringBuilder blacklisted = new StringBuilder();
            for (IvyNodeBlacklist blacklist : toBlacklist) {
                if (blacklisted.length() > 0) {
                    blacklisted.append(" ");
                }
                IvyNode blacklistedNode = blacklist.getBlacklistedNode();
                blacklistedNode.blacklist(blacklist);
                blacklisted.append(blacklistedNode);
            }
            String rootModuleConf = parent.getData().getReport().getConfiguration();
            evicted.markEvicted(new IvyNodeEviction.EvictionData(rootModuleConf, parent, this, Collections.singleton(selected), "with blacklisting of " + blacklisted));
            if (settings.debugConflictResolution()) {
                Message.debug("evicting " + evicted + " by " + evicted.getEvictedData(rootModuleConf));
            }
            throw new RestartResolveProcess("trying to handle incompatibilities between " + selected + " and " + evicted);
        }
    }

    private boolean handleIncompatibleCaller(Stack<IvyNode> callerStack, IvyNode node, IvyNode callerNode, IvyNode conflictParent, IvyNode selectedNode, IvyNode evictedNode, Collection<IvyNodeBlacklist> blacklisted, VersionMatcher versionMatcher) {
        if (callerStack.subList(0, callerStack.size() - 1).contains(node)) {
            return true;
        }
        callerStack.push(callerNode);
        Collection<IvyNodeBlacklist> sub = this.blackListIncompatibleCaller(versionMatcher, conflictParent, selectedNode, evictedNode, callerStack);
        callerStack.pop();
        if (sub == null) {
            return false;
        }
        blacklisted.addAll(sub);
        return true;
    }

    private Collection<IvyNodeBlacklist> blackListIncompatibleCaller(VersionMatcher versionMatcher, IvyNode conflictParent, IvyNode selectedNode, IvyNode evictedNode, Stack<IvyNode> callerStack) {
        ArrayList<IvyNodeBlacklist> blacklisted = new ArrayList<IvyNodeBlacklist>();
        IvyNode node = callerStack.peek();
        String rootModuleConf = conflictParent.getData().getReport().getConfiguration();
        for (IvyNodeCallers.Caller caller : node.getCallers(rootModuleConf)) {
            IvyNode callerNode = node.findNode(caller.getModuleRevisionId());
            if (callerNode.isBlacklisted(rootModuleConf)) continue;
            if (versionMatcher.isDynamic(caller.getAskedDependencyId())) {
                blacklisted.add(new IvyNodeBlacklist(conflictParent, selectedNode, evictedNode, node, rootModuleConf));
                if (!node.isEvicted(rootModuleConf) || this.handleIncompatibleCaller(callerStack, node, callerNode, conflictParent, selectedNode, evictedNode, blacklisted, versionMatcher)) continue;
                return null;
            }
            if (this.handleIncompatibleCaller(callerStack, node, callerNode, conflictParent, selectedNode, evictedNode, blacklisted, versionMatcher)) continue;
            return null;
        }
        if (blacklisted.isEmpty() && !callerStack.subList(0, callerStack.size() - 1).contains(node)) {
            return null;
        }
        return blacklisted;
    }

    protected void handleUnsolvableConflict(IvyNode parent, Collection<IvyNode> conflicts, IvyNode node1, IvyNode node2) {
        throw new StrictConflictException(node1, node2);
    }

    @Override
    public void handleAllBlacklistedRevisions(DependencyDescriptor dd, Collection<ModuleRevisionId> foundBlacklisted) {
        ResolveData resolveData = IvyContext.getContext().getResolveData();
        HashSet<IvyNode> blacklisted = new HashSet<IvyNode>();
        for (ModuleRevisionId mrid : foundBlacklisted) {
            blacklisted.add(resolveData.getNode(mrid));
        }
        for (IvyNode node : blacklisted) {
            IvyNodeBlacklist bdata = node.getBlacklistData(resolveData.getReport().getConfiguration());
            this.handleUnsolvableConflict(bdata.getConflictParent(), Arrays.asList(bdata.getEvictedNode(), bdata.getSelectedNode()), bdata.getEvictedNode(), bdata.getSelectedNode());
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

