/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiElement
extends Iconable,
UserDataHolder {
    public static final PsiElement[] EMPTY_ARRAY = new PsiElement[0];
    public static final ArrayFactory<PsiElement> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiElement[count];

    @NotNull
    @Contract(pure=true)
    public Project getProject() throws PsiInvalidElementAccessException;

    @NotNull
    @Contract(pure=true)
    public Language getLanguage();

    @Contract(pure=true)
    public PsiManager getManager();

    @NotNull
    @Contract(pure=true)
    public PsiElement[] getChildren();

    @Contract(pure=true)
    public PsiElement getParent();

    @Contract(pure=true)
    public PsiElement getFirstChild();

    @Contract(pure=true)
    public PsiElement getLastChild();

    @Contract(pure=true)
    public PsiElement getNextSibling();

    @Contract(pure=true)
    public PsiElement getPrevSibling();

    @Contract(pure=true)
    public PsiFile getContainingFile() throws PsiInvalidElementAccessException;

    @Contract(pure=true)
    public TextRange getTextRange();

    @Contract(pure=true)
    @NotNull
    default public TextRange getTextRangeInParent() {
        TextRange textRange = TextRange.from(this.getStartOffsetInParent(), this.getTextLength());
        if (textRange == null) {
            PsiElement.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @Contract(pure=true)
    public int getStartOffsetInParent();

    @Contract(pure=true)
    public int getTextLength();

    @Nullable
    @Contract(pure=true)
    public PsiElement findElementAt(int var1);

    @Nullable
    @Contract(pure=true)
    public PsiReference findReferenceAt(int var1);

    @Contract(pure=true)
    public int getTextOffset();

    @NonNls
    @Contract(pure=true)
    public String getText();

    @NotNull
    @Contract(pure=true)
    public char[] textToCharArray();

    @Contract(pure=true)
    public PsiElement getNavigationElement();

    @Contract(pure=true)
    public PsiElement getOriginalElement();

    @Contract(pure=true)
    public boolean textMatches(@NotNull @NonNls CharSequence var1);

    @Contract(pure=true)
    public boolean textMatches(@NotNull PsiElement var1);

    @Contract(pure=true)
    public boolean textContains(char var1);

    public void accept(@NotNull PsiElementVisitor var1);

    public void acceptChildren(@NotNull PsiElementVisitor var1);

    public PsiElement copy();

    public PsiElement add(@NotNull PsiElement var1) throws IncorrectOperationException;

    public PsiElement addBefore(@NotNull PsiElement var1, @Nullable PsiElement var2) throws IncorrectOperationException;

    public PsiElement addAfter(@NotNull PsiElement var1, @Nullable PsiElement var2) throws IncorrectOperationException;

    @Deprecated
    public void checkAdd(@NotNull PsiElement var1) throws IncorrectOperationException;

    public PsiElement addRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement addRangeBefore(@NotNull PsiElement var1, @NotNull PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public PsiElement addRangeAfter(PsiElement var1, PsiElement var2, PsiElement var3) throws IncorrectOperationException;

    public void delete() throws IncorrectOperationException;

    @Deprecated
    public void checkDelete() throws IncorrectOperationException;

    public void deleteChildRange(PsiElement var1, PsiElement var2) throws IncorrectOperationException;

    public PsiElement replace(@NotNull PsiElement var1) throws IncorrectOperationException;

    @Contract(pure=true)
    public boolean isValid();

    @Contract(pure=true)
    public boolean isWritable();

    @Nullable
    @Contract(pure=true)
    public PsiReference getReference();

    @NotNull
    @Contract(pure=true)
    public PsiReference[] getReferences();

    @Nullable
    @Contract(pure=true)
    public <T> T getCopyableUserData(Key<T> var1);

    public <T> void putCopyableUserData(Key<T> var1, @Nullable T var2);

    public boolean processDeclarations(@NotNull PsiScopeProcessor var1, @NotNull ResolveState var2, @Nullable PsiElement var3, @NotNull PsiElement var4);

    @Nullable
    @Contract(pure=true)
    public PsiElement getContext();

    @Contract(pure=true)
    public boolean isPhysical();

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope getResolveScope();

    @NotNull
    @Contract(pure=true)
    public SearchScope getUseScope();

    @Contract(pure=true)
    public ASTNode getNode();

    @NonNls
    @Contract(pure=true)
    public String toString();

    @Contract(pure=true)
    public boolean isEquivalentTo(PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElement", "getTextRangeInParent"));
    }
}

