// For license of this file, see <project-root-folder>/LICENSE.md.

#ifndef STANDARDSERVICEROOT_H
#define STANDARDSERVICEROOT_H

#include "services/abstract/serviceroot.h"

#include <QCoreApplication>
#include <QPair>

class StandardCategory;
class StandardFeed;
class FeedsImportExportModel;
class QMenu;

class StandardServiceRoot : public ServiceRoot {
  Q_OBJECT

  public:
    explicit StandardServiceRoot(RootItem* parent = nullptr);
    virtual ~StandardServiceRoot();

    // Start/stop root.
    void start(bool freshly_activated);
    void stop();

    QString code() const;

    bool canBeEdited() const;
    bool canBeDeleted() const;
    bool deleteViaGui();
    bool supportsFeedAdding() const;
    bool supportsCategoryAdding() const;

    Qt::ItemFlags additionalFlags() const;

    // Returns menu to be shown in "Services -> service" menu.
    QList<QAction*> serviceMenu();

    // Returns context specific menu actions for given feed.
    QList<QAction*> getContextMenuForFeed(StandardFeed* feed);

    // Takes structure residing under given root item and adds feeds/categories from
    // it to active structure.
    // NOTE: This is used for import/export of the model.
    bool mergeImportExportModel(FeedsImportExportModel* model, RootItem* target_root_node, QString& output_message);

    void loadFromDatabase();
    void checkArgumentForFeedAdding(const QString& argument);

  public slots:
    void addNewFeed(const QString& url = QString());
    void addNewCategory();
    void importFeeds();
    void exportFeeds();

  private:
    QString processFeedUrl(const QString& feed_url);
    void checkArgumentsForFeedAdding();

    QAction* m_actionExportFeeds;
    QAction* m_actionImportFeeds;

    QList<QAction*> m_serviceMenu;
    QList<QAction*> m_feedContextMenu;
    QAction* m_actionFeedFetchMetadata;
};

#endif // STANDARDSERVICEROOT_H
