/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin.spreadsheet.wizard;

import java.awt.Component;
import javax.swing.JComponent;
import org.gephi.io.importer.plugin.file.spreadsheet.AbstractImporterSpreadsheet;
import org.gephi.io.importer.plugin.file.spreadsheet.ImporterSpreadsheetExcel;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.WizardPanel1Excel;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.WizardPanel2;
import org.openide.WizardDescriptor;

public final class ImportExcelUIWizard {
    private final ImporterSpreadsheetExcel[] importers;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wizardDescriptor;

    public ImportExcelUIWizard(ImporterSpreadsheetExcel[] importers) {
        this.importers = importers;
        this.initDescriptor();
    }

    public WizardDescriptor getDescriptor() {
        return this.wizardDescriptor;
    }

    public void initDescriptor() {
        this.buildPanels();
        this.wizardDescriptor = new WizardDescriptor(this.panels);
    }

    private void buildPanels() {
        this.panels = new WizardDescriptor.Panel[this.importers.length * 2];
        for (int i = 0; i < this.importers.length; ++i) {
            ImporterSpreadsheetExcel importer = this.importers[i];
            WizardPanel1Excel step1 = new WizardPanel1Excel(importer);
            WizardPanel2 step2 = new WizardPanel2((AbstractImporterSpreadsheet)importer);
            this.panels[i * 2] = step1;
            this.panels[i * 2 + 1] = step2;
        }
        String[] steps = new String[this.panels.length];
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }
}

