/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public enum OnlineResource {
    OSM_API(I18n.tr("OSM API", new Object[0])),
    JOSM_WEBSITE(I18n.tr("JOSM website", new Object[0])),
    CACHE_UPDATES(I18n.tr("Cache updates", new Object[0])),
    CERTIFICATES(I18n.tr("Certificates", new Object[0])),
    ALL(I18n.tr("All", new Object[0]));

    private final String locName;

    private OnlineResource(String locName) {
        this.locName = locName;
    }

    public final String getLocName() {
        return this.locName;
    }

    public final boolean matches(String url) {
        String baseUrl;
        switch (this) {
            case ALL: {
                return true;
            }
            case OSM_API: {
                baseUrl = OsmApi.getOsmApi().getServerUrl();
                break;
            }
            case JOSM_WEBSITE: {
                baseUrl = Config.getUrls().getJOSMWebsite();
                break;
            }
            default: {
                return false;
            }
        }
        return url.startsWith(baseUrl.substring(baseUrl.indexOf("://")), url.indexOf("://"));
    }

    @Deprecated
    public final void checkOfflineAccess(String downloadString, String ignore) {
        if (NetworkManager.isOffline(downloadString)) {
            throw OfflineAccessException.forResource(downloadString);
        }
    }
}

