/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.parser.m2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;

class MavenVersionRangeParser {
    private static final DeweyDecimal javaVersion;

    static boolean currentJavaVersionInRange(String range) {
        if (range == null) {
            return false;
        }
        if (javaVersion == null) {
            return false;
        }
        Range parsedRange = MavenVersionRangeParser.parse(range);
        return parsedRange != null && parsedRange.accepts(javaVersion);
    }

    private static Range parse(String rangeValue) {
        if (rangeValue == null || rangeValue.trim().isEmpty()) {
            return null;
        }
        try {
            String[] versionParts = rangeValue.split(",");
            if (versionParts.length == 1) {
                String boundVal = versionParts[0].trim();
                String stripped = MavenVersionRangeParser.stripBoundChars(boundVal);
                if (stripped.isEmpty()) {
                    return null;
                }
                DeweyDecimal bound = new DeweyDecimal(stripped);
                return new BasicRange(bound, !boundVal.startsWith("("), bound, !boundVal.endsWith(")"));
            }
            if (versionParts.length == 2) {
                String lowerBoundVal = versionParts[0].trim();
                String strippedLowerBound = MavenVersionRangeParser.stripBoundChars(lowerBoundVal);
                DeweyDecimal lowerBound = strippedLowerBound.isEmpty() ? null : new DeweyDecimal(strippedLowerBound);
                String upperBoundVal = versionParts[1].trim();
                String strippedUpperBound = MavenVersionRangeParser.stripBoundChars(upperBoundVal);
                DeweyDecimal upperBound = strippedUpperBound.isEmpty() ? null : new DeweyDecimal(strippedUpperBound);
                return new BasicRange(lowerBound, !lowerBoundVal.startsWith("("), upperBound, !upperBoundVal.endsWith(")"));
            }
            if (versionParts.length > 2) {
                ArrayList<Range> ranges = new ArrayList<Range>();
                int i = 0;
                while (i < versionParts.length) {
                    String partOne = versionParts[i];
                    String partTwo = i + 1 < versionParts.length ? versionParts[i + 1] : "";
                    Range rangePart = MavenVersionRangeParser.parse(partOne + "," + partTwo);
                    if (rangePart != null) {
                        ranges.add(rangePart);
                    }
                    i = i + 2 < versionParts.length ? i + 2 : i + 1;
                }
                return ranges == null || ranges.isEmpty() ? null : new MultiSetRange(ranges);
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static String stripBoundChars(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("(", "").replace(")", "").replace("[", "").replace("]", "");
    }

    static {
        DeweyDecimal v = null;
        try {
            v = new DeweyDecimal(System.getProperty("java.specification.version"));
        }
        catch (Exception e) {
            v = null;
        }
        javaVersion = v;
    }

    private static final class DeweyDecimal {
        private final int[] components;

        public DeweyDecimal(String string) throws NumberFormatException {
            StringTokenizer tokenizer = new StringTokenizer(string, ".", true);
            int size = tokenizer.countTokens();
            this.components = new int[(size + 1) / 2];
            for (int i = 0; i < this.components.length; ++i) {
                String component = tokenizer.nextToken();
                if (component.length() == 0) {
                    throw new NumberFormatException("Empty component in string");
                }
                this.components[i] = Integer.parseInt(component);
                if (!tokenizer.hasMoreTokens()) continue;
                tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) continue;
                throw new NumberFormatException("DeweyDecimal ended in a '.'");
            }
        }

        public boolean isEqual(DeweyDecimal other) {
            int max = Math.max(other.components.length, this.components.length);
            for (int i = 0; i < max; ++i) {
                int component2;
                int component1 = i < this.components.length ? this.components[i] : 0;
                int n = component2 = i < other.components.length ? other.components[i] : 0;
                if (component2 == component1) continue;
                return false;
            }
            return true;
        }

        public boolean isLessThan(DeweyDecimal other) {
            return !this.isGreaterThanOrEqual(other);
        }

        public boolean isLessThanOrEqual(DeweyDecimal other) {
            return !this.isGreaterThan(other);
        }

        public boolean isGreaterThan(DeweyDecimal other) {
            int max = Math.max(other.components.length, this.components.length);
            for (int i = 0; i < max; ++i) {
                int component2;
                int component1 = i < this.components.length ? this.components[i] : 0;
                int n = component2 = i < other.components.length ? other.components[i] : 0;
                if (component2 > component1) {
                    return false;
                }
                if (component2 >= component1) continue;
                return true;
            }
            return false;
        }

        public boolean isGreaterThanOrEqual(DeweyDecimal other) {
            int max = Math.max(other.components.length, this.components.length);
            for (int i = 0; i < max; ++i) {
                int component2;
                int component1 = i < this.components.length ? this.components[i] : 0;
                int n = component2 = i < other.components.length ? other.components[i] : 0;
                if (component2 > component1) {
                    return false;
                }
                if (component2 >= component1) continue;
                return true;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int component : this.components) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(component);
            }
            return sb.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DeweyDecimal && this.isEqual((DeweyDecimal)o);
        }
    }

    private static final class MultiSetRange
    implements Range {
        private final Collection<Range> ranges;

        private MultiSetRange(Collection<Range> ranges) {
            this.ranges = ranges == null ? Collections.emptySet() : ranges;
        }

        @Override
        public boolean accepts(DeweyDecimal value) {
            if (this.ranges.isEmpty()) {
                return false;
            }
            for (Range range : this.ranges) {
                if (range == null || !range.accepts(value)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class BasicRange
    implements Range {
        private final DeweyDecimal lowerBound;
        private final DeweyDecimal upperBound;
        private final boolean lowerInclusive;
        private final boolean upperInclusive;

        private BasicRange(DeweyDecimal lowerBound, boolean lowerInclusive, DeweyDecimal upperBound, boolean upperInclusive) {
            this.lowerBound = lowerBound;
            this.lowerInclusive = lowerInclusive;
            this.upperBound = upperBound;
            this.upperInclusive = upperInclusive;
        }

        @Override
        public boolean accepts(DeweyDecimal value) {
            return value != null && (this.lowerBound == null || (this.lowerInclusive ? value.isGreaterThanOrEqual(this.lowerBound) : value.isGreaterThan(this.lowerBound))) && (this.upperBound == null || (this.upperInclusive ? value.isLessThanOrEqual(this.upperBound) : value.isLessThan(this.upperBound)));
        }
    }

    private static interface Range {
        public boolean accepts(DeweyDecimal var1);
    }
}

