export = BridgeStore;
/**
 * Bridge store base class
 * @constructor
 * @param {Datastore} db
 */
declare function BridgeStore(db: any): void;
declare class BridgeStore {
    /**
     * Bridge store base class
     * @constructor
     * @param {Datastore} db
     */
    constructor(db: any);
    db: any;
    insert(objects: Object, defer?: any | undefined): Promise<any>;
    upsert(query: Object, updateVals: Object, defer?: any | undefined): Promise<any>;
    insertIfNotExists(query: Object, insertObj: Object): Promise<any>;
    update(query: Object, updateVals: Object, defer?: any | undefined): Promise<any>;
    delete(query: Object, defer?: any | undefined): Promise<any>;
    selectOne(query: Object, transformFn: Function, defer?: any | undefined): Promise<any>;
    select(query: Object, transformFn: Function, defer?: any | undefined): Promise<any>;
    setUnique(fieldName: string, sparse: boolean): void;
    convertTo(func: Function): Function;
}
