export = ConfigValidator;
/**
 * Construct a validator of YAML files.
 * @constructor
 * @param {string|Object} schema The JSON schema file (as YAML) or object.
 */
declare function ConfigValidator(schema: string | Object): void;
declare class ConfigValidator {
    /**
     * Construct a validator of YAML files.
     * @constructor
     * @param {string|Object} schema The JSON schema file (as YAML) or object.
     */
    constructor(schema: string | Object);
    schema: string | object | undefined;
    validate(inputConfig: string | Object, defaultConfig?: Object | undefined): Object;
    _loadFromFile(filename: any): string | object | undefined;
}
