/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.annotation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Optional;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.TextFieldSearchHandler;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.annotation.EntityCreationMetadataPreferences;
import org.protege.editor.owl.model.annotation.EntityCreationMetadataPreferencesManager;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.model.user.OrcidPreferencesManager;
import org.protege.editor.owl.model.user.UserPreferences;
import org.protege.editor.owl.model.util.DateFormatter;
import org.protege.editor.owl.model.util.ISO8601Formatter;
import org.protege.editor.owl.model.util.TimestampFormatter;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLAutoCompleter;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCreationMetadataPreferencesPanel
extends OWLPreferencesPanel {
    private static final Logger logger = LoggerFactory.getLogger(EntityCreationMetadataPreferences.class);
    private final JCheckBox createdByAnnotationEnabled = new JCheckBox("Annotate new entities with creator (user)");
    private final AugmentedJTextField createdByPropertyIriField = new AugmentedJTextField(40, "Enter annotation property name");
    private final JCheckBox creationDateAnnotationEnabled = new JCheckBox("Annotate new entities with creation date/time");
    private final AugmentedJTextField creationDatePropertyIriField = new AugmentedJTextField(40, "Enter annotation property name");
    private final JRadioButton iso8601Radio = new JRadioButton("ISO-8601");
    private final JRadioButton timestampRadio = new JRadioButton("Timestamp");
    private final JRadioButton useUserName = new JRadioButton("Use user name");
    private final JRadioButton useOrcid = new JRadioButton("Use ORCID");

    public void initialise() {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        String helpText = "<html><body>Use Ctrl+Space to auto-complete name if property exists, or enter complete IRI.<br>Well known prefix names can also be used e.g. dc:creator</body></html>";
        panel.addGroupComponent((JComponent)this.createdByAnnotationEnabled);
        panel.addVerticalPadding();
        panel.addGroup("Creator property");
        panel.addGroupComponent((JComponent)this.createdByPropertyIriField);
        TextFieldSearchHandler annotationPropertySearchHandler = textField -> {
            OWLAnnotationProperty prop = new UIHelper(this.getOWLEditorKit()).pickAnnotationProperty();
            if (prop == null) {
                return Optional.empty();
            }
            return Optional.of(this.getOWLModelManager().getRendering((OWLObject)prop));
        };
        this.createdByPropertyIriField.setSearchHandler(annotationPropertySearchHandler);
        panel.addHelpText(helpText);
        panel.addVerticalPadding();
        panel.addGroup("Creator value");
        panel.addGroupComponent((JComponent)this.useUserName);
        panel.addGroupComponent((JComponent)this.useOrcid);
        panel.closeCurrentButtonRun();
        panel.addSeparator();
        panel.addGroupComponent((JComponent)this.creationDateAnnotationEnabled);
        panel.addVerticalPadding();
        panel.addGroup("Date property");
        panel.addGroupComponent((JComponent)this.creationDatePropertyIriField);
        this.creationDatePropertyIriField.setSearchHandler(annotationPropertySearchHandler);
        panel.addHelpText(helpText);
        panel.addVerticalPadding();
        panel.addGroup("Date value format");
        panel.addGroupComponent((JComponent)this.iso8601Radio);
        panel.addGroupComponent((JComponent)this.timestampRadio);
        panel.closeCurrentButtonRun();
        OWLEditorKit editorKit = this.getOWLEditorKit();
        OWLModelManager modelManager = this.getOWLModelManager();
        new OWLAutoCompleter(editorKit, (JTextComponent)this.createdByPropertyIriField, EntityCreationMetadataPreferencesPanel.createExpressionChecker(modelManager));
        new OWLAutoCompleter(editorKit, (JTextComponent)this.creationDatePropertyIriField, EntityCreationMetadataPreferencesPanel.createExpressionChecker(modelManager));
        Preferences prefs = EntityCreationMetadataPreferences.get();
        EntityCreationMetadataPreferencesManager prefsManager = new EntityCreationMetadataPreferencesManager(prefs);
        this.createdByAnnotationEnabled.setSelected(prefsManager.isCreatedByAnnotationEnabled());
        this.createdByPropertyIriField.setText(this.renderIRI(prefsManager.getCreatedByAnnotationPropertyIRI()));
        this.creationDateAnnotationEnabled.setSelected(prefsManager.isCreationDateAnnotationEnabled());
        this.creationDatePropertyIriField.setText(this.renderIRI(prefsManager.getCreationDateAnnotationPropertyIRI()));
        DateFormatter dateFormatter = prefsManager.getDateFormatter();
        if (dateFormatter instanceof ISO8601Formatter) {
            this.iso8601Radio.setSelected(true);
        } else if (dateFormatter instanceof TimestampFormatter) {
            this.timestampRadio.setSelected(true);
        } else {
            this.iso8601Radio.setSelected(true);
        }
        this.useUserName.setSelected(!prefsManager.isCreatedByValueOrcid());
        this.useOrcid.setSelected(prefsManager.isCreatedByValueOrcid());
        this.updateOrcidRadioButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                EntityCreationMetadataPreferencesPanel.this.updateOrcidRadioButton();
            }
        });
    }

    private String renderIRI(IRI iri) {
        return iri.toString();
    }

    private void updateOrcidRadioButton() {
        Preferences orcidPreferences = UserPreferences.get();
        OrcidPreferencesManager orcidPreferencesManager = new OrcidPreferencesManager(orcidPreferences);
        boolean orcidPresent = orcidPreferencesManager.getOrcid().isPresent();
        this.useOrcid.setEnabled(orcidPresent);
    }

    public void applyChanges() {
        Optional<IRI> iri;
        Preferences prefs = EntityCreationMetadataPreferences.get();
        EntityCreationMetadataPreferencesManager prefsManager = new EntityCreationMetadataPreferencesManager(prefs);
        try {
            prefsManager.setCreatedByAnnotationEnabled(this.createdByAnnotationEnabled.isSelected());
            iri = this.parseIri(this.createdByPropertyIriField.getText().trim());
            if (iri.isPresent()) {
                prefsManager.setCreatedByAnnotationPropertyIRI(iri.get());
            }
        }
        catch (URISyntaxException e) {
            logger.warn("Invalid IRI specified for creator annotation property: {}", (Object)e.getMessage());
        }
        try {
            prefsManager.setCreationDateAnnotationEnabled(this.creationDateAnnotationEnabled.isSelected());
            iri = this.parseIri(this.creationDatePropertyIriField.getText().trim());
            if (iri.isPresent()) {
                prefsManager.setCreationDateAnnotationPropertyIRI(iri.get());
            } else {
                prefsManager.setCreationDateAnnotationPropertyIRI(DublinCoreVocabulary.DATE.getIRI());
            }
        }
        catch (URISyntaxException e) {
            logger.warn("Invalid IRI specified for creation date annotation property: {}", (Object)e.getMessage());
        }
        if (this.iso8601Radio.isSelected()) {
            prefsManager.setDateFormatter(new ISO8601Formatter());
        } else if (this.timestampRadio.isSelected()) {
            prefsManager.setDateFormatter(new TimestampFormatter());
        }
        prefsManager.setCreatedByValueOrcid(this.useOrcid.isSelected());
    }

    private Optional<IRI> parseIri(String text) throws URISyntaxException {
        String trimmedText = text.trim();
        if (trimmedText.isEmpty()) {
            return Optional.empty();
        }
        OWLAnnotationProperty property = this.getOWLModelManager().getOWLEntityFinder().getOWLAnnotationProperty(trimmedText);
        if (property != null) {
            return Optional.of(property.getIRI());
        }
        if (text.startsWith("<") && text.endsWith(">")) {
            return Optional.of(IRI.create((URI)new URI(trimmedText.substring(1, trimmedText.length() - 1))));
        }
        try {
            URI uri = new URI(trimmedText);
            if (uri.isAbsolute()) {
                return Optional.of(IRI.create((URI)uri));
            }
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
        for (Namespaces ns : Namespaces.values()) {
            if (!trimmedText.startsWith(ns.name().toLowerCase() + ":")) continue;
            return Optional.of(IRI.create((String)(ns.toString() + text.substring(ns.name().length() + 1))));
        }
        return Optional.of(IRI.create((URI)new URI(trimmedText)));
    }

    public void dispose() throws Exception {
    }

    private static OWLExpressionChecker createExpressionChecker(final OWLModelManager modelManager) {
        return new OWLExpressionChecker(){

            @Override
            public void check(String text) throws OWLExpressionParserException {
                if (EntityCreationMetadataPreferencesPanel.getOwlAnnotationProperty(text, modelManager) == null) {
                    throw new OWLExpressionParserException(text, 0, text.length(), false, false, false, false, false, true, Collections.emptySet());
                }
            }

            public Object createObject(String text) throws OWLExpressionParserException {
                return EntityCreationMetadataPreferencesPanel.getOwlAnnotationProperty(text, modelManager);
            }
        };
    }

    private static OWLAnnotationProperty getOwlAnnotationProperty(String text, OWLModelManager modelManager) {
        for (DublinCoreVocabulary dc : DublinCoreVocabulary.values()) {
            if (!dc.getPrefixedName().equals(text) && !text.equals(dc.getIRI().toString())) continue;
            return modelManager.getOWLDataFactory().getOWLAnnotationProperty(dc.getIRI());
        }
        return modelManager.getOWLEntityFinder().getOWLAnnotationProperty(text);
    }
}

