from .. import Provider as LoremProvider


class Provider(LoremProvider):
    """th_TH word list is drawn from the Thailand's Ministry of Education
    which can be found here: http://www.arts.chula.ac.th/~ling/TTC/id-4.html.
    """

    word_list = (
        'คน',
        'ผม',
        'ขัน',
        'มัน',
        'เขา',
        'เที่ยว',
        'พาย',
        'ตา',
        'ขา',
        'แปรง',
        'ฟัน',
        'ปู',
        'ฝรั่ง',
        'หนู',
        'ฉัน',
        'มี',
        'ไม่',
        'ก็',
        'ไป',
        'กิน',
        'แม่',
        'บ้าน',
        'หมอ',
        'ใส่',
        'ขาย',
        'ข้าว',
        'พ่อ',
        'เล่น',
        'ให้',
        'ชอบ',
        'มา',
        'ล้าง',
        'พี่',
        'ซื้อ',
        'รู้',
        'อยู่',
        'ได้',
        'หนังสือ',
        'น้ำ',
        'นอน',
        'รถ',
        'เห็น',
        'น้อง',
        'มือ',
        'ขนม',
        'ช้อน',
        'เลี้ยง',
        'จาน',
        'ดู',
        'เสื้อ',
        'ไข่',
        'ลูก',
        'ถ้วย',
        'ไก่',
        'ตำรวจ',
        'จับ',
        'โรงเรียน',
        'ปลูก',
        'ผัก',
        'รู้จัก',
        'เดิน',
        'ชาม',
        'รัก',
        'มะม่วง',
        'หมู',
        'กระต่าย',
        'พระ',
        'ปาก',
        'เรือ',
        'หม้อ',
        'ตัว',
        'กล้วย',
        'หมอน',
        'ดิน',
        'เก็บ',
        'ปลา',
        'หมา',
        'ตลาด',
        'หา',
        'ผ้าห่ม',
        'น้ำปลา',
        'ขี่',
        'แขน',
        'อาบน้ำ',
        'แตงโม',
        'แกง',
        'ดอกไม้',
        'มะพร้าว',
        'ส้ม',
        'ฟัง',
        'เงาะ',
        'เรา',
        'มีด',
        'หัว',
        'ยาย',
        'มะละกอ',
        'น้า',
        'โทรทัศน์',
        'ชุด',
        'นก',
        'แมว',
        'เพื่อน',
        'น้ำตาล',
        'จมูก',
        'ผ้า',
        'ถู',
        'ครู',
        'นม',
        'ผักบุ้ง',
        'ตู้',
        'พระเจ้าอยู่หัว',
        'ตี',
        'สอน',
        'ย่า',
        'ห้อง',
        'วิ่ง',
        'ไหว้',
        'โรงพยาบาล',
        'ทหาร',
        'ลิง',
        'เด็ก',
        'ชมพู่',
        'หน้า',
        'โต๊ะ',
        'ช้าง',
        'พา',
        'ยา',
        'นักเรียน',
        'ของเล่น',
        'แม่ค้า',
        'ลำไย',
        'เป็ด',
        'ส้มโอ',
        'ตีน',
        'ตุ๊กตา',
        'เตียง',
        'หลัง',
        'กัด',
        'เสื้อกันหนาว',
        'ขนมปัง',
        'เตา',
        'มุ้ง',
        'พระราชินี',
        'นั่ง',
        'เต่า',
        'ผักกาด',
        'การ์ตูน',
        'เท้า',
        'ร้อน',
        'วัว',
        'อา',
        'พริก',
        'หู',
        'ผู้หญิง',
        'ป้า',
        'ผู้ชาย',
        'ดอกเข็ม',
        'รูป',
        'ป่า',
        'มะเขือ',
        'กางเกง',
        'ในหลวง',
        'เสื้อผ้า',
        'เขียน',
        'งู',
        'ลุง',
        'เสือ',
        'ตู้เย็น',
        'ละมุด',
        'กุหลาบ',
        'หญ้า',
        'หยิบ',
        'ตัด',
        'ที่นอน',
        'จระเข้',
        'เจอ',
        'ปู่',
        'ก๋วยเตี๋ยว',
        'รถไฟ',
        'ครัว',
        'ควาย',
        'นา',
        'ขนุน',
        'นกแก้ว',
        'สวนสัตว์',
        'หมี',
        'ฝน',
        'ต้ม',
        'คะน้า',
        'ข้าวสาร',
        'สะดือ',
        'ร่ม',
        'คิ้ว',
        'ดื่ม',
        'ยิง',
        'สมุด',
        'น้อยหน่า',
        'ม้า',
        'หัวเข่า',
        'สิงโต',
        'กวาง',
        'ร้องไห้',
        'วัด',
        'มะขาม',
        'หมาป่า',
        'ลางสาด',
        'ชาวนา',
        'ประตู',
        'นั่น',
        'ถนน',
        'วิทยุ',
        'อ่าน',
        'ทัพพี',
        'องุ่น',
        'มะยม',
        'หมวก',
        'กระเป๋า',
        'กะหล่ำปลี',
        'นิ้ว',
        'กวาด',
        'ถุง',
        'ไล่',
        'ติด',
        'เปิด',
        'มัด',
        'ผักชี',
        'บิน',
        'มะลิ',
        'รถยนต์',
        'กระป๋อง',
        'ฉีดยา',
        'ถั่ว',
        'คอ',
        'ตะหลิว',
        'ปลาทู',
        'ตับ',
        'กระโดด',
        'ตก',
        'กราบ',
        'กุ้ง',
        'หก',
        'ทาน',
        'ดัง',
        'ดำ',
        'หอม',
        'คด',
        'ยาง',
        'จอก',
        'กบ',
        'กระจก',
        'กระจุย',
        'กระดิ่ง',
        'กระดุม',
        'กระถิน',
        'กระเทียม',
        'กระเบื้อง',
        'กระโปรง',
        'กระรอก',
        'กลัว',
        'กว่า',
        'กอด',
        'ก่อน',
        'กะ',
        'กะทิ',
        'กะละมัง',
        'กัน',
        'กับ',
        'กา',
        'กาง',
        'กาแฟ',
        'กาย',
        'ก้าว',
        'กำเนิด',
        'กำลัง',
        'กี่',
        'กู',
        'เก๊',
        'เก่ง',
        'เกม',
        'เกเร',
        'เกลือ',
        'เก้าอี้',
        'เกาะ',
        'เกิด',
        'เกี่ยว',
        'แก',
        'แก่',
        'แก้ว',
        'แกะ',
        'ใกล้',
        'ไกล',
        'ขน',
        'ขยะ',
        'ขวา',
        'ขอ',
        'ของ',
        'ขัง',
        'ขวด',
        'ขับ',
        'ข่า',
        'ข้า',
        'ข้าง',
        'ขาด',
        'ข้าม',
        'ขาว',
        'ข่าว',
        'ขี้',
        'ขีด',
        'ขึ้น',
        'ขุด',
        'เข็ม',
        'เข่า',
        'เข้า',
        'เขียง',
        'เขี้ยว',
        'แข็ง',
        'แข่ง',
        'ไข้',
        'ค้น',
        'คบ',
        'คว่ำ',
        'คอย',
        'ค่อย',
        'ค่ะ',
        'คัด',
        'คั่ว',
        'ค้า',
        'คาง',
        'คำ',
        'ค่ำ',
        'คำนับ',
        'คิด',
        'คืน',
        'คือ',
        'คุก',
        'คุย',
        'คู',
        'คู่',
        'เค็ม',
        'เคย',
        'เคียว',
        'แค่',
        'ใคร',
        'ฆ่า',
        'งาน',
        'งาม',
        'ง่าย',
        'เงิน',
        'เงือก',
        'จน',
        'จบ',
        'จม',
        'จอด',
        'จอบ',
        'จะ',
        'จังหวัด',
        'จัด',
        'จาก',
        'จ้าง',
        'จำ',
        'จำปี',
        'จิ้งจอก',
        'จิงโจ้',
        'จึง',
        'จืด',
        'เจ็บ',
        'เจ้า',
        'เจาะ',
        'แจก',
        'แจกัน',
        'ใจ',
        'ใจดี',
        'ฉีด',
        'ชก',
        'ชน',
        'ชนะ',
        'ชวน',
        'ช่วย',
        'ชะอม',
        'ชั่ง',
        'ชิ้น',
        'ชั่ว',
        'ช่าง',
        'ชาย',
        'ชาว',
        'ชิงช้า',
        'ชื่อ',
        'เช็ด',
        'เช้า',
        'เชิด',
        'เชื่อ',
        'เชือก',
        'ใช่',
        'ใช้',
        'ซน',
        'ซ่อน',
        'ซ้อน',
        'ซ่อม',
        'ซอย',
        'ซัก',
        'ซ้าย',
        'ซิ',
        'ดม',
        'ด้วย',
        'ดอก',
        'ด่า',
        'ดาว',
        'ดินสอ',
        'ดี',
        'ดึง',
        'ดื้อ',
        'ดุ',
        'เดียว',
        'เดี่ยว',
        'เดี๋ยว',
        'แดง',
        'แดด',
        'โดด',
        'โดน',
        'โดย',
        'ตน',
        'ต้น',
        'ต่อ',
        'ตอก',
        'ต้อง',
        'ตอน',
        'ตอบ',
        'ต่อย',
        'ตะกร้า',
        'ตะไคร้',
        'ตะปู',
        'ตะวัน',
        'ตัก',
        'ตั้ง',
        'ตาก',
        'ต่าง',
        'ตาม',
        'ตาย',
        'ตำ',
        'ตึก',
        'ตื่น',
        'ตุ่ม',
        'เต้น',
        'เต็ม',
        'เตะ',
        'เติม',
        'แต่',
        'แตงกวา',
        'แต่ง',
        'โต',
        'ใต้',
        'ใต้ถุน',
        'ถม',
        'ถอด',
        'ถอน',
        'ถอย',
        'ถัง',
        'ถ้า',
        'ถาง',
        'ถาด',
        'ถ่าน',
        'ถาม',
        'ถีบ',
        'ถึง',
        'ถือ',
        'ถูก',
        'แถว',
        'ไถ',
        'ท่วม',
        'ท่อ',
        'ทอง',
        'ท้อง',
        'ทอด',
        'ทะนาน',
        'ทะเล',
        'ทะเลาะ',
        'ทั้ง',
        'ทัน',
        'ทับ',
        'ทา',
        'ทาง',
        'ท่าน',
        'ทำ',
        'ทำไม',
        'ทำเล',
        'ทิ้ง',
        'ที',
        'ที่',
        'ทีวี',
        'ทุก',
        'ทุเรียน',
        'เท',
        'เท่า',
        'เที่ยง',
        'เทียน',
        'แทน',
        'ไทย',
        'เธอ',
        'นอก',
        'น้อย',
        'นัก',
        'นั้น',
        'นับ',
        'น่า',
        'นาง',
        'นาน',
        'นาย',
        'นาฬิกา',
        'นำ',
        'นิด',
        'นิทาน',
        'นิ่ม',
        'นิยาย',
        'นิสัย',
        'นี่',
        'นี้',
        'นึก',
        'นึ่ง',
        'นุ่ง',
        'เนื้อ',
        'แน่',
        'โน้น',
        'ใน',
        'บน',
        'บวก',
        'บ้วน',
        'บ่อ',
        'บอก',
        'บอด',
        'บอน',
        'บ่อน',
        'บ่อย',
        'บัง',
        'บันได',
        'บาง',
        'บ้าง',
        'บ่าย',
        'บุก',
        'บุ้ง',
        'บูชา',
        'แบบ',
        'ใบ',
        'ปวด',
        'ป่วย',
        'ปอ',
        'ปอก',
        'ปั้น',
        'ปิ้ง',
        'ปิด',
        'ปี',
        'ปีน',
        'ปืน',
        'ปุ๋ย',
        'ปูน',
        'เป็น',
        'เปล่า',
        'เป้า',
        'เปียก',
        'แป้ง',
        'แปล',
        'ผัด',
        'ผ่าน',
        'ผิด',
        'ผี',
        'ผู้',
        'ผูก',
        'เผา',
        'เผื่อ',
        'ฝัง',
        'ฝา',
        'ฝ่าย',
        'เฝ้า',
        'พบ',
        'พละ',
        'พวก',
        'พอ',
        'พะโล้',
        'พัก',
        'พัด',
        'พับ',
        'พื้น',
        'พุง',
        'พูด',
        'เพราะ',
        'เพาะ',
        'เพื่อ',
        'แพ้',
        'แพะ',
        'ฟ้า',
        'ฟืน',
        'ฟื้น',
        'ฟุ้ง',
        'ฟูก',
        'ไฟ',
        'มอง',
        'มะกอก',
        'มะนาว',
        'มะไฟ',
        'มังคุด',
        'มาก',
        'มึง',
        'มืด',
        'มื้อ',
        'มุง',
        'มุ่ง',
        'เม็ด',
        'เมีย',
        'เมื่อ',
        'เมือง',
        'แมง',
        'แม้น',
        'โมง',
        'ไม้',
        'ยก',
        'ยอด',
        'ย่อม',
        'ยัก',
        'ยัง',
        'ยาก',
        'ย่าง',
        'ยาม',
        'ย้าย',
        'ยาว',
        'ยิ้ม',
        'ยืน',
        'ยุง',
        'ยุ่ง',
        'เย็น',
        'เย็บ',
        'เยอะ',
        'แย่ง',
        'โยน',
        'รด',
        'รวม',
        'รอ',
        'รอง',
        'ร้อง',
        'รอบ',
        'ระวัง',
        'รักษา',
        'รัด',
        'รับ',
        'ราคา',
        'ราชินี',
        'ราด',
        'ร้าน',
        'ร้าย',
        'รำ',
        'รีด',
        'รีบ',
        'เร็ว',
        'เรียก',
        'เรียง',
        'เรียน',
        'เรื่อง',
        'เรือน',
        'เรื่อย',
        'แรก',
        'โรย',
        'ไร่',
        'ลง',
        'ลด',
        'ลบ',
        'ลม',
        'ล้ม',
        'ลอง',
        'ลัก',
        'ลับ',
        'ลา',
        'ลาก',
        'ลาง',
        'ลาบ',
        'ลาย',
        'ลิเก',
        'ลื่น',
        'ลืม',
        'ลุก',
        'เล็ก',
        'เลข',
        'เล็บ',
        'เล่ม',
        'เลย',
        'เละ',
        'เล่า',
        'เล้า',
        'เลี้ยว',
        'เลือด',
        'เลื่อย',
        'แล',
        'แล้ง',
        'แล้ว',
        'และ',
        'วัน',
        'ว่า',
        'วาง',
        'ว่าง',
        'วาด',
        'ว่าน',
        'วิชา',
        'วิตามิน',
        'วิธี',
        'เวลา',
        'เวียน',
        'ไว้',
        'ศาลา',
        'ส่ง',
        'สบู่',
        'สวด',
        'สวน',
        'สวม',
        'สวย',
        'สอบ',
        'ส้อม',
        'สะพาน',
        'สะอาด',
        'สั่ง',
        'สังกะสี',
        'สั้น',
        'สับ',
        'สับปะรด',
        'สาด',
        'สาย',
        'สาว',
        'สี',
        'สุก',
        'สุข',
        'สู้',
        'เส้น',
        'เสา',
        'เสียง',
        'เสียบ',
        'เสื่อ',
        'หนา',
        'หนี',
        'ห่ม',
        'หมู่',
        'หรือ',
        'หวี',
        'ห่อ',
        'หอย',
        'หัก',
        'หั่น',
        'หัวเราะ',
        'ห่า',
        'หาง',
        'หาม',
        'หาย',
        'หิน',
        'หิว',
        'หุง',
        'หุ่น',
        'เห',
        'เหนือ',
        'เหล้า',
        'เหลือ',
        'เห่า',
        'แห่ง',
        'แหน',
        'ใหญ่',
        'ใหม่',
        'ไหน',
        'ไหม',
        'ไหล่',
        'อย่า',
        'ออก',
        'อ่อน',
        'อะไร',
        'อัน',
        'อาบ',
        'อาละวาด',
        'อำเภอ',
        'อิ่ม',
        'อีก',
        'อื่น',
        'อุ่น',
        'เอง',
        'เอา',
        'แอบ',
        'โอ๋',
        'โอ่ง',
        'โอน',
        'ไอ',
        'ก๋ง',
        'กด',
        'ก้ม',
        'กระดูก',
        'กระติก',
        'กระตุก',
        'กระถาง',
        'กระทบ',
        'กระท้อน',
        'กระทะ',
        'กระสอบ',
        'กล้า',
        'กอ',
        'ก่อ',
        'กอง',
        'ก้อน',
        'กะปิ',
        'กะเพรา',
        'กะลา',
        'ก้าง',
        'กำ',
        'กำแพง',
        'กิ่ง',
        'กิริยา',
        'กู้',
        'เก',
        'เก๋ง',
        'เก่า',
        'เกิน',
        'เกื้อ',
        'เกือบ',
        'แก้',
        'แก้ม',
        'โกน',
        'โกหก',
        'ไกว',
        'ขณะ',
        'ขม',
        'ขย้ำ',
        'ขยี้',
        'ข้อ',
        'ข้อง',
        'ขอน',
        'ขัด',
        'ขาน',
        'ขำ',
        'ขิง',
        'เข่ง',
        'เข็น',
        'เขี่ย',
        'เขียว',
        'เขื่อน',
        'แขก',
        'คง',
        'ครู่',
        'ค้อน',
        'คัน',
        'คับ',
        'ค่า',
        'ค้าง',
        'คางคก',
        'คาด',
        'คาบ',
        'คุ้ม',
        'เค้ก',
        'เคาะ',
        'เคี้ยว',
        'แคะ',
        'โค้ง',
        'งม',
        'งวง',
        'ง่วง',
        'งอก',
        'งา',
        'เงา',
        'โง่',
        'จด',
        'จริยะ',
        'จ๊ะ',
        'จัง',
        'จ๋า',
        'จ่าย',
        'จำปา',
        'จิก',
        'จิ้ม',
        'จีน',
        'จุด',
        'จูง',
        'เจอะ',
        'แจ้ง',
        'เฉย',
        'ชม',
        'ชวด',
        'ชะนี',
        'ชัก',
        'ชา',
        'ช้า',
        'ชี้',
        'ชุก',
        'ชุ่ม',
        'เช่น',
        'แช่',
        'ซด',
        'ซัด',
        'ซิ่ง',
        'ซึ่ง',
        'ซื่อ',
        'ซุก',
        'แซง',
        'แซะ',
        'ดง',
        'ดัก',
        'ดับ',
        'ด้าน',
        'ดาบ',
        'ดาย',
        'ด้าย',
        'ดีด',
        'ดึก',
        'ดูด',
        'เด็ด',
        'เดิม',
        'เดือด',
        'เดือน',
        'ใด',
        'ตบ',
        'ตอม',
        'ตะเกียบ',
        'ตะโกน',
        'ตู่',
        'ตูด',
        'เตียน',
        'แตก',
        'แตง',
        'แตะ',
        'โต้',
        'ถาก',
        'ถ่าย',
        'ถ้ำ',
        'เถียง',
        'ทบ',
        'ท่อง',
        'ทอน',
        'ทัก',
        'ท่า',
        'ท้า',
        'ทาก',
        'ทาย',
        'ท้าย',
        'ทีม',
        'ทุ่ง',
        'ทุย',
        'เทียม',
        'แทง',
        'แท่ง',
        'แท้ง',
        'ธง',
        'นัด',
        'นาที',
        'นิ่ง',
        'เน่า',
        'แนว',
        'บ่น',
        'บัว',
        'บ่า',
        'บาด',
        'บาน',
        'บำรุง',
        'บิดา',
        'บีบ',
        'บึง',
        'เบา',
        'เบาะ',
        'เบื่อ',
        'แบก',
        'แบ่ง',
        'เบ่ง',
        'ใบไม้',
        'ป่น',
        'ประถม',
        'ประจำ',
        'ประชุม',
        'ประดับ',
        'ประธาน',
        'ปะ',
        'ปัก',
        'ปัง',
        'ปัด',
        'ปัน',
        'ปั่น',
        'ปา',
        'ปาด',
        'ปี่',
        'ปีก',
        'เปรอะ',
        'เป่า',
        'ผง',
        'ผัว',
        'ผ่า',
        'ผาง',
        'ผึ่ง',
        'ผึ้ง',
        'ผืน',
        'ผุ',
        'เผ็ด',
        'แผ่',
        'แผ่น',
        'โผล่',
        'ไผ่',
        'ฝั่ง',
        'ฝัน',
        'ฝาก',
        'ฝ้าย',
        'ฝุ่น',
        'ฝูง',
        'พ่น',
        'พร้า',
        'พอง',
        'พัง',
        'พาด',
        'พาน',
        'เพลีย',
        'เพียง',
        'แพ',
        'แพง',
        'ไพ่',
        'ไพเราะ',
        'ฟอก',
        'ฟอง',
        'ฟัก',
        'ฟาก',
        'ฟาง',
        'แฟง',
        'แฟ้ม',
        'ภัย',
        'ภาษา',
        'มด',
        'ม่วง',
        'มอบ',
        'มะดัน',
        'มะเฟือง',
        'มูมมาม',
        'เมา',
        'เมื่อย',
        'แม้',
        'โมโห',
        'ย่อ',
        'ยอม',
        'ยัด',
        'ยำ',
        'ยิ่ง',
        'ยิน',
        'ยืม',
        'ยุ',
        'เยาะ',
        'แย่',
        'แยก',
        'แยะ',
        'ใย',
        'รก',
        'รบ',
        'ร่วม',
        'รวย',
        'ระฆัง',
        'ระเบียง',
        'ระเบียบ',
        'ระมัดระวัง',
        'รัง',
        'ราก',
        'ริม',
        'รู',
        'เริ่ม',
        'เรียบ',
        'แรง',
        'โรง',
        'ไร',
        'ล้อ',
        'ลอด',
        'ลอย',
        'ละ',
        'ละเอียด',
        'ล่า',
        'ล่าง',
        'ลาด',
        'ลาน',
        'ล้าน',
        'ลิ้นจี่',
        'เลิก',
        'เลีย',
        'เลียบ',
        'เลือก',
        'แลก',
        'แล่น',
        'วง',
        'ว่าว',
        'ไว',
        'ศอก',
        'สด',
        'สถานี',
        'สม',
        'สระ',
        'ส่วน',
        'ส้วม',
        'ส่อง',
        'สอด',
        'สะดวก',
        'สัก',
        'สาก',
        'สาธุ',
        'สาลี่',
        'สำรับ',
        'สิ่ง',
        'สิ้น',
        'สุด',
        'สู่',
        'สูง',
        'สูบ',
        'เสีย',
        'เสียม',
        'ไส',
        'ไส้',
        'หัด',
        'หัน',
        'หาก',
        'ห่าง',
        'หาด',
        'ห่าน',
        'ห้าม',
        'หิด',
        'หิ้ว',
        'เหงา',
        'เหงื่อ',
        'เหลา',
        'เหา',
        'เหี่ยว',
        'แห่',
        'แห้ง',
        'แหย่',
        'แหละ',
        'โหน',
        'ไห',
        'ไหล',
        'ไหว',
        'อก',
        'อด',
        'อบ',
        'อ้วน',
        'ออด',
        'อ้อย',
        'อัด',
        'อายุ',
        'อุ้ม',
        'เอว',
        'เอี่ยม',
        'ไอ้',
        'กระดานดำ',
        'กระโดดยาง',
        'กระติกน้ำ',
        'กระปุกออมสิน',
        'กอไผ่',
        'ก้อนหิน',
        'กับข้าว',
        'กางเกงขายาว',
        'กางเกงขาสั้น',
        'กางเกงใน',
        'กาชาด',
        'กายบริหาร',
        'กิ่งไม้',
        'แกงจืด',
        'แกงเผ็ด',
        'แกงส้ม',
        'แก้วน้ำ',
        'ข้อต่อ',
        'ข้อศอก',
        'ของกิน',
        'ของแข็ง',
        'ของใช้',
        'ของมีคม',
        'ขันน้ำ',
        'ข้าวเจ้า',
        'ข้าวต้ม',
        'ข้าวผัด',
        'ข้าวโพด',
        'ข้าวมันไก่',
        'ขี้มูก',
        'ขี้หู',
        'เข็มขัด',
        'เข้าใจ',
        'เข้าแถว',
        'เขียนไทย',
        'แข็งแรง',
        'แข่งขัน',
        'ไขมัน',
        'ไขลาน',
        'ไข่ทอด',
        'ไข้เลือดออก',
        'คนแก่',
        'คนขาย',
        'คนขายของ',
        'คนไข้',
        'คนป่วย',
        'คนร้าย',
        'ครูประจำชั้น',
        'ครูใหญ่',
        'ควบคุม',
        'คัดไทย',
        'ค้าขาย',
        'คิดถึง',
        'ง่วงนอน',
        'งานบ้าน',
        'จงรักภักดี',
        'เจ็บป่วย',
        'เจ็บปวด',
        'เจ้าของ',
        'เจ้าชาย',
        'เจ้าฟ้าชาย',
        'แจ่มใส',
        'ช่วยเหลือ',
        'ชั้นเรียน',
        'ชั่วโมง',
        'ชาวเขา',
        'ชาวใต้',
        'ชาวไทย',
        'ชาวบ้าน',
        'ชุดนักเรียน',
        'เชื่อฟัง',
        'ซ่อนหา',
        'ซักผ้า',
        'ซุกซน',
        'ดวงใจ',
        'ดอกกระดังงา',
        'ดอกจำปา',
        'ดอกจำปี',
        'ดอกชบา',
        'ดอกดาวกระจาย',
        'ดอกดาวเรือง',
        'ดอกทานตะวัน',
        'ดอกเทียน',
        'ดอกบัว',
        'ดอกบานชื่น',
        'ดอกบานไม่รู้โรย',
        'ดอกพุด',
        'ดอกรัก',
        'ดาวเรือง',
        'ดำนา',
        'ดินน้ำมัน',
        'ดีใจ',
        'ดูแล',
        'เด็กชาย',
        'เด็กนักเรียน',
        'เดินแถว',
        'เดินทาง',
        'เดี๋ยวเดียว',
        'เดี๋ยวนี้',
        'เดือดร้อน',
        'ได้ยิน',
        'ตกกล้า',
        'ตกใจ',
        'ตกลง',
        'ต้นกระถิน',
        'ต้นกระท้อน',
        'ต้นก้ามปู',
        'ต้นโกสน',
        'ต้นเข็ม',
        'ต้นงิ้ว',
        'ต้นเงาะ',
        'ต้นชมพู่',
        'ต้นดาวเรือง',
        'ต้นทานตะวัน',
        'ต้นทุเรียน',
        'ต้นไทร',
        'ต้นน้อยหน่า',
        'ต้นไผ่',
        'ต้นโพ',
        'ต้นมะขาม',
        'ต้นมะเขือ',
        'ต้นมะนาว',
        'ต้นมะเฟือง',
        'ต้นมะไฟ',
        'ต้นมะม่วง',
        'ต้นมะยม',
        'ต้นมะละกอ',
        'ต้นมะลิ',
        'ต้นมังคุด',
        'ต้นไม้',
        'ต้นยาง',
        'ต้นละมุด',
        'ต้นลำไย',
        'ต้นลิ้นจี่',
        'ต้นสน',
        'ต้นส้ม',
        'ต้นส้มโอ',
        'ต้นหญ้า',
        'ต้นหอม',
        'ต้นหางนกยูง',
        'ต้นหูกวาง',
        'ต้มยำ',
        'ต่อไป',
        'ต่อมา',
        'ต้องการ',
        'ตอบแทน',
        'ตั้งใจ',
        'ตั้งแต่',
        'ตัดสิน',
        'ตัวต่อ',
        'ตัวเมีย',
        'ตัวเอง',
        'ตาแดง',
        'ตาบอด',
        'ตามใจ',
        'ตื่นนอน',
        'ตู้กับข้าว',
        'ตู้เสื้อผ้า',
        'เตาไฟ',
        'เติบโต',
        'เตารีด',
        'แต่งกาย',
        'แต่งงาน',
        'แต่งตั้ง',
        'แต่งตัว',
        'ถ้วยชาม',
        'ถังขยะ',
        'ถั่วเขียว',
        'ถั่วงอก',
        'ถั่วฝักยาว',
        'ถุงเท้า',
        'ไถนา',
        'ทอดมัน',
        'ทอดผ้าป่า',
        'ทักทาย',
        'ทานตะวัน',
        'ทำงาน',
        'ทำนา',
        'ทำไร่',
        'ทำสวน',
        'ทำลาย',
        'ทีนี้',
        'ที่สุด',
        'ทุ่งนา',
        'เท่านั้น',
        'เท่านี้',
        'เท่าไร',
        'นกกระจาบ',
        'นกกระสา',
        'นกเขา',
        'นกเอี้ยง',
        'นอกนั้น',
        'นับถือ',
        'นัยน์ตา',
        'น่ารัก',
        'น้ำแกง',
        'น้ำเกลือ',
        'น้ำข้าว',
        'น้ำแข็ง',
        'น้ำเงิน',
        'น้ำชา',
        'น้ำตก',
        'น้ำตา',
        'น้ำนม',
        'น้ำผึ้ง',
        'น้ำมัน',
        'น้ำมันหมู',
        'น้ำส้ม',
        'น้ำส้มสายชู',
        'น้ำหวาน',
        'น้ำอ้อย',
        'นิ้วมือ',
        'เนื้อหมู',
        'บ้วนปาก',
        'บ่อน้ำ',
        'บังคับ',
        'บัดนี้',
        'บางที',
        'บาดเจ็บ',
        'บ้านเมือง',
        'บานชื่น',
        'บานไม่รู้โรย',
        'บานเย็น',
        'เบิกบาน',
        'แบบฝึกหัด',
        'แบบเรียน',
        'ประแป้ง',
        'ประชาชน',
        'ประถมศึกษา',
        'ปลากระป๋อง',
        'ปลาเค็ม',
        'ปลาดุก',
        'ปลาร้า',
        'ป้องกัน',
        'ป่าไม้',
        'ปากกา',
        'ปิ่นโต',
        'ปุ๋ยคอก',
        'ผงซักฟอก',
        'ผักกระเฉด',
        'ผักคะน้า',
        'ผักตำลึง',
        'ผ่าตัด',
        'ผ้าขี้ริ้ว',
        'ผ้าเช็ดหน้า',
        'ผ้านวม',
        'ผ้าปูที่นอน',
        'ผีเสื้อ',
        'ผู้คน',
        'ผู้ช่วย',
        'ผู้เฒ่า',
        'ผู้ร้าย',
        'ผู้ให้กำเนิด',
        'ผู้ใหญ่',
        'ฝักบัว',
        'ฝาชี',
        'ฝึกหัด',
        'ฝุ่นละออง',
        'พระเจ้า',
        'พระเจ้าแผ่นดิน',
        'พระที่นั่ง',
        'พระนางเจ้า',
        'พระราชา',
        'พระเอก',
        'พวงมาลัย',
        'พอดี',
        'พ่อค้า',
        'พักผ่อน',
        'พัดลม',
        'พับเพียบ',
        'พายเรือ',
        'พายุ',
        'พี่ชาย',
        'พี่สาว',
        'พูดจา',
        'เพราะว่า',
        'ฟักทอง',
        'เฟื่องฟ้า',
        'ไฟฟ้า',
        'ภูเขา',
        'ม้านั่ง',
        'มากมาย',
        'มีดโกน',
        'เมื่อวาน',
        'แม่น้ำ',
        'แม่มด',
        'แม่เลี้ยง',
        'แมงมุม',
        'ไม้ขีด',
        'ยวดยาน',
        'ยาสระผม',
        'ยาสีฟัน',
        'ยากจน',
        'ยางลบ',
        'ยินดี',
        'เยอะแยะ',
        'รดน้ำ',
        'ร่มเงา',
        'ร่มเย็น',
        'รองเท้า',
        'รังแก',
        'รับจ้าง',
        'รับประทาน',
        'ร่างกาย',
        'ร้านค้า',
        'รายงาน',
        'ร้ายแรง',
        'รำวง',
        'รีดผ้า',
        'รู้สึก',
        'เรียบร้อย',
        'ลอยกระทง',
        'ลำบาก',
        'ลูกแก้ว',
        'ลูกเขย',
        'ลูกชิ้น',
        'ลูกตา',
        'ลูกโป่ง',
        'ลูกสาว',
        'ลูกเสือ',
        'ลูกหิน',
        'เล็กน้อย',
        'เล็บเท้า',
        'เลี้ยงดู',
        'แล้วก็',
        'วันพระ',
        'วาดเขียน',
        'ว่ายน้ำ',
        'วาววับ',
        'วิ่งเล่น',
        'เวียนเทียน',
        'สดชื่น',
        'สดใส',
        'สนใจ',
        'ส้มตำ',
        'สวนครัว',
        'สวยงาม',
        'สั่งสอน',
        'สิ่งของ',
        'สินค้า',
        'สีกากี',
        'สีขาว',
        'สีเขียว',
        'สีดำ',
        'สีแดง',
        'สีน้ำเงิน',
        'เส้นชัย',
        'เสาธง',
        'เสียใจ',
        'เสื้อแขนยาว',
        'เสื้อแขนสั้น',
        'เสื้อนักเรียน',
        'แสงแดด',
        'หกล้ม',
        'หน่อไม้',
        'หน้ากาก',
        'หน้าต่าง',
        'หน้าที่',
        'หน้าร้อน',
        'ห่มผ้า',
        'หมอลำ',
        'หม้อข้าว',
        'หม้อหุงข้าว',
        'หมาจิ้งจอก',
        'หมูยอ',
        'หมู่บ้าน',
        'ห่วงใย',
        'ห่อข้าว',
        'ห้องครัว',
        'ห้องนอน',
        'ห้องน้ำ',
        'ห้องเรียน',
        'หอยโข่ง',
        'หัวใจ',
        'หัวหน้า',
        'หากิน',
        'หายใจ',
        'หุงข้าว',
        'อบรม',
        'อบอุ่น',
        'ออกไข่',
        'อ่อนเพลีย',
        'ออมสิน',
        'อาจจะ',
        'อึ่งอ่าง',
        'กรง',
        'กรรไกร',
        'กรรม',
        'กรอก',
        'กรอบ',
        'กระดาษ',
        'กรีด',
        'กลบ',
        'กลม',
        'กลอง',
        'กล่อง',
        'กลับ',
        'กลาง',
        'กล้าม',
        'กลาย',
        'กล่าว',
        'กลิ้ง',
        'กลิ่น',
        'กลืน',
        'กลุ่ม',
        'กวยจั๊บ',
        'กว้าง',
        'กัญชา',
        'การ',
        'กาล',
        'กิจ',
        'กุญแจ',
        'เกลียด',
        'เกษตร',
        'แกล้ง',
        'แกว่ง',
        'แก๊ส',
        'โกรธ',
        'ขนาด',
        'ขโมย',
        'ขยัน',
        'ขวาง',
        'ขว้าง',
        'ขวาน',
        'ข้าพเจ้า',
        'เขต',
        'เขย่ง',
        'เขยิบ',
        'เขยื้อน',
        'แขวน',
        'ครก',
        'ครบ',
        'ครอบ',
        'ครั้ง',
        'ครับ',
        'คราว',
        'คริสต์',
        'ครึ่ง',
        'คลอง',
        'คลาน',
        'คล้าย',
        'คลื่น',
        'คลุก',
        'คลุม',
        'ควร',
        'ควัน',
        'ความ',
        'คุณ',
        'คูณ',
        'เครื่อง',
        'เคารพ',
        'จรวด',
        'จริง',
        'จักร',
        'จันทร์',
        'จิ้งหรีด',
        'เจดีย์',
        'เจริญ',
        'โจทย์',
        'โจร',
        'ชนิด',
        'ชอล์ก',
        'ชาติ',
        'ชีวิต',
        'เชอร์รี่',
        'เชิญ',
        'ญาติ',
        'เณร',
        'ดนตรี',
        'ตรง',
        'ตรวจ',
        'ตลก',
        'ตลอด',
        'ตะครุบ',
        'ตาล',
        'ตำบล',
        'ตำแหน่ง',
        'ตุ๊กตุ่น',
        'เตรียม',
        'ถลก',
        'ถลอก',
        'ถวาย',
        'ทรง',
        'ทรพี',
        'ทราบ',
        'ทราย',
        'ทอฟฟี่',
        'ทิศ',
        'ทุกข์',
        'เทป',
        'เทวดา',
        'เทศน์',
        'โทษ',
        'ธูป',
        'นาค',
        'บรรทัด',
        'บริเวณ',
        'บริหาร',
        'บวช',
        'บอล',
        'บัตร',
        'บาตร',
        'บาท',
        'บุญ',
        'โบสถ์',
        'ปฏิญาณ',
        'ปฏิบัติ',
        'ประดิษฐ์',
        'ประเทศ',
        'ประมาณ',
        'ประโยค',
        'ประโยชน์',
        'ปราบ',
        'ปริญญา',
        'ปรึกษา',
        'ปรุง',
        'ปล่อย',
        'ปลาย',
        'ปัสสาวะ',
        'เปรี้ยง',
        'เปรียว',
        'เปรี้ยว',
        'เปลี่ยน',
        'เปลือก',
        'แปลก',
        'แปลง',
        'โปรย',
        'ผล',
        'ผลัก',
        'แผล',
        'พยาธิ',
        'พยาบาล',
        'พยายาม',
        'พรรษา',
        'พรวน',
        'พร้อม',
        'พราน',
        'พลัง',
        'พัฒนา',
        'พันธุ์',
        'พิการ',
        'พิษ',
        'พืช',
        'พุทธ',
        'พุทรา',
        'เพล',
        'เพลง',
        'เพลิน',
        'เพียร',
        'แพทย์',
        'ภรรยา',
        'ภาค',
        'ภาพ',
        'มะกรูด',
        'มะขวิด',
        'มะปราง',
        'มัสยิด',
        'มิตร',
        'เมฆ',
        'เมตตา',
        'เมล็ด',
        'แมลง',
        'ยักษ์',
        'ยีราฟ',
        'รส',
        'ราษฎร',
        'โรค',
        'ฤดู',
        'ละหมาด',
        'วิเศษ',
        'เวร',
        'ศพ',
        'ศาสตร์',
        'ศาสนา',
        'ศิลปะ',
        'ศีรษะ',
        'ศึกษา',
        'ศูนย์',
        'เศรษฐี',
        'เศษ',
        'สกปรก',
        'สงบ',
        'สงสาร',
        'สตรอว์เบอรี่',
        'สตางค์',
        'สนาม',
        'สนุก',
        'สบาย',
        'สมเด็จ',
        'สมบัติ',
        'สมบูรณ์',
        'สมมุติ',
        'สมอง',
        'สมาธิ',
        'สร้อย',
        'สร้าง',
        'สวัสดี',
        'สหกรณ์',
        'สัญญา',
        'สัตว์',
        'สามัคคี',
        'สำคัญ',
        'สำหรับ',
        'สุนัข',
        'สุเหร่า',
        'เสด็จ',
        'เสร็จ',
        'เสาร์',
        'แสดง',
        'หญิง',
        'หน่วย',
        'หนอง',
        'หนอน',
        'หน่อย',
        'หนัก',
        'หนัง',
        'หนาว',
        'หนีบ',
        'หนุน',
        'หนุ่ม',
        'หมด',
        'หมอก',
        'หมอบ',
        'หมั่น',
        'หมาก',
        'หมาย',
        'หมุน',
        'หยอก',
        'หยอด',
        'หยุด',
        'หรอก',
        'หล่น',
        'หลบ',
        'หลวม',
        'หลอก',
        'หลอด',
        'หลับ',
        'หลาน',
        'หลาย',
        'หลุด',
        'หลุม',
        'หวัง',
        'หวัด',
        'หวาน',
        'หว่าน',
        'หาร',
        'เหนียว',
        'เหนื่อย',
        'เหม็น',
        'เหมือน',
        'เหยียด',
        'เหยียบ',
        'เหยี่ยว',
        'เหล็ก',
        'เหลือง',
        'แหลม',
        'แหวน',
        'องค์',
        'อธิบาย',
        'อนามัย',
        'อยาก',
        'อย่าง',
        'อร่อย',
        'อวัยวะ',
        'อันตราย',
        'อัศจรรย์',
        'อาการ',
        'อากาศ',
        'อาคาร',
        'อาจ',
        'อาจารย์',
        'อาชีพ',
        'อาศัย',
        'อาหาร',
        'อิฐ',
        'อิสลาม',
        'แอปเปิล',
        'ไอศกรีม',
        'ก้น',
        'กระจง',
        'กระจาด',
        'กระเจี๊ยบ',
        'กระแซะ',
        'กระดอง',
        'กระดิก',
        'กระเด้ง',
        'กระแต',
        'กระโถน',
        'กระทง',
        'กระท่อม',
        'กระแทก',
        'กระบอก',
        'กระบะ',
        'กระบุง',
        'กระมัง',
        'กรุณา',
        'กวน',
        'กัก',
        'กั้น',
        'กาก',
        'ก้าน',
        'กาม',
        'ก่าย',
        'กาว',
        'กำนัน',
        'กำไล',
        'กิ้งก่า',
        'กีฬา',
        'กุนเชียง',
        'กุม',
        'เก้ง',
        'เกะกะ',
        'เกี้ยว',
        'แก่น',
        'โกง',
        'โกย',
        'โกสน',
        'ขด',
        'ข้น',
        'ขยำ',
        'ข่วน',
        'ขอบ',
        'ขั้น',
        'ข่าย',
        'ขุ่น',
        'เขย่า',
        'เขียด',
        'แข้ง',
        'ไข',
        'คณะ',
        'คม',
        'ควบ',
        'คว้า',
        'คอก',
        'คะแนน',
        'คั้น',
        'คาย',
        'ค่าย',
        'คาว',
        'คิงคอง',
        'คุม',
        'เคียง',
        'แคร่',
        'โคน',
        'โคม',
        'ใคร่',
        'งอ',
        'เงียบ',
        'จง',
        'จวน',
        'จอง',
        'จ้อง',
        'จอม',
        'จัก',
        'จาง',
        'จ้ำ',
        'จุ่ม',
        'จูบ',
        'เจียว',
        'แจ้ว',
        'โจ๊ก',
        'ฉก',
        'ฉีก',
        'ฉุกเฉิน',
        'เฉพาะ',
        'เฉียง',
        'แฉะ',
        'ชบา',
        'ชรา',
        'ช่อง',
        'ชอน',
        'ชัง',
        'ชัด',
        'ชาน',
        'ชำ',
        'ช้ำ',
        'ชิง',
        'ชิม',
        'ชีวี',
        'ชื้น',
        'ชู',
        'เช่า',
        'เชื้อ',
        'เชือด',
        'เชื่อม',
        'ไช',
        'ไชโย',
        'ซ้อม',
        'ซ้ำ',
        'ซี่',
        'ซีอิ๊ว',
        'ซึ้ง',
        'โซ่',
        'ดก',
        'ดวง',
        'ด้วง',
        'ด้วน',
        'ดอง',
        'ดอย',
        'ดัด',
        'ดัน',
        'ดาม',
        'ดำเนิน',
        'ดิบ',
        'เด้ง',
        'เดือย',
        'แด่',
        'ตด',
        'ตวง',
        'ต่อม',
        'ตะกร้อ',
        'ตะกละ',
        'ตะเกียง',
        'ตะโพก',
        'ตั๋ว',
        'ตำลึง',
        'ตึง',
        'ตุ่น',
        'เตย',
        'เต้าหู้',
        'เติบ',
        'เตือน',
        'ไต้',
        'ถ่ม',
        'ถ่อม',
        'ถัก',
        'ถิ่น',
        'เถอะ',
        'แถบ',
        'แถม',
        'ไถ่',
        'ทด',
        'ทน',
        'ทวง',
        'ทวด',
        'ท่อน',
        'ทอย',
        'ทั่ว',
        'ทิ่ม',
        'ทุบ',
        'ทุ่ม',
        'แท้',
        'ธุระ',
        'นวด',
        'นวม',
        'นะ',
        'นาม',
        'นินทา',
        'นุ่น',
        'นุ่ม',
        'เนย',
        'เนียน',
        'แน่น',
        'โน่น',
        'บด',
        'บ่ม',
        'บ่วง',
        'บวม',
        'บะหมี่',
        'บันทึก',
        'บ้า',
        'บาก',
        'บุหรี่',
        'บูด',
        'เบ็ด',
        'เบี้ย',
        'แบน',
        'โบ',
        'ใบ้',
        'ปน',
        'ประกอบ',
        'ประเคน',
        'ประเดี๋ยว',
        'ประทัด',
        'ประเมิน',
        'ป้อง',
        'ป้อน',
        'ปั๊ม',
        'ป้าย',
        'ปิงปอง',
        'ปิ่น',
        'ปูด',
        'เปล',
        'โป้ง',
        'ผ่อน',
        'ผอม',
        'เผลอ',
        'เผือก',
        'แผน',
        'โผ',
        'ฝอย',
        'ฝัก',
        'ฝาน',
        'ฝึก',
        'เฝือก',
        'พ้น',
        'พลู',
        'พวง',
        'พัน',
        'พิธี',
        'พุ่ม',
        'เพดาน',
        'ฟรี',
        'ฟ้อน',
        'ฟู',
        'ภาระ',
        'ม้วน',
        'มะเร็ง',
        'มัก',
        'มันแกว',
        'มั่น',
        'มุม',
        'เมาะ',
        'ไมตรี',
        'ย้อน',
        'ย้อย',
        'ยัน',
        'ย้ำ',
        'ยึด',
        'ยืด',
        'ยึ่น',
        'ยุ้ง',
        'เยี่ยว',
        'เยื่อ',
        'แยง',
        'โยก',
        'ร่อง',
        'รอด',
        'ร่อน',
        'รอย',
        'ระกำ',
        'ระบาย',
        'ระเบิด',
        'ระยำ',
        'ระลึก',
        'ระแวง',
        'รั้ว',
        'ร่าง',
        'ริ้ว',
        'รุน',
        'รุ่น',
        'แรด',
        'ล่ม',
        'ลวก',
        'ล่วง',
        'ล่อ',
        'ลอก',
        'ล้อม',
        'ละออง',
        'ลั่น',
        'ล่าม',
        'ลำ',
        'ลิ้น',
        'ลึก',
        'ลุย',
        'เลว',
        'เลอะ',
        'เลื่อน',
        'โลก',
        'วน',
        'วัง',
        'วัย',
        'วา',
        'วิว',
        'วุ่น',
        'เว้า',
        'สวะ',
        'สอ',
        'ส่อ',
        'สอย',
        'สะกด',
        'สะดุด',
        'สะบัด',
        'สะใภ้',
        'สัน',
        'สั่น',
        'สาน',
        'สามี',
        'สำลี',
        'สุ่ม',
        'เสียว',
        'แสง',
        'แสน',
        'แสบ',
        'หมี่',
        'หวง',
        'ห่วง',
        'หวด',
        'หวย',
        'หอบ',
        'หารือ',
        'ห้าง',
        'หาบ',
        'หาว',
        'หีบ',
        'หุบ',
        'หุ้ม',
        'เห็ด',
        'เหมา',
        'เหยื่อ',
        'เหว',
        'เหาะ',
        'ไหม้',
        'อักเสบ',
        'อ้า',
        'อ่าง',
        'อาเจียน',
        'อาย',
        'อาสา',
        'อำลา',
        'เอ่ย',
        'เฮฮา',
        'กบเหลาดินสอ',
        'ก๊อกน้ำ',
        'กับดัก',
        'กาน้ำ',
        'กำมือ',
        'กำบัง',
        'กำไร',
        'กำลังกาย',
        'กินเลี้ยง',
        'เกี่ยวข้อง',
        'แก้ไข',
        'แกงคั่ว',
        'แก้วหู',
        'ไก่โต้ง',
        'ไก่ย่าง',
        'ขอบใจ',
        'ขอบฟ้า',
        'ขั้นตอน',
        'ขับร้อง',
        'ข้างเคียง',
        'ข้าวต้มมัด',
        'ข้าวราดแกง',
        'ข้าวหมูแดง',
        'ข้าวห่อ',
        'ข้าศึก',
        'ขี้ดิน',
        'ขี้ตา',
        'ขี้ผง',
        'ขี้เล็บ',
        'เข็มฉีดยา',
        'เข้าที',
        'แขกเมือง',
        'ไข่ขาว',
        'ไข่เจียว',
        'ไข่ดัน',
        'ไข่ดาว',
        'ไข่พะโล้',
        'ไข้มาลาเรีย',
        'คนจน',
        'คนใช้',
        'คนซื้อ',
        'คนดี',
        'คนตาย',
        'คนโท',
        'ค้นคว้า',
        'คมนาคม',
        'ค่อยยังชั่ว',
        'คัดลายมือ',
        'คันนา',
        'คันส่ง',
        'ค้างคาว',
        'คาถา',
        'คำตอบ',
        'คำถาม',
        'คำสั่ง',
        'คุกเข่า',
        'งดงาม',
        'งมงาย',
        'งอกงาม',
        'งานศพ',
        'ง่ายดาย',
        'จนกระทั่ง',
        'จำเป็น',
        'จำพวก',
        'เจ็บไข้',
        'เจ็บไข้ได้ป่วย',
        'เจ้านาย',
        'ใจร้าย',
        'ชมเชย',
        'ชมพู',
        'ช่อฟ้า',
        'ช้อนชา',
        'ชัยชนะ',
        'ชายแดน',
        'ชาวประมง',
        'ชื่นใจ',
        'ชุดนอน',
        'ชุมชน',
        'ชุ่มชื่น',
        'เชิงเขา',
        'เชิญธง',
        'ซ่อมแซม',
        'ดอกแก้ว',
        'ดอกโกสน',
        'ดอกซ่อนกลิ่น',
        'ดอกเฟื่องฟ้า',
        'ดอกมะเขือ',
        'ดอกรักเร่',
        'ดังนี้',
        'ดินร่วน',
        'ดินสอสี',
        'ดูเล่น',
        'ได้แก่',
        'ต้นกะเพรา',
        'ต้นกาแฟ',
        'ต้นข้าว',
        'ต้นคว่ำตายหงายเป็น',
        'ต้นคุณนายตื่นสาย',
        'ต้นแค',
        'ต้นชงโค',
        'ต้นชะอม',
        'ต้นตะไคร้',
        'ต้นแตงโม',
        'ต้นทับทิม',
        'ต้นเทียน',
        'ต้นนุ่น',
        'ต้นบานชื่น',
        'ต้นบานไม่รู้โรย',
        'ต้นเฟื่องฟ้า',
        'ต้นมะกอก',
        'ต้นมัน',
        'ต้นลางสาด',
        'ต้นว่าน',
        'ต้นสะแก',
        'ต้นสะตอ',
        'ต้นสัก',
        'ต้นอ้อย',
        'ต่อรอง',
        'ต่อสู้',
        'ตักเตือน',
        'ตัวผู้',
        'ตาราง',
        'ตารางสอน',
        'ตายโหง',
        'ติดตาม',
        'ตีลังกา',
        'ตุ้มหู',
        'เต้นรำ',
        'เตียงนอน',
        'แตกต่าง',
        'แตงไทย',
        'ถกเถียง',
        'ถ่ายเท',
        'ถือศีล',
        'ทดลอง',
        'ทดสอบ',
        'ทอผ้า',
        'ทองคำ',
        'ท้องฟ้า',
        'ทันที',
        'ทันใด',
        'ทับทิม',
        'ค่าน้ำ',
        'ที่นั่ง',
        'ทุกที',
        'เท่ากับ',
        'นกกระจอก',
        'นกยูง',
        'นกอินทรี',
        'น้องสาว',
        'น้อยใจ',
        'นักกีฬา',
        'น่าเกลียด',
        'น่าขัน',
        'นางฟ้า',
        'นานมาแล้ว',
        'นายท้าย',
        'นำหน้า',
        'น้ำใจ',
        'น้ำท่วม',
        'น้ำประปา',
        'น้ำยา',
        'น้ำเย็น',
        'น้ำอัดลม',
        'นิ้วเท้า',
        'แนะนำ',
        'บอกใบ้',
        'ใบตอง',
        'ปกปักรักษา',
        'ปลากัด',
        'ปลาตะเพียน',
        'ปิดทอง',
        'ปีนป่าย',
        'ปูม้า',
        'ผ้าถุง',
        'ผ้าใบ',
        'ผ้าพันคอ',
        'ผ้าโพกหัว',
        'ผีกองกอย',
        'ผู้ขาย',
        'ผู้ป่วย',
        'แผนที่',
        'แผ่นดิน',
        'พระเจ้าลูกเธอ',
        'พ่อขุน',
        'พังพอน',
        'พี่น้อง',
        'พี่เลี้ยง',
        'พื้นดิน',
        'พื้นที่',
        'พุ่มไม้',
        'พู่กัน',
        'พูดคุย',
        'พูดปด',
        'เพื่อนบ้าน',
        'ฟองน้ำ',
        'ฟ้อนรำ',
        'ภายนอก',
        'มดแดง',
        'ม้าลาย',
        'ม้ากระดก',
        'มิฉะนั้น',
        'เมืองไทย',
        'แม่ครัว',
        'แม้แต่',
        'ไม้ตะเคียน',
        'ไม้ถูบ้าน',
        'ไม้ไผ่',
        'ไม้เรียว',
        'ยากันยุง',
        'ยาสูบ',
        'ยางพารา',
        'เย็บปักถักร้อย',
        'เยี่ยมเยียน',
        'ร่มไม้',
        'ร่มรื่น',
        'รวบรวม',
        'รับผิดชอบ',
        'รับมือ',
        'รับสั่ง',
        'รายได้',
        'ร่ายรำ',
        'รุ่งเช้า',
        'รุ่งเรือง',
        'รุนแรง',
        'รู้เรื่อง',
        'เริ่มต้น',
        'เรือบิน',
        'เรือใบ',
        'เรือพาย',
        'เรื่องราว',
        'โรงงาน',
        'โรงสี',
        'ลงมือ',
        'ล้อมวง',
        'ลับตา',
        'ลายมือ',
        'ลำตัว',
        'ลำพัง',
        'ลืมตา',
        'ลูกค้า',
        'ลูกจัน',
        'ลูกชาย',
        'ลูกน้อง',
        'ลูกนิมิต',
        'ลูกสูบ',
        'ลูกเสือชาวบ้าน',
        'ลูกอม',
        'เล็ม',
        'เลอะเทอะ',
        'เล่าเรียน',
        'ไล่จับ',
        'วอดวาย',
        'วันเกิด',
        'วันที่',
        'วันรุ่งขึ้น',
        'วิ่งเปี้ยว',
        'วิ่งหนี',
        'แว่นตา',
        'ส้มเช้ง',
        'ส่องแสง',
        'สามแยก',
        'สายตา',
        'สายไฟ',
        'สำนักงาน',
        'สิบล้อ',
        'สีชมพู',
        'สีเทา',
        'สีน้ำ',
        'สีฟ้า',
        'สุดท้าย',
        'สูดดม',
        'เสือดาว',
        'เสื้อยืด',
        'หน้าตา',
        'หน้าผาก',
        'หน้าฝน',
        'หน้าอก',
        'หนูตะเภา',
        'หม้อแกง',
        'หมาบ้า',
        'หรี่ตา',
        'ห้องฉุกเฉิน',
        'หัวผักกาด',
        'อดทน',
        'อบอ้าว',
        'ออกกำลัง',
        'ออกลูก',
        'อับปาง',
        'กตัญญู',
        'กติกา',
        'กรอง',
        'กระยาสารท',
        'กล',
        'กล้อง',
        'กลอน',
        'กล่อม',
        'กลัก',
        'กษัตริย์',
        'กันดาร',
        'กุฏิ',
        'เกรด',
        'เกล็ด',
        'เกลี้ยง',
        'เกลียว',
        'เกวียน',
        'เกียรติ',
        'แกลบ',
        'แกลลอน',
        'ขจัด',
        'ขมา',
        'ขยับ',
        'ขยาย',
        'ขวิด',
        'ครอง',
        'ครั่ง',
        'คราด',
        'คลอด',
        'คลาย',
        'เคล็ด',
        'จราจร',
        'ฉลาด',
        'ฉันท์',
        'ช็อกโกแลต',
        'เช็ค',
        'เชลย',
        'ซ่าหริ่ม',
        'ตลิ่ง',
        'ตะแกรง',
        'ตั๊กแตน',
        'ถล่ม',
        'ถวิล',
        'เทอม',
        'แท็กซี่',
        'ธนาคาร',
        'ธาตุ',
        'นคร',
        'บท',
        'บรรดา',
        'บริการ',
        'บริจาค',
        'บริษัท',
        'บริสุทธิ์',
        'บำเพ็ญ',
        'บาป',
        'บุตร',
        'เบอร์',
        'แบดมินตัน',
        'แบบทดสอบ',
        'ปกติ',
        'ปฏิวัติ',
        'ประกาศ',
        'ประพฤติ',
        'ประเภท',
        'ประมาท',
        'ประมุข',
        'ประวัติ',
        'ประสงค์',
        'ประหยัด',
        'ประหลาด',
        'ปรากฏ',
        'ปลอม',
        'ปลั๊ก',
        'ปลิว',
        'ปัจจัย',
        'ปัญหา',
        'เปรต',
        'เปรียบ',
        'เปลือง',
        'โปรด',
        'โปรตีน',
        'ไปรษณีย์',
        'ผลัด',
        'ผลิต',
        'ผสม',
        'พนม',
        'พรม',
        'พลัด',
        'พลั่ว',
        'พลิก',
        'พิจารณา',
        'พิมพ์',
        'พิเศษ',
        'เพชร',
        'แฟลต',
        'ภูษา',
        'มนต์',
        'มลาย',
        'มะปริง',
        'มัธยม',
        'มารยาท',
        'เมรุ',
        'ระหว่าง',
        'รางวัล',
        'ฤาษี',
        'ลักษณะ',
        'ลาภ',
        'วัสดุ',
        'วิหค',
        'ศาล',
        'ศีล',
        'เศร้า',
        'สงกรานต์',
        'สงคราม',
        'สติ',
        'สนอง',
        'สนั่น',
        'สนิท',
        'สภาพ',
        'สมาน',
        'สรรเสริญ',
        'สรุป',
        'สลบ',
        'สลับ',
        'สวรรค์',
        'สวิตช์',
        'สังเกต',
        'สังขยา',
        'สัปดาห์',
        'สัมพันธ์',
        'สามารถ',
        'สาร',
        'สาหัส',
        'สาเหตุ',
        'สำเร็จ',
        'สูตร',
        'เสริฟ',
        'เสมอ',
        'เสริม',
        'หงส์',
        'หนาม',
        'หมก',
        'หมวด',
        'หมัด',
        'หย่อน',
        'หยัก',
        'หยาบ',
        'หลง',
        'หวาย',
        'เหตุ',
        'เหรียญ',
        'เหลว',
        'เหลี่ยม',
        'เหลียว',
        'เหวี่ยง',
        'อธิษฐาน',
        'อนุญาต',
        'อนุบาล',
        'ออกซิเจน',
        'อารมณ์',
        'อาวุธ',
        'อินทร์',
        'อุจจาระ',
        'อุทิศ',
        'อุปกรณ์',
        'โอกาส',
        'โอรส',
        'กงการ',
        'กรรมกร',
        'กรรมการ',
        'กล้วยไม้',
        'กล้วยหอม',
        'กล่องข้าว',
        'กล่องดินสอ',
        'กลับบ้าน',
        'กลางคืน',
        'กลางวัน',
        'ก่อสร้าง',
        'กากบาท',
        'การกีฬา',
        'การคูณ',
        'การงาน',
        'การนอน',
        'การบวก',
        'การบำรุงรักษา',
        'การบ้าน',
        'การป้องกัน',
        'การพักผ่อน',
        'การแพทย์',
        'การระวัง',
        'การรักษา',
        'การเรียน',
        'การเล่าเรื่อง',
        'การศึกษา',
        'กาลครั้งหนึ่ง',
        'กิจกรรม',
        'กิจการ',
        'กิโลกรัม',
        'กิโลเมตร',
        'เกรงใจ',
        'เกียจคร้าน',
        'ขนมกล้วย',
        'ขนมไข่',
        'ขนมครก',
        'ขนมเค้ก',
        'ขนมจีน',
        'ขนมชั้น',
        'ขนมตาล',
        'ขนมเทียน',
        'ขนมบัวลอย',
        'ขนมเปียกปูน',
        'ขนมใส่ไส้',
        'ขยายพันธุ์',
        'ขอโทษ',
        'ของขวัญ',
        'ของหวาน',
        'ของแหลม',
        'ขอบคุณ',
        'ขัดสมาธิ',
        'ข้าราชการ',
        'ขาดแคลน',
        'ข้าวเกรียบกุ้ง',
        'ข้าวปลาอาหาร',
        'ข้าวเปลือก',
        'ข้าวหมกไก่',
        'ข้าวเหนียว',
        'ขี้เกียจ',
        'ขี้ไคล',
        'เข็มกลัด',
        'เข้าพรรษา',
        'ไข้หวัด',
        'คณิตศาสตร์',
        'ครอบครัว',
        'ครูบาอาจารย์',
        'ความกตัญญู',
        'ความเข้าใจ',
        'ความเคยชิน',
        'ความเคารพ',
        'ความเจริญ',
        'ความชั่ว',
        'ความดี',
        'ความทุกข์',
        'ความเป็นอยู่',
        'ความเมตตา',
        'ความร่มเย็น',
        'ความรัก',
        'ความรู้',
        'ความรู้สึก',
        'ความสวยงาม',
        'ความสะอาด',
        'ความสำคัญ',
        'ความสุข',
        'ความหนาว',
        'ความอบอุ่น',
        'คำปฏิญาณ',
        'คำศัพท์',
        'คุณครู',
        'คุณตา',
        'คุณธรรม',
        'คุณน้า',
        'คุณนาย',
        'คุณป้า',
        'คุณปู่',
        'คุณพ่อ',
        'คุณพี่',
        'คุณแม่',
        'คุณย่า',
        'คุณยาย',
        'คุณลุง',
        'คุณหมอ',
        'คุณอา',
        'เครื่องกระป๋อง',
        'เครื่องแกง ',
        'เครื่องเขียน',
        'เครื่องครัว',
        'เครื่องใช้',
        'เครื่องแต่งกาย',
        'เครื่องนอน',
        'เครื่องบังคับ',
        'เครื่องบิน',
        'เครื่องแบบ',
        'เครื่องปรุง',
        'เครื่องมือ',
        'เครื่องยนต์',
        'เครื่องเรือน',
        'เครื่องเล่น',
        'เครื่องหมาย',
        'งานประดิษฐ์',
        'จดหมาย',
        'จริยศึกษา',
        'จักรยาน',
        'จักรยานยนต์',
        'จิตใจ',
        'จุดประสงค์',
        'เจ้าหญิง',
        'ชนชาติ',
        'ช้อนกลาง',
        'ช้อนส้อม',
        'เชื้อโรค',
        'แชร์บอล',
        'ซื่อสัตย์',
        'ดวงจันทร์',
        'ดวงอาทิตย์',
        'ดอกกระดาษ',
        'ดอกกล้วยไม้',
        'ดอกกุหลาบ',
        'ดอกคุณนายตื่นสาย',
        'ดอกเบญจมาศ',
        'ดอกพุทธรักษา',
        'ดอกหงอนไก่',
        'ดินเหนียว',
        'เด็กหญิง',
        'โดยสาร',
        'ต้นกล้วย',
        'ต้นกุหลาบ',
        'ต้นขนุน',
        'ต้นขี้เหล็ก',
        'ต้นตาล',
        'ต้นนางกวัก',
        'ต้นฝรั่ง',
        'ต้นพริก',
        'ต้นพุทรา',
        'ต้นมะกรูด',
        'ต้นมะขามเทศ',
        'ต้นมะปราง',
        'ต้นมะปริง',
        'ต้นมะพร้าว',
        'ต้นมะม่วงหิมพานต์',
        'ต้นยูคาลิปตัส',
        'ต้นองุ่น',
        'ต้นแอปเปิล',
        'ตลาดนัด',
        'ตักบาตร',
        'ตัวคูณ',
        'ตัวเลข',
        'ตัวหาร',
        'ตัวอย่าง',
        'ตาเขย่ง',
        'ต่างประเทศ',
        'ตู้โชว์',
        'เตรียมตัว',
        'เตาแก๊ส',
        'ถอยหลัง',
        'ถั่วเหลือง',
        'ถ่ายรูป',
        'ทหารเรือ',
        'ทอดกฐิน',
        'ทอดพระเนตร',
        'ทะเลทราย',
        'ทั้งหมด',
        'ทั้งหลาย',
        'ทำบุญ',
        'ทำเวร',
        'ทิวทัศน์',
        'ทีหลัง',
        'ทุกข์สุข',
        'เทพารักษ์',
        'โทรศัพท์',
        'ธงชาติ',
        'ธรรมชาติ',
        'ธรรมดา',
        'ธุรกิจ',
        'นมัสการ',
        'นอนหลับ',
        'นางพยาบาล',
        'นาฎศิลป์',
        'นายพราน',
        'น้ำพริก',
        'น้ำมนต์',
        'นิดหน่อย',
        'บวชชี',
        'บวชนาค',
        'บาดแผล',
        'บาสเกตบอล',
        'บิณฑบาต',
        'บุญคุณ',
        'ปกครอง',
        'ปกคลุม',
        'ประเทศชาติ',
        'ประสบการณ์',
        'ปลอกหมอน',
        'ปลอดโปร่ง',
        'ปลอดภัย',
        'ปลาวาฬ',
        'ปลาหมึก',
        'ปลาหวาน',
        'ปักษ์ใต้',
        'ปานกลาง',
        'เปลี่ยนแปลง',
        'แปรงสีฟัน',
        'ผงชูรส',
        'ผลไม้',
        'ผลผลิต',
        'ผิวหนัง',
        'ผู้ปกครอง',
        'ผู้อำนวยการ',
        'แผ่เมตตา',
        'ฝาผนัง',
        'พนมมือ',
        'พรวนดิน',
        'พระคุณ',
        'พระธาตุ',
        'พระบรมโอรสาธิราช',
        'พระบาทสมเด็จพระเจ้าอยู่หัว',
        'พระบารมี',
        'พระพุทธเจ้า',
        'พระพุทธรูป',
        'พระมหากษัตริย์',
        'พระมเหสี',
        'พระราชกรณียกิจ',
        'พระราชดำริ',
        'พระราชดำเนิน',
        'พระราชทาน',
        'พระราชวัง',
        'พระราชโอรส',
        'พระสงฆ์',
        'พระองค์',
        'พระอาทิตย์',
        'พระอินทร์',
        'พริกขี้หนู',
        'พริกไทย',
        'พรุ่งนี้',
        'พลเมือง',
        'พลศึกษา',
        'พลาสติก',
        'เพลงชาติ',
        'เพลงปลุกใจ',
        'เพลิดเพลิน',
        'พังทลาย',
        'เพาะปลูก',
        'ฟุตบอล',
        'ภาพยนตร์',
        'ภารโรง',
        'ภูมิใจ',
        'มอเตอร์ไซค์',
        'มอบหมาย',
        'มะขามเทศ',
        'มะเขือเทศ',
        'มันสำปะหลัง',
        'มาฆบูชา',
        'ม้าหมุน',
        'แม่เฒ่า',
        'แมลงวัน',
        'แมลงหวี่',
        'ไม่ค่อย',
        'ไม้กวาด',
        'ไม้แขวนเสื้อ',
        'ไม้บรรทัด',
        'ยารักษาโรค',
        'ยาเสพติด',
        'ยาหยอดตา',
        'ยุวกาชาด',
        'เยาวชน',
        'รถกระบะ',
        'รถเก๋ง',
        'รถเข็น',
        'รถแข่ง',
        'รถเครื่อง',
        'รถจักรยาน',
        'รถจักรยานยนต์',
        'รถโดยสาร',
        'รถตำรวจ',
        'รถถัง',
        'รถไถ',
        'รถทัวร์',
        'รถแท็กซี่',
        'รถบรรทุก',
        'รถบัส',
        'รถประจำทาง',
        'รถพยาบาล',
        'รถมอเตอร์ไซค์',
        'รถเมล์',
        'รถสองแถว',
        'รสชาติ',
        'ร้องเพลง',
        'รัชกาล',
        'รับราชการ',
        'ราชสาส์น',
        'ราชสีห์',
        'ราชาศัพท์',
        'รูปภาพ',
        'โรงอาหาร',
        'ฤดูร้อน',
        'ฤดูหนาว',
        'ลงโทษ',
        'ลักขโมย',
        'ลำคลอง',
        'ลำธาร',
        'ลิปสติก',
        'เลขคณิต',
        'ลูกบอล',
        'ลูกศิษย์',
        'วงกลม',
        'วอลเลย์บอล',
        'วันเข้าพรรษา',
        'วันจันทร์',
        'วันพฤหัสบดี',
        'วันพุธ',
        'วันมาฆบูชา',
        'วันวิสาขบูชา',
        'วันศุกร์',
        'วันเสาร์',
        'วันออกพรรษา',
        'วันอังคาร',
        'วันอาทิตย์',
        'วันอาสาฬหบูชา',
        'วาดรูป',
        'วิ่งผลัด',
        'วิสาขบูชา',
        'ศาลากลาง',
        'ศาสนาคริสต์',
        'ศาสนาพุทธ',
        'ศาสนาอิสลาม',
        'เศษกระดาษ',
        'เศษอาหาร',
        'ส่งเสริม',
        'สถานที่',
        'สถานีตำรวจ',
        'สถานีอนามัย',
        'สนุกสนาน',
        'ส้มเขียวหวาน',
        'สม่ำเสมอ',
        'สมุดวาดเขียน',
        'สวดมนต์',
        'สวนหย่อม',
        'สัตว์ป่า',
        'สามเณร',
        'สารวัตร',
        'สีคราม',
        'สีน้ำตาล',
        'สีเหลือง',
        'สี่เหลี่ยม',
        'สุขภาพ',
        'สุนัขจิ้งจอก',
        'สุภาพ',
        'สูตรคูณ',
        'เสือโคร่ง',
        'เสื้อกล้าม',
        'แสงสว่าง',
        'แสงอาทิตย์',
        'ใส่บาตร',
        'ไส้กรอก',
        'หงอนไก่',
        'หนังจีน',
        'หนังไทย',
        'หนังสะติ๊ก',
        'หนังสือพิมพ์',
        'หนังสือเรียน',
        'หน้าหนาว',
        'หมอนข้าง',
        'หมากเก็บ',
        'หมากฮอส',
        'หลวงปู่',
        'หลวงพ่อ',
        'หลังคา',
        'หลับตา',
        'หวานเย็น',
        'ห้องพยาบาล',
        'หารสั้น',
        'หุ่นยนต์',
        'หูหนวก',
        'เหตุการณ์',
        'แห่นาค',
        'แหลกลาญ',
        'อย่างไร',
        'ออกพรรษา',
        'อ่อนหวาน',
        'อาจารย์ใหญ่',
        'อาทิตย์',
        'อุบัติเหตุ',
    )
