/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.ClipboardDialog;
import com.tigervnc.vncviewer.DesktopWindow;
import com.tigervnc.vncviewer.JavaPixelBuffer;
import com.tigervnc.vncviewer.KeyMap;
import com.tigervnc.vncviewer.MenuKey;
import com.tigervnc.vncviewer.OptionsDialog;
import com.tigervnc.vncviewer.Parameters;
import com.tigervnc.vncviewer.PlatformPixelBuffer;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

class Viewport
extends JPanel
implements ActionListener {
    static LogWriter vlog = new LogWriter("Viewport");
    static final int[] dotcursor_xpm = new int[]{0, 0, 0, 0, 0, 0, -16777216, -16777216, -16777216, 0, 0, -16777216, -16777216, -16777216, 0, 0, -16777216, -16777216, -16777216, 0, 0, 0, 0, 0, 0};
    private CConn cc;
    private PlatformPixelBuffer frameBuffer;
    Point lastPointerPos = new Point(0, 0);
    int lastButtonMask = 0;
    DownMap downKeySym = new DownMap(256);
    int menuKeySym;
    int menuKeyCode;
    int menuKeyJava;
    JPopupMenu contextMenu;
    boolean menuRecursion = false;
    boolean menuCtrlKey = false;
    boolean menuAltKey = false;
    static Toolkit tk = Toolkit.getDefaultToolkit();
    public int scaledWidth = 0;
    public int scaledHeight = 0;
    float scaleRatioX;
    float scaleRatioY;
    static BufferedImage cursor;
    Point cursorHotspot = new Point();

    public Viewport(int n, int n2, PixelFormat pixelFormat, CConn cConn) {
        this.cc = cConn;
        this.setScaledSize(n, n2);
        this.frameBuffer = this.createFramebuffer(pixelFormat, n, n2);
        assert (this.frameBuffer != null);
        this.setBackground(Color.BLACK);
        this.cc.setFramebuffer(this.frameBuffer);
        this.contextMenu = new JPopupMenu();
        OptionsDialog.addCallback("handleOptions", this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Viewport.this.handle(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Viewport.this.handle(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Viewport.this.handle(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Viewport.this.handle(mouseEvent);
            }
        });
        this.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Viewport.this.handle(mouseWheelEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Viewport.this.handle(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Viewport.this.handle(mouseEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Viewport.this.handleSystemEvent(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Viewport.this.handleSystemEvent(keyEvent);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ClipboardDialog.clientCutText();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Viewport.this.releaseDownKeys();
            }
        });
        this.getActionMap().put("null", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        arrayList.add(KeyStroke.getKeyStroke(121, 0, true));
        arrayList.add(KeyStroke.getKeyStroke(18, 0, true));
        for (int i = 0; i < arrayList.size(); ++i) {
            this.getInputMap(0).put((KeyStroke)arrayList.get(i), "null");
        }
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusable(true);
        this.setMenuKey();
        this.handlePointerEvent(new Point(n / 2, n2 / 2), 0);
    }

    public PixelFormat getPreferredPF() {
        return this.frameBuffer.getPF();
    }

    public void updateWindow() {
        Rect rect = this.frameBuffer.getDamage();
        if (!rect.is_empty()) {
            if (this.cc.server.width() != this.scaledWidth || this.cc.server.height() != this.scaledHeight) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(this.scaleRatioX, this.scaleRatioY);
                Rectangle rectangle = new Rectangle(rect.tl.x, rect.tl.y, rect.width(), rect.height());
                rectangle = affineTransform.createTransformedShape(rectangle).getBounds();
                this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                this.paintImmediately(rect.tl.x, rect.tl.y, rect.width(), rect.height());
            }
        }
    }

    public void setCursor(int n, int n2, Point point, byte[] byArray) {
        int n3;
        if (cursor != null) {
            cursor.flush();
        }
        for (n3 = 0; n3 < n * n2 && byArray[n3 * 4 + 3] == 0; ++n3) {
        }
        if (n3 == n * n2 && Parameters.dotWhenNoCursor.getValue()) {
            vlog.debug("cursor is empty - using dot", new Object[0]);
            cursor = new BufferedImage(5, 5, 3);
            cursor.setRGB(0, 0, 5, 5, dotcursor_xpm, 0, 5);
            this.cursorHotspot.y = 3;
            this.cursorHotspot.x = 3;
        } else if (n == 0 || n2 == 0) {
            cursor = new BufferedImage(Viewport.tk.getBestCursorSize((int)0, (int)0).width, Viewport.tk.getBestCursorSize((int)0, (int)0).height, 3);
            this.cursorHotspot.y = 0;
            this.cursorHotspot.x = 0;
        } else {
            IntBuffer intBuffer = IntBuffer.allocate(n * n2);
            intBuffer.put(ByteBuffer.wrap(byArray).asIntBuffer());
            cursor = new BufferedImage(n, n2, 3);
            cursor.setRGB(0, 0, n, n2, intBuffer.array(), 0, n);
            this.cursorHotspot = point;
        }
        int n4 = (int)Math.floor((float)cursor.getWidth() * this.scaleRatioX);
        int n5 = (int)Math.floor((float)cursor.getHeight() * this.scaleRatioY);
        int n6 = (int)Math.floor((float)this.cursorHotspot.x * this.scaleRatioX);
        int n7 = (int)Math.floor((float)this.cursorHotspot.y * this.scaleRatioY);
        Dimension dimension = tk.getBestCursorSize(n4, n5);
        if (dimension.width != n4 && dimension.height != n5) {
            n4 = Math.min(n4, dimension.width);
            n5 = Math.min(n5, dimension.height);
            n6 = Math.min(n6, Math.max(dimension.width - 1, 0));
            n7 = Math.min(n7, Math.max(dimension.height - 1, 0));
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(cursor, 0, 0, n4, n5, 0, 0, n, n2, null);
            graphics2D.dispose();
            cursor = bufferedImage;
        }
        this.setCursor(cursor, n6, n7);
    }

    private void setCursor(Image image, int n, int n2) {
        String string = "rfb cursor";
        java.awt.Point point = new java.awt.Point(n, n2);
        Cursor cursor = tk.createCustomCursor(image, point, string);
        this.setCursor(cursor);
    }

    public void resize(int n, int n2, int n3, int n4) {
        if (n3 != this.frameBuffer.width() || n4 != this.frameBuffer.height()) {
            vlog.debug("Resizing framebuffer from " + this.frameBuffer.width() + "x" + this.frameBuffer.height() + " to " + n3 + "x" + n4, new Object[0]);
            this.frameBuffer = this.createFramebuffer(this.frameBuffer.getPF(), n3, n4);
            assert (this.frameBuffer != null);
            this.cc.setFramebuffer(this.frameBuffer);
        }
        this.setScaledSize(n3, n4);
    }

    public int handle(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 504: {
                if (cursor != null) {
                    this.setCursor(cursor, this.cursorHotspot.x, this.cursorHotspot.y);
                }
                return 1;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                return 1;
            }
            case 501: 
            case 502: 
            case 503: 
            case 506: 
            case 507: {
                int n = 0;
                if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
                    n |= 1;
                }
                if ((mouseEvent.getModifiersEx() & 0x800) != 0) {
                    n |= 2;
                }
                if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                    n |= 4;
                }
                if (mouseEvent.getID() == 507) {
                    int n2 = 0;
                    int n3 = ((MouseWheelEvent)mouseEvent).getWheelRotation();
                    n2 = n3 < 0 ? (n2 |= mouseEvent.isShiftDown() ? 32 : 8) : (n2 |= mouseEvent.isShiftDown() ? 64 : 16);
                    Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                    for (int i = 0; i < Math.abs(n3); ++i) {
                        this.handlePointerEvent(point, n | n2);
                        this.handlePointerEvent(point, n);
                    }
                    return 1;
                }
                this.handlePointerEvent(new Point(mouseEvent.getX(), mouseEvent.getY()), n);
                return 1;
            }
        }
        return -1;
    }

    private PlatformPixelBuffer createFramebuffer(PixelFormat pixelFormat, int n, int n2) {
        JavaPixelBuffer javaPixelBuffer = new JavaPixelBuffer(n, n2);
        return javaPixelBuffer;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Image image = this.frameBuffer.getImage();
        synchronized (image) {
            if (this.cc.server.width() != this.scaledWidth || this.cc.server.height() != this.scaledHeight) {
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.drawImage(this.frameBuffer.getImage(), 0, 0, this.scaledWidth, this.scaledHeight, null);
            } else {
                graphics2D.drawImage(this.frameBuffer.getImage(), 0, 0, null);
            }
        }
        graphics2D.dispose();
    }

    public void setScaledSize(int n, int n2) {
        assert (n != 0 && n2 != 0);
        String string = Parameters.scalingFactor.getValue();
        if (Parameters.remoteResize.getValue()) {
            this.scaledWidth = n;
            this.scaledHeight = n2;
            this.scaleRatioX = 1.0f;
            this.scaleRatioY = 1.0f;
        } else {
            if (string.matches("^[0-9]+$")) {
                int n3 = Integer.parseInt(string);
                this.scaledWidth = (int)Math.floor((double)((float)n * (float)n3) / 100.0);
                this.scaledHeight = (int)Math.floor((double)((float)n2 * (float)n3) / 100.0);
            } else if (string.equalsIgnoreCase("Auto")) {
                this.scaledWidth = n;
                this.scaledHeight = n2;
            } else {
                float f = (float)n / (float)this.cc.server.width();
                float f2 = (float)n2 / (float)this.cc.server.height();
                float f3 = Math.min(f, f2);
                this.scaledWidth = (int)Math.floor((float)this.cc.server.width() * f3);
                this.scaledHeight = (int)Math.floor((float)this.cc.server.height() * f3);
            }
            this.scaleRatioX = (float)this.scaledWidth / (float)this.cc.server.width();
            this.scaleRatioY = (float)this.scaledHeight / (float)this.cc.server.height();
        }
        if (this.scaledWidth != this.getWidth() || this.scaledHeight != this.getHeight()) {
            this.setSize(new Dimension(this.scaledWidth, this.scaledHeight));
        }
    }

    private void handlePointerEvent(Point point, int n) {
        if (!Parameters.viewOnly.getValue()) {
            if (n != this.lastButtonMask || !point.equals(this.lastPointerPos)) {
                try {
                    if (this.cc.server.width() != this.scaledWidth || this.cc.server.height() != this.scaledHeight) {
                        int n2 = (double)this.scaleRatioX == 1.0 ? point.x : (int)Math.floor((float)point.x / this.scaleRatioX);
                        int n3 = (double)this.scaleRatioY == 1.0 ? point.y : (int)Math.floor((float)point.y / this.scaleRatioY);
                        point = point.translate(new Point(n2 - point.x, n3 - point.y));
                    }
                    this.cc.writer().writePointerEvent(point, n);
                }
                catch (Exception exception) {
                    vlog.error("%s", exception.getMessage());
                    this.cc.close();
                }
            }
            this.lastPointerPos = point;
            this.lastButtonMask = n;
        }
    }

    public void handleKeyPress(int n, int n2) {
        if (this.menuKeySym != 0 && n2 == this.menuKeySym && !this.menuRecursion) {
            this.popupContextMenu();
            return;
        }
        if (Parameters.viewOnly.getValue()) {
            return;
        }
        if (n == 0) {
            vlog.error("No key code specified on key press", new Object[0]);
            return;
        }
        if (VncViewer.os.startsWith("mac os x")) {
            switch (n2) {
                case 65511: {
                    n2 = 65513;
                    break;
                }
                case 65512: {
                    n2 = 65515;
                    break;
                }
                case 65513: {
                    n2 = 65406;
                    break;
                }
                case 65514: {
                    n2 = 65027;
                }
            }
        }
        if (VncViewer.os.startsWith("windows") && this.downKeySym.containsValue(65507) && this.downKeySym.containsValue(65514)) {
            vlog.debug("Faking release of AltGr (Ctrl_L+Alt_R)", new Object[0]);
            try {
                this.cc.writer().writeKeyEvent(65507, false);
                this.cc.writer().writeKeyEvent(65514, false);
            }
            catch (Exception exception) {
                vlog.error("%s", exception.getMessage());
                this.cc.close();
            }
        }
        this.downKeySym.put(n, n2);
        vlog.debug("Key pressed: 0x%04x => 0x%04x", n, n2);
        try {
            if (n > 65535) {
                this.cc.writer().writeKeyEvent(n2, true);
            } else {
                this.cc.writer().writeKeyEvent(n2, true);
            }
        }
        catch (Exception exception) {
            vlog.error("%s", exception.getMessage());
            this.cc.close();
        }
        if (VncViewer.os.startsWith("windows") && this.downKeySym.containsValue(65507) && this.downKeySym.containsValue(65514)) {
            vlog.debug("Restoring AltGr state", new Object[0]);
            try {
                this.cc.writer().writeKeyEvent(65507, true);
                this.cc.writer().writeKeyEvent(65514, true);
            }
            catch (Exception exception) {
                vlog.error("%s", exception.getMessage());
                this.cc.close();
            }
        }
    }

    public void handleKeyRelease(int n) {
        if (Parameters.viewOnly.getValue()) {
            return;
        }
        Integer n2 = (Integer)this.downKeySym.get(n);
        if (n2 == null) {
            vlog.debug("Unexpected release of key code %d", n);
            return;
        }
        vlog.debug("Key released: 0x%04x => 0x%04x", n, n2);
        try {
            if (n > 65535) {
                this.cc.writer().writeKeyEvent(n2, false);
            } else {
                this.cc.writer().writeKeyEvent(n2, false);
            }
        }
        catch (Exception exception) {
            vlog.error("%s", exception.getMessage());
            this.cc.close();
        }
        this.downKeySym.remove(n);
    }

    private int handleSystemEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (keyEvent.getKeyCode() == 0) {
                vlog.debug("Ignoring KeyEvent with unknown Java keycode", new Object[0]);
                return 0;
            }
            if (keyEvent.getID() == 401) {
                int n;
                int n2 = keyEvent.getKeyCode() | keyEvent.getKeyLocation() << 16;
                if (VncViewer.os.startsWith("windows") && this.downKeySym.containsValue(65507) && this.downKeySym.containsValue(65514)) {
                    n = keyEvent.getModifiers();
                    n &= 0xFFFFFFFD;
                    n &= 0xFFFFFFF7;
                    AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStroke(keyEvent.getKeyCode(), n |= 0x20);
                    keyEvent = new KeyEvent((JComponent)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), n, keyEvent.getKeyCode(), aWTKeyStroke.getKeyChar(), keyEvent.getKeyLocation());
                }
                if ((n = KeyMap.vkey_to_keysym(keyEvent)) == 0) {
                    vlog.error("No symbol for virtual key 0x%02x", n2);
                }
                if (VncViewer.os.startsWith("linux")) {
                    switch (n) {
                        case 65517: {
                            n = 65515;
                            break;
                        }
                        case 65518: {
                            n = 65516;
                            break;
                        }
                        case 65056: {
                            n = 65289;
                        }
                    }
                }
                this.handleKeyPress(n2, n);
                if (VncViewer.os.startsWith("mac os x") && n == 65509) {
                    this.handleKeyRelease(n2);
                }
                return 1;
            }
            if (keyEvent.getID() == 402) {
                int n = keyEvent.getKeyCode() | keyEvent.getKeyLocation() << 16;
                this.handleKeyRelease(n);
                return 1;
            }
        }
        return 0;
    }

    private void initContextMenu() {
        this.contextMenu.setLightWeightPopupEnabled(false);
        this.contextMenu.removeAll();
        Viewport.menu_add(this.contextMenu, "Exit viewer", 88, this, ID.EXIT, EnumSet.of(MENU.DIVIDER));
        Viewport.menu_add(this.contextMenu, "Full screen", 70, this, ID.FULLSCREEN, this.window().fullscreen_active() ? EnumSet.of(MENU.TOGGLE, MENU.VALUE) : EnumSet.of(MENU.TOGGLE));
        Viewport.menu_add(this.contextMenu, "Minimize", 90, this, ID.MINIMIZE, EnumSet.noneOf(MENU.class));
        Viewport.menu_add(this.contextMenu, "Resize window to session", 87, this, ID.RESIZE, this.window().fullscreen_active() ? EnumSet.of(MENU.INACTIVE, MENU.DIVIDER) : EnumSet.of(MENU.DIVIDER));
        Viewport.menu_add(this.contextMenu, "Clipboard viewer...", 0, this, ID.CLIPBOARD, EnumSet.of(MENU.DIVIDER));
        Viewport.menu_add(this.contextMenu, "Ctrl", 67, this, ID.CTRL, this.menuCtrlKey ? EnumSet.of(MENU.TOGGLE, MENU.VALUE) : EnumSet.of(MENU.TOGGLE));
        Viewport.menu_add(this.contextMenu, "Alt", 65, this, ID.ALT, this.menuAltKey ? EnumSet.of(MENU.TOGGLE, MENU.VALUE) : EnumSet.of(MENU.TOGGLE));
        if (this.menuKeySym != 0) {
            String string = String.format("Send %s", Parameters.menuKey.getValueStr());
            Viewport.menu_add(this.contextMenu, string, this.menuKeyJava, this, ID.MENUKEY, EnumSet.noneOf(MENU.class));
        }
        Viewport.menu_add(this.contextMenu, "Send Ctrl-Alt-Del", 68, this, ID.CTRLALTDEL, EnumSet.of(MENU.DIVIDER));
        Viewport.menu_add(this.contextMenu, "Refresh screen", 82, this, ID.REFRESH, EnumSet.of(MENU.DIVIDER));
        Viewport.menu_add(this.contextMenu, "New connection...", 78, this, ID.NEWVIEWER, EnumSet.of(MENU.DIVIDER));
        Viewport.menu_add(this.contextMenu, "Options...", 79, this, ID.OPTIONS, EnumSet.noneOf(MENU.class));
        Viewport.menu_add(this.contextMenu, "Connection info...", 73, this, ID.INFO, EnumSet.noneOf(MENU.class));
        Viewport.menu_add(this.contextMenu, "About TigerVNC viewer...", 84, this, ID.ABOUT, EnumSet.of(MENU.DIVIDER));
        Viewport.menu_add(this.contextMenu, "Dismiss menu", 77, this, ID.DISMISS, EnumSet.noneOf(MENU.class));
    }

    static void menu_add(JPopupMenu jPopupMenu, String string, int n, ActionListener actionListener, ID iD, EnumSet<MENU> enumSet) {
        JMenuItem jMenuItem = enumSet.contains((Object)MENU.TOGGLE) ? new JCheckBoxMenuItem(string, enumSet.contains((Object)MENU.VALUE)) : (n != 0 ? new JMenuItem(string, n) : new JMenuItem(string));
        jMenuItem.setActionCommand(iD.toString());
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setEnabled(!enumSet.contains((Object)MENU.INACTIVE));
        jPopupMenu.add(jMenuItem);
        if (enumSet.contains((Object)MENU.DIVIDER)) {
            jPopupMenu.addSeparator();
        }
    }

    void popupContextMenu() {
        this.initContextMenu();
        this.contextMenu.setCursor(Cursor.getDefaultCursor());
        this.contextMenu.show(this, this.lastPointerPos.x, this.lastPointerPos.y);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (ID.valueOf(actionEvent.getActionCommand())) {
            case EXIT: {
                this.cc.close();
                break;
            }
            case FULLSCREEN: {
                if (this.window().fullscreen_active()) {
                    this.window().fullscreen_off();
                    break;
                }
                this.window().fullscreen_on();
                break;
            }
            case MINIMIZE: {
                if (this.window().fullscreen_active()) {
                    this.window().fullscreen_off();
                }
                this.window().setExtendedState(1);
                break;
            }
            case RESIZE: {
                if (this.window().fullscreen_active()) break;
                int n = this.window().getInsets().left + this.window().getInsets().right;
                int n2 = this.window().getInsets().top + this.window().getInsets().bottom;
                this.window().setSize(this.getWidth() + n, this.getHeight() + n2);
                break;
            }
            case CLIPBOARD: {
                ClipboardDialog.showDialog(this.window());
                break;
            }
            case CTRL: {
                if (((JMenuItem)actionEvent.getSource()).isSelected()) {
                    this.handleKeyPress(29, 65507);
                } else {
                    this.handleKeyRelease(29);
                }
                this.menuCtrlKey = !this.menuCtrlKey;
                break;
            }
            case ALT: {
                if (((JMenuItem)actionEvent.getSource()).isSelected()) {
                    this.handleKeyPress(56, 65513);
                } else {
                    this.handleKeyRelease(56);
                }
                this.menuAltKey = !this.menuAltKey;
                break;
            }
            case MENUKEY: {
                this.menuRecursion = true;
                this.handleKeyPress(this.menuKeyCode, this.menuKeySym);
                this.menuRecursion = false;
                this.handleKeyRelease(this.menuKeyCode);
                break;
            }
            case CTRLALTDEL: {
                this.handleKeyPress(29, 65507);
                this.handleKeyPress(56, 65513);
                this.handleKeyPress(211, 65535);
                this.handleKeyRelease(211);
                this.handleKeyRelease(56);
                this.handleKeyRelease(29);
                break;
            }
            case REFRESH: {
                this.cc.refreshFramebuffer();
                break;
            }
            case NEWVIEWER: {
                VncViewer.newViewer();
                break;
            }
            case OPTIONS: {
                OptionsDialog.showDialog(this.cc.desktop);
                break;
            }
            case INFO: {
                Window window = DesktopWindow.getFullScreenWindow();
                if (window != null) {
                    DesktopWindow.setFullScreenWindow(null);
                }
                JOptionPane jOptionPane = new JOptionPane(this.cc.connectionInfo(), -1, -1);
                JDialog jDialog = jOptionPane.createDialog(this.window(), "VNC connection info");
                jDialog.setIconImage(VncViewer.frameIcon);
                jDialog.setAlwaysOnTop(true);
                jDialog.setVisible(true);
                if (window == null) break;
                DesktopWindow.setFullScreenWindow(window);
                break;
            }
            case ABOUT: {
                VncViewer.about_vncviewer(this.cc.desktop);
                break;
            }
        }
    }

    private void setMenuKey() {
        this.menuKeyJava = MenuKey.getMenuKeyJavaCode();
        this.menuKeyCode = MenuKey.getMenuKeyCode();
        this.menuKeySym = MenuKey.getMenuKeySym();
    }

    public void handleOptions() {
        this.setMenuKey();
    }

    public void releaseDownKeys() {
        while (!this.downKeySym.isEmpty()) {
            this.handleKeyRelease((Integer)this.downKeySym.keySet().iterator().next());
        }
    }

    private DesktopWindow window() {
        return (DesktopWindow)this.getTopLevelAncestor();
    }

    private int x() {
        return this.getX();
    }

    private int y() {
        return this.getY();
    }

    private int w() {
        return this.getWidth();
    }

    private int h() {
        return this.getHeight();
    }

    private class DownMap
    extends HashMap<Integer, Integer> {
        public DownMap(int n) {
            super(n);
        }
    }

    static enum MENU {
        INACTIVE,
        TOGGLE,
        VALUE,
        RADIO,
        INVISIBLE,
        SUBMENU_POINTER,
        SUBMENU,
        DIVIDER;

    }

    static enum ID {
        EXIT,
        FULLSCREEN,
        MINIMIZE,
        RESIZE,
        NEWVIEWER,
        CTRL,
        ALT,
        MENUKEY,
        CTRLALTDEL,
        CLIPBOARD,
        REFRESH,
        OPTIONS,
        INFO,
        ABOUT,
        DISMISS;

    }
}

