import hl = require('../highLevelAST');
/**
 * __$helperMethod__
 * Retrieve an ordered list of all uri parameters including those which are not described in the `uriParameters` node.
 * Consider a fragment of RAML specification:
 * ```yaml
 * /resource/{objectId}/{propertyId}:
 *   uriParameters:
 *     objectId:
 * ```
 * Here `propertyId` uri parameter is not described in the `uriParameters` node,
 * but it is among Resource.allUriParameters().
 * __$meta__={"name":"allUriParameters","deprecated":true}
 */
export declare function uriParameters(resource: hl.IHighLevelNode, serializeMetadata?: boolean): hl.IHighLevelNode[];
/**
 * __$helperMethod__
 * Retrieve an ordered list of all base uri parameters regardless of whether they are described in `baseUriParameters` or not
 * Consider a fragment of RAML specification:
 * ```yaml
 * version: v1
 * baseUri: https://{organization}.example.com/{version}/{service}
 * baseUriParameters:
 *   service:
 * ```
 * Here `version` and `organization` are base uri parameters which are not described in the `baseUriParameters` node,
 * but they are among `Api.allBaseUriParameters()`.
 * __$meta__={"name":"allBaseUriParameters","deprecated":true}
 */
export declare function baseUriParameters(api: hl.IHighLevelNode, serializeMetadata?: boolean): hl.IHighLevelNode[];
export declare function completeRelativeUri(res: hl.IHighLevelNode): string;
export declare function absoluteUri(res: hl.IHighLevelNode): string;
/**
 * __$helperMethod__
 * __$meta__={"name":"example","primary":true}
 */
export declare function typeExample(node: hl.IHighLevelNode, dumpXMLRepresentationOfExamples?: boolean): any;
/**
 * __$helperMethod__
 * __$meta__={"name":"examples","primary":true}
 */
export declare function typeExamples(node: hl.IHighLevelNode, dumpXMLRepresentationOfExamples?: boolean): any;
export declare function dumpExpandableExample(ex: any, dumpXMLRepresentationOfExamples?: boolean): any;
/**
 * __$helperMethod__ Retrieve all traits including those defined in libraries
 * __$meta__{"deprecated":true}
 */
export declare function allTraits(hlNode: hl.IHighLevelNode, serializeMetadata?: boolean): hl.IHighLevelNode[];
/**
 * __$helperMethod__ Retrieve all resource types including those defined in libraries
 * __$meta__{"deprecated":true}
 */
export declare function allResourceTypes(hlNode: hl.IHighLevelNode, serializeMetadata?: boolean): hl.IHighLevelNode[];
/**
 * __$helperMethod__
 * __$meta__={"primary":true}
 **/
export declare function schemaContent08(bodyDeclaration: hl.IHighLevelNode): hl.IAttribute;
export declare function schemaContent08Internal(bodyDeclaration: hl.IHighLevelNode, cache?: {
    [key: string]: hl.IHighLevelNode;
}): hl.IAttribute;
/**
 * __$helperMethod__
 * __$meta__={"name":"parametrizedProperties","primary":true}
 */
export declare function getTemplateParametrizedProperties(node: hl.IHighLevelNode): any;
/**
 * __$helperMethod__
 * __$meta__={"name":"fixedFacets","primary":true}
 */
export declare function typeFixedFacets(td: hl.IHighLevelNode): any[];
