/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SystemAction
extends SharedClassObject
implements Action,
HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(SystemAction.class.getName());
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_ICON = "icon";
    private static final String PROP_ICON_TEXTUAL = "iconTextual";
    private static Icon BLANK_ICON = new Icon(){

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    };
    private static final Set<String> relativeIconResourceClasses = new HashSet<String>(200);
    private static final long serialVersionUID = -8361232596876856810L;

    public static <T extends SystemAction> T get(Class<T> clazz) {
        return (T)((SystemAction)SystemAction.findObject(clazz, true));
    }

    public abstract String getName();

    @Override
    public abstract HelpCtx getHelpCtx();

    @Override
    public boolean isEnabled() {
        return this.getProperty(PROP_ENABLED).equals(Boolean.TRUE);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.putProperty(PROP_ENABLED, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    @Override
    public final void putValue(String string, Object object) {
        this.putProperty(string, object, true);
    }

    @Override
    public final Object getValue(String string) {
        if ("iconBase".equals(string)) {
            return this.iconResource();
        }
        Object object = this.getProperty(string);
        if (object == null) {
            if ("Name".equals(string)) {
                object = this.getName();
            } else if ("SmallIcon".equals(string)) {
                object = this.getIcon();
            }
        }
        return object;
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Override
    protected void initialize() {
        this.putProperty(PROP_ENABLED, Boolean.TRUE);
        super.initialize();
    }

    @Override
    protected boolean clearSharedData() {
        return false;
    }

    public final void setIcon(Icon icon) {
        this.putProperty(PROP_ICON, icon, true);
        this.putProperty(PROP_ICON_TEXTUAL, icon);
    }

    public final Icon getIcon() {
        return this.getIcon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Icon getIcon(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            String string;
            Icon icon = (Icon)this.getProperty(bl ? PROP_ICON_TEXTUAL : PROP_ICON);
            if (icon == null && (string = this.iconResource()) != null) {
                Object object2;
                if (string.indexOf(47) == -1) {
                    object2 = this.getClass().getName();
                    URL uRL = this.getClass().getResource(string);
                    if (uRL != null) {
                        icon = new ImageIcon(uRL);
                        if (relativeIconResourceClasses.add((String)object2)) {
                            LOG.warning("Deprecated relative path in " + (String)object2 + ".iconResource (cf. #20072)");
                        }
                    } else {
                        LOG.warning("No such icon from " + (String)object2 + ": " + string);
                    }
                } else {
                    object2 = Utilities.loadImage(string, true);
                    if (object2 != null) {
                        icon = new ImageIcon((Image)object2);
                    } else {
                        URL uRL = this.getClass().getResource(string);
                        String string2 = this.getClass().getName();
                        if (uRL != null) {
                            icon = new ImageIcon(uRL);
                            if (relativeIconResourceClasses.add(string2)) {
                                LOG.warning("Deprecated relative path in " + string2 + ".iconResource (cf. #26887)");
                            }
                        } else {
                            LOG.warning("No such icon from " + string2 + ": " + string);
                        }
                    }
                }
                this.putProperty(PROP_ICON, icon);
                this.putProperty(PROP_ICON_TEXTUAL, icon);
            }
            if (icon == null) {
                if (bl) {
                    int n;
                    string = this.getName();
                    if (string.endsWith("...")) {
                        string = string.substring(0, string.length() - 3);
                    }
                    if ((n = (string = string.trim()).indexOf(38)) != -1) {
                        string = new StringBuffer(string).deleteCharAt(n).toString();
                    }
                    icon = new ComponentIcon(new JLabel(string));
                    this.putProperty(PROP_ICON_TEXTUAL, icon);
                } else {
                    icon = BLANK_ICON;
                    this.putProperty(PROP_ICON, icon);
                }
            }
            return icon;
        }
    }

    protected String iconResource() {
        return null;
    }

    public static JToolBar createToolbarPresenter(SystemAction[] systemActionArray) {
        JToolBar jToolBar = new JToolBar();
        for (SystemAction systemAction : systemActionArray) {
            if (systemAction == null) {
                jToolBar.addSeparator();
                continue;
            }
            if (!(systemAction instanceof Presenter.Toolbar)) continue;
            jToolBar.add(((Presenter.Toolbar)((Object)systemAction)).getToolbarPresenter());
        }
        return jToolBar;
    }

    public static SystemAction[] linkActions(SystemAction[] systemActionArray, SystemAction[] systemActionArray2) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(Arrays.asList(systemActionArray));
        arrayList.addAll(Arrays.asList(systemActionArray2));
        return arrayList.toArray(systemActionArray);
    }

    @Deprecated
    public static JPopupMenu createPopupMenu(SystemAction[] systemActionArray) {
        return Utilities.actionsToPopup((Action[])systemActionArray, Utilities.actionsGlobalContext());
    }

    private static class ComponentIcon
    extends ImageIcon {
        private JComponent comp;
        private BufferedImage image;

        public ComponentIcon(JComponent jComponent) {
            if (jComponent.getParent() != null) {
                throw new IllegalArgumentException();
            }
            this.comp = jComponent;
            Dimension dimension = jComponent.getPreferredSize();
            jComponent.setSize(Math.max(dimension.width, 16), Math.max(dimension.height, 16));
        }

        protected void loadImage(Image image) {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.comp.setBackground(component.getBackground());
            this.comp.setForeground(component.getForeground());
            Graphics graphics2 = graphics.create(n, n2, this.getIconWidth(), this.getIconHeight());
            this.comp.paint(graphics2);
        }

        public int getIconWidth() {
            return this.comp.getWidth();
        }

        public int getIconHeight() {
            return this.comp.getHeight();
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.comp.setForeground(Color.black);
                this.comp.paint(this.image.getGraphics());
            }
            return this.image;
        }
    }
}

