/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;
import junit.framework.TestCase;

public class ExifDirectoryTest
extends TestCase {
    public ExifDirectoryTest(String s) {
        super(s);
    }

    public void testGetDirectoryName() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(ExifDirectory.class);
        ExifDirectoryTest.assertEquals((String)"Exif", (String)directory.getName());
    }

    public void testGetThumbnailData() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(file);
        ExifDirectory exifDirectory = (ExifDirectory)metadata.getDirectory(ExifDirectory.class);
        ExifDirectoryTest.assertTrue((boolean)exifDirectory.containsTag(61441));
        byte[] thumbData = exifDirectory.getThumbnailData();
        try {
            new JpegSegmentReader(thumbData);
        }
        catch (JpegProcessingException e) {
            ExifDirectoryTest.fail((String)"Unable to construct JpegSegmentReader from thumbnail data");
        }
    }

    public void testWriteThumbnail() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(file);
        ExifDirectory exifDirectory = (ExifDirectory)metadata.getDirectory(ExifDirectory.class);
        ExifDirectoryTest.assertTrue((boolean)exifDirectory.containsTag(61441));
        File thumbnailFile = File.createTempFile("thumbnail", ".jpg");
        try {
            exifDirectory.writeThumbnail(thumbnailFile.getAbsolutePath());
            ExifDirectoryTest.assertTrue((boolean)new File(thumbnailFile.getAbsolutePath()).exists());
        }
        finally {
            thumbnailFile.delete();
        }
    }

    public void testContainsThumbnail() {
        ExifDirectory exifDirectory = new ExifDirectory();
        ExifDirectoryTest.assertTrue((!exifDirectory.containsThumbnail() ? 1 : 0) != 0);
        exifDirectory.setObject(61441, "foo");
        ExifDirectoryTest.assertTrue((boolean)exifDirectory.containsThumbnail());
    }
}

