/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;

public abstract class FeatureUsage {
    private final String summary;
    private final Class<?> calledFrom;
    private final Exception traceException;
    private List<StackTraceElement> stack;

    protected FeatureUsage(String summary, Class<?> calledFrom) {
        this(summary, calledFrom, new Exception());
    }

    @VisibleForTesting
    protected FeatureUsage(String summary, Class<?> calledFrom, Exception traceException) {
        this.summary = summary;
        this.calledFrom = calledFrom;
        this.traceException = traceException;
    }

    public String getSummary() {
        return this.summary;
    }

    protected Class<?> getCalledFrom() {
        return this.calledFrom;
    }

    public List<StackTraceElement> getStack() {
        if (this.stack == null) {
            this.stack = FeatureUsage.calculateStack(this.calledFrom, this.traceException);
        }
        return this.stack;
    }

    private static List<StackTraceElement> calculateStack(Class<?> calledFrom, Exception traceRoot) {
        int caller;
        StackTraceElement[] originalStack = traceRoot.getStackTrace();
        String calledFromName = calledFrom.getName();
        boolean calledFromFound = false;
        for (caller = 0; caller < originalStack.length; ++caller) {
            StackTraceElement current = originalStack[caller];
            if (!calledFromFound) {
                if (!current.getClassName().startsWith(calledFromName)) continue;
                calledFromFound = true;
                continue;
            }
            if (!current.getClassName().startsWith(calledFromName)) break;
        }
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        for (caller = FeatureUsage.skipSystemStackElements(originalStack, caller); caller < originalStack.length; ++caller) {
            result.add(originalStack[caller]);
        }
        return result;
    }

    private static int skipSystemStackElements(StackTraceElement[] stackTrace, int caller) {
        String currentClassName;
        while (caller < stackTrace.length && ((currentClassName = stackTrace[caller].getClassName()).startsWith("org.codehaus.groovy.") || currentClassName.startsWith("org.gradle.internal.metaobject.") || currentClassName.startsWith("groovy.") || currentClassName.startsWith("java.") || currentClassName.startsWith("jdk.internal."))) {
            ++caller;
        }
        return caller;
    }

    public String formattedMessage() {
        return this.summary;
    }
}

