export = RemoteRoom;
/**
 * Create a remote room.
 * @constructor
 * @param {string} identifier The ID for this room
 * @param {Object=} data The key-value data object to assign to this room.
 */
declare function RemoteRoom(identifier: string, data?: Object | undefined): void;
declare class RemoteRoom {
    /**
     * Create a remote room.
     * @constructor
     * @param {string} identifier The ID for this room
     * @param {Object=} data The key-value data object to assign to this room.
     */
    constructor(identifier: string, data?: Object | undefined);
    roomId: string;
    data: Object;
    getId(): string;
    serialize(): Object;
    get(key: string): any;
    set(key: string, val: any): void;
}
