/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.io.FileUtils;

public class ByteUnitUtil {
    private static final int DIVISION_SCALE = 2;
    private static final RoundingMode ROUNDING_MODE = RoundingMode.DOWN;

    public static String byteCountToDisplaySize(long fileSize) {
        return ByteUnitUtil.byteCountToDisplaySize(BigInteger.valueOf(fileSize));
    }

    public static String byteCountToDisplaySize(BigInteger fileSizeBytes) {
        ByteUnit byteUnit = ByteUnitUtil.getMatchingUnitRange(fileSizeBytes);
        BigDecimal fileSizeInUnit = ByteUnitUtil.getFileSizeInUnit(fileSizeBytes, byteUnit);
        String numberAsText = ByteUnitUtil.getRoundedFileSizeInUnit(fileSizeInUnit);
        numberAsText = ByteUnitUtil.prettyPrintRoundedFileSizeInUnit(numberAsText);
        String byteUnitName = byteUnit.unitName();
        return String.format("%s %s", numberAsText, byteUnitName);
    }

    private static ByteUnit getMatchingUnitRange(BigInteger fileSizeBytes) {
        int bitLength = fileSizeBytes.bitLength();
        ByteUnit byteUnitRaw = ByteUnit.fromBitLength(bitLength);
        BigInteger bytesRawUnit = byteUnitRaw.byteCount();
        BigInteger thousandTimesRawUnit = bytesRawUnit.multiply(BigInteger.valueOf(1000L));
        if (fileSizeBytes.compareTo(thousandTimesRawUnit) >= 0) {
            return byteUnitRaw.next();
        }
        return byteUnitRaw;
    }

    private static BigDecimal getFileSizeInUnit(BigInteger fileSizeBytes, ByteUnit byteUnit) {
        BigDecimal fileSizeBytes_bd = new BigDecimal(fileSizeBytes);
        BigDecimal byteUnitCount_bd = new BigDecimal(byteUnit.byteCount());
        return fileSizeBytes_bd.divide(byteUnitCount_bd, 2, ROUNDING_MODE);
    }

    private static String getRoundedFileSizeInUnit(BigDecimal fileSizeInUnit) {
        if (fileSizeInUnit.compareTo(BigDecimal.valueOf(100.0)) >= 0) {
            return fileSizeInUnit.setScale(0, ROUNDING_MODE).toString();
        }
        if (fileSizeInUnit.compareTo(BigDecimal.valueOf(10.0)) >= 0) {
            return fileSizeInUnit.setScale(1, ROUNDING_MODE).toString();
        }
        return fileSizeInUnit.setScale(2, ROUNDING_MODE).toString();
    }

    private static String prettyPrintRoundedFileSizeInUnit(String val) {
        if (val.endsWith(".00")) {
            return val.substring(0, val.length() - 3);
        }
        if (val.endsWith(".0")) {
            return val.substring(0, val.length() - 2);
        }
        return val;
    }

    static enum ByteUnit {
        BYTE("bytes", BigInteger.ONE),
        KILOBYTE("kB", FileUtils.ONE_KB_BI),
        MEGABYTE("MB", FileUtils.ONE_MB_BI),
        GIGABYTE("GB", FileUtils.ONE_GB_BI),
        TERABYTE("TB", FileUtils.ONE_TB_BI),
        PETABYTE("PB", FileUtils.ONE_PB_BI),
        EXABYTE("EB", FileUtils.ONE_EB_BI),
        ZETTABYTE("ZB", FileUtils.ONE_ZB),
        YOTTABYTE("YB", FileUtils.ONE_YB);

        private final String unitName;
        private final BigInteger byteCount;

        private ByteUnit(String unitName, BigInteger byteCount) {
            this.unitName = unitName;
            this.byteCount = byteCount;
        }

        static ByteUnit fromBitLength(int bitLength) {
            int ordinalRaw = Math.max(bitLength - 1, 0) / 10;
            int ordinal = Math.min(ordinalRaw, ByteUnit.values().length - 1);
            return ByteUnit.values()[ordinal];
        }

        ByteUnit previous() {
            return ByteUnit.values()[Math.max(this.ordinal() - 1, 0)];
        }

        ByteUnit next() {
            return ByteUnit.values()[Math.min(this.ordinal() + 1, ByteUnit.values().length - 1)];
        }

        private String unitName() {
            return this.unitName;
        }

        private BigInteger byteCount() {
            return this.byteCount;
        }
    }
}

