/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.Pattern2;

public abstract class MyPattern {
    public static Pattern2 cmpile(String p) {
        p = MyPattern.transformAndCheck(p);
        return new Pattern2(Pattern.compile(p));
    }

    public static Pattern2 cmpileNockeck(String p) {
        p = MyPattern.transform(p);
        return new Pattern2(Pattern.compile(p));
    }

    public static Pattern2 cmpile(String p, int type) {
        p = MyPattern.transformAndCheck(p);
        return new Pattern2(Pattern.compile(p, type));
    }

    public static Pattern2 cmpileNockeck(String p, int type) {
        p = MyPattern.transform(p);
        return new Pattern2(Pattern.compile(p, type));
    }

    private static String transformAndCheck(String p) {
        p = MyPattern.transform(p);
        return p;
    }

    private static String transform(String p) {
        p = p.replaceAll("%s", "\\\\s\u00a0");
        p = p.replaceAll("%q", "'\u2018\u2019");
        p = p.replaceAll("%g", "\"\u201c\u201d\u00ab\u00bb");
        return p;
    }

    public static boolean mtches(CharSequence input, String regex) {
        return MyPattern.cmpile(regex).matcher(input).matches();
    }

    public static CharSequence removeAll(CharSequence src, String regex) {
        return src.toString().replaceAll(MyPattern.transform(regex), "");
    }
}

