/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;

public class ClockwiseTopRightBottomLeft {
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;

    public static ClockwiseTopRightBottomLeft same(double value) {
        return new ClockwiseTopRightBottomLeft(value, value, value, value);
    }

    public static ClockwiseTopRightBottomLeft none() {
        return new ClockwiseTopRightBottomLeft(0.0, 0.0, 0.0, 0.0);
    }

    public static ClockwiseTopRightBottomLeft read(String value) {
        if (value.matches("[0-9 ]+")) {
            String[] split = value.split(" +");
            if (split.length == 1) {
                double first = Integer.parseInt(split[0]);
                return new ClockwiseTopRightBottomLeft(first, first, first, first);
            }
            if (split.length == 2) {
                double first = Integer.parseInt(split[0]);
                double second = Integer.parseInt(split[1]);
                return new ClockwiseTopRightBottomLeft(first, second, first, second);
            }
            if (split.length == 3) {
                double first = Integer.parseInt(split[0]);
                double second = Integer.parseInt(split[1]);
                double third = Integer.parseInt(split[2]);
                return new ClockwiseTopRightBottomLeft(first, second, third, second);
            }
            if (split.length == 4) {
                double first = Integer.parseInt(split[0]);
                double second = Integer.parseInt(split[1]);
                double third = Integer.parseInt(split[2]);
                double forth = Integer.parseInt(split[3]);
                return new ClockwiseTopRightBottomLeft(first, second, third, forth);
            }
        }
        return ClockwiseTopRightBottomLeft.none();
    }

    public static ClockwiseTopRightBottomLeft margin1margin2(double margin1, double margin2) {
        return new ClockwiseTopRightBottomLeft(margin1, margin2, margin2, margin1);
    }

    private ClockwiseTopRightBottomLeft(double top, double right, double bottom, double left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public String toString() {
        return "" + this.top + ":" + this.right + ":" + this.bottom + ":" + this.left;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public static ClockwiseTopRightBottomLeft marginForDocument(StyleBuilder styleBuilder) {
        Style style = StyleSignature.of(SName.root, SName.document).getMergedStyle(styleBuilder);
        return style.getMargin();
    }
}

