/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.BaseFile;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.SkinParamForecolored;
import net.sourceforge.plantuml.SkinParamSameClassWidth;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.descdiagram.EntityImageDesignedDomain;
import net.sourceforge.plantuml.descdiagram.EntityImageDomain;
import net.sourceforge.plantuml.descdiagram.EntityImageMachine;
import net.sourceforge.plantuml.descdiagram.EntityImageRequirement;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.EntityImageDegenerated;
import net.sourceforge.plantuml.svek.EntityImageProtected;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Node;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekResult;
import net.sourceforge.plantuml.svek.image.EntityImageActivity;
import net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import net.sourceforge.plantuml.svek.image.EntityImageBranch;
import net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.svek.image.EntityImageDeepHistory;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage;
import net.sourceforge.plantuml.svek.image.EntityImageGroup;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImageMap;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.EntityImageObject;
import net.sourceforge.plantuml.svek.image.EntityImagePort;
import net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageState2;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import net.sourceforge.plantuml.svek.image.EntityImageTips;
import net.sourceforge.plantuml.svek.image.EntityImageUseCase;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class GeneralImageBuilder {
    private final DotData dotData;
    private final EntityFactory entityFactory;
    private final UmlSource source;
    private final Pragma pragma;
    private final boolean strictUmlStyle;
    private Map<String, Double> maxX;
    private final StringBounder stringBounder;
    private final boolean mergeIntricated;
    private final SName styleName;

    public static IEntityImage createEntityImageBlock(ILeaf leaf, ISkinParam skinParam, boolean isHideEmptyDescriptionForState, PortionShower portionShower, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType, Collection<Link> links) {
        if (leaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (leaf.getLeafType().isLikeClass()) {
            EntityImageClass entityImageClass = new EntityImageClass(graphvizVersion, leaf, skinParam, portionShower);
            Neighborhood neighborhood = leaf.getNeighborhood();
            if (neighborhood != null) {
                return new EntityImageProtected(entityImageClass, 20.0, neighborhood, bibliotekon);
            }
            return entityImageClass;
        }
        if (leaf.getLeafType() == LeafType.NOTE) {
            return new EntityImageNote(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.ACTIVITY) {
            return new EntityImageActivity(leaf, skinParam, bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.PORT || leaf.getLeafType() == LeafType.PORTIN || leaf.getLeafType() == LeafType.PORTOUT) {
            Cluster parent = bibliotekon.getCluster(leaf.getParentContainer());
            return new EntityImagePort(leaf, skinParam, parent, bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.STATE) {
            if (leaf.getEntityPosition() != EntityPosition.NORMAL) {
                Cluster stateParent = bibliotekon.getCluster(leaf.getParentContainer());
                return new EntityImageStateBorder(leaf, skinParam, stateParent, bibliotekon);
            }
            if (isHideEmptyDescriptionForState && leaf.getBodier().getFieldsToDisplay().size() == 0) {
                return new EntityImageStateEmptyDescription(leaf, skinParam);
            }
            if (leaf.getStereotype() != null && "<<sdlreceive>>".equals(leaf.getStereotype().getLabel(Guillemet.DOUBLE_COMPARATOR))) {
                return new EntityImageState2(leaf, skinParam);
            }
            return new EntityImageState(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE_START) {
            ColorParam param = ColorParam.activityStart;
            if (umlDiagramType == UmlDiagramType.STATE) {
                param = ColorParam.stateStart;
            }
            return new EntityImageCircleStart(leaf, skinParam, param);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE_END) {
            ColorParam param = ColorParam.activityEnd;
            if (umlDiagramType == UmlDiagramType.STATE) {
                param = ColorParam.stateEnd;
            }
            return new EntityImageCircleEnd(leaf, skinParam, param);
        }
        if (leaf.getLeafType() == LeafType.BRANCH || leaf.getLeafType() == LeafType.STATE_CHOICE) {
            return new EntityImageBranch(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.LOLLIPOP_FULL || leaf.getLeafType() == LeafType.LOLLIPOP_HALF) {
            return new EntityImageLollipopInterface(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE) {
            return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(), null);
        }
        if (leaf.getLeafType() == LeafType.DESCRIPTION) {
            UStroke forced = leaf.getUSymbol() == USymbol.PACKAGE ? GeneralImageBuilder.getForcedStroke(leaf.getStereotype(), skinParam) : null;
            return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(), forced);
        }
        if (leaf.getLeafType() == LeafType.USECASE) {
            return new EntityImageUseCase(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.OBJECT) {
            return new EntityImageObject(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.MAP) {
            return new EntityImageMap(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.SYNCHRO_BAR || leaf.getLeafType() == LeafType.STATE_FORK_JOIN) {
            return new EntityImageSynchroBar(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.ARC_CIRCLE) {
            return new EntityImageArcCircle(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(leaf, skinParam);
        }
        if (leaf.isGroup()) {
            return new EntityImageGroup(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.EMPTY_PACKAGE) {
            if (leaf.getUSymbol() != null) {
                HColor black = SkinParamUtils.getColor(skinParam, leaf.getStereotype(), leaf.getUSymbol().getColorParamBorder());
                return new EntityImageDescription(leaf, new SkinParamForecolored(skinParam, black), portionShower, links, umlDiagramType.getStyleName(), GeneralImageBuilder.getForcedStroke(leaf.getStereotype(), skinParam));
            }
            return new EntityImageEmptyPackage(leaf, skinParam, portionShower, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.ASSOCIATION) {
            return new EntityImageAssociation(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.PSEUDO_STATE) {
            return new EntityImagePseudoState(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.DEEP_HISTORY) {
            return new EntityImageDeepHistory(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.TIPS) {
            return new EntityImageTips(leaf, skinParam, bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isMachineOrSpecification()) {
            return new EntityImageMachine(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isDesignedOrSolved()) {
            return new EntityImageDesignedDomain(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.REQUIREMENT) {
            return new EntityImageRequirement(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isLexicalOrGiven()) {
            return new EntityImageDomain(leaf, skinParam, 'X');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isCausal()) {
            return new EntityImageDomain(leaf, skinParam, 'C');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isBiddableOrUncertain()) {
            return new EntityImageDomain(leaf, skinParam, 'B');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN) {
            return new EntityImageDomain(leaf, skinParam, 'P');
        }
        throw new UnsupportedOperationException(leaf.getLeafType().toString());
    }

    public static UStroke getForcedStroke(Stereotype stereotype, ISkinParam skinParam) {
        UStroke stroke = skinParam.getThickness(LineParam.packageBorder, stereotype);
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    public GeneralImageBuilder(boolean mergeIntricated, DotData dotData, EntityFactory entityFactory, UmlSource source, Pragma pragma, StringBounder stringBounder, SName styleName) {
        this.dotData = dotData;
        this.styleName = styleName;
        this.entityFactory = entityFactory;
        this.source = source;
        this.pragma = pragma;
        this.stringBounder = stringBounder;
        this.strictUmlStyle = dotData.getSkinParam().strictUmlStyle();
        this.mergeIntricated = mergeIntricated;
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, this.styleName, SName.arrow);
    }

    private boolean isOpalisable(IEntity entity) {
        if (this.strictUmlStyle) {
            return false;
        }
        return !entity.isGroup() && entity.getLeafType() == LeafType.NOTE && this.onlyOneLink(entity);
    }

    private HColor getBackcolor() {
        if (SkinParam.USE_STYLES()) {
            Style style = StyleSignature.of(SName.root, SName.document).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
            return style.value(PName.BackGroundColor).asColor(this.dotData.getSkinParam().getIHtmlColorSet());
        }
        return this.dotData.getSkinParam().getBackgroundColor(false);
    }

    public IEntityImage buildImage(BaseFile basefile, String[] dotStrings) {
        String svg;
        ILeaf single;
        Object group;
        if (this.dotData.isDegeneratedWithFewEntities(0)) {
            return new EntityImageSimpleEmpty(this.dotData.getSkinParam().getBackgroundColor(false));
        }
        if (this.dotData.isDegeneratedWithFewEntities(1) && this.dotData.getUmlDiagramType() != UmlDiagramType.STATE && (group = (single = this.dotData.getLeafs().iterator().next()).getParentContainer()) instanceof GroupRoot) {
            IEntityImage tmp = GeneralImageBuilder.createEntityImageBlock(single, this.dotData.getSkinParam(), this.dotData.isHideEmptyDescriptionForState(), this.dotData, null, null, this.dotData.getUmlDiagramType(), this.dotData.getLinks());
            return new EntityImageDegenerated(tmp, this.getBackcolor());
        }
        this.dotData.removeIrrelevantSametail();
        DotStringFactory dotStringFactory = new DotStringFactory(this.stringBounder, this.dotData);
        this.printGroups(dotStringFactory, this.dotData.getRootGroup());
        this.printEntities(dotStringFactory, this.getUnpackagedEntities());
        for (Link link : this.dotData.getLinks()) {
            if (link.isRemoved()) continue;
            try {
                Node other;
                Node node;
                FontConfiguration labelFont;
                ISkinParam skinParam = this.dotData.getSkinParam();
                if (SkinParam.USE_STYLES()) {
                    Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
                    labelFont = style.getFontConfiguration(skinParam.getIHtmlColorSet());
                } else {
                    labelFont = new FontConfiguration(skinParam, FontParam.ARROW, null);
                }
                Line line = new Line(link, dotStringFactory.getColorSequence(), skinParam, this.stringBounder, labelFont, dotStringFactory.getBibliotekon(), this.dotData.getPragma());
                dotStringFactory.getBibliotekon().addLine(line);
                if (this.isOpalisable(link.getEntity1())) {
                    node = dotStringFactory.getBibliotekon().getNode(link.getEntity1());
                    other = dotStringFactory.getBibliotekon().getNode(link.getEntity2());
                    if (other == null) continue;
                    ((EntityImageNote)node.getImage()).setOpaleLine(line, node, other);
                    line.setOpale(true);
                    continue;
                }
                if (!this.isOpalisable(link.getEntity2())) continue;
                node = dotStringFactory.getBibliotekon().getNode(link.getEntity2());
                other = dotStringFactory.getBibliotekon().getNode(link.getEntity1());
                if (other == null) continue;
                ((EntityImageNote)node.getImage()).setOpaleLine(line, node, other);
                line.setOpale(true);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        if (dotStringFactory.illegalDotExe()) {
            return this.error(dotStringFactory.getDotExe());
        }
        if (basefile == null && this.isSvekTrace()) {
            basefile = new BaseFile();
        }
        try {
            svg = dotStringFactory.getSvg(basefile, dotStrings);
        }
        catch (IOException e) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        if (svg.length() == 0) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        String graphvizVersion = this.extractGraphvizVersion(svg);
        try {
            dotStringFactory.solve(this.mergeIntricated, this.dotData.getEntityFactory(), svg);
            SvekResult result = new SvekResult(this.dotData, dotStringFactory);
            this.maxX = dotStringFactory.getBibliotekon().getMaxX();
            return result;
        }
        catch (Exception e) {
            Log.error("Exception " + e);
            throw new UnparsableGraphvizException(e, graphvizVersion, svg, this.source.getPlainString());
        }
    }

    private boolean isSvekTrace() {
        String value = this.pragma.getValue("svek_trace");
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    private String extractGraphvizVersion(String svg) {
        Pattern pGraph = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher mGraph = pGraph.matcher(svg);
        if (mGraph.find()) {
            return StringUtils.trin(mGraph.group(1));
        }
        return null;
    }

    private boolean onlyOneLink(IEntity ent) {
        int nb = 0;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis()) continue;
            if (link.contains(ent)) {
                ++nb;
            }
            if (nb <= 1) continue;
            return false;
        }
        return nb == 1;
    }

    private IEntityImage error(File dotExe) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Dot Executable: " + dotExe);
        ExeState exeState = ExeState.checkFile(dotExe);
        msg.add(exeState.getTextMessage());
        msg.add("Cannot find Graphviz. You should try");
        msg.add(" ");
        msg.add("@startuml");
        msg.add("testdot");
        msg.add("@enduml");
        msg.add(" ");
        msg.add(" or ");
        msg.add(" ");
        msg.add("java -jar plantuml.jar -testdot");
        msg.add(" ");
        return GraphicStrings.createForError(msg, false);
    }

    private void printEntities(DotStringFactory dotStringFactory, Collection<ILeaf> entities2) {
        for (ILeaf ent : entities2) {
            if (ent.isRemoved()) continue;
            this.printEntity(dotStringFactory, ent);
        }
    }

    private void printEntity(DotStringFactory dotStringFactory, ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage image = this.printEntityInternal(dotStringFactory, ent);
        Node node = dotStringFactory.getBibliotekon().createNode(ent, image, dotStringFactory.getColorSequence(), this.stringBounder);
        dotStringFactory.addNode(node);
    }

    private IEntityImage printEntityInternal(DotStringFactory dotStringFactory, ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.dotData.getSkinParam();
            if (skinParam.sameClassWidth()) {
                double width = this.getMaxWidth(dotStringFactory);
                skinParam = new SkinParamSameClassWidth(skinParam, width);
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, skinParam, this.dotData.isHideEmptyDescriptionForState(), this.dotData, dotStringFactory.getBibliotekon(), dotStringFactory.getGraphvizVersion(), this.dotData.getUmlDiagramType(), this.dotData.getLinks());
        }
        return ent.getSvekImage();
    }

    private double getMaxWidth(DotStringFactory dotStringFactory) {
        double result = 0.0;
        for (ILeaf ent : this.dotData.getLeafs()) {
            EntityImageClass im;
            double w;
            if (!ent.getLeafType().isLikeClass() || !((w = (im = new EntityImageClass(dotStringFactory.getGraphvizVersion(), ent, this.dotData.getSkinParam(), this.dotData)).calculateDimension(this.stringBounder).getWidth()) > result)) continue;
            result = w;
        }
        return result;
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> result = new ArrayList<ILeaf>();
        for (ILeaf ent : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private void printGroups(DotStringFactory dotStringFactory, IGroup parent) {
        Collection<IGroup> groups = this.dotData.getGroupHierarchy().getChildrenGroups(parent);
        for (IGroup g : groups) {
            if (g.isRemoved()) continue;
            if (this.dotData.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                ISkinParam skinParam = this.dotData.getSkinParam();
                this.entityFactory.thisIsGoingToBeALeaf(g.getIdent());
                ILeaf folder = this.entityFactory.createLeafForEmptyGroup(g, skinParam);
                this.printEntity(dotStringFactory, folder);
                continue;
            }
            this.printGroup(dotStringFactory, g);
        }
    }

    private void printGroup(DotStringFactory dotStringFactory, IGroup g) {
        IGroup intricated;
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        if (this.mergeIntricated && (intricated = this.dotData.getEntityFactory().isIntricated(g)) != null) {
            this.printGroup(dotStringFactory, intricated);
            return;
        }
        int titleAndAttributeWidth = 0;
        int titleAndAttributeHeight = 0;
        TextBlock title = this.getTitleBlock(g);
        TextBlock stereo = this.getStereoBlock(g);
        TextBlock stereoAndTitle = TextBlockUtils.mergeTB(stereo, title, HorizontalAlignment.CENTER);
        Dimension2D dimLabel = stereoAndTitle.calculateDimension(this.stringBounder);
        if (dimLabel.getWidth() > 0.0) {
            List<Member> members = g.getBodier().getFieldsToDisplay();
            AbstractTextBlock attribute = members.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(members, FontParam.STATE_ATTRIBUTE, this.dotData.getSkinParam(), g.getStereotype(), null, SName.stateDiagram);
            Dimension2D dimAttribute = attribute.calculateDimension(this.stringBounder);
            double attributeHeight = dimAttribute.getHeight();
            double attributeWidth = dimAttribute.getWidth();
            double marginForFields = attributeHeight > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = g.getUSymbol();
            int suppHeightBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int suppWidthBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            titleAndAttributeWidth = (int)Math.max(dimLabel.getWidth(), attributeWidth) + suppWidthBecauseOfShape;
            titleAndAttributeHeight = (int)(dimLabel.getHeight() + attributeHeight + marginForFields + (double)suppHeightBecauseOfShape);
        }
        dotStringFactory.openCluster(titleAndAttributeWidth, titleAndAttributeHeight, title, stereo, g);
        this.printEntities(dotStringFactory, g.getLeafsDirect());
        this.printGroups(dotStringFactory, g);
        dotStringFactory.closeCluster();
    }

    private TextBlock getTitleBlock(IGroup g) {
        Display label = g.getDisplay();
        if (label == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        ISkinParam skinParam = this.dotData.getSkinParam();
        FontConfiguration fontConfiguration = g.getFontConfigurationForTitle(skinParam);
        return label.create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
    }

    private TextBlock addLegend(TextBlock original, DisplayPositionned legend) {
        if (legend == null || legend.isNull()) {
            return original;
        }
        TextBlock legendBlock = EntityImageLegend.create(legend.getDisplay(), this.dotData.getSkinParam());
        return DecorateEntityImage.add(legendBlock, original, legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    private TextBlock getStereoBlock(IGroup g) {
        DisplayPositionned legend = g.getLegend();
        return this.addLegend(this.getStereoBlockWithoutLegend(g), legend);
    }

    private TextBlock getStereoBlockWithoutLegend(IGroup g) {
        Stereotype stereotype = g.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock tmp = stereotype.getSprite(this.dotData.getSkinParam());
        if (tmp != null) {
            return tmp;
        }
        List<String> stereos = stereotype.getLabels(this.dotData.getSkinParam().guillemet());
        if (stereos == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean show = this.dotData.showPortion(EntityPortion.STEREOTYPE, g);
        if (!show) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = FontParam.PACKAGE_STEREOTYPE;
        return Display.create(stereos).create(new FontConfiguration(this.dotData.getSkinParam(), fontParam, stereotype), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    public String getWarningOrError(int warningOrError) {
        if (this.maxX == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Double> ent : this.maxX.entrySet()) {
            if (!(ent.getValue() > (double)warningOrError)) continue;
            sb.append(ent.getKey() + " is overpassing the width limit.");
            sb.append("\n");
        }
        return sb.length() == 0 ? "" : sb.toString();
    }

    static class EntityImageSimpleEmpty
    implements IEntityImage {
        private final HColor backColor;

        EntityImageSimpleEmpty(HColor backColor) {
            this.backColor = backColor;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public HColor getBackcolor() {
            return this.backColor;
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            return new Dimension2DDouble(10.0, 10.0);
        }

        @Override
        public MinMax getMinMax(StringBounder stringBounder) {
            return MinMax.fromDim(this.calculateDimension(stringBounder));
        }

        @Override
        public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
            return null;
        }

        @Override
        public void drawU(UGraphic ug) {
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.RECTANGLE;
        }

        @Override
        public Margins getShield(StringBounder stringBounder) {
            return Margins.NONE;
        }

        @Override
        public double getOverscanX(StringBounder stringBounder) {
            return 0.0;
        }
    }
}

