export = AppServiceBot;
/**
 * Construct an AS bot user which has various helper methods.
 * @constructor
 * @param {MatrixClient} client The client instance configured for the AS bot.
 * @param {AppServiceRegistration} registration The registration that the bot
 * is following. Used to determine which user IDs it is controlling.
 * @param {MembershipCache} memberCache The bridges membership cache instance,
 * for storing membership the bot has discovered.
 */
declare function AppServiceBot(client: any, registration: any, memberCache: any): void;
declare class AppServiceBot {
    /**
     * Construct an AS bot user which has various helper methods.
     * @constructor
     * @param {MatrixClient} client The client instance configured for the AS bot.
     * @param {AppServiceRegistration} registration The registration that the bot
     * is following. Used to determine which user IDs it is controlling.
     * @param {MembershipCache} memberCache The bridges membership cache instance,
     * for storing membership the bot has discovered.
     */
    constructor(client: any, registration: any, memberCache: any);
    client: any;
    registration: any;
    memberCache: any;
    exclusiveUserRegexes: any[];
    getClient(): any;
    getUserId(): any;
    getJoinedRooms(): Promise<string[], Error>;
    getJoinedMembers(roomId: string): Promise<Object, Error>;
    getMemberLists(): never;
    _getRoomInfo(roomId: any, joinedRoom: any): {
        id: any;
        state: any;
        realJoinedUsers: never[];
        remoteJoinedUsers: never[];
    };
    isRemoteUser(userId: any): boolean;
    _isRemoteUser: any;
}
declare namespace AppServiceBot {
    export { AppServiceBot };
}
/**
 * ~RoomInfo
 */
type AppServiceBot = {
    /**
     * The matrix room ID
     */
    id: string;
    /**
     * The raw state events for this room
     */
    state: Object[];
    /**
     * A list of user IDs of real matrix users
     * that have joined this room.
     */
    realJoinedUsers: string[];
    /**
     * A list of user IDs of remote users
     * (provisioned by the AS) that have joined this room.
     */
    remoteJoinedUsers: string[];
};
