import { ILogger } from "matrix-bot-sdk";
interface MatrixActivityTrackerOpts {
    /**
     * Matrix homeserver url
     * @example https://matrix.org
     */
    homeserverUrl: string;
    /**
     * Access token for making requests
     */
    accessToken: string;
    /**
     * Matrix server name. Used for determining local and remote users.
     * @example matrix.org
     */
    serverName: string;
    /**
     * Should the tracker assume offline or online if it doesn't have enough information.
     */
    defaultOnline: boolean;
    /**
     * Should presence be used. Set to false if the homeserver has presence disabled.
     */
    usePresence?: boolean;
    /**
     * matrix-bot-sdk logger. By default this will not log.
     */
    logger?: ILogger;
}
/**
 * This class provides a "one stop shop" to determine if a user is online. It will use a combination of a
 * local cache, presence endpoints and admin APIs in that order.
 */
export declare class MatrixActivityTracker {
    private opts;
    private client;
    private lastActiveTime;
    private canUseWhois;
    constructor(opts: MatrixActivityTrackerOpts);
    get usingWhois(): boolean | null;
    /**
     * This should be called when a user has performed an action to bump their locally stored active time.
     * @param userId The userId of a user who performed an action.
     */
    bumpLastActiveTime(userId: string): void;
    setLastActiveTime(userId: string, ts: number): void;
    /**
     * Determine if a user is online or offline using a range of metrics.
     * @param userId The userId to check
     * @param maxTimeMs The maximum time a user may be inactive for before they are considered offline.
     * @param defaultOnline Should the user be online or offline if no data is found. Defaults to `opts.defaultOnline`
     */
    isUserOnline(userId: string, maxTimeMs: number, defaultOnline?: boolean): Promise<{
        online: boolean;
        inactiveMs: number;
    }>;
}
export {};
