/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.util.Debug;

public final class AccessController {
    private AccessController() {
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0);

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) {
        AccessControlContext acc = AccessController.getStackAccessControlContext();
        if (acc == null) {
            return AccessController.doPrivileged(action);
        }
        DomainCombiner dc = acc.getAssignedCombiner();
        return AccessController.doPrivileged(action, AccessController.preserveCombiner(dc, Reflection.getCallerClass()));
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedAction<T> var0, AccessControlContext var1);

    @CallerSensitive
    static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context, Permission ... perms) {
        AccessControlContext parent = AccessController.getContext();
        if (perms == null) {
            throw new NullPointerException("null permissions parameter");
        }
        Class caller = Reflection.getCallerClass();
        DomainCombiner dc = context == null ? null : context.getCombiner();
        return AccessController.doPrivileged(action, AccessController.createWrapper(dc, caller, parent, context, perms));
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0) throws PrivilegedActionException;

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        AccessControlContext acc = AccessController.getStackAccessControlContext();
        if (acc == null) {
            return AccessController.doPrivileged(action);
        }
        DomainCombiner dc = acc.getAssignedCombiner();
        return AccessController.doPrivileged(action, AccessController.preserveCombiner(dc, Reflection.getCallerClass()));
    }

    private static AccessControlContext preserveCombiner(DomainCombiner combiner, Class<?> caller) {
        return AccessController.createWrapper(combiner, caller, null, null, null);
    }

    private static AccessControlContext createWrapper(DomainCombiner combiner, Class<?> caller, AccessControlContext parent, AccessControlContext context, Permission[] perms) {
        ProtectionDomain callerPD = AccessController.getCallerPD(caller);
        if (context != null && !context.isAuthorized() && System.getSecurityManager() != null && !callerPD.impliesCreateAccessControlContext()) {
            ProtectionDomain nullPD = new ProtectionDomain(null, null);
            return new AccessControlContext(new ProtectionDomain[]{nullPD});
        }
        return new AccessControlContext(callerPD, combiner, parent, context, perms);
    }

    private static ProtectionDomain getCallerPD(final Class<?> caller) {
        ProtectionDomain callerPd = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return caller.getProtectionDomain();
            }
        });
        return callerPd;
    }

    @CallerSensitive
    public static native <T> T doPrivileged(PrivilegedExceptionAction<T> var0, AccessControlContext var1) throws PrivilegedActionException;

    @CallerSensitive
    static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context, Permission ... perms) throws PrivilegedActionException {
        AccessControlContext parent = AccessController.getContext();
        if (perms == null) {
            throw new NullPointerException("null permissions parameter");
        }
        Class caller = Reflection.getCallerClass();
        DomainCombiner dc = context == null ? null : context.getCombiner();
        return AccessController.doPrivileged(action, AccessController.createWrapper(dc, caller, parent, context, perms));
    }

    private static native AccessControlContext getStackAccessControlContext();

    static native AccessControlContext getInheritedAccessControlContext();

    public static AccessControlContext getContext() {
        AccessControlContext acc = AccessController.getStackAccessControlContext();
        if (acc == null) {
            return new AccessControlContext(null, true);
        }
        return acc.optimize();
    }

    public static void checkPermission(Permission perm) throws AccessControlException {
        if (perm == null) {
            throw new NullPointerException("permission can't be null");
        }
        AccessControlContext stack = AccessController.getStackAccessControlContext();
        if (stack == null) {
            Debug debug = AccessControlContext.getDebug();
            boolean dumpDebug = false;
            if (debug != null) {
                dumpDebug = !Debug.isOn("codebase=");
                dumpDebug &= !Debug.isOn("permission=") || Debug.isOn("permission=" + perm.getClass().getCanonicalName());
            }
            if (dumpDebug && Debug.isOn("stack")) {
                Thread.dumpStack();
            }
            if (dumpDebug && Debug.isOn("domain")) {
                debug.println("domain (context is null)");
            }
            if (dumpDebug) {
                debug.println("access allowed " + perm);
            }
            return;
        }
        AccessControlContext acc = stack.optimize();
        acc.checkPermission(perm);
    }
}

