/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.openide.util.Exceptions;

class ReportSelection
implements Transferable {
    private static ArrayList flavors = new ArrayList();
    private String html;

    public ReportSelection(String html) {
        this.html = html;
        String newHTML = new String();
        String[] result = html.split("file:");
        boolean first = true;
        for (int i = 0; i < result.length; ++i) {
            if (result[i].contains("</IMG>")) {
                String next = result[i];
                String[] elements = next.split("\"");
                String filename = elements[0];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                File file = new File(filename);
                try {
                    BufferedImage image = ImageIO.read(file);
                    ImageIO.write((RenderedImage)image, "PNG", out);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                byte[] imageBytes = out.toByteArray();
                String base64String = Base64.encodeBase64String((byte[])imageBytes);
                if (!first) {
                    newHTML = newHTML + "\"";
                }
                first = false;
                newHTML = newHTML + "data:image/png;base64," + base64String;
                for (int j = 1; j < elements.length; ++j) {
                    newHTML = newHTML + "\"" + elements[j];
                }
                continue;
            }
            newHTML = newHTML + result[i];
        }
        this.html = newHTML;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavors.contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (String.class.equals(flavor.getRepresentationClass())) {
            return this.html;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    static {
        try {
            flavors.add(new DataFlavor("text/html;class=java.lang.String"));
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

