/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.CategoryNode;
import org.languagetool.gui.CheckBoxTreeCellRenderer;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.RuleNode;
import org.languagetool.gui.SavablePanel;
import org.languagetool.gui.Tools;
import org.languagetool.gui.TreeListener;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.Rule;

public class ConfigurationDialog
implements ActionListener {
    private static final String NO_MOTHER_TONGUE = "---";
    private static final String ACTION_COMMAND_OK = "OK";
    private static final String ACTION_COMMAND_CANCEL = "CANCEL";
    private static final int MAX_PORT = 65536;
    private final ResourceBundle messages;
    private final Configuration original;
    private Configuration config;
    private final Frame owner;
    private final boolean insideOffice;
    private boolean configChanged = false;
    private boolean profileChanged = true;
    private boolean restartShow = false;
    private boolean firstSelection = true;
    private JDialog dialog;
    private JCheckBox serverCheckbox;
    private JTextField serverPortField;
    private JTree[] configTree;
    private JCheckBox serverSettingsCheckbox;
    private final List<JPanel> extraPanels = new ArrayList<JPanel>();
    private final List<Rule> configurableRules = new ArrayList<Rule>();

    public ConfigurationDialog(Frame owner, boolean insideOffice, Configuration config) {
        this.owner = owner;
        this.insideOffice = insideOffice;
        this.original = config;
        this.config = this.original.copy(this.original);
        this.messages = JLanguageTool.getMessageBundle();
    }

    void addExtraPanel(JPanel panel) {
        this.extraPanels.add(panel);
    }

    private DefaultMutableTreeNode createTree(List<Rule> rules, boolean isStyle, String tabName) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Rules");
        String lastRuleId = null;
        TreeMap<String, CategoryNode> parents = new TreeMap<String, CategoryNode>();
        for (Rule rule : rules) {
            if (!(tabName == null && !this.config.isSpecialTabCategory(rule.getCategory().getName()) && (isStyle && this.config.isStyleCategory(rule.getCategory().getName()) || !isStyle && !this.config.isStyleCategory(rule.getCategory().getName()))) && (tabName == null || !this.config.isInSpecialTab(rule.getCategory().getName(), tabName))) continue;
            if (rule.hasConfigurableValue()) {
                this.configurableRules.add(rule);
                continue;
            }
            if (!parents.containsKey(rule.getCategory().getName())) {
                boolean enabled = true;
                if (this.config.getDisabledCategoryNames() != null && this.config.getDisabledCategoryNames().contains(rule.getCategory().getName())) {
                    enabled = false;
                }
                if (rule.getCategory().isDefaultOff() && (this.config.getEnabledCategoryNames() == null || !this.config.getEnabledCategoryNames().contains(rule.getCategory().getName()))) {
                    enabled = false;
                }
                CategoryNode categoryNode = new CategoryNode(rule.getCategory(), enabled);
                root.add(categoryNode);
                parents.put(rule.getCategory().getName(), categoryNode);
            }
            if (!rule.getId().equals(lastRuleId)) {
                RuleNode ruleNode = new RuleNode(rule, this.getEnabledState(rule));
                ((DefaultMutableTreeNode)parents.get(rule.getCategory().getName())).add(ruleNode);
            }
            lastRuleId = rule.getId();
        }
        return root;
    }

    private boolean getEnabledState(Rule rule) {
        boolean ret = true;
        if (this.config.getDisabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (this.config.getDisabledCategoryNames().contains(rule.getCategory().getName())) {
            ret = false;
        }
        if ((rule.isDefaultOff() || rule.getCategory().isDefaultOff()) && !this.config.getEnabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (this.insideOffice && rule.isOfficeDefaultOff() && !this.config.getEnabledRuleIds().contains(rule.getId())) {
            ret = false;
        }
        if (this.insideOffice && rule.isOfficeDefaultOn() && !this.config.getDisabledRuleIds().contains(rule.getId())) {
            ret = true;
        }
        if (rule.isDefaultOff() && rule.getCategory().isDefaultOff() && this.config.getEnabledRuleIds().contains(rule.getId())) {
            this.config.getDisabledCategoryNames().remove(rule.getCategory().getName());
        }
        return ret;
    }

    public boolean show(List<Rule> rules) {
        this.restartShow = false;
        do {
            this.showPanel(rules);
        } while (this.restartShow);
        return this.configChanged;
    }

    public boolean showPanel(List<Rule> rules) {
        GridBagConstraints cons;
        this.configChanged = false;
        if (this.original != null && !this.restartShow) {
            this.config.restoreState(this.original);
        }
        this.restartShow = false;
        this.dialog = new JDialog(this.owner, true);
        this.dialog.setTitle(this.messages.getString("guiConfigWindowTitle"));
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = actionEvent -> this.dialog.setVisible(false);
        JRootPane rootPane = this.dialog.getRootPane();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        this.configurableRules.clear();
        Language lang = this.config.getLanguage();
        if (lang == null) {
            lang = Languages.getLanguageForLocale((Locale)Locale.getDefault());
        }
        String[] specialTabNames = this.config.getSpecialTabNames();
        int numConfigTrees = 2 + specialTabNames.length;
        this.configTree = new JTree[numConfigTrees];
        JPanel[] checkBoxPanel = new JPanel[numConfigTrees];
        for (int i = 0; i < numConfigTrees; ++i) {
            checkBoxPanel[i] = new JPanel();
            cons = new GridBagConstraints();
            checkBoxPanel[i].setLayout(new GridBagLayout());
            cons.anchor = 18;
            cons.gridx = 0;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.fill = 2;
            Collections.sort(rules, new CategoryComparator());
            DefaultMutableTreeNode rootNode = i == 0 ? this.createTree(rules, false, null) : (i == 1 ? this.createTree(rules, true, null) : this.createTree(rules, true, specialTabNames[i - 2]));
            this.configTree[i] = new JTree(this.getTreeModel(rootNode));
            this.configTree[i].applyComponentOrientation(ComponentOrientation.getOrientation(lang.getLocale()));
            this.configTree[i].setRootVisible(false);
            this.configTree[i].setEditable(false);
            this.configTree[i].setCellRenderer(new CheckBoxTreeCellRenderer());
            TreeListener.install(this.configTree[i]);
            checkBoxPanel[i].add((Component)this.configTree[i], cons);
            this.configTree[i].addMouseListener(this.getMouseAdapter());
        }
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.anchor = 17;
        cons.fill = 0;
        cons.weightx = 0.0;
        if (!this.insideOffice) {
            this.createNonOfficeElements(cons, portPanel);
        } else {
            this.createOfficeElements(cons, portPanel);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        JButton okButton = new JButton(Tools.getLabel(this.messages.getString("guiOKButton")));
        okButton.setMnemonic(Tools.getMnemonic(this.messages.getString("guiOKButton")));
        okButton.setActionCommand(ACTION_COMMAND_OK);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(Tools.getLabel(this.messages.getString("guiCancelButton")));
        cancelButton.setMnemonic(Tools.getMnemonic(this.messages.getString("guiCancelButton")));
        cancelButton.setActionCommand(ACTION_COMMAND_CANCEL);
        cancelButton.addActionListener(this);
        cons = new GridBagConstraints();
        cons.insets = new Insets(0, 4, 0, 0);
        buttonPanel.add((Component)okButton, cons);
        buttonPanel.add((Component)cancelButton, cons);
        JTabbedPane tabpane = new JTabbedPane();
        JPanel jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        cons.anchor = 18;
        jPane.add((Component)this.getProfilePanel(cons, rules), cons);
        tabpane.addTab(this.messages.getString("guiProfiles"), new JScrollPane(jPane));
        jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 18;
        ++cons.gridy;
        cons.anchor = 17;
        jPane.add((Component)this.getMotherTonguePanel(cons), cons);
        cons.gridy = this.insideOffice ? (cons.gridy += 3) : ++cons.gridy;
        cons.anchor = 17;
        jPane.add((Component)this.getNgramPanel(cons), cons);
        ++cons.gridy;
        cons.anchor = 17;
        jPane.add((Component)this.getWord2VecPanel(cons), cons);
        ++cons.gridy;
        cons.anchor = 17;
        jPane.add((Component)portPanel, cons);
        cons.fill = 2;
        cons.anchor = 17;
        for (JPanel extra : this.extraPanels) {
            SwingUtilities.updateComponentTreeUI(extra);
            ++cons.gridy;
            jPane.add((Component)extra, cons);
        }
        ++cons.gridy;
        cons.fill = 1;
        cons.weighty = 1.0;
        jPane.add((Component)new JPanel(), cons);
        tabpane.addTab(this.messages.getString("guiGeneral"), new JScrollPane(jPane));
        jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        jPane.add((Component)new JScrollPane(checkBoxPanel[0]), cons);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 22;
        jPane.add((Component)this.getTreeButtonPanel(0), cons);
        tabpane.addTab(this.messages.getString("guiGrammarRules"), jPane);
        jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        jPane.add((Component)new JScrollPane(checkBoxPanel[1]), cons);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 22;
        jPane.add((Component)this.getTreeButtonPanel(1), cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.weightx = 5.0;
        cons.weighty = 5.0;
        cons.fill = 1;
        cons.anchor = 17;
        jPane.add((Component)new JScrollPane(this.getSpecialRuleValuePanel()), cons);
        tabpane.addTab(this.messages.getString("guiStyleRules"), jPane);
        for (int i = 0; i < specialTabNames.length; ++i) {
            jPane = new JPanel();
            jPane.setLayout(new GridBagLayout());
            cons = new GridBagConstraints();
            cons.insets = new Insets(4, 4, 4, 4);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 10.0;
            cons.weighty = 10.0;
            cons.fill = 1;
            jPane.add((Component)new JScrollPane(checkBoxPanel[i + 2]), cons);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.gridx = 0;
            ++cons.gridy;
            cons.fill = 0;
            cons.anchor = 22;
            jPane.add((Component)this.getTreeButtonPanel(i + 2), cons);
            tabpane.addTab(specialTabNames[i], jPane);
        }
        jPane = new JPanel();
        jPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        if (this.insideOffice) {
            JLabel versionText = new JLabel(this.messages.getString("guiUColorHint"));
            versionText.setForeground(Color.blue);
            jPane.add((Component)versionText, cons);
            ++cons.gridy;
            JLabel versionText1 = new JLabel(this.messages.getString("guiUColorHint1"));
            versionText1.setForeground(Color.blue);
            jPane.add((Component)versionText1, cons);
            ++cons.gridy;
        }
        cons.weightx = 2.0;
        cons.weighty = 2.0;
        cons.fill = 1;
        jPane.add((Component)new JScrollPane(this.getUnderlineColorPanel(rules)), cons);
        if (this.insideOffice) {
            JCheckBox markSingleCharBold = new JCheckBox(Tools.getLabel(this.messages.getString("guiMarkSingleCharBold")));
            markSingleCharBold.setSelected(this.config.markSingleCharBold());
            markSingleCharBold.addItemListener(e -> this.config.setMarkSingleCharBold(markSingleCharBold.isSelected()));
            JLabel dummyLabel = new JLabel(" ");
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.gridx = 0;
            ++cons.gridy;
            jPane.add((Component)dummyLabel, cons);
            jPane.add((Component)markSingleCharBold, cons);
        }
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        cons.anchor = 18;
        contentPane.add((Component)tabpane, cons);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 13;
        contentPane.add((Component)buttonPanel, cons);
        this.dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.dialog.getSize();
        this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
        this.dialog.setLocationByPlatform(true);
        tabpane.addTab(this.messages.getString("guiUnderlineColor"), jPane);
        for (JPanel extra : this.extraPanels) {
            if (!(extra instanceof SavablePanel)) continue;
            ((SavablePanel)((Object)extra)).componentShowing();
        }
        this.dialog.setVisible(true);
        return this.configChanged;
    }

    private void createNonOfficeElements(GridBagConstraints cons, JPanel portPanel) {
        this.serverCheckbox = new JCheckBox(Tools.getLabel(this.messages.getString("guiRunOnPort")));
        this.serverCheckbox.setMnemonic(Tools.getMnemonic(this.messages.getString("guiRunOnPort")));
        this.serverCheckbox.setSelected(this.config.getRunServer());
        portPanel.add((Component)this.serverCheckbox, cons);
        this.serverCheckbox.addActionListener(e -> {
            this.serverPortField.setEnabled(this.serverCheckbox.isSelected());
            this.serverSettingsCheckbox.setEnabled(this.serverCheckbox.isSelected());
        });
        this.serverCheckbox.addItemListener(e -> this.config.setRunServer(this.serverCheckbox.isSelected()));
        this.serverPortField = new JTextField(Integer.toString(this.config.getServerPort()));
        this.serverPortField.setEnabled(this.serverCheckbox.isSelected());
        this.serverSettingsCheckbox = new JCheckBox(Tools.getLabel(this.messages.getString("useGUIConfig")));
        this.serverPortField.setMinimumSize(new Dimension(100, 25));
        cons.gridx = 1;
        portPanel.add((Component)this.serverPortField, cons);
        this.serverPortField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    int serverPort = Integer.parseInt(ConfigurationDialog.this.serverPortField.getText());
                    if (serverPort > -1 && serverPort < 65536) {
                        ConfigurationDialog.this.serverPortField.setForeground(null);
                        ConfigurationDialog.this.config.setServerPort(serverPort);
                    } else {
                        ConfigurationDialog.this.serverPortField.setForeground(Color.RED);
                    }
                }
                catch (NumberFormatException ex) {
                    ConfigurationDialog.this.serverPortField.setForeground(Color.RED);
                }
            }
        });
        cons.gridx = 0;
        cons.gridy = 10;
        this.serverSettingsCheckbox.setMnemonic(Tools.getMnemonic(this.messages.getString("useGUIConfig")));
        this.serverSettingsCheckbox.setSelected(this.config.getUseGUIConfig());
        this.serverSettingsCheckbox.setEnabled(this.config.getRunServer());
        this.serverSettingsCheckbox.addItemListener(e -> this.config.setUseGUIConfig(this.serverSettingsCheckbox.isSelected()));
        portPanel.add((Component)this.serverSettingsCheckbox, cons);
    }

    private void createOfficeElements(GridBagConstraints cons, JPanel portPanel) {
        int numParaCheck = this.config.getNumParasToCheck();
        JRadioButton[] radioButtons = new JRadioButton[4];
        ButtonGroup numParaGroup = new ButtonGroup();
        radioButtons[0] = new JRadioButton(Tools.getLabel(this.messages.getString("guiCheckOnlyParagraph")));
        radioButtons[0].setActionCommand("ParagraphCheck");
        radioButtons[1] = new JRadioButton(Tools.getLabel(this.messages.getString("guiCheckFullText")));
        radioButtons[1].setActionCommand("FullTextCheck");
        radioButtons[2] = new JRadioButton(Tools.getLabel(this.messages.getString("guiCheckChapter")));
        radioButtons[2].setActionCommand("ChapterCheck");
        radioButtons[3] = new JRadioButton(Tools.getLabel(this.messages.getString("guiCheckNumParagraphs")));
        radioButtons[3].setActionCommand("NParagraphCheck");
        final JTextField numParaField = new JTextField(Integer.toString(5), 2);
        numParaField.setEnabled(radioButtons[2].isSelected());
        numParaField.setMinimumSize(new Dimension(30, 25));
        JCheckBox fullTextCheckAtFirstBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiCheckFullTextAtFirst")));
        fullTextCheckAtFirstBox.addItemListener(e -> this.config.setFullCheckAtFirst(fullTextCheckAtFirstBox.isSelected()));
        JCheckBox useQueueResetbox = new JCheckBox(Tools.getLabel(this.messages.getString("guiUseTextLevelQueue")));
        useQueueResetbox.setSelected(this.config.useTextLevelQueue());
        fullTextCheckAtFirstBox.setEnabled(!useQueueResetbox.isSelected());
        useQueueResetbox.addItemListener(e -> {
            this.config.setUseTextLevelQueue(useQueueResetbox.isSelected());
            fullTextCheckAtFirstBox.setEnabled(!useQueueResetbox.isSelected());
        });
        for (int i = 0; i < 4; ++i) {
            numParaGroup.add(radioButtons[i]);
        }
        if (numParaCheck == 0) {
            radioButtons[0].setSelected(true);
            numParaField.setEnabled(false);
            useQueueResetbox.setEnabled(false);
            fullTextCheckAtFirstBox.setEnabled(false);
        } else if (numParaCheck < -1) {
            radioButtons[1].setSelected(true);
            numParaField.setEnabled(false);
            useQueueResetbox.setEnabled(true);
            fullTextCheckAtFirstBox.setEnabled(false);
        } else if (numParaCheck < 0) {
            radioButtons[2].setSelected(true);
            numParaField.setEnabled(false);
            useQueueResetbox.setEnabled(true);
            fullTextCheckAtFirstBox.setEnabled(false);
        } else {
            radioButtons[3].setSelected(true);
            numParaField.setText(Integer.toString(numParaCheck));
            numParaField.setEnabled(true);
            useQueueResetbox.setEnabled(true);
            fullTextCheckAtFirstBox.setEnabled(!useQueueResetbox.isSelected());
        }
        radioButtons[0].addActionListener(e -> {
            numParaField.setEnabled(false);
            useQueueResetbox.setEnabled(false);
            fullTextCheckAtFirstBox.setEnabled(false);
            this.config.setNumParasToCheck(0);
        });
        radioButtons[1].addActionListener(e -> {
            numParaField.setEnabled(false);
            useQueueResetbox.setEnabled(true);
            fullTextCheckAtFirstBox.setEnabled(false);
            this.config.setNumParasToCheck(-2);
        });
        radioButtons[2].addActionListener(e -> {
            numParaField.setEnabled(false);
            useQueueResetbox.setEnabled(true);
            fullTextCheckAtFirstBox.setEnabled(false);
            this.config.setNumParasToCheck(-1);
        });
        radioButtons[3].addActionListener(e -> {
            int numParaCheck1 = Integer.parseInt(numParaField.getText());
            if (numParaCheck1 < 1) {
                numParaCheck1 = 1;
            } else if (numParaCheck1 > 99) {
                numParaCheck1 = 99;
            }
            this.config.setNumParasToCheck(numParaCheck1);
            numParaField.setForeground(Color.BLACK);
            numParaField.setText(Integer.toString(numParaCheck1));
            numParaField.setEnabled(true);
            useQueueResetbox.setEnabled(true);
            fullTextCheckAtFirstBox.setEnabled(!useQueueResetbox.isSelected());
        });
        numParaField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                try {
                    int numParaCheck = Integer.parseInt(numParaField.getText());
                    if (numParaCheck > 0 && numParaCheck < 99) {
                        numParaField.setForeground(Color.BLACK);
                        ConfigurationDialog.this.config.setNumParasToCheck(numParaCheck);
                    } else {
                        numParaField.setForeground(Color.RED);
                    }
                }
                catch (NumberFormatException ex) {
                    numParaField.setForeground(Color.RED);
                }
            }
        });
        JLabel textChangedLabel = new JLabel(Tools.getLabel(this.messages.getString("guiTextChangeLabel")));
        ++cons.gridy;
        portPanel.add((Component)textChangedLabel, cons);
        ++cons.gridy;
        cons.insets = new Insets(0, 30, 0, 0);
        for (int i = 0; i < 4; ++i) {
            portPanel.add((Component)radioButtons[i], cons);
            if (i >= 3) continue;
            ++cons.gridy;
        }
        cons.gridx = 1;
        portPanel.add((Component)numParaField, cons);
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)useQueueResetbox, cons);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)fullTextCheckAtFirstBox, cons);
        JCheckBox isMultiThreadBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiIsMultiThread")));
        isMultiThreadBox.setSelected(this.config.isMultiThread());
        isMultiThreadBox.addItemListener(e -> this.config.setMultiThreadLO(isMultiThreadBox.isSelected()));
        ++cons.gridy;
        JLabel dummyLabel3 = new JLabel(" ");
        portPanel.add((Component)dummyLabel3, cons);
        ++cons.gridy;
        portPanel.add((Component)isMultiThreadBox, cons);
        final JTextField otherServerNameField = new JTextField(this.config.getServerUrl() == null ? "" : this.config.getServerUrl(), 25);
        otherServerNameField.setMinimumSize(new Dimension(100, 25));
        otherServerNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                String serverName = otherServerNameField.getText();
                if ((serverName = serverName.trim()).isEmpty()) {
                    serverName = null;
                }
                if (ConfigurationDialog.this.config.isValidServerUrl(serverName)) {
                    otherServerNameField.setForeground(Color.BLACK);
                    ConfigurationDialog.this.config.setOtherServerUrl(serverName);
                } else {
                    otherServerNameField.setForeground(Color.RED);
                }
            }
        });
        JCheckBox useServerBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiUseServer")) + " ");
        useServerBox.setSelected(this.config.useOtherServer());
        useServerBox.addItemListener(e -> {
            int select = 0;
            boolean selected = useServerBox.isSelected();
            if (selected && this.firstSelection) {
                select = this.showRemoteServerHint(useServerBox, true);
                this.firstSelection = false;
            } else {
                this.firstSelection = true;
            }
            if (select == 0) {
                useServerBox.setSelected(selected);
                this.config.setUseOtherServer(useServerBox.isSelected());
                otherServerNameField.setEnabled(useServerBox.isSelected());
            } else {
                useServerBox.setSelected(false);
                this.firstSelection = true;
            }
        });
        JCheckBox useRemoteServerBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiUseRemoteServer")));
        useRemoteServerBox.setSelected(this.config.doRemoteCheck());
        useServerBox.setEnabled(useRemoteServerBox.isSelected());
        otherServerNameField.setEnabled(useRemoteServerBox.isSelected() && useServerBox.isSelected());
        isMultiThreadBox.setEnabled(!useRemoteServerBox.isSelected());
        useRemoteServerBox.addItemListener(e -> {
            int select = 0;
            boolean selected = useRemoteServerBox.isSelected();
            if (selected && this.firstSelection) {
                select = this.showRemoteServerHint(useRemoteServerBox, false);
                this.firstSelection = false;
            } else {
                this.firstSelection = true;
            }
            if (select == 0) {
                useRemoteServerBox.setSelected(selected);
                this.config.setRemoteCheck(useRemoteServerBox.isSelected());
                useServerBox.setEnabled(useRemoteServerBox.isSelected());
                otherServerNameField.setEnabled(useRemoteServerBox.isSelected() && useServerBox.isSelected());
                isMultiThreadBox.setEnabled(!useRemoteServerBox.isSelected());
            } else {
                useRemoteServerBox.setSelected(false);
                this.firstSelection = true;
            }
        });
        ++cons.gridy;
        portPanel.add((Component)useRemoteServerBox, cons);
        cons.insets = new Insets(0, 30, 0, 0);
        JPanel serverPanel = new JPanel();
        serverPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.insets = new Insets(0, 0, 0, 0);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.anchor = 17;
        cons1.fill = 0;
        cons1.weightx = 0.0;
        serverPanel.add((Component)useServerBox, cons1);
        ++cons1.gridx;
        serverPanel.add((Component)otherServerNameField, cons1);
        JLabel serverExampleLabel = new JLabel(" " + Tools.getLabel(this.messages.getString("guiUseServerExample")));
        serverExampleLabel.enable(false);
        ++cons1.gridy;
        serverPanel.add((Component)serverExampleLabel, cons1);
        cons.gridx = 0;
        ++cons.gridy;
        portPanel.add((Component)serverPanel, cons);
        cons.insets = new Insets(0, 4, 0, 0);
        cons.gridx = 0;
        ++cons.gridy;
        JLabel dummyLabel4 = new JLabel(" ");
        portPanel.add((Component)dummyLabel4, cons);
        JCheckBox useLtDictionaryBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiUseLtDictionary")));
        useLtDictionaryBox.setSelected(this.config.useLtDictionary());
        useLtDictionaryBox.addItemListener(e -> this.config.setUseLtDictionary(useLtDictionaryBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)useLtDictionaryBox, cons);
        JCheckBox noSynonymsAsSuggestionsBox = new JCheckBox(Tools.getLabel(this.messages.getString("guiNoSynonymsAsSuggestions")));
        noSynonymsAsSuggestionsBox.setSelected(this.config.noSynonymsAsSuggestions());
        noSynonymsAsSuggestionsBox.addItemListener(e -> this.config.setNoSynonymsAsSuggestions(noSynonymsAsSuggestionsBox.isSelected()));
        ++cons.gridy;
        portPanel.add((Component)noSynonymsAsSuggestionsBox, cons);
    }

    private int showRemoteServerHint(Component component, boolean otherServer) {
        if (this.config.useOtherServer() || otherServer) {
            return JOptionPane.showConfirmDialog(component, MessageFormat.format(this.messages.getString("loRemoteInfoOtherServer"), this.config.getServerUrl()), this.messages.getString("loMenuRemoteInfo"), 2);
        }
        return JOptionPane.showConfirmDialog(component, this.messages.getString("loRemoteInfoDefaultServer"), this.messages.getString("loMenuRemoteInfo"), 2);
    }

    @NotNull
    private DefaultTreeModel getTreeModel(DefaultMutableTreeNode rootNode) {
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DefaultMutableTreeNode o;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                int index = e.getChildIndices()[0];
                if ((node = (DefaultMutableTreeNode)node.getChildAt(index)) instanceof RuleNode) {
                    o = (RuleNode)node;
                    if (((RuleNode)o).getRule().isDefaultOff() || ((RuleNode)o).getRule().getCategory().isDefaultOff()) {
                        if (((RuleNode)o).isEnabled()) {
                            ConfigurationDialog.this.config.getEnabledRuleIds().add(((RuleNode)o).getRule().getId());
                            ConfigurationDialog.this.config.getDisabledRuleIds().remove(((RuleNode)o).getRule().getId());
                        } else {
                            ConfigurationDialog.this.config.getEnabledRuleIds().remove(((RuleNode)o).getRule().getId());
                            ConfigurationDialog.this.config.getDisabledRuleIds().add(((RuleNode)o).getRule().getId());
                        }
                    } else if (((RuleNode)o).isEnabled()) {
                        ConfigurationDialog.this.config.getDisabledRuleIds().remove(((RuleNode)o).getRule().getId());
                    } else {
                        ConfigurationDialog.this.config.getDisabledRuleIds().add(((RuleNode)o).getRule().getId());
                    }
                }
                if (node instanceof CategoryNode) {
                    o = (CategoryNode)node;
                    if (((CategoryNode)o).getCategory().isDefaultOff()) {
                        if (((CategoryNode)o).isEnabled()) {
                            ConfigurationDialog.this.config.getDisabledCategoryNames().remove(((CategoryNode)o).getCategory().getName());
                            ConfigurationDialog.this.config.getEnabledCategoryNames().add(((CategoryNode)o).getCategory().getName());
                        } else {
                            ConfigurationDialog.this.config.getDisabledCategoryNames().add(((CategoryNode)o).getCategory().getName());
                            ConfigurationDialog.this.config.getEnabledCategoryNames().remove(((CategoryNode)o).getCategory().getName());
                        }
                    } else if (((CategoryNode)o).isEnabled()) {
                        ConfigurationDialog.this.config.getDisabledCategoryNames().remove(((CategoryNode)o).getCategory().getName());
                    } else {
                        ConfigurationDialog.this.config.getDisabledCategoryNames().add(((CategoryNode)o).getCategory().getName());
                    }
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        return treeModel;
    }

    @NotNull
    private MouseAdapter getMouseAdapter() {
        return new MouseAdapter(){

            private void handlePopupEvent(MouseEvent e) {
                JTree tree = (JTree)e.getSource();
                TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                TreePath[] paths = tree.getSelectionPaths();
                boolean isSelected = false;
                if (paths != null) {
                    for (TreePath selectionPath : paths) {
                        if (!selectionPath.equals(path)) continue;
                        isSelected = true;
                    }
                }
                if (!isSelected) {
                    tree.setSelectionPath(path);
                }
                if (node.isLeaf()) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem aboutRuleMenuItem = new JMenuItem(ConfigurationDialog.this.messages.getString("guiAboutRuleMenu"));
                    aboutRuleMenuItem.addActionListener(actionEvent -> {
                        RuleNode node1 = (RuleNode)tree.getSelectionPath().getLastPathComponent();
                        Rule rule = node1.getRule();
                        Language lang = ConfigurationDialog.this.config.getLanguage();
                        if (lang == null) {
                            lang = Languages.getLanguageForLocale((Locale)Locale.getDefault());
                        }
                        Tools.showRuleInfoDialog(tree, ConfigurationDialog.this.messages.getString("guiAboutRuleTitle"), rule.getDescription(), rule, rule.getUrl(), ConfigurationDialog.this.messages, lang.getShortCodeWithCountryAndVariant());
                    });
                    popup.add(aboutRuleMenuItem);
                    popup.show(tree, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopupEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.handlePopupEvent(e);
                }
            }
        };
    }

    @NotNull
    private JPanel getTreeButtonPanel(int num) {
        JPanel treeButtonPanel = new JPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        JButton expandAllButton = new JButton(this.messages.getString("guiExpandAll"));
        treeButtonPanel.add((Component)expandAllButton, cons);
        expandAllButton.addActionListener(e -> {
            TreeNode root = (TreeNode)this.configTree[num].getModel().getRoot();
            TreePath parent = new TreePath(root);
            Enumeration<? extends TreeNode> cat = root.children();
            while (cat.hasMoreElements()) {
                TreeNode n = cat.nextElement();
                TreePath child = parent.pathByAddingChild(n);
                this.configTree[num].expandPath(child);
            }
        });
        cons.gridx = 1;
        cons.gridy = 0;
        JButton collapseAllButton = new JButton(this.messages.getString("guiCollapseAll"));
        treeButtonPanel.add((Component)collapseAllButton, cons);
        collapseAllButton.addActionListener(e -> {
            TreeNode root = (TreeNode)this.configTree[num].getModel().getRoot();
            TreePath parent = new TreePath(root);
            Enumeration<? extends TreeNode> categ = root.children();
            while (categ.hasMoreElements()) {
                TreeNode n = categ.nextElement();
                TreePath child = parent.pathByAddingChild(n);
                this.configTree[num].collapsePath(child);
            }
        });
        return treeButtonPanel;
    }

    @NotNull
    private JPanel getProfilePanel(GridBagConstraints cons, List<Rule> rules) {
        this.profileChanged = true;
        JPanel profilePanel = new JPanel();
        profilePanel.setLayout(new GridBagLayout());
        cons.insets = new Insets(16, 0, 0, 8);
        cons.gridx = 0;
        cons.anchor = 18;
        cons.fill = 0;
        cons.weightx = 0.0;
        ArrayList<String> profiles = new ArrayList<String>();
        String defaultOptions = this.messages.getString("guiDefaultOptions");
        String userOptions = this.messages.getString("guiUserProfile");
        profiles.add(userOptions);
        profiles.addAll(this.config.getDefinedProfiles());
        String currentProfile = this.config.getCurrentProfile();
        JComboBox<String> profileBox = new JComboBox<String>(profiles.toArray(new String[profiles.size()]));
        if (currentProfile == null || currentProfile.isEmpty()) {
            profileBox.setSelectedItem(userOptions);
        } else {
            profileBox.setSelectedItem(currentProfile);
        }
        profileBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                if (this.profileChanged) {
                    try {
                        ArrayList<String> saveProfiles = new ArrayList<String>();
                        saveProfiles.addAll(this.config.getDefinedProfiles());
                        if (e.getItem().equals(userOptions)) {
                            this.config.initOptions();
                            this.config.loadConfiguration("");
                            this.config.setCurrentProfile(null);
                        } else {
                            this.config.initOptions();
                            this.config.loadConfiguration((String)e.getItem());
                            this.config.setCurrentProfile((String)e.getItem());
                        }
                        this.config.addProfiles(saveProfiles);
                        this.restartShow = true;
                        this.dialog.setVisible(false);
                    }
                    catch (IOException iOException) {}
                } else {
                    this.profileChanged = true;
                }
            }
        });
        profilePanel.add((Component)new JLabel(this.messages.getString("guiCurrentProfile")), cons);
        cons.insets = new Insets(6, 12, 0, 8);
        ++cons.gridy;
        profilePanel.add(profileBox, cons);
        JButton defaultButton = new JButton(defaultOptions);
        defaultButton.addActionListener(e -> {
            ArrayList<String> saveProfiles = new ArrayList<String>();
            saveProfiles.addAll(this.config.getDefinedProfiles());
            String saveCurrent = this.config.getCurrentProfile() == null ? null : this.config.getCurrentProfile();
            this.config.initOptions();
            this.config.addProfiles(saveProfiles);
            this.config.setCurrentProfile(saveCurrent);
            this.restartShow = true;
            this.dialog.setVisible(false);
        });
        ++cons.gridy;
        profilePanel.add((Component)defaultButton, cons);
        JButton deleteButton = new JButton(this.messages.getString("guiDeleteProfile"));
        deleteButton.setEnabled(!profileBox.getSelectedItem().equals(defaultOptions) && !profileBox.getSelectedItem().equals(userOptions));
        deleteButton.addActionListener(e -> {
            ArrayList<String> saveProfiles = new ArrayList<String>();
            saveProfiles.addAll(this.config.getDefinedProfiles());
            this.config.initOptions();
            try {
                this.config.loadConfiguration("");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.config.setCurrentProfile(null);
            this.config.addProfiles(saveProfiles);
            this.config.removeProfile((String)profileBox.getSelectedItem());
            this.restartShow = true;
            this.dialog.setVisible(false);
        });
        ++cons.gridy;
        profilePanel.add((Component)deleteButton, cons);
        JTextField newProfileName = new JTextField(15);
        cons.insets = new Insets(16, 0, 0, 8);
        ++cons.gridy;
        profilePanel.add((Component)new JLabel(this.messages.getString("guiAddNewProfile")), cons);
        cons.insets = new Insets(6, 12, 0, 8);
        ++cons.gridy;
        profilePanel.add((Component)new JLabel(this.messages.getString("guiAddProfileName")), cons);
        ++cons.gridx;
        profilePanel.add((Component)newProfileName, cons);
        JButton addNewButton = new JButton(this.messages.getString("guiAddProfileButton"));
        addNewButton.addActionListener(e -> {
            String profileName = newProfileName.getText();
            while (this.config.getDefinedProfiles().contains(profileName) || userOptions.equals(profileName)) {
                profileName = profileName + "_new";
            }
            profileName = profileName.replaceAll("[ \t]", "_");
            this.config.addProfile(profileName);
            this.config.setCurrentProfile(profileName);
            this.profileChanged = false;
            profileBox.addItem(profileName);
            profileBox.setSelectedItem(profileName);
            newProfileName.setText("");
            deleteButton.setEnabled(true);
        });
        ++cons.gridx;
        profilePanel.add((Component)addNewButton, cons);
        return profilePanel;
    }

    @NotNull
    private JPanel getMotherTonguePanel(GridBagConstraints cons) {
        JPanel motherTonguePanel = new JPanel();
        if (this.insideOffice) {
            motherTonguePanel.setLayout(new GridBagLayout());
            GridBagConstraints cons1 = new GridBagConstraints();
            cons1.insets = new Insets(16, 0, 0, 0);
            cons1.gridx = 0;
            cons1.gridy = 0;
            cons1.anchor = 17;
            cons1.fill = 0;
            cons1.weightx = 0.0;
            JRadioButton[] radioButtons = new JRadioButton[2];
            ButtonGroup numParaGroup = new ButtonGroup();
            radioButtons[0] = new JRadioButton(Tools.getLabel(this.messages.getString("guiUseDocumentLanguage")));
            radioButtons[0].setActionCommand("DocLang");
            radioButtons[0].setSelected(true);
            radioButtons[1] = new JRadioButton(Tools.getLabel(this.messages.getString("guiSetLanguageTo")));
            radioButtons[1].setActionCommand("SelectLang");
            JComboBox<String> motherTongueBox = new JComboBox<String>(this.getPossibleMotherTongues());
            if (this.config.getMotherTongue() != null) {
                motherTongueBox.setSelectedItem(this.config.getMotherTongue().getTranslatedName(this.messages));
            }
            motherTongueBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    Language motherTongue = motherTongueBox.getSelectedItem() instanceof String ? this.getLanguageForLocalizedName(motherTongueBox.getSelectedItem().toString()) : (Language)motherTongueBox.getSelectedItem();
                    this.config.setMotherTongue(motherTongue);
                    this.config.setUseDocLanguage(false);
                    radioButtons[1].setSelected(true);
                }
            });
            for (int i = 0; i < 2; ++i) {
                numParaGroup.add(radioButtons[i]);
            }
            if (this.config.getUseDocLanguage()) {
                radioButtons[0].setSelected(true);
            } else {
                radioButtons[1].setSelected(true);
            }
            radioButtons[0].addActionListener(e -> this.config.setUseDocLanguage(true));
            radioButtons[1].addActionListener(e -> {
                this.config.setUseDocLanguage(false);
                Language motherTongue = motherTongueBox.getSelectedItem() instanceof String ? this.getLanguageForLocalizedName(motherTongueBox.getSelectedItem().toString()) : (Language)motherTongueBox.getSelectedItem();
                this.config.setMotherTongue(motherTongue);
            });
            motherTonguePanel.add((Component)radioButtons[0], cons1);
            ++cons1.gridy;
            motherTonguePanel.add((Component)radioButtons[1], cons1);
            cons1.gridx = 1;
            motherTonguePanel.add(motherTongueBox, cons1);
        } else {
            motherTonguePanel.add((Component)new JLabel(this.messages.getString("guiMotherTongue")), cons);
            JComboBox<String> motherTongueBox = new JComboBox<String>(this.getPossibleMotherTongues());
            if (this.config.getMotherTongue() != null) {
                motherTongueBox.setSelectedItem(this.config.getMotherTongue().getTranslatedName(this.messages));
            }
            motherTongueBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    Language motherTongue = motherTongueBox.getSelectedItem() instanceof String ? this.getLanguageForLocalizedName(motherTongueBox.getSelectedItem().toString()) : (Language)motherTongueBox.getSelectedItem();
                    this.config.setMotherTongue(motherTongue);
                }
            });
            motherTonguePanel.add(motherTongueBox, cons);
        }
        return motherTonguePanel;
    }

    private JPanel getNgramPanel(GridBagConstraints cons) {
        JPanel panel = new JPanel();
        panel.add((Component)new JLabel(this.messages.getString("guiNgramDir")), cons);
        File dir = this.config.getNgramDirectory();
        int maxDirDisplayLength = 45;
        String buttonText = dir != null ? StringUtils.abbreviate((String)dir.getAbsolutePath(), (int)maxDirDisplayLength) : this.messages.getString("guiNgramDirSelect");
        JButton ngramDirButton = new JButton(buttonText);
        ngramDirButton.addActionListener(e -> {
            File newDir = Tools.openDirectoryDialog(this.owner, dir);
            if (newDir != null) {
                try {
                    if (this.config.getLanguage() != null) {
                        File checkDir = new File(newDir, this.config.getLanguage().getShortCode());
                        LuceneLanguageModel.validateDirectory((File)checkDir);
                    }
                    this.config.setNgramDirectory(newDir);
                    ngramDirButton.setText(StringUtils.abbreviate((String)newDir.getAbsolutePath(), (int)maxDirDisplayLength));
                }
                catch (Exception ex) {
                    Tools.showErrorMessage(ex);
                }
            } else {
                this.config.setNgramDirectory(null);
                ngramDirButton.setText(StringUtils.abbreviate((String)this.messages.getString("guiNgramDirSelect"), (int)maxDirDisplayLength));
            }
        });
        panel.add((Component)ngramDirButton, cons);
        JButton helpButton = new JButton(this.messages.getString("guiNgramHelp"));
        helpButton.addActionListener(e -> Tools.openURL("http://wiki.languagetool.org/finding-errors-using-n-gram-data"));
        panel.add((Component)helpButton, cons);
        return panel;
    }

    private JPanel getWord2VecPanel(GridBagConstraints cons) {
        JPanel panel = new JPanel();
        panel.add((Component)new JLabel(this.messages.getString("guiWord2VecDir")), cons);
        File dir = this.config.getWord2VecDirectory();
        int maxDirDisplayLength = 45;
        String buttonText = dir != null ? StringUtils.abbreviate((String)dir.getAbsolutePath(), (int)maxDirDisplayLength) : this.messages.getString("guiWord2VecDirSelect");
        JButton word2vecDirButton = new JButton(buttonText);
        word2vecDirButton.addActionListener(e -> {
            File newDir = Tools.openDirectoryDialog(this.owner, dir);
            if (newDir != null) {
                try {
                    this.config.setWord2VecDirectory(newDir);
                    word2vecDirButton.setText(StringUtils.abbreviate((String)newDir.getAbsolutePath(), (int)maxDirDisplayLength));
                }
                catch (Exception ex) {
                    Tools.showErrorMessage(ex);
                }
            } else {
                this.config.setWord2VecDirectory(null);
                word2vecDirButton.setText(StringUtils.abbreviate((String)this.messages.getString("guiWord2VecDirSelect"), (int)maxDirDisplayLength));
            }
        });
        panel.add((Component)word2vecDirButton, cons);
        JButton helpButton = new JButton(this.messages.getString("guiWord2VecHelp"));
        helpButton.addActionListener(e -> Tools.openURL("https://github.com/gulp21/languagetool-neural-network"));
        panel.add((Component)helpButton, cons);
        return panel;
    }

    private String[] getPossibleMotherTongues() {
        ArrayList<String> motherTongues = new ArrayList<String>();
        if (!this.insideOffice) {
            motherTongues.add(NO_MOTHER_TONGUE);
        }
        for (Language lang : Languages.get()) {
            motherTongues.add(lang.getTranslatedName(this.messages));
            motherTongues.sort(null);
        }
        return motherTongues.toArray(new String[motherTongues.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ACTION_COMMAND_OK.equals(e.getActionCommand())) {
            String serverName;
            if (this.original != null) {
                this.original.restoreState(this.config);
            }
            for (JPanel extra : this.extraPanels) {
                if (!(extra instanceof SavablePanel)) continue;
                ((SavablePanel)((Object)extra)).save();
            }
            if (this.insideOffice && this.config.doRemoteCheck() && this.config.useOtherServer() && ((serverName = this.config.getServerUrl()) == null || !serverName.startsWith("http://") && !serverName.startsWith("https://") || serverName.endsWith("/") || serverName.endsWith("/v2"))) {
                JOptionPane.showMessageDialog(this.dialog, Tools.getLabel(this.messages.getString("guiUseServerWarning1")) + "\n" + Tools.getLabel(this.messages.getString("guiUseServerWarning2")));
                if (serverName.endsWith("/")) {
                    serverName = serverName.substring(0, serverName.length() - 1);
                    this.config.setOtherServerUrl(serverName);
                }
                if (serverName.endsWith("/v2")) {
                    serverName = serverName.substring(0, serverName.length() - 3);
                    this.config.setOtherServerUrl(serverName);
                }
                this.restartShow = true;
                this.dialog.setVisible(false);
                return;
            }
            this.configChanged = true;
            this.dialog.setVisible(false);
        } else if (ACTION_COMMAND_CANCEL.equals(e.getActionCommand())) {
            this.dialog.setVisible(false);
        }
    }

    @Nullable
    private Language getLanguageForLocalizedName(String languageName) {
        for (Language element : Languages.get()) {
            if (!languageName.equals(element.getTranslatedName(this.messages))) continue;
            return element;
        }
        return null;
    }

    private JPanel getSpecialRuleValuePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.anchor = 17;
        ArrayList<JCheckBox> ruleCheckboxes = new ArrayList<JCheckBox>();
        ArrayList<JLabel> ruleLabels = new ArrayList<JLabel>();
        ArrayList<JTextField> ruleValueFields = new ArrayList<JTextField>();
        for (int i = 0; i < this.configurableRules.size(); ++i) {
            final Rule rule = this.configurableRules.get(i);
            JCheckBox ruleCheckbox = new JCheckBox(rule.getDescription());
            ruleCheckboxes.add(ruleCheckbox);
            ruleCheckbox.setSelected(this.getEnabledState(rule));
            cons.insets = new Insets(3, 0, 0, 0);
            panel.add((Component)ruleCheckbox, cons);
            cons.insets = new Insets(0, 24, 0, 0);
            ++cons.gridy;
            JLabel ruleLabel = new JLabel(rule.getConfigureText());
            ruleLabels.add(ruleLabel);
            ruleLabel.setEnabled(ruleCheckbox.isSelected());
            panel.add((Component)ruleLabel, cons);
            ++cons.gridx;
            int value = this.config.getConfigurableValue(rule.getId());
            if (this.config.getConfigurableValue(rule.getId()) < 0) {
                value = rule.getDefaultValue();
            }
            final JTextField ruleValueField = new JTextField(Integer.toString(value), 2);
            ruleValueFields.add(ruleValueField);
            ruleValueField.setEnabled(ruleCheckbox.isSelected());
            ruleValueField.setMinimumSize(new Dimension(35, 25));
            panel.add((Component)ruleValueField, cons);
            ruleCheckbox.addActionListener(e -> {
                ruleValueField.setEnabled(ruleCheckbox.isSelected());
                ruleLabel.setEnabled(ruleCheckbox.isSelected());
                if (ruleCheckbox.isSelected()) {
                    this.config.getEnabledRuleIds().add(rule.getId());
                    this.config.getDisabledRuleIds().remove(rule.getId());
                } else {
                    this.config.getEnabledRuleIds().remove(rule.getId());
                    this.config.getDisabledRuleIds().add(rule.getId());
                }
            });
            ruleValueField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    try {
                        int num = Integer.parseInt(ruleValueField.getText());
                        if (num < rule.getMinConfigurableValue()) {
                            num = rule.getMinConfigurableValue();
                            ruleValueField.setForeground(Color.RED);
                        } else if (num > rule.getMaxConfigurableValue()) {
                            num = rule.getMaxConfigurableValue();
                            ruleValueField.setForeground(Color.RED);
                        } else {
                            ruleValueField.setForeground(null);
                        }
                        ConfigurationDialog.this.config.setConfigurableValue(rule.getId(), num);
                    }
                    catch (Exception ex) {
                        ruleValueField.setForeground(Color.RED);
                    }
                }
            });
            cons.gridx = 0;
            ++cons.gridy;
        }
        return panel;
    }

    private String[] getUnderlineTypes() {
        String[] types = new String[]{this.messages.getString("guiUTypeWave"), this.messages.getString("guiUTypeBoldWave"), this.messages.getString("guiUTypeBold"), this.messages.getString("guiUTypeDash")};
        return types;
    }

    private int getUnderlineType(String category) {
        short nType = this.config.getUnderlineType(category);
        if (nType == 18) {
            return 1;
        }
        if (nType == 12) {
            return 2;
        }
        if (nType == 5) {
            return 3;
        }
        return 0;
    }

    private void setUnderlineType(int index, String category) {
        if (index == 1) {
            this.config.setUnderlineType(category, (short)18);
        } else if (index == 2) {
            this.config.setUnderlineType(category, (short)12);
        } else if (index == 3) {
            this.config.setUnderlineType(category, (short)5);
        } else {
            this.config.setDefaultUnderlineType(category);
        }
    }

    JPanel getUnderlineColorPanel(List<Rule> rules) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.fill = 0;
        cons.anchor = 18;
        ArrayList<String> categories = new ArrayList<String>();
        for (Rule rule : rules) {
            String category = rule.getCategory().getName();
            boolean contain = false;
            for (String c : categories) {
                if (!c.equals(category)) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            categories.add(category);
        }
        ArrayList<JLabel> categorieLabel = new ArrayList<JLabel>();
        ArrayList<JLabel> underlineLabel = new ArrayList<JLabel>();
        ArrayList<JButton> changeButton = new ArrayList<JButton>();
        ArrayList<JButton> defaultButton = new ArrayList<JButton>();
        ArrayList<JComboBox<String>> underlineType = new ArrayList<JComboBox<String>>();
        for (int nCat = 0; nCat < categories.size(); ++nCat) {
            categorieLabel.add(new JLabel((String)categories.get(nCat) + " "));
            underlineLabel.add(new JLabel(" \u2588\u2588\u2588 "));
            ((JLabel)underlineLabel.get(nCat)).setForeground(this.config.getUnderlineColor((String)categories.get(nCat)));
            ((JLabel)underlineLabel.get(nCat)).setBackground(this.config.getUnderlineColor((String)categories.get(nCat)));
            JLabel uLabel = (JLabel)underlineLabel.get(nCat);
            String cLabel = (String)categories.get(nCat);
            panel.add((Component)categorieLabel.get(nCat), cons);
            underlineType.add(new JComboBox<String>(this.getUnderlineTypes()));
            JComboBox uLineType = (JComboBox)underlineType.get(nCat);
            if (this.insideOffice) {
                uLineType.setSelectedIndex(this.getUnderlineType(cLabel));
                uLineType.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        this.setUnderlineType(uLineType.getSelectedIndex(), cLabel);
                    }
                });
                ++cons.gridx;
                panel.add((Component)uLineType, cons);
            }
            ++cons.gridx;
            panel.add((Component)underlineLabel.get(nCat), cons);
            changeButton.add(new JButton(this.messages.getString("guiUColorChange")));
            ((JButton)changeButton.get(nCat)).addActionListener(e -> {
                Color oldColor = uLabel.getForeground();
                Color newColor = JColorChooser.showDialog(null, this.messages.getString("guiUColorDialogHeader"), oldColor);
                if (newColor != null && newColor != oldColor) {
                    uLabel.setForeground(newColor);
                    this.config.setUnderlineColor(cLabel, newColor);
                }
            });
            ++cons.gridx;
            panel.add((Component)changeButton.get(nCat), cons);
            defaultButton.add(new JButton(this.messages.getString("guiUColorDefault")));
            ((JButton)defaultButton.get(nCat)).addActionListener(e -> {
                this.config.setDefaultUnderlineColor(cLabel);
                uLabel.setForeground(this.config.getUnderlineColor(cLabel));
                if (this.insideOffice) {
                    this.config.setDefaultUnderlineType(cLabel);
                    uLineType.setSelectedIndex(this.getUnderlineType(cLabel));
                }
            });
            ++cons.gridx;
            panel.add((Component)defaultButton.get(nCat), cons);
            cons.gridx = 0;
            ++cons.gridy;
        }
        return panel;
    }

    static class CategoryComparator
    implements Comparator<Rule> {
        CategoryComparator() {
        }

        @Override
        public int compare(Rule r1, Rule r2) {
            boolean hasCat;
            boolean bl = hasCat = r1.getCategory() != null && r2.getCategory() != null;
            if (hasCat) {
                int res = r1.getCategory().getName().compareTo(r2.getCategory().getName());
                if (res == 0) {
                    return r1.getDescription().compareToIgnoreCase(r2.getDescription());
                }
                return res;
            }
            return r1.getDescription().compareToIgnoreCase(r2.getDescription());
        }
    }
}

