/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.Map;
import java.util.Objects;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.Term;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.term_t;

public class Atom
extends Term {
    protected final String name;
    protected final String type;

    public Atom(String string) {
        if (string == null) {
            throw new JPLException("cannot construct with null name");
        }
        this.name = string;
        this.type = "text";
    }

    public Atom(String string, String string2) {
        if (string == null) {
            throw new JPLException("cannot construct with null name");
        }
        if (string2 == null) {
            throw new JPLException("cannot construct with null type");
        }
        if (string2.equals("jref")) {
            throw new JPLException("cannot construct a <jref>() atom (use JPL.newJRef)");
        }
        this.name = string;
        this.type = string2;
    }

    @Override
    public Term[] args() {
        return new Term[0];
    }

    @Override
    public final String atomType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Atom atom = (Atom)object;
        return this.name.equals(atom.name) && this.type.equals(atom.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Override
    public final boolean hasFunctor(String string, int n) {
        return string.equals(this.name) && n == 0;
    }

    @Override
    protected final boolean isAtomOfNameType(String string, String string2) {
        return string != null && string2 != null && string.equals(this.name) && string2.equals(this.type);
    }

    @Override
    public final boolean isListNil() {
        return this.equals(JPL.LIST_NIL);
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    protected void put(Map<String, term_t> map, term_t term_t2) {
        if (this.equals(JPL.LIST_NIL)) {
            Prolog.put_nil(term_t2);
        } else {
            Prolog.put_atom_chars(term_t2, this.name);
        }
    }

    public String toString() {
        return JPL.isSimpleName(this.name) || this.isListNil() ? this.name : "'" + this.name + "'";
    }

    @Override
    public final int type() {
        return 2;
    }

    @Override
    public String typeName() {
        return "Atom";
    }
}

