## Contributing code the right way 

*(or: how I learned to post merge requests without crying myself to sleep)*

New user accounts on Gogs are not allowed to fork repositories because people 
use development accounts to spam. To get initial fork access, do the following:

1. Register on the forums and on [Gogs](https://git.tt-rss.org);
2. Create a thread describing your proposed changes in [Development subforum](https://community.tt-rss.org/c/tiny-tiny-rss/development) 
while including your Gogs username;
3. You'll be given proper access and will be able to fork repositories and file PRs, etc;

If you already have a fully functional Gogs account it works pretty much like Github:

1. Fork the repository you're interested in;
2. Do the needful;
3. File a pull request with your changes against master branch;

That's it. If you have any other questions, see this [forum thread](https://discourse.tt-rss.org/t/how-to-contribute-code-via-pull-requests-on-git-tt-rss-org/1850).

If you don't want to deal with the above, you can also clone one of the repositories 
locally, do the needful, and post resulting patches on the [forums](https://community.tt-rss.org/c/tiny-tiny-rss/development). 

Please don't inline patches in forum posts, attach files instead (``.patch`` or ``.diff`` file 
extensions should work).

## Contributing translations

Believe it or not, people also spam using Weblate. Therefore, there's some minor 
jumping through hoops involved here:

1. Register on [Weblate](https://weblate.tt-rss.org/) / forums;
2. Post in the [Weblate discussion thread](https://community.tt-rss.org/t/easier-translations-with-weblate/1680) on the forum, ask to be added to a project 
you're interested in;
3. You'll be given proper access rights and will be able to edit translations. 

That's it. If the language you're interested is not available yet, ask and we'll add it;
