/* Library libcerf:
 *   A self-contained numeric library that provides an efficient and accurate implementation
 *   of complex error functions, along with Dawson, Faddeeva, and Voigt functions.
 *
 * File cerf_ptr.h:
 *   Wrappers around complex functions.
 *   By casting pointers from (double _Complex)*, which is C only, to void*,
 *   we make the wrapped functions callable from C++.
 *
 * Copyright:
 *   (C) 2012 Massachusetts Institute of Technology
 *   (C) 2013 Forschungszentrum Jülich GmbH
 *
 * Licence:
 *   Permission is hereby granted, free of charge, to any person obtaining
 *   a copy of this software and associated documentation files (the
 *   "Software"), to deal in the Software without restriction, including
 *   without limitation the rights to use, copy, modify, merge, publish,
 *   distribute, sublicense, and/or sell copies of the Software, and to
 *   permit persons to whom the Software is furnished to do so, subject to
 *   the following conditions:
 *
 *   The above copyright notice and this permission notice shall be
 *   included in all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *   LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 *   OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *   WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *   Steven G. Johnson, Massachusetts Institute of Technology, 2012, core author
 *   Joachim Wuttke, Forschungszentrum Jülich, 2013, package maintainer
 *
 * Website:
 *   http://apps.jcns.fz-juelich.de/libcerf
 *
 * Revision history:
 *   ../CHANGELOG
 *
 * Man pages:
 *   w_of_z(3), dawson(3), voigt(3), cerf(3), erfcx(3), erfi(3)
 */

#ifndef CERF_PTR_H
#define CERF_PTR_H

#ifdef __cplusplus
extern "C" {
#endif

#if _WIN32
#define EXPORT __declspec(dllexport)
#else
#define EXPORT
#endif

EXPORT void p_w_of_z(void* z, void* ret);
EXPORT void p_cerf(void* z, void* ret);
EXPORT void p_cerfc(void* z, void* ret);
EXPORT void p_cerfcx(void* z, void* ret);
EXPORT void p_cerfi(void* z, void* ret);
EXPORT void p_cdawson(void* z, void* ret);

#ifdef __cplusplus
} // extern "C"
#endif

#endif // CERF_PTR_H
