/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.SSLConf;
import org.apache.tomcat.util.net.openssl.OpenSSLConfCmd;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLConf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(OpenSSLConf.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLConf.class);
    private final List<OpenSSLConfCmd> commands = new ArrayList<OpenSSLConfCmd>();

    public void addCmd(OpenSSLConfCmd cmd) {
        this.commands.add(cmd);
    }

    public List<OpenSSLConfCmd> getCommands() {
        return this.commands;
    }

    public boolean check(long cctx) throws Exception {
        boolean result = true;
        Iterator<OpenSSLConfCmd> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            int rc;
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = iterator.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{value}));
                result = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("opensslconf.checkCommand", new Object[]{name, value}));
            }
            try {
                rc = SSLConf.check((long)cctx, (String)name, (String)value);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("opensslconf.checkFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{name, value, Integer.toString(rc)}));
                result = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("opensslconf.resultCommand", new Object[]{name, value, Integer.toString(rc)}));
        }
        if (!result) {
            log.error((Object)sm.getString("opensslconf.checkFailed"));
        }
        return result;
    }

    public boolean apply(long cctx, long ctx) throws Exception {
        int rc;
        boolean result = true;
        SSLConf.assign((long)cctx, (long)ctx);
        Iterator<OpenSSLConfCmd> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = iterator.next();
            String name = cmd.getName();
            String value = cmd.getValue();
            if (name == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{value}));
                result = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("opensslconf.applyCommand", new Object[]{name, value}));
            }
            try {
                rc = SSLConf.apply((long)cctx, (String)name, (String)value);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("opensslconf.applyFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{name, value, Integer.toString(rc)}));
                result = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("opensslconf.resultCommand", new Object[]{name, value, Integer.toString(rc)}));
        }
        rc = SSLConf.finish((long)cctx);
        if (rc <= 0) {
            log.error((Object)sm.getString("opensslconf.finishFailed", new Object[]{Integer.toString(rc)}));
            result = false;
        }
        if (!result) {
            log.error((Object)sm.getString("opensslconf.applyFailed"));
        }
        return result;
    }
}

