/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.utils;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Pair;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.filehandling.FileHandlingUtils;
import org.islandoftex.arara.filehandling.FileSearchingUtils;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.model.Session;
import org.islandoftex.arara.ruleset.Command;
import org.islandoftex.arara.utils.ClassLoadingUtils;
import org.islandoftex.arara.utils.CommonUtils;
import org.islandoftex.arara.utils.MessageUtils;
import org.islandoftex.arara.utils.SystemCallUtils;

public class Methods {
    private static final LanguageController messages = LanguageController.INSTANCE;
    private static final Session session = Session.INSTANCE;

    public static Map<String, Object> getRuleMethods() {
        HashMap<String, Object> map2 = new HashMap<String, Object>(Methods.getConditionalMethods());
        try {
            Method[] methods2 = Methods.class.getMethods();
            Arrays.asList("getOriginalFile", "getOriginalReference", "isEmpty", "isNotEmpty", "isTrue", "isFalse", "trimSpaces", "getBasename", "getFiletype", "throwError", "getSession", "isWindows", "isLinux", "isMac", "isUnix", "isCygwin", "replicatePattern", "buildString", "getCommand", "checkClass", "isString", "isList", "isMap", "isBoolean", "isVerboseMode", "showMessage", "isOnPath", "unsafelyExecuteSystemCommand", "getCommandWithWorkingDirectory", "listFilesByExtensions", "listFilesByPatterns", "writeToFile", "readFromFile", "isSubdirectory", "halt").forEach(name -> map2.put((String)name, Stream.of(methods2).filter(m -> m.getName().equals(name)).findFirst().get()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map2;
    }

    public static Map<String, Object> getConditionalMethods() {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        try {
            Method[] methods2 = Methods.class.getMethods();
            Arrays.asList("exists", "missing", "changed", "unchanged", "found", "toFile", "showDropdown", "showInput", "showOptions", "currentFile", "loadClass", "loadObject").forEach(name -> map2.put((String)name, Stream.of(methods2).filter(m -> m.getName().equals(name)).findFirst().get()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map2;
    }

    public static void halt() {
        Methods.halt(0);
    }

    public static void halt(int status) {
        session.put("arara:" + Methods.getOriginalFile() + ":halt", status);
    }

    public static String getOriginalFile() {
        File file2 = Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getReference());
        return file2.getName();
    }

    public static File getOriginalReference() {
        return Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getReference());
    }

    public static boolean isEmpty(String string) {
        return string.equals("");
    }

    public static boolean isNotEmpty(String string) {
        return !Methods.isEmpty(string);
    }

    public static Object isEmpty(String string, Object yes) {
        return Methods.isEmpty(string) ? yes : "";
    }

    public static Object isNotEmpty(String string, Object yes) {
        return Methods.isNotEmpty(string) ? yes : "";
    }

    public static Object isEmpty(String string, Object yes, Object no) {
        return Methods.isEmpty(string) ? yes : no;
    }

    public static Object isNotEmpty(String string, Object yes, Object no) {
        return Methods.isNotEmpty(string) ? yes : no;
    }

    public static boolean isTrue(String string) throws AraraException {
        return !Methods.isEmpty(string) && CommonUtils.INSTANCE.checkBoolean(string);
    }

    public static boolean isFalse(String string) throws AraraException {
        return !Methods.isEmpty(string) && !CommonUtils.INSTANCE.checkBoolean(string);
    }

    public static Object isTrue(String string, Object yes) throws AraraException {
        return Methods.isTrue(string) ? yes : "";
    }

    public static Object isFalse(String string, Object yes) throws AraraException {
        return Methods.isFalse(string) ? yes : "";
    }

    public static Object isTrue(String string, Object yes, Object no) throws AraraException {
        return Methods.isTrue(string) ? yes : no;
    }

    public static Object isFalse(String string, Object yes, Object no) throws AraraException {
        return Methods.isFalse(string) ? yes : no;
    }

    public static Object isTrue(String string, Object yes, Object no, Object fallback) throws AraraException {
        return Methods.isEmpty(string) ? fallback : (Methods.isTrue(string) ? yes : no);
    }

    public static Object isFalse(String string, Object yes, Object no, Object fallback) throws AraraException {
        return Methods.isEmpty(string) ? fallback : (Methods.isFalse(string) ? yes : no);
    }

    public static String trimSpaces(String string) {
        return string.trim();
    }

    public static Object isTrue(boolean value2, Object yes) {
        return value2 ? yes : "";
    }

    public static Object isFalse(boolean value2, Object yes) {
        return !value2 ? yes : "";
    }

    public static Object isTrue(boolean value2, Object yes, Object no) {
        return value2 ? yes : no;
    }

    public static Object isFalse(boolean value2, Object yes, Object no) {
        return !value2 ? yes : no;
    }

    public static String getBasename(File file2) throws AraraException {
        if (file2.isFile()) {
            return FileHandlingUtils.INSTANCE.getBasename(file2);
        }
        throw new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_BASENAME_NOT_A_FILE, file2.getName())));
    }

    public static String getBasename(String filename) {
        return FileHandlingUtils.INSTANCE.getBasename(new File(filename));
    }

    public static String getFiletype(File file2) throws AraraException {
        if (file2.isFile()) {
            return FileHandlingUtils.INSTANCE.getFileExtension(file2);
        }
        throw new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_FILETYPE_NOT_A_FILE, file2.getName())));
    }

    public static String getFiletype(String filename) {
        return FileHandlingUtils.INSTANCE.getFileExtension(new File(filename));
    }

    public static List<Object> replicatePattern(String pattern, List<Object> values2) throws AraraException {
        return CommonUtils.INSTANCE.replicateList(pattern, values2);
    }

    public static void throwError(String text2) throws AraraException {
        throw new AraraException(text2);
    }

    public static Session getSession() {
        return session;
    }

    public static boolean isWindows() throws AraraException {
        return CommonUtils.INSTANCE.checkOS("windows");
    }

    public static boolean isCygwin() throws AraraException {
        return CommonUtils.INSTANCE.checkOS("cygwin");
    }

    public static boolean isLinux() throws AraraException {
        return CommonUtils.INSTANCE.checkOS("linux");
    }

    public static boolean isMac() throws AraraException {
        return CommonUtils.INSTANCE.checkOS("mac");
    }

    public static boolean isUnix() throws AraraException {
        return CommonUtils.INSTANCE.checkOS("unix");
    }

    public static Object isWindows(Object yes, Object no) throws AraraException {
        return CommonUtils.INSTANCE.checkOS("windows") ? yes : no;
    }

    public static Object isCygwin(Object yes, Object no) throws AraraException {
        return CommonUtils.INSTANCE.checkOS("cygwin") ? yes : no;
    }

    public static Object isLinux(Object yes, Object no) throws AraraException {
        return CommonUtils.INSTANCE.checkOS("linux") ? yes : no;
    }

    public static Object isMac(Object yes, Object no) throws AraraException {
        return CommonUtils.INSTANCE.checkOS("mac") ? yes : no;
    }

    public static Object isUnix(Object yes, Object no) throws AraraException {
        return CommonUtils.INSTANCE.checkOS("unix") ? yes : no;
    }

    public static boolean exists(String extension) throws AraraException {
        return FileHandlingUtils.INSTANCE.exists(extension);
    }

    public static boolean missing(String extension) throws AraraException {
        return !Methods.exists(extension);
    }

    public static boolean changed(String extension) throws AraraException {
        return FileHandlingUtils.INSTANCE.hasChanged(extension);
    }

    public static boolean unchanged(String extension) throws AraraException {
        return !Methods.changed(extension);
    }

    public static boolean exists(File filename) {
        return filename.exists();
    }

    public static boolean missing(File filename) {
        return !Methods.exists(filename);
    }

    public static boolean changed(File filename) throws AraraException {
        return FileHandlingUtils.INSTANCE.hasChanged(filename);
    }

    public static boolean unchanged(File filename) throws AraraException {
        return !Methods.changed(filename);
    }

    public static String buildString(Object ... objects) {
        return CommonUtils.INSTANCE.generateString(objects);
    }

    public static boolean found(String extension, String regex) throws AraraException {
        return CommonUtils.INSTANCE.checkRegex(extension, regex);
    }

    public static boolean found(File file2, String regex) throws AraraException {
        return CommonUtils.INSTANCE.checkRegex(file2, regex);
    }

    public static Command getCommand(List<String> elements) {
        return new Command(elements);
    }

    public static Command getCommand(Object ... elements) {
        return new Command(elements);
    }

    public static Command getCommandWithWorkingDirectory(String path, Object ... elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(new File(path));
        return command;
    }

    public static Command getCommandWithWorkingDirectory(File file2, Object ... elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(file2);
        return command;
    }

    public static Command getCommandWithWorkingDirectory(String path, List<String> elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(new File(path));
        return command;
    }

    public static Command getCommandWithWorkingDirectory(File file2, List<String> elements) {
        Command command = new Command(elements);
        command.setWorkingDirectory(file2);
        return command;
    }

    public static boolean checkClass(Class<?> clazz, Object object) {
        return clazz.isInstance(object);
    }

    public static boolean isString(Object object) {
        return Methods.checkClass(String.class, object);
    }

    public static boolean isList(Object object) {
        return Methods.checkClass(List.class, object);
    }

    public static boolean isMap(Object object) {
        return Methods.checkClass(Map.class, object);
    }

    public static boolean isBoolean(Object object) {
        return Methods.checkClass(Boolean.class, object);
    }

    public static boolean isVerboseMode() {
        return Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getVerbose());
    }

    public static File toFile(String name) {
        return new File(name);
    }

    public static void showMessage(int width, int type2, String title, String text2) {
        MessageUtils.INSTANCE.showMessage(width, type2, title, text2);
    }

    public static void showMessage(int type2, String title, String text2) {
        MessageUtils.INSTANCE.showMessage(type2, title, text2);
    }

    public static int showOptions(int width, int type2, String title, String text2, Object ... buttons) {
        return MessageUtils.INSTANCE.showOptions(width, type2, title, text2, buttons);
    }

    public static int showOptions(int type2, String title, String text2, Object ... buttons) {
        return MessageUtils.INSTANCE.showOptions(type2, title, text2, buttons);
    }

    public static String showInput(int width, int type2, String title, String text2) {
        return MessageUtils.INSTANCE.showInput(width, type2, title, text2);
    }

    public static String showInput(int type2, String title, String text2) {
        return MessageUtils.INSTANCE.showInput(type2, title, text2);
    }

    public static int showDropdown(int width, int type2, String title, String text2, Object ... elements) {
        return MessageUtils.INSTANCE.showDropdown(width, type2, title, text2, elements);
    }

    public static int showDropdown(int type2, String title, String text2, Object ... elements) {
        return MessageUtils.INSTANCE.showDropdown(type2, title, text2, elements);
    }

    public static boolean isOnPath(String command) {
        return CommonUtils.INSTANCE.isOnPath(command);
    }

    public static Pair<Integer, String> unsafelyExecuteSystemCommand(Command command) {
        return SystemCallUtils.INSTANCE.executeSystemCommand(command);
    }

    public static File currentFile() {
        return Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getFile());
    }

    public static Pair<Integer, Class<?>> loadClass(File file2, String name) {
        Pair<ClassLoadingUtils.ClassLoadingStatus, Class<?>> pair2 = ClassLoadingUtils.INSTANCE.loadClass(file2, name);
        return new Pair(pair2.getFirst().ordinal(), pair2.getSecond());
    }

    public static Pair<Integer, Class<?>> loadClass(String ref, String name) {
        Pair<ClassLoadingUtils.ClassLoadingStatus, Class<?>> pair2 = ClassLoadingUtils.INSTANCE.loadClass(new File(ref), name);
        return new Pair(pair2.getFirst().ordinal(), pair2.getSecond());
    }

    public static Pair<Integer, Object> loadObject(File file2, String name) {
        Pair<ClassLoadingUtils.ClassLoadingStatus, Object> pair2 = ClassLoadingUtils.INSTANCE.loadObject(file2, name);
        return new Pair<Integer, Object>(pair2.getFirst().ordinal(), pair2.getSecond());
    }

    public static Pair<Integer, Object> loadObject(String ref, String name) {
        Pair<ClassLoadingUtils.ClassLoadingStatus, Object> pair2 = ClassLoadingUtils.INSTANCE.loadObject(new File(ref), name);
        return new Pair<Integer, Object>(pair2.getFirst().ordinal(), pair2.getSecond());
    }

    public static List<File> listFilesByExtensions(File directory, List<String> extensions, boolean recursive) {
        return FileSearchingUtils.INSTANCE.listFilesByExtensions(directory, extensions, recursive);
    }

    public static List<File> listFilesByExtensions(String path, List<String> extensions, boolean recursive) {
        return FileSearchingUtils.INSTANCE.listFilesByExtensions(new File(path), extensions, recursive);
    }

    public static List<File> listFilesByPatterns(File directory, List<String> patterns, boolean recursive) {
        return FileSearchingUtils.INSTANCE.listFilesByPatterns(directory, patterns, recursive);
    }

    public static List<File> listFilesByPatterns(String path, List<String> patterns, boolean recursive) {
        return FileSearchingUtils.INSTANCE.listFilesByPatterns(new File(path), patterns, recursive);
    }

    public static boolean writeToFile(File file2, String text2, boolean append) {
        return FileHandlingUtils.INSTANCE.writeToFile(file2, text2, append);
    }

    public static boolean writeToFile(String path, String text2, boolean append) {
        return FileHandlingUtils.INSTANCE.writeToFile(new File(path), text2, append);
    }

    public static boolean writeToFile(File file2, List<String> lines, boolean append) {
        return FileHandlingUtils.INSTANCE.writeToFile(file2, lines, append);
    }

    public static boolean writeToFile(String path, List<String> lines, boolean append) {
        return FileHandlingUtils.INSTANCE.writeToFile(new File(path), lines, append);
    }

    public static List<String> readFromFile(File file2) {
        return FileHandlingUtils.INSTANCE.readFromFile(file2);
    }

    public static List<String> readFromFile(String path) {
        return FileHandlingUtils.INSTANCE.readFromFile(new File(path));
    }

    public static boolean isSubdirectory(File directory) throws AraraException {
        return FileHandlingUtils.INSTANCE.isSubDirectory(directory, Methods.getOriginalReference());
    }
}

