/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import java.util.Map;
import org.mvel2.DataConversion;
import org.mvel2.integration.VariableResolver;

public class MapVariableResolver
implements VariableResolver {
    private String name;
    private Class<?> knownType;
    private Map<String, Object> variableMap;

    public MapVariableResolver(Map<String, Object> variableMap, String name) {
        this.variableMap = variableMap;
        this.name = name;
    }

    public MapVariableResolver(Map<String, Object> variableMap, String name, Class knownType) {
        this.name = name;
        this.knownType = knownType;
        this.variableMap = variableMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setStaticType(Class knownType) {
        this.knownType = knownType;
    }

    public void setVariableMap(Map<String, Object> variableMap) {
        this.variableMap = variableMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.knownType;
    }

    @Override
    public void setValue(Object value2) {
        if (this.knownType != null && value2 != null && value2.getClass() != this.knownType) {
            if (!DataConversion.canConvert(this.knownType, value2.getClass())) {
                throw new RuntimeException("cannot assign " + value2.getClass().getName() + " to type: " + this.knownType.getName());
            }
            try {
                value2 = DataConversion.convert(value2, this.knownType);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot convert value of " + value2.getClass().getName() + " to: " + this.knownType.getName());
            }
        }
        this.variableMap.put(this.name, value2);
    }

    @Override
    public Object getValue() {
        return this.variableMap.get(this.name);
    }

    @Override
    public int getFlags() {
        return 0;
    }
}

