#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_vlans
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: junos_vlans
short_description: VLANs resource module
description:
- This module creates and manages VLAN configurations on Junos OS.
version_added: 1.0.0
author: Daniel Mellado (@dmellado)
requirements:
- ncclient (>=v0.6.4)
notes:
- This module requires the netconf system service be enabled on the remote device
  being managed
- Tested against Junos OS 18.4R1
- This module works with connection C(netconf). See L(the Junos OS Platform Options,../network/user_guide/platform_junos.html).
options:
  config:
    description: A dictionary of Vlan options
    type: list
    elements: dict
    suboptions:
      vlan_id:
        description:
        - IEEE 802.1q VLAN identifier for VLAN (1..4094).
        type: int
      name:
        description:
        - Name of VLAN.
        type: str
        required: true
      description:
        description:
        - Text description of VLANs
        type: str
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show vlans).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result
    type: str
  state:
    description:
    - The state of the configuration after module completion.
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - parsed
    - rendered
    default: merged
"""

EXAMPLES = """
# Using merged
#############

# Before State
# ------------
#
# admin# show vlans
# vlan-2 {
#     vlan-id 2;
# }
# vlan-3 {
#     vlan-id 3;
# }

- name: Merge JUNOS vlan
  junipernetworks.junos.junos_vlans:
    config:
    - name: vlan-1
      vlan-id: 1
  state: merged
- name: Replace JUNOS vlan
  junipernetworks.junos.junos_vlans:
    config:
    - name: vlan-1
      vlan-id: 10
    - name: vlan-3
      vlan-id: 30
  state: replaced
- name: Override JUNOS vlan
  junipernetworks.junos.junos_vlans:
    config:
    - name: vlan-4
      vlan-id: 100
    - name: vlan-2
      vlan-id: 200
  state: overridden
- name: Delete JUNOS vlan
  junipernetworks.junos.junos_vlans:
    config:
    - name: vlan-1
  state: deleted
"""

RETURN = """
before:
  description: The configuration as structured data prior to module invocation.
  returned: always
  type: str
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The configuration as structured data after module completion.
  returned: when changed
  type: str
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['xml 1', 'xml 2', 'xml 3']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.vlans.vlans import (
    VlansArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.vlans.vlans import (
    Vlans,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]

    module = AnsibleModule(
        argument_spec=VlansArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Vlans(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
