/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class CommandButtonLayoutManagerBigFixed
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize() {
        return 32;
    }

    @Override
    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = commandButton.getFontMetrics(commandButton.getFont());
        JSeparator jsep = new JSeparator(1);
        int layoutVGap = FlamingoUtilities.getVLayoutGap(commandButton);
        int fillTitleWidth = fm.stringWidth(commandButton.getText());
        int widthFull = Math.max(this.getPreferredIconSize(), fillTitleWidth);
        int heightFull = by + this.getPreferredIconSize() + layoutVGap + jsep.getPreferredSize().width;
        if (commandButton.getText() != null) {
            heightFull += fm.getHeight();
        }
        widthFull = Math.max(widthFull, heightFull);
        return new Dimension(bx + widthFull, heightFull);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
        return new Point(commandButton.getWidth() / 2, commandButton.getHeight());
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int x = ins.left;
        int y = ins.top;
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton instanceof JCommandButton ? ((JCommandButton)commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        result.isTextInActionArea = false;
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_ONLY) {
            result.actionClickArea.x = 0;
            result.actionClickArea.y = 0;
            result.actionClickArea.width = width;
            result.actionClickArea.height = height;
            result.isTextInActionArea = true;
        }
        if (buttonKind == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            result.popupClickArea.x = 0;
            result.popupClickArea.y = 0;
            result.popupClickArea.width = width;
            result.popupClickArea.height = height;
        }
        JSeparator jsep = new JSeparator(1);
        ResizableIcon buttonIcon = commandButton.getIcon();
        if (commandButton.getText() == null) {
            y = ins.top + (height - ins.top - ins.bottom - buttonIcon.getIconHeight()) / 2;
        }
        result.iconRect.x = (width - buttonIcon.getIconWidth()) / 2;
        result.iconRect.y = y;
        result.iconRect.width = buttonIcon.getIconWidth();
        result.iconRect.height = buttonIcon.getIconHeight();
        y += buttonIcon.getIconHeight();
        y += jsep.getPreferredSize().width;
        CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
        lineLayoutInfo.text = commandButton.getText();
        lineLayoutInfo.textRect = new Rectangle();
        int labelWidth = (int)fm.getStringBounds(commandButton.getText(), g).getWidth();
        lineLayoutInfo.textRect.x = ins.left + (width - labelWidth - ins.left - ins.right) / 2;
        lineLayoutInfo.textRect.y = y;
        lineLayoutInfo.textRect.width = labelWidth;
        lineLayoutInfo.textRect.height = labelHeight;
        result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
        result.textLayoutInfoList.add(lineLayoutInfo);
        return result;
    }
}

