/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.index.SlowCompositeReaderWrapper;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.FacetFieldProcessorByArrayUIF;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.uninverting.DocTermOrds;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnInvertedField
extends DocTermOrds {
    private static int TNUM_OFFSET = 2;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    long memsz;
    final AtomicLong use = new AtomicLong();
    int[] maxTermCounts = new int[1024];
    final Map<Integer, TopTerm> bigTerms = new LinkedHashMap<Integer, TopTerm>();
    private SolrIndexSearcher.DocsEnumState deState;
    private final SolrIndexSearcher searcher;
    private static final UnInvertedField uifPlaceholder = new UnInvertedField();

    private UnInvertedField() {
        super("fake", 0, 0);
        this.searcher = null;
    }

    @Override
    protected void visitTerm(TermsEnum te, int termNum) throws IOException {
        if (termNum >= this.maxTermCounts.length) {
            int[] newMaxTermCounts = new int[Math.min(0x7FFFFFEF, this.maxTermCounts.length * 2)];
            System.arraycopy(this.maxTermCounts, 0, newMaxTermCounts, 0, termNum);
            this.maxTermCounts = newMaxTermCounts;
        }
        BytesRef term = te.term();
        if (te.docFreq() > this.maxTermDocFreq) {
            Term t = new Term(this.field, term);
            TopTerm topTerm = new TopTerm();
            topTerm.term = t.bytes();
            topTerm.termNum = termNum;
            topTerm.termQuery = new TermQuery(t);
            this.bigTerms.put(topTerm.termNum, topTerm);
            if (this.deState == null) {
                this.deState = new SolrIndexSearcher.DocsEnumState();
                this.deState.fieldName = this.field;
                this.deState.liveDocs = this.searcher.getLiveDocsBits();
                this.deState.termsEnum = te;
                this.deState.postingsEnum = this.postingsEnum;
                this.deState.minSetSizeCached = this.maxTermDocFreq;
            }
            this.postingsEnum = this.deState.postingsEnum;
            DocSet set = this.searcher.getDocSet(this.deState);
            this.maxTermCounts[termNum] = set.size();
        }
    }

    @Override
    protected void setActualDocFreq(int termNum, int docFreq) {
        this.maxTermCounts[termNum] = docFreq;
    }

    public long memSize() {
        if (this.memsz != 0L) {
            return this.memsz;
        }
        long sz = super.ramBytesUsed();
        sz += 96L;
        sz += (long)(this.bigTerms.size() * 64);
        for (TopTerm tt : this.bigTerms.values()) {
            sz += tt.memSize();
        }
        if (this.maxTermCounts != null) {
            sz += (long)(this.maxTermCounts.length * 4);
        }
        this.memsz = sz;
        return sz;
    }

    public UnInvertedField(String field, SolrIndexSearcher searcher) throws IOException {
        super(field, searcher.maxDoc() / 20 + 2, 7);
        assert (TestInjection.injectUIFOutOfMemoryError());
        String prefix = TrieField.getMainValuePrefix(searcher.getSchema().getFieldType(field));
        this.searcher = searcher;
        try {
            LeafReader r = SlowCompositeReaderWrapper.wrap((IndexReader)searcher.getRawReader());
            this.uninvert(r, r.getLiveDocs(), prefix == null ? null : new BytesRef((CharSequence)prefix));
        }
        catch (IllegalStateException ise) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ise);
        }
        if (this.tnums != null) {
            for (byte[] target : this.tnums) {
                if (target == null || !((double)target.length > 1.50994944E7)) continue;
                log.warn("Approaching too many values for UnInvertedField faceting on field '{}' : bucket size={}", (Object)field, (Object)target.length);
            }
        }
        if (this.maxTermCounts.length - this.numTermsInField > 1024) {
            int[] newMaxTermCounts = new int[this.numTermsInField];
            System.arraycopy(this.maxTermCounts, 0, newMaxTermCounts, 0, this.numTermsInField);
            this.maxTermCounts = newMaxTermCounts;
        }
        log.info("UnInverted multi-valued field {}", (Object)this);
    }

    public int getNumTerms() {
        return this.numTermsInField;
    }

    private void getCounts(FacetFieldProcessorByArrayUIF processor, SlotAcc.CountSlotAcc counts) throws IOException {
        boolean doNegative;
        DocSet docs = processor.fcontext.base;
        int baseSize = docs.size();
        int maxDoc = this.searcher.maxDoc();
        if (baseSize < processor.effectiveMincount) {
            return;
        }
        int[] index = this.index;
        boolean bl = doNegative = baseSize > maxDoc >> 1 && this.termInstances > 0L && docs instanceof BitDocSet;
        if (doNegative) {
            FixedBitSet bs = ((BitDocSet)docs).getBits().clone();
            bs.flip(0, maxDoc);
            docs = new BitDocSet(bs, maxDoc - baseSize);
        }
        for (TopTerm tt : this.bigTerms.values()) {
            counts.incrementCount(tt.termNum, this.searcher.numDocs(tt.termQuery, docs));
        }
        if (this.termInstances > 0L) {
            DocIterator iter = docs.iterator();
            block1: while (iter.hasNext()) {
                int doc = iter.nextDoc();
                int code = index[doc];
                if ((code & Integer.MIN_VALUE) != 0) {
                    int pos = code & Integer.MAX_VALUE;
                    int whichArray = doc >>> 16 & 0xFF;
                    byte[] arr = this.tnums[whichArray];
                    int tnum = 0;
                    while (true) {
                        byte b;
                        int delta = 0;
                        do {
                            b = arr[pos++];
                            delta = delta << 7 | b & 0x7F;
                        } while ((b & 0x80) != 0);
                        if (delta == 0) continue block1;
                        counts.incrementCount(tnum += delta - TNUM_OFFSET, 1);
                    }
                }
                int tnum = 0;
                int delta = 0;
                while (true) {
                    delta = delta << 7 | code & 0x7F;
                    if ((code & 0x80) == 0) {
                        if (delta == 0) continue block1;
                        counts.incrementCount(tnum += delta - TNUM_OFFSET, 1);
                        delta = 0;
                    }
                    code >>>= 8;
                }
            }
        }
        if (doNegative) {
            for (int i = 0; i < this.numTermsInField; ++i) {
                counts.incrementCount(i, this.maxTermCounts[i] - counts.getCount(i) * 2);
            }
        }
    }

    public void collectDocs(FacetFieldProcessorByArrayUIF processor) throws IOException {
        if (processor.collectAcc == null && processor.allBucketsAcc == null && processor.startTermIndex == 0 && processor.endTermIndex >= this.numTermsInField) {
            this.getCounts(processor, processor.countAcc);
            return;
        }
        this.collectDocsGeneric(processor);
    }

    public void collectDocsGeneric(FacetFieldProcessorByArrayUIF processor) throws IOException {
        this.use.incrementAndGet();
        int startTermIndex = processor.startTermIndex;
        int endTermIndex = processor.endTermIndex;
        int nTerms = processor.nTerms;
        DocSet docs = processor.fcontext.base;
        int uniqueTerms = 0;
        SlotAcc.CountSlotAcc countAcc = processor.countAcc;
        for (TopTerm tt : this.bigTerms.values()) {
            if (tt.termNum < startTermIndex || tt.termNum >= endTermIndex) continue;
            DocSet intersection = this.searcher.getDocSet(tt.termQuery, docs);
            int collected = processor.collectFirstPhase(intersection, tt.termNum - startTermIndex, slotNum -> new SlotAcc.SlotContext(tt.termQuery));
            countAcc.incrementCount(tt.termNum - startTermIndex, collected);
            if (collected <= 0) continue;
            ++uniqueTerms;
        }
        if (this.termInstances > 0L) {
            List leaves = this.searcher.getIndexReader().leaves();
            Iterator ctxIt = leaves.iterator();
            LeafReaderContext ctx = null;
            int segBase = 0;
            int adjustedMax = 0;
            DocIterator iter = docs.iterator();
            block1: while (iter.hasNext()) {
                int doc = iter.nextDoc();
                if (doc >= adjustedMax) {
                    int segMax;
                    do {
                        if ((ctx = (LeafReaderContext)ctxIt.next()) != null) continue;
                        throw new RuntimeException("INTERNAL FACET ERROR");
                    } while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = ctx.reader().maxDoc())));
                    assert (doc >= ctx.docBase);
                    processor.setNextReaderFirstPhase(ctx);
                }
                int segDoc = doc - segBase;
                int code = this.index[doc];
                if ((code & Integer.MIN_VALUE) != 0) {
                    int pos = code & Integer.MAX_VALUE;
                    int whichArray = doc >>> 16 & 0xFF;
                    byte[] arr = this.tnums[whichArray];
                    int tnum = 0;
                    while (true) {
                        byte b;
                        int delta = 0;
                        do {
                            b = arr[pos++];
                            delta = delta << 7 | b & 0x7F;
                        } while ((b & 0x80) != 0);
                        if (delta == 0) continue block1;
                        int arrIdx = (tnum += delta - TNUM_OFFSET) - startTermIndex;
                        if (arrIdx < 0) continue;
                        if (arrIdx >= nTerms) continue block1;
                        countAcc.incrementCount(arrIdx, 1);
                        processor.collectFirstPhase(segDoc, arrIdx, (IntFunction<SlotAcc.SlotContext>)processor.slotContext);
                    }
                }
                int tnum = 0;
                int delta = 0;
                while (true) {
                    delta = delta << 7 | code & 0x7F;
                    if ((code & 0x80) == 0) {
                        if (delta == 0) continue block1;
                        int arrIdx = (tnum += delta - TNUM_OFFSET) - startTermIndex;
                        if (arrIdx >= 0) {
                            if (arrIdx >= nTerms) continue block1;
                            countAcc.incrementCount(arrIdx, 1);
                            processor.collectFirstPhase(segDoc, arrIdx, (IntFunction<SlotAcc.SlotContext>)processor.slotContext);
                        }
                        delta = 0;
                    }
                    code >>>= 8;
                }
            }
        }
    }

    String getReadableValue(BytesRef termval, FieldType ft, CharsRefBuilder charsRef) {
        return ft.indexedToReadable(termval, charsRef).toString();
    }

    BytesRef getTermValue(TermsEnum te, int termNum) throws IOException {
        TopTerm tt;
        if (this.bigTerms.size() > 0 && (tt = this.bigTerms.get(termNum)) != null) {
            return tt.term;
        }
        return this.lookupTerm(te, termNum);
    }

    public String toString() {
        long indexSize = this.indexedTermsArray == null ? 0L : (long)(32 + (this.indexedTermsArray.length << 3)) + this.sizeOfIndexedStrings;
        return "{field=" + this.field + ",memSize=" + this.memSize() + ",tindexSize=" + indexSize + ",time=" + this.total_time + ",phase1=" + this.phase1_time + ",nTerms=" + this.numTermsInField + ",bigTerms=" + this.bigTerms.size() + ",termInstances=" + this.termInstances + ",uses=" + this.use.get() + "}";
    }

    public static UnInvertedField getUnInvertedField(String field, SolrIndexSearcher searcher) throws IOException {
        SolrCache<String, UnInvertedField> cache = searcher.getFieldValueCache();
        if (cache == null) {
            return new UnInvertedField(field, searcher);
        }
        AtomicReference throwableRef = new AtomicReference();
        UnInvertedField uif = cache.computeIfAbsent(field, f -> {
            UnInvertedField newUif;
            try {
                newUif = new UnInvertedField(field, searcher);
            }
            catch (Throwable t) {
                throwableRef.set(t);
                newUif = null;
            }
            return newUif;
        });
        if (throwableRef.get() != null) {
            UnInvertedField.rethrowAsSolrException(field, (Throwable)throwableRef.get());
        }
        return uif;
    }

    protected static void rethrowAsSolrException(String field, Throwable e) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception occured during uninverting " + field, e);
    }

    public static UnInvertedField checkUnInvertedField(String field, SolrIndexSearcher searcher) throws IOException {
        SolrCache<String, UnInvertedField> cache = searcher.getFieldValueCache();
        if (cache == null) {
            return null;
        }
        UnInvertedField uif = cache.get(field);
        return uif == uifPlaceholder || !(uif instanceof UnInvertedField) ? null : uif;
    }

    static class TopTerm {
        Query termQuery;
        BytesRef term;
        int termNum;

        TopTerm() {
        }

        long memSize() {
            return 24 + this.term.length + 4;
        }
    }

    public static interface Callback {
        public void call(int var1);
    }

    public class DocToTerm
    implements Closeable {
        private final DocSet[] bigTermSets;
        private final int[] bigTermNums;
        private TermsEnum te;

        public DocToTerm() throws IOException {
            this.bigTermSets = new DocSet[UnInvertedField.this.bigTerms.size()];
            this.bigTermNums = new int[UnInvertedField.this.bigTerms.size()];
            int i = 0;
            for (TopTerm tt : UnInvertedField.this.bigTerms.values()) {
                this.bigTermSets[i] = UnInvertedField.this.searcher.getDocSet(tt.termQuery);
                this.bigTermNums[i] = tt.termNum;
                ++i;
            }
        }

        public BytesRef lookupOrd(int ord) throws IOException {
            return UnInvertedField.this.getTermValue(this.getTermsEnum(), ord);
        }

        public TermsEnum getTermsEnum() throws IOException {
            if (this.te == null) {
                this.te = UnInvertedField.this.getOrdTermsEnum(UnInvertedField.this.searcher.getSlowAtomicReader());
            }
            return this.te;
        }

        public void getBigTerms(int doc, Callback target) throws IOException {
            if (this.bigTermSets != null) {
                for (int i = 0; i < this.bigTermSets.length; ++i) {
                    if (!this.bigTermSets[i].exists(doc)) continue;
                    target.call(this.bigTermNums[i]);
                }
            }
        }

        public void getSmallTerms(int doc, Callback target) {
            if (UnInvertedField.this.termInstances > 0L) {
                int code = UnInvertedField.this.index[doc];
                if ((code & Integer.MIN_VALUE) != 0) {
                    int pos = code & Integer.MAX_VALUE;
                    int whichArray = doc >>> 16 & 0xFF;
                    byte[] arr = UnInvertedField.this.tnums[whichArray];
                    int tnum = 0;
                    while (true) {
                        byte b;
                        int delta = 0;
                        do {
                            b = arr[pos++];
                            delta = delta << 7 | b & 0x7F;
                        } while ((b & 0x80) != 0);
                        if (delta != 0) {
                            target.call(tnum += delta - TNUM_OFFSET);
                            continue;
                        }
                        break;
                    }
                } else {
                    int tnum = 0;
                    int delta = 0;
                    while (true) {
                        delta = delta << 7 | code & 0x7F;
                        if ((code & 0x80) == 0) {
                            if (delta == 0) break;
                            target.call(tnum += delta - TNUM_OFFSET);
                            delta = 0;
                        }
                        code >>>= 8;
                    }
                }
            }
        }

        @Override
        public void close() throws IOException {
            for (DocSet docSet : this.bigTermSets) {
            }
        }
    }
}

